/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import ca.uhn.fhir.model.api.IQueryParameterType;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.param.BaseParam;
import ca.uhn.fhir.rest.param.ParameterUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class UriParam
extends BaseParam
implements IQueryParameterType {
    private String myValue;

    public UriParam() {
    }

    public UriParam(String theValue) {
        this.setValue(theValue);
    }

    @Override
    String doGetQueryParameterQualifier() {
        return null;
    }

    @Override
    String doGetValueAsQueryToken() {
        return ParameterUtil.escape(this.myValue);
    }

    @Override
    void doSetValueAsQueryToken(String theQualifier, String theValue) {
        this.myValue = ParameterUtil.unescape(theValue);
    }

    public String getValue() {
        return this.myValue;
    }

    public StringDt getValueAsStringDt() {
        return new StringDt(this.myValue);
    }

    public UriDt getValueAsUriDt() {
        return new UriDt(this.myValue);
    }

    public String getValueNotNull() {
        return StringUtils.defaultString((String)this.myValue);
    }

    public boolean isEmpty() {
        return StringUtils.isEmpty((CharSequence)this.myValue);
    }

    public void setValue(String theValue) {
        this.myValue = theValue;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        builder.append("value", (Object)this.getValue());
        return builder.toString();
    }
}

