/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.rest.server.IncomingRequestAddressStrategy;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class ApacheProxyAddressStrategy
extends IncomingRequestAddressStrategy {
    private boolean myUseHttps = false;

    protected ApacheProxyAddressStrategy(boolean theUseHttps) {
        this.myUseHttps = theUseHttps;
    }

    public static ApacheProxyAddressStrategy forHttp() {
        return new ApacheProxyAddressStrategy(false);
    }

    public static ApacheProxyAddressStrategy forHttps() {
        return new ApacheProxyAddressStrategy(true);
    }

    @Override
    public String determineServerBase(ServletContext theServletContext, HttpServletRequest theRequest) {
        String forwardedHost = this.getForwardedHost(theRequest);
        if (forwardedHost != null) {
            return this.forwardedServerBase(theServletContext, theRequest, forwardedHost);
        }
        return super.determineServerBase(theServletContext, theRequest);
    }

    private String getForwardedHost(HttpServletRequest theRequest) {
        int commaPos;
        String forwardedHost = theRequest.getHeader("x-forwarded-host");
        if (forwardedHost != null && (commaPos = forwardedHost.indexOf(44)) >= 0) {
            forwardedHost = forwardedHost.substring(0, commaPos - 1);
        }
        return forwardedHost;
    }

    public String forwardedServerBase(ServletContext theServletContext, HttpServletRequest theRequest, String theForwardedHost) {
        String serverBase = super.determineServerBase(theServletContext, theRequest);
        String host = theRequest.getHeader("host");
        if (host != null) {
            serverBase = serverBase.replace(host, theForwardedHost);
            serverBase = serverBase.substring(serverBase.indexOf("://"));
            return this.protocol(theRequest) + serverBase;
        }
        return serverBase;
    }

    protected String protocol(HttpServletRequest theRequest) {
        String protocol = theRequest.getHeader("x-forwarded-proto");
        if (protocol != null) {
            return protocol;
        }
        return this.myUseHttps ? "https" : "http";
    }
}

