/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.BundleEntry;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.rest.server.AddProfileTagEnum;
import ca.uhn.fhir.rest.server.BundleInclusionRule;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.IBundleProvider;
import ca.uhn.fhir.rest.server.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Dstu1BundleFactory
implements IVersionSpecificBundleFactory {
    private static final Logger ourLog = LoggerFactory.getLogger(Dstu1BundleFactory.class);
    private Bundle myBundle;
    private FhirContext myContext;

    public Dstu1BundleFactory(FhirContext theContext) {
        this.myContext = theContext;
    }

    @Override
    public void addResourcesToBundle(List<IResource> theResult, BundleTypeEnum theBundleType, String theServerBase, BundleInclusionRule theBundleInclusionRule, Set<Include> theIncludes) {
        if (this.myBundle == null) {
            this.myBundle = new Bundle();
        }
        ArrayList includedResources = new ArrayList();
        HashSet<IdDt> addedResourceIds = new HashSet<IdDt>();
        for (IResource next : theResult) {
            if (next.getId().isEmpty()) continue;
            addedResourceIds.add(next.getId());
        }
        for (IResource next : theResult) {
            HashSet<String> containedIds = new HashSet<String>();
            for (IResource iResource : next.getContained().getContainedResources()) {
                if (iResource.getId().isEmpty()) continue;
                containedIds.add(iResource.getId().getValue());
            }
            if (this.myContext.getNarrativeGenerator() != null) {
                String title = this.myContext.getNarrativeGenerator().generateTitle(next);
                ourLog.trace("Narrative generator created title: {}", (Object)title);
                if (StringUtils.isNotBlank((CharSequence)title)) {
                    ResourceMetadataKeyEnum.TITLE.put(next, title);
                }
            } else {
                ourLog.trace("No narrative generator specified");
            }
            List<ResourceReferenceInfo> references = this.myContext.newTerser().getAllResourceReferences(next);
            do {
                ArrayList<IResource> arrayList = new ArrayList<IResource>();
                for (ResourceReferenceInfo nextRefInfo : references) {
                    IResource nextRes;
                    if (!theBundleInclusionRule.shouldIncludeReferencedResource(nextRefInfo, theIncludes) || (nextRes = nextRefInfo.getResourceReference().getResource()) == null || !nextRes.getId().hasIdPart() || containedIds.contains(nextRes.getId().getValue())) continue;
                    IdDt id = nextRes.getId();
                    if (!id.hasResourceType()) {
                        String resName = this.myContext.getResourceDefinition(nextRes).getName();
                        id = id.withResourceType(resName);
                    }
                    if (addedResourceIds.contains(id)) continue;
                    addedResourceIds.add(id);
                    arrayList.add(nextRes);
                }
                includedResources.addAll(arrayList);
                references = new ArrayList<ResourceReferenceInfo>();
                for (IResource iResource : arrayList) {
                    List<ResourceReferenceInfo> newReferences = this.myContext.newTerser().getAllResourceReferences(iResource);
                    references.addAll(newReferences);
                }
            } while (!references.isEmpty());
            this.myBundle.addResource(next, this.myContext, theServerBase);
        }
        for (IResource next : includedResources) {
            BundleEntry entry = this.myBundle.addResource(next, this.myContext, theServerBase);
            if (!this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1) || !entry.getSearchMode().isEmpty()) continue;
            entry.getSearchMode().setValueAsEnum(BundleEntrySearchModeEnum.INCLUDE);
        }
    }

    @Override
    public void initializeBundleFromBundleProvider(RestfulServer theServer, IBundleProvider theResult, EncodingEnum theResponseEncoding, String theServerBase, String theCompleteUrl, boolean thePrettyPrint, int theOffset, Integer theLimit, String theSearchId, BundleTypeEnum theBundleType, Set<Include> theIncludes) {
        List<IResource> resourceList;
        int numToReturn;
        String searchId = null;
        if (theServer.getPagingProvider() == null) {
            numToReturn = theResult.size();
            resourceList = theResult.getResources(0, numToReturn);
            RestfulServerUtils.validateResourceListNotNull(resourceList);
        } else {
            Iterator<IResource> pagingProvider = theServer.getPagingProvider();
            numToReturn = theLimit == null ? pagingProvider.getDefaultPageSize() : Math.min(pagingProvider.getMaximumPageSize(), theLimit);
            numToReturn = Math.min(numToReturn, theResult.size() - theOffset);
            resourceList = theResult.getResources(theOffset, numToReturn + theOffset);
            RestfulServerUtils.validateResourceListNotNull(resourceList);
            if (theSearchId != null) {
                searchId = theSearchId;
            } else if (theResult.size() > numToReturn) {
                searchId = pagingProvider.storeResultList(theResult);
                Validate.notNull((Object)searchId, (String)"Paging provider returned null searchId", (Object[])new Object[0]);
            }
        }
        for (IResource next : resourceList) {
            if (next.getId() != null && !next.getId().isEmpty() || next instanceof BaseOperationOutcome) continue;
            throw new InternalErrorException("Server method returned resource of type[" + next.getClass().getSimpleName() + "] with no ID specified (IResource#setId(IdDt) must be called)");
        }
        if (theServer.getAddProfileTag() != AddProfileTagEnum.NEVER) {
            for (IResource nextRes : resourceList) {
                RuntimeResourceDefinition def = theServer.getFhirContext().getResourceDefinition(nextRes);
                if (theServer.getAddProfileTag() != AddProfileTagEnum.ALWAYS && def.isStandardProfile()) continue;
                RestfulServerUtils.addProfileToBundleEntry(theServer.getFhirContext(), nextRes, theServerBase);
            }
        }
        this.addResourcesToBundle(resourceList, theBundleType, theServerBase, theServer.getBundleInclusionRule(), theIncludes);
        this.addRootPropertiesToBundle(null, theServerBase, theCompleteUrl, theResult.size(), theBundleType);
        if (theServer.getPagingProvider() != null) {
            int limit = theLimit != null ? theLimit.intValue() : theServer.getPagingProvider().getDefaultPageSize();
            limit = Math.min(limit, theServer.getPagingProvider().getMaximumPageSize());
            if (searchId != null) {
                if (theOffset + numToReturn < theResult.size()) {
                    this.myBundle.getLinkNext().setValue(RestfulServerUtils.createPagingLink(theIncludes, theServerBase, searchId, theOffset + numToReturn, numToReturn, theResponseEncoding, thePrettyPrint));
                }
                if (theOffset > 0) {
                    int start = Math.max(0, theOffset - limit);
                    this.myBundle.getLinkPrevious().setValue(RestfulServerUtils.createPagingLink(theIncludes, theServerBase, searchId, start, limit, theResponseEncoding, thePrettyPrint));
                }
            }
        }
    }

    @Override
    public void addRootPropertiesToBundle(String theAuthor, String theServerBase, String theCompleteUrl, Integer theTotalResults, BundleTypeEnum theBundleType) {
        if (this.myBundle.getAuthorName().isEmpty()) {
            this.myBundle.getAuthorName().setValue(theAuthor);
        }
        if (this.myBundle.getBundleId().isEmpty()) {
            this.myBundle.getBundleId().setValue(UUID.randomUUID().toString());
        }
        if (this.myBundle.getLinkBase().isEmpty()) {
            this.myBundle.getLinkBase().setValue(theServerBase);
        }
        if (this.myBundle.getLinkSelf().isEmpty()) {
            this.myBundle.getLinkSelf().setValue(theCompleteUrl);
        }
        if (theBundleType != null && this.myBundle.getType().isEmpty()) {
            this.myBundle.getType().setValueAsString(theBundleType.getCode());
        }
        if (this.myBundle.getTotalResults().isEmpty() && theTotalResults != null) {
            this.myBundle.getTotalResults().setValue(theTotalResults);
        }
    }

    @Override
    public Bundle getDstu1Bundle() {
        return this.myBundle;
    }

    @Override
    public IResource getResourceBundle() {
        return null;
    }

    @Override
    public void initializeBundleFromResourceList(String theAuthor, List<IResource> theResult, String theServerBase, String theCompleteUrl, int theTotalResults, BundleTypeEnum theBundleType) {
        this.myBundle = new Bundle();
        this.myBundle.getAuthorName().setValue(theAuthor);
        this.myBundle.getBundleId().setValue(UUID.randomUUID().toString());
        this.myBundle.getLinkBase().setValue(theServerBase);
        this.myBundle.getLinkSelf().setValue(theCompleteUrl);
        this.myBundle.getType().setValueAsEnum(theBundleType);
        ArrayList includedResources = new ArrayList();
        HashSet<IdDt> addedResourceIds = new HashSet<IdDt>();
        for (IResource next : theResult) {
            if (next.getId().isEmpty()) continue;
            addedResourceIds.add(next.getId());
        }
        for (IResource next : theResult) {
            HashSet<String> containedIds = new HashSet<String>();
            for (IResource iResource : next.getContained().getContainedResources()) {
                if (iResource.getId().isEmpty()) continue;
                containedIds.add(iResource.getId().getValue());
            }
            if (this.myContext.getNarrativeGenerator() != null) {
                String title = this.myContext.getNarrativeGenerator().generateTitle(next);
                ourLog.trace("Narrative generator created title: {}", (Object)title);
                if (StringUtils.isNotBlank((CharSequence)title)) {
                    ResourceMetadataKeyEnum.TITLE.put(next, title);
                }
            } else {
                ourLog.trace("No narrative generator specified");
            }
            List<BaseResourceReferenceDt> references = this.myContext.newTerser().getAllPopulatedChildElementsOfType(next, BaseResourceReferenceDt.class);
            do {
                ArrayList<IResource> arrayList = new ArrayList<IResource>();
                for (BaseResourceReferenceDt nextRef : references) {
                    IResource nextRes = nextRef.getResource();
                    if (nextRes == null || !nextRes.getId().hasIdPart() || containedIds.contains(nextRes.getId().getValue())) continue;
                    IdDt id = nextRes.getId();
                    if (!id.hasResourceType()) {
                        String resName = this.myContext.getResourceDefinition(nextRes).getName();
                        id = id.withResourceType(resName);
                    }
                    if (addedResourceIds.contains(id)) continue;
                    addedResourceIds.add(id);
                    arrayList.add(nextRes);
                }
                references = new ArrayList<BaseResourceReferenceDt>();
                for (IResource iResource : arrayList) {
                    List<BaseResourceReferenceDt> newReferences = this.myContext.newTerser().getAllPopulatedChildElementsOfType(iResource, BaseResourceReferenceDt.class);
                    references.addAll(newReferences);
                }
                includedResources.addAll(arrayList);
            } while (!references.isEmpty());
            this.myBundle.addResource(next, this.myContext, theServerBase);
        }
        for (IResource next : includedResources) {
            BundleEntry entry = this.myBundle.addResource(next, this.myContext, theServerBase);
            if (!this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1) || !entry.getSearchMode().isEmpty()) continue;
            entry.getSearchMode().setValueAsEnum(BundleEntrySearchModeEnum.INCLUDE);
        }
        this.myBundle.getTotalResults().setValue(theTotalResults);
    }

    @Override
    public void initializeWithBundleResource(IResource theResource) {
        throw new UnsupportedOperationException("DSTU1 server doesn't support resource style bundles");
    }

    @Override
    public List<IResource> toListOfResources() {
        return this.myBundle.toListOfResources();
    }
}

