/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.parser.IParser;
import java.util.HashMap;

public enum EncodingEnum {
    XML("application/xml+fhir", "application/atom+xml", "application/xml", "xml"){

        @Override
        public IParser newParser(FhirContext theContext) {
            return theContext.newXmlParser();
        }
    }
    ,
    JSON("application/json+fhir", "application/json+fhir", "application/json", "json"){

        @Override
        public IParser newParser(FhirContext theContext) {
            return theContext.newJsonParser();
        }
    };

    private static HashMap<String, EncodingEnum> ourContentTypeToEncoding;
    private String myResourceContentType;
    private String myBundleContentType;
    private String myBrowserFriendlyContentType;
    private String myFormatContentType;

    private EncodingEnum(String theResourceContentType, String theBundleContentType, String theBrowserFriendlyContentType, String theFormatContentType) {
        this.myResourceContentType = theResourceContentType;
        this.myBundleContentType = theBundleContentType;
        this.myBrowserFriendlyContentType = theBrowserFriendlyContentType;
        this.myFormatContentType = theFormatContentType;
    }

    public String getRequestContentType() {
        return this.myFormatContentType;
    }

    public abstract IParser newParser(FhirContext var1);

    public String getBundleContentType() {
        return this.myBundleContentType;
    }

    public String getResourceContentType() {
        return this.myResourceContentType;
    }

    public String getBrowserFriendlyBundleContentType() {
        return this.myBrowserFriendlyContentType;
    }

    public static EncodingEnum forContentType(String theContentType) {
        return ourContentTypeToEncoding.get(theContentType);
    }

    public String getFormatContentType() {
        return this.myFormatContentType;
    }

    static {
        ourContentTypeToEncoding = new HashMap();
        for (EncodingEnum next : EncodingEnum.values()) {
            ourContentTypeToEncoding.put(next.getBundleContentType(), next);
            ourContentTypeToEncoding.put(next.getResourceContentType(), next);
            ourContentTypeToEncoding.put(next.getBrowserFriendlyBundleContentType(), next);
        }
        ourContentTypeToEncoding.put("application/json", JSON);
        ourContentTypeToEncoding.put("application/xml", XML);
        ourContentTypeToEncoding.put("application/fhir+xml", XML);
        ourContentTypeToEncoding.put("text/json", JSON);
        ourContentTypeToEncoding.put("text/xml", XML);
    }
}

