/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.rest.server.IBundleProvider;
import ca.uhn.fhir.rest.server.IPagingProvider;
import java.util.LinkedHashMap;
import java.util.UUID;
import org.apache.commons.lang3.Validate;

public class FifoMemoryPagingProvider
implements IPagingProvider {
    private LinkedHashMap<String, IBundleProvider> myBundleProviders;
    private int myDefaultPageSize = 10;
    private int myMaximumPageSize = 50;
    private int mySize;

    public FifoMemoryPagingProvider(int theSize) {
        Validate.isTrue((theSize > 0 ? 1 : 0) != 0, (String)"theSize must be greater than 0", (Object[])new Object[0]);
        this.mySize = theSize;
        this.myBundleProviders = new LinkedHashMap(this.mySize);
    }

    @Override
    public int getDefaultPageSize() {
        return this.myDefaultPageSize;
    }

    @Override
    public int getMaximumPageSize() {
        return this.myMaximumPageSize;
    }

    @Override
    public synchronized IBundleProvider retrieveResultList(String theId) {
        return this.myBundleProviders.get(theId);
    }

    public FifoMemoryPagingProvider setDefaultPageSize(int theDefaultPageSize) {
        Validate.isTrue((theDefaultPageSize > 0 ? 1 : 0) != 0, (String)"size must be greater than 0", (Object[])new Object[0]);
        this.myDefaultPageSize = theDefaultPageSize;
        return this;
    }

    public FifoMemoryPagingProvider setMaximumPageSize(int theMaximumPageSize) {
        Validate.isTrue((theMaximumPageSize > 0 ? 1 : 0) != 0, (String)"size must be greater than 0", (Object[])new Object[0]);
        this.myMaximumPageSize = theMaximumPageSize;
        return this;
    }

    @Override
    public synchronized String storeResultList(IBundleProvider theList) {
        while (this.myBundleProviders.size() > this.mySize) {
            this.myBundleProviders.remove(this.myBundleProviders.keySet().iterator().next());
        }
        String key = UUID.randomUUID().toString();
        this.myBundleProviders.put(key, theList);
        return key;
    }
}

