/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.rest.server.IServerAddressStrategy;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class IncomingRequestAddressStrategy
implements IServerAddressStrategy {
    private String myServletPath;

    @Override
    public String determineServerBase(ServletContext theServletContext, HttpServletRequest theRequest) {
        String requestPath;
        String requestFullPath = StringUtils.defaultString((String)theRequest.getRequestURI());
        String servletPath = this.myServletPath != null ? this.myServletPath : StringUtils.defaultString((String)theRequest.getServletPath());
        StringBuffer requestUrl = theRequest.getRequestURL();
        String servletContextPath = "";
        if (theServletContext != null) {
            servletContextPath = StringUtils.defaultString((String)theServletContext.getContextPath());
        }
        if ((requestPath = requestFullPath.substring(servletContextPath.length() + servletPath.length())).length() > 0 && requestPath.charAt(0) == '/') {
            requestPath = requestPath.substring(1);
        }
        int startOfPath = requestUrl.indexOf("//");
        int requestUrlLength = requestUrl.length();
        if (startOfPath != -1 && startOfPath + 2 < requestUrlLength) {
            startOfPath = requestUrl.indexOf("/", startOfPath + 2);
        }
        if (startOfPath == -1) {
            startOfPath = 0;
        }
        int contextIndex = servletPath.length() == 0 || servletPath.equals("/") ? (requestPath.length() == 0 ? requestUrlLength : requestUrl.indexOf(requestPath, startOfPath)) : requestUrl.indexOf(servletPath, startOfPath);
        int length = contextIndex + servletPath.length();
        if (length > requestUrlLength) {
            length = requestUrlLength;
        }
        String fhirServerBase = requestUrl.substring(0, length);
        return fhirServerBase;
    }

    public void setServletPath(String theServletPath) {
        this.myServletPath = theServletPath;
    }
}

