/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.Request;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceBinding {
    private static final Logger ourLog = LoggerFactory.getLogger(ResourceBinding.class);
    private String resourceName;
    private List<BaseMethodBinding<?>> methods = new ArrayList();

    public ResourceBinding() {
    }

    public ResourceBinding(String resourceName, List<BaseMethodBinding<?>> methods) {
        this.resourceName = resourceName;
        this.methods = methods;
    }

    public BaseMethodBinding<?> getMethod(Request theRequest) throws Exception {
        if (null == this.methods) {
            ourLog.warn("No methods exist for resource: {}", (Object)this.resourceName);
            return null;
        }
        ourLog.debug("Looking for a handler for {}", (Object)theRequest);
        for (BaseMethodBinding<?> rm : this.methods) {
            if (rm.incomingServerRequestMatchesMethod(theRequest)) {
                ourLog.debug("Handler {} matches", rm);
                return rm;
            }
            ourLog.trace("Handler {} does not match", rm);
        }
        return null;
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String resourceName) {
        this.resourceName = resourceName;
    }

    public List<BaseMethodBinding<?>> getMethodBindings() {
        return this.methods;
    }

    public void setMethods(List<BaseMethodBinding<?>> methods) {
        this.methods = methods;
    }

    public void addMethod(BaseMethodBinding<?> method) {
        this.methods.add(method);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ResourceBinding)) {
            return false;
        }
        return this.resourceName.equals(((ResourceBinding)o).getResourceName());
    }

    public int hashCode() {
        return 0;
    }
}

