/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.IBaseResource;

public class ResponseResourceList {
    public static final ResponseResourceList EMPTY = new EmptyResponseResourceList();
    private List<IBaseResource> myIncludeResults;
    private List<IBaseResource> myMatchResults;

    public void addIncludeResults(IBaseResource theIncludeResult) {
        if (this.myIncludeResults == null) {
            this.myIncludeResults = new ArrayList<IBaseResource>();
        }
        this.myIncludeResults.add(theIncludeResult);
    }

    public void addMatchResult(IBaseResource theResource) {
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        if (this.myMatchResults == null) {
            this.myMatchResults = new ArrayList<IBaseResource>();
        }
        this.myMatchResults.add(theResource);
    }

    public List<IBaseResource> getIncludeResults() {
        return this.myIncludeResults;
    }

    public List<IBaseResource> getMatchResults() {
        return this.myMatchResults;
    }

    public void setIncludeResults(List<IBaseResource> theIncludeResults) {
        this.myIncludeResults = theIncludeResults;
    }

    public void setMatchResults(List<IBaseResource> theMatchResults) {
        this.myMatchResults = theMatchResults;
    }

    private static final class EmptyResponseResourceList
    extends ResponseResourceList {
        private EmptyResponseResourceList() {
        }

        @Override
        public void addIncludeResults(IBaseResource theIncludeResult) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addMatchResult(IBaseResource theResource) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setIncludeResults(List<IBaseResource> theIncludeResults) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setMatchResults(List<IBaseResource> theMatchResults) {
            throw new UnsupportedOperationException();
        }
    }
}

