/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.ProvidedResourceScanner;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.annotation.Destroy;
import ca.uhn.fhir.rest.annotation.IdParam;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.method.BaseMethodBinding;
import ca.uhn.fhir.rest.method.ConformanceMethodBinding;
import ca.uhn.fhir.rest.method.OtherOperationTypeEnum;
import ca.uhn.fhir.rest.method.Request;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.AddProfileTagEnum;
import ca.uhn.fhir.rest.server.BundleInclusionRule;
import ca.uhn.fhir.rest.server.ConfigurationException;
import ca.uhn.fhir.rest.server.ETagSupportEnum;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.IBundleProvider;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.IResourceProvider;
import ca.uhn.fhir.rest.server.IServerAddressStrategy;
import ca.uhn.fhir.rest.server.IServerConformanceProvider;
import ca.uhn.fhir.rest.server.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.server.IncomingRequestAddressStrategy;
import ca.uhn.fhir.rest.server.ResourceBinding;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InvalidRequestException;
import ca.uhn.fhir.rest.server.exceptions.NotModifiedException;
import ca.uhn.fhir.rest.server.interceptor.ExceptionHandlingInterceptor;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.util.ReflectionUtil;
import ca.uhn.fhir.util.UrlUtil;
import ca.uhn.fhir.util.VersionUtil;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulServer
extends HttpServlet {
    public static final ETagSupportEnum DEFAULT_ETAG_SUPPORT = ETagSupportEnum.ENABLED;
    private static final Logger ourLog = LoggerFactory.getLogger(RestfulServer.class);
    private static final long serialVersionUID = 1L;
    private AddProfileTagEnum myAddProfileTag;
    private BundleInclusionRule myBundleInclusionRule = BundleInclusionRule.BASED_ON_INCLUDES;
    private boolean myDefaultPrettyPrint = false;
    private EncodingEnum myDefaultResponseEncoding = EncodingEnum.XML;
    private ETagSupportEnum myETagSupport = DEFAULT_ETAG_SUPPORT;
    private FhirContext myFhirContext;
    private String myImplementationDescription;
    private final List<IServerInterceptor> myInterceptors = new ArrayList<IServerInterceptor>();
    private IPagingProvider myPagingProvider;
    private Collection<Object> myPlainProviders;
    private Map<String, ResourceBinding> myResourceNameToProvider = new HashMap<String, ResourceBinding>();
    private Collection<IResourceProvider> myResourceProviders;
    private IServerAddressStrategy myServerAddressStrategy = new IncomingRequestAddressStrategy();
    private ResourceBinding myServerBinding = new ResourceBinding();
    private BaseMethodBinding<?> myServerConformanceMethod;
    private Object myServerConformanceProvider;
    private String myServerName = "HAPI FHIR Server";
    private String myServerVersion = VersionUtil.getVersion();
    private boolean myStarted;
    private boolean myUseBrowserFriendlyContentTypes;

    public RestfulServer() {
        this(new FhirContext());
    }

    public RestfulServer(FhirContext theCtx) {
        this.myFhirContext = theCtx;
    }

    public void addHeadersToResponse(HttpServletResponse theHttpResponse) {
        theHttpResponse.addHeader("X-Powered-By", "HAPI FHIR " + VersionUtil.getVersion() + " RESTful Server");
    }

    private void assertProviderIsValid(Object theNext) throws ConfigurationException {
        if (!Modifier.isPublic(theNext.getClass().getModifiers())) {
            throw new ConfigurationException("Can not use provider '" + theNext.getClass() + "' - Class must be public");
        }
    }

    public void destroy() {
        if (this.getResourceProviders() != null) {
            for (IResourceProvider iResourceProvider : this.getResourceProviders()) {
                this.invokeDestroy(iResourceProvider);
            }
        }
    }

    protected void doDelete(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(RequestTypeEnum.DELETE, request, response);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(RequestTypeEnum.GET, request, response);
    }

    protected void doOptions(HttpServletRequest theReq, HttpServletResponse theResp) throws ServletException, IOException {
        this.handleRequest(RequestTypeEnum.OPTIONS, theReq, theResp);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(RequestTypeEnum.POST, request, response);
    }

    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.handleRequest(RequestTypeEnum.PUT, request, response);
    }

    protected int escapedLength(String theServletPath) {
        int delta = 0;
        for (int i = 0; i < theServletPath.length(); ++i) {
            char next = theServletPath.charAt(i);
            if (next != ' ') continue;
            delta += 2;
        }
        return theServletPath.length() + delta;
    }

    private void findResourceMethods(Object theProvider) throws Exception {
        ourLog.info("Scanning type for RESTful methods: {}", theProvider.getClass());
        int count = 0;
        Class<?> clazz = theProvider.getClass();
        Class<?> supertype = clazz.getSuperclass();
        while (!Object.class.equals(supertype)) {
            count += this.findResourceMethods(theProvider, supertype);
            supertype = supertype.getSuperclass();
        }
        if ((count += this.findResourceMethods(theProvider, clazz)) == 0) {
            throw new ConfigurationException("Did not find any annotated RESTful methods on provider class " + theProvider.getClass().getCanonicalName());
        }
    }

    private int findResourceMethods(Object theProvider, Class<?> clazz) throws ConfigurationException {
        int count = 0;
        for (Method m : ReflectionUtil.getDeclaredMethods(clazz)) {
            ResourceBinding resourceBinding;
            BaseMethodBinding<?> foundMethodBinding = BaseMethodBinding.bindMethod(m, this.myFhirContext, theProvider);
            if (foundMethodBinding == null) continue;
            ++count;
            if (!Modifier.isPublic(m.getModifiers())) {
                throw new ConfigurationException("Method '" + m.getName() + "' is not public, FHIR RESTful methods must be public");
            }
            if (Modifier.isStatic(m.getModifiers())) {
                throw new ConfigurationException("Method '" + m.getName() + "' is static, FHIR RESTful methods must not be static");
            }
            ourLog.debug("Scanning public method: {}#{}", theProvider.getClass(), (Object)m.getName());
            String resourceName = foundMethodBinding.getResourceName();
            if (resourceName == null) {
                resourceBinding = this.myServerBinding;
            } else {
                RuntimeResourceDefinition definition = this.myFhirContext.getResourceDefinition(resourceName);
                if (this.myResourceNameToProvider.containsKey(definition.getName())) {
                    resourceBinding = this.myResourceNameToProvider.get(definition.getName());
                } else {
                    resourceBinding = new ResourceBinding();
                    resourceBinding.setResourceName(resourceName);
                    this.myResourceNameToProvider.put(resourceName, resourceBinding);
                }
            }
            List<Class<?>> allowableParams = foundMethodBinding.getAllowableParamAnnotations();
            if (allowableParams != null) {
                Annotation[][] annotationArray = m.getParameterAnnotations();
                int n = annotationArray.length;
                for (int i = 0; i < n; ++i) {
                    Annotation[] nextParamAnnotations;
                    for (Annotation annotation : nextParamAnnotations = annotationArray[i]) {
                        Package pack = annotation.annotationType().getPackage();
                        if (!pack.equals(IdParam.class.getPackage()) || allowableParams.contains(annotation.annotationType())) continue;
                        throw new ConfigurationException("Method[" + m.toString() + "] is not allowed to have a parameter annotated with " + annotation);
                    }
                }
            }
            resourceBinding.addMethod(foundMethodBinding);
            ourLog.debug(" * Method: {}#{} is a handler", theProvider.getClass(), (Object)m.getName());
        }
        return count;
    }

    private void findSystemMethods(Object theSystemProvider) {
        Class<?> clazz = theSystemProvider.getClass();
        this.findSystemMethods(theSystemProvider, clazz);
    }

    private void findSystemMethods(Object theSystemProvider, Class<?> clazz) {
        Class<?> supertype = clazz.getSuperclass();
        if (!Object.class.equals(supertype)) {
            this.findSystemMethods(theSystemProvider, supertype);
        }
        for (Method m : ReflectionUtil.getDeclaredMethods(clazz)) {
            if (!Modifier.isPublic(m.getModifiers())) continue;
            ourLog.debug("Scanning public method: {}#{}", theSystemProvider.getClass(), (Object)m.getName());
            BaseMethodBinding<?> foundMethodBinding = BaseMethodBinding.bindMethod(m, this.myFhirContext, theSystemProvider);
            if (foundMethodBinding != null) {
                if (foundMethodBinding instanceof ConformanceMethodBinding) {
                    this.myServerConformanceMethod = foundMethodBinding;
                } else {
                    this.myServerBinding.addMethod(foundMethodBinding);
                }
                ourLog.info(" * Method: {}#{} is a handler", theSystemProvider.getClass(), (Object)m.getName());
                continue;
            }
            ourLog.debug(" * Method: {}#{} is not a handler", theSystemProvider.getClass(), (Object)m.getName());
        }
    }

    public AddProfileTagEnum getAddProfileTag() {
        return this.myAddProfileTag;
    }

    public BundleInclusionRule getBundleInclusionRule() {
        return this.myBundleInclusionRule;
    }

    public EncodingEnum getDefaultResponseEncoding() {
        return this.myDefaultResponseEncoding;
    }

    public ETagSupportEnum getETagSupport() {
        return this.myETagSupport;
    }

    public FhirContext getFhirContext() {
        return this.myFhirContext;
    }

    public String getImplementationDescription() {
        return this.myImplementationDescription;
    }

    public List<IServerInterceptor> getInterceptors() {
        return Collections.unmodifiableList(this.myInterceptors);
    }

    public IPagingProvider getPagingProvider() {
        return this.myPagingProvider;
    }

    public Collection<Object> getPlainProviders() {
        return this.myPlainProviders;
    }

    protected String getRequestPath(String requestFullPath, String servletContextPath, String servletPath) {
        return requestFullPath.substring(this.escapedLength(servletContextPath) + this.escapedLength(servletPath));
    }

    public Collection<ResourceBinding> getResourceBindings() {
        return this.myResourceNameToProvider.values();
    }

    public Collection<IResourceProvider> getResourceProviders() {
        return this.myResourceProviders;
    }

    public IServerAddressStrategy getServerAddressStrategy() {
        return this.myServerAddressStrategy;
    }

    public String getServerBaseForRequest(HttpServletRequest theRequest) {
        String fhirServerBase = this.myServerAddressStrategy.determineServerBase(this.getServletContext(), theRequest);
        if (fhirServerBase.endsWith("/")) {
            fhirServerBase = fhirServerBase.substring(0, fhirServerBase.length() - 1);
        }
        return fhirServerBase;
    }

    public Object getServerConformanceProvider() {
        return this.myServerConformanceProvider;
    }

    public String getServerName() {
        return this.myServerName;
    }

    public IResourceProvider getServerProfilesProvider() {
        return this.myFhirContext.getVersion().createServerProfilesProvider(this);
    }

    public String getServerVersion() {
        return this.myServerVersion;
    }

    private void handlePagingRequest(Request theRequest, HttpServletResponse theResponse, String thePagingAction) throws IOException {
        IBundleProvider resultList = this.getPagingProvider().retrieveResultList(thePagingAction);
        if (resultList == null) {
            ourLog.info("Client requested unknown paging ID[{}]", (Object)thePagingAction);
            theResponse.setStatus(410);
            this.addHeadersToResponse(theResponse);
            theResponse.setContentType("text/plain");
            theResponse.setCharacterEncoding("UTF-8");
            theResponse.getWriter().append("Search ID[" + thePagingAction + "] does not exist and may have expired.");
            theResponse.getWriter().close();
            return;
        }
        Integer count = RestfulServerUtils.extractCountParameter(theRequest.getServletRequest());
        if (count == null) {
            count = this.getPagingProvider().getDefaultPageSize();
        } else if (count > this.getPagingProvider().getMaximumPageSize()) {
            count = this.getPagingProvider().getMaximumPageSize();
        }
        Integer offsetI = RestfulServerUtils.tryToExtractNamedParameter(theRequest.getServletRequest(), "_getpagesoffset");
        if (offsetI == null || offsetI < 0) {
            offsetI = 0;
        }
        int start = Math.min(offsetI, resultList.size() - 1);
        EncodingEnum responseEncoding = RestfulServerUtils.determineResponseEncodingNoDefault(theRequest.getServletRequest());
        boolean prettyPrint = RestfulServerUtils.prettyPrintResponse(this, theRequest);
        boolean requestIsBrowser = RestfulServer.requestIsBrowser(theRequest.getServletRequest());
        NarrativeModeEnum narrativeMode = RestfulServerUtils.determineNarrativeMode(theRequest);
        boolean respondGzip = theRequest.isRespondGzip();
        IVersionSpecificBundleFactory bundleFactory = this.myFhirContext.newBundleFactory();
        HashSet<Include> includes = new HashSet<Include>();
        String[] reqIncludes = theRequest.getServletRequest().getParameterValues("_include");
        if (reqIncludes != null) {
            for (String nextInclude : reqIncludes) {
                includes.add(new Include(nextInclude));
            }
        }
        bundleFactory.initializeBundleFromBundleProvider(this, resultList, responseEncoding, theRequest.getFhirServerBase(), theRequest.getCompleteUrl(), prettyPrint, start, count, thePagingAction, null, includes);
        Bundle bundle = bundleFactory.getDstu1Bundle();
        if (bundle != null) {
            for (int i = this.getInterceptors().size() - 1; i >= 0; --i) {
                IServerInterceptor next = this.getInterceptors().get(i);
                boolean continueProcessing = next.outgoingResponse((RequestDetails)theRequest, bundle, theRequest.getServletRequest(), theRequest.getServletResponse());
                if (continueProcessing) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            RestfulServerUtils.streamResponseAsBundle(this, theResponse, bundle, responseEncoding, theRequest.getFhirServerBase(), prettyPrint, narrativeMode, respondGzip, requestIsBrowser);
        } else {
            IResource resBundle = bundleFactory.getResourceBundle();
            for (int i = this.getInterceptors().size() - 1; i >= 0; --i) {
                IServerInterceptor next = this.getInterceptors().get(i);
                boolean continueProcessing = next.outgoingResponse((RequestDetails)theRequest, resBundle, theRequest.getServletRequest(), theRequest.getServletResponse());
                if (continueProcessing) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            RestfulServerUtils.streamResponseAsResource(this, theResponse, resBundle, responseEncoding, prettyPrint, requestIsBrowser, narrativeMode, 200, theRequest.isRespondGzip(), theRequest.getFhirServerBase(), false);
        }
    }

    protected void handleRequest(RequestTypeEnum theRequestType, HttpServletRequest theRequest, HttpServletResponse theResponse) throws ServletException, IOException {
        for (IServerInterceptor next : this.myInterceptors) {
            boolean continueProcessing = next.incomingRequestPreProcessed(theRequest, theResponse);
            if (continueProcessing) continue;
            ourLog.debug("Interceptor {} returned false, not continuing processing");
            return;
        }
        String fhirServerBase = null;
        boolean requestIsBrowser = RestfulServer.requestIsBrowser(theRequest);
        Request requestDetails = new Request();
        requestDetails.setServer(this);
        try {
            String contentLocation;
            String nextString;
            String resourceName = null;
            String requestFullPath = StringUtils.defaultString((String)theRequest.getRequestURI());
            String servletPath = StringUtils.defaultString((String)theRequest.getServletPath());
            StringBuffer requestUrl = theRequest.getRequestURL();
            String servletContextPath = "";
            if (this.getServletContext() != null) {
                servletContextPath = StringUtils.defaultString((String)this.getServletContext().getContextPath());
            }
            if (ourLog.isTraceEnabled()) {
                ourLog.trace("Request FullPath: {}", (Object)requestFullPath);
                ourLog.trace("Servlet Path: {}", (Object)servletPath);
                ourLog.trace("Request Url: {}", (Object)requestUrl);
                ourLog.trace("Context Path: {}", (Object)servletContextPath);
            }
            IdDt id = null;
            String operation = null;
            String compartment = null;
            String requestPath = this.getRequestPath(requestFullPath, servletContextPath, servletPath);
            if (requestPath.length() > 0 && requestPath.charAt(0) == '/') {
                requestPath = requestPath.substring(1);
            }
            fhirServerBase = this.getServerBaseForRequest(theRequest);
            String completeUrl = StringUtils.isNotBlank((CharSequence)theRequest.getQueryString()) ? requestUrl + "?" + theRequest.getQueryString() : requestUrl.toString();
            HashMap<String, String[]> params = new HashMap<String, String[]>(theRequest.getParameterMap());
            requestDetails.setParameters(params);
            StringTokenizer tok = new StringTokenizer(requestPath, "/");
            if (tok.hasMoreTokens() && RestfulServer.partIsOperation(resourceName = tok.nextToken())) {
                operation = resourceName;
                resourceName = null;
            }
            requestDetails.setResourceName(resourceName);
            ResourceBinding resourceBinding = null;
            BaseMethodBinding<?> resourceMethod = null;
            if ("metadata".equals(resourceName) || theRequestType == RequestTypeEnum.OPTIONS) {
                resourceMethod = this.myServerConformanceMethod;
            } else if (resourceName == null) {
                resourceBinding = this.myServerBinding;
            } else {
                resourceBinding = this.myResourceNameToProvider.get(resourceName);
                if (resourceBinding == null) {
                    throw new InvalidRequestException("Unknown resource type '" + resourceName + "' - Server knows how to handle: " + this.myResourceNameToProvider.keySet());
                }
            }
            if (tok.hasMoreTokens()) {
                nextString = tok.nextToken();
                if (RestfulServer.partIsOperation(nextString)) {
                    operation = nextString;
                } else {
                    id = new IdDt(resourceName, UrlUtil.unescape(nextString));
                }
            }
            if (tok.hasMoreTokens()) {
                nextString = tok.nextToken();
                if (nextString.equals("_history")) {
                    if (tok.hasMoreTokens()) {
                        String versionString = tok.nextToken();
                        if (id == null) {
                            throw new InvalidRequestException("Don't know how to handle request path: " + requestPath);
                        }
                        id = new IdDt(resourceName, id.getIdPart(), UrlUtil.unescape(versionString));
                    } else {
                        operation = "_history";
                    }
                } else if (RestfulServer.partIsOperation(nextString)) {
                    if (operation != null) {
                        throw new InvalidRequestException("URL Path contains two operations: " + requestPath);
                    }
                    operation = nextString;
                } else {
                    compartment = nextString;
                }
            }
            String secondaryOperation = null;
            while (tok.hasMoreTokens()) {
                String nextString2 = tok.nextToken();
                if (operation == null) {
                    operation = nextString2;
                    continue;
                }
                if (secondaryOperation == null) {
                    secondaryOperation = nextString2;
                    continue;
                }
                throw new InvalidRequestException("URL path has unexpected token '" + nextString2 + "' at the end: " + requestPath);
            }
            if (theRequestType == RequestTypeEnum.PUT && (contentLocation = theRequest.getHeader("Content-Location")) != null) {
                id = new IdDt(contentLocation);
            }
            requestDetails.setId(id);
            requestDetails.setOperation(operation);
            requestDetails.setSecondaryOperation(secondaryOperation);
            requestDetails.setCompartmentName(compartment);
            String acceptEncoding = theRequest.getHeader("Accept-Encoding");
            boolean respondGzip = false;
            if (acceptEncoding != null) {
                String[] parts = acceptEncoding.trim().split("\\s*,\\s*");
                for (String string : parts) {
                    if (!string.equals("gzip")) continue;
                    respondGzip = true;
                }
            }
            requestDetails.setRespondGzip(respondGzip);
            requestDetails.setRequestType(theRequestType);
            requestDetails.setFhirServerBase(fhirServerBase);
            requestDetails.setCompleteUrl(completeUrl);
            requestDetails.setServletRequest(theRequest);
            requestDetails.setServletResponse(theResponse);
            String pagingAction = theRequest.getParameter("_getpages");
            if (this.getPagingProvider() != null && StringUtils.isNotBlank((CharSequence)pagingAction)) {
                requestDetails.setOtherOperationType(OtherOperationTypeEnum.GET_PAGE);
                this.handlePagingRequest(requestDetails, theResponse, pagingAction);
                return;
            }
            if (resourceMethod == null && resourceBinding != null) {
                resourceMethod = resourceBinding.getMethod(requestDetails);
            }
            if (resourceMethod == null) {
                StringBuilder b = new StringBuilder();
                b.append("No resource method available for ");
                b.append(theRequestType.name());
                b.append(" operation[");
                b.append(requestPath);
                b.append("]");
                b.append(" with parameters ");
                b.append(params.keySet());
                throw new InvalidRequestException(b.toString());
            }
            requestDetails.setResourceOperationType(resourceMethod.getResourceOperationType());
            requestDetails.setSystemOperationType(resourceMethod.getSystemOperationType());
            requestDetails.setOtherOperationType(resourceMethod.getOtherOperationType());
            for (IServerInterceptor next : this.myInterceptors) {
                boolean continueProcessing = next.incomingRequestPostProcessed(requestDetails, theRequest, theResponse);
                if (continueProcessing) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            resourceMethod.invokeServer(this, requestDetails);
        }
        catch (NotModifiedException e) {
            for (int i = this.getInterceptors().size() - 1; i >= 0; --i) {
                IServerInterceptor next = this.getInterceptors().get(i);
                if (next.handleException(requestDetails, e, theRequest, theResponse)) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            this.writeExceptionToResponse(theResponse, e);
        }
        catch (AuthenticationException e) {
            for (int i = this.getInterceptors().size() - 1; i >= 0; --i) {
                IServerInterceptor next = this.getInterceptors().get(i);
                if (next.handleException(requestDetails, e, theRequest, theResponse)) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            if (requestIsBrowser) {
                theResponse.setHeader("WWW-Authenticate", "BASIC realm=\"FHIR\"");
            }
            this.writeExceptionToResponse(theResponse, e);
        }
        catch (Throwable e) {
            for (int i = this.getInterceptors().size() - 1; i >= 0; --i) {
                IServerInterceptor next = this.getInterceptors().get(i);
                if (next.handleException(requestDetails, e, theRequest, theResponse)) continue;
                ourLog.debug("Interceptor {} returned false, not continuing processing");
                return;
            }
            new ExceptionHandlingInterceptor().handleException(requestDetails, e, theRequest, theResponse);
        }
    }

    public final void init() throws ServletException {
        this.initialize();
        try {
            Collection<Object> providers;
            ourLog.info("Initializing HAPI FHIR restful server");
            ProvidedResourceScanner providedResourceScanner = new ProvidedResourceScanner(this.getFhirContext());
            providedResourceScanner.scanForProvidedResources((Object)this);
            Collection<IResourceProvider> resourceProvider = this.getResourceProviders();
            if (resourceProvider != null) {
                HashMap<String, IResourceProvider> typeToProvider = new HashMap<String, IResourceProvider>();
                for (IResourceProvider nextProvider : resourceProvider) {
                    Class<? extends IBaseResource> resourceType = nextProvider.getResourceType();
                    if (resourceType == null) {
                        throw new NullPointerException("getResourceType() on class '" + nextProvider.getClass().getCanonicalName() + "' returned null");
                    }
                    String resourceName = this.myFhirContext.getResourceDefinition(resourceType).getName();
                    if (typeToProvider.containsKey(resourceName)) {
                        throw new ServletException("Multiple resource providers return resource type[" + resourceName + "]: First[" + ((IResourceProvider)typeToProvider.get(resourceName)).getClass().getCanonicalName() + "] and Second[" + nextProvider.getClass().getCanonicalName() + "]");
                    }
                    typeToProvider.put(resourceName, nextProvider);
                    providedResourceScanner.scanForProvidedResources(nextProvider);
                }
                ourLog.info("Got {} resource providers", (Object)typeToProvider.size());
                for (IResourceProvider provider : typeToProvider.values()) {
                    this.assertProviderIsValid(provider);
                    this.findResourceMethods(provider);
                }
            }
            if ((providers = this.getPlainProviders()) != null) {
                for (Object next : providers) {
                    this.assertProviderIsValid(next);
                    this.findResourceMethods(next);
                }
            }
            this.findResourceMethods(this.getServerProfilesProvider());
            IServerConformanceProvider<? extends IBaseResource> confProvider = this.getServerConformanceProvider();
            if (confProvider == null) {
                confProvider = this.myFhirContext.getVersion().createServerConformanceProvider(this);
            }
            this.findSystemMethods(confProvider);
        }
        catch (Exception ex) {
            ourLog.error("An error occurred while loading request handlers!", (Throwable)ex);
            throw new ServletException("Failed to initialize FHIR Restful server", (Throwable)ex);
        }
        this.myStarted = true;
        ourLog.info("A FHIR has been lit on this server");
    }

    protected void initialize() throws ServletException {
    }

    private void invokeDestroy(Object theProvider) {
        Class<?> clazz = theProvider.getClass();
        this.invokeDestroy(theProvider, clazz);
    }

    private void invokeDestroy(Object theProvider, Class<?> clazz) {
        for (Method m : ReflectionUtil.getDeclaredMethods(clazz)) {
            Destroy destroy = m.getAnnotation(Destroy.class);
            if (destroy == null) continue;
            try {
                m.invoke(theProvider, new Object[0]);
            }
            catch (IllegalAccessException e) {
                ourLog.error("Exception occurred in destroy ", (Throwable)e);
            }
            catch (InvocationTargetException e) {
                ourLog.error("Exception occurred in destroy ", (Throwable)e);
            }
            return;
        }
        Class<?> supertype = clazz.getSuperclass();
        if (!Object.class.equals(supertype)) {
            this.invokeDestroy(theProvider, supertype);
        }
    }

    public boolean isDefaultPrettyPrint() {
        return this.myDefaultPrettyPrint;
    }

    public boolean isUseBrowserFriendlyContentTypes() {
        return this.myUseBrowserFriendlyContentTypes;
    }

    public void registerInterceptor(IServerInterceptor theInterceptor) {
        Validate.notNull((Object)theInterceptor, (String)"Interceptor can not be null", (Object[])new Object[0]);
        this.myInterceptors.add(theInterceptor);
    }

    public static boolean requestIsBrowser(HttpServletRequest theRequest) {
        String userAgent = theRequest.getHeader("User-Agent");
        return userAgent != null && userAgent.contains("Mozilla");
    }

    public void setAddProfileTag(AddProfileTagEnum theAddProfileTag) {
        Validate.notNull((Object)((Object)theAddProfileTag), (String)"theAddProfileTag must not be null", (Object[])new Object[0]);
        this.myAddProfileTag = theAddProfileTag;
    }

    public void setBundleInclusionRule(BundleInclusionRule theBundleInclusionRule) {
        this.myBundleInclusionRule = theBundleInclusionRule;
    }

    public void setDefaultPrettyPrint(boolean theDefaultPrettyPrint) {
        this.myDefaultPrettyPrint = theDefaultPrettyPrint;
    }

    public void setDefaultResponseEncoding(EncodingEnum theDefaultResponseEncoding) {
        Validate.notNull((Object)((Object)theDefaultResponseEncoding), (String)"theDefaultResponseEncoding can not be null", (Object[])new Object[0]);
        this.myDefaultResponseEncoding = theDefaultResponseEncoding;
    }

    public void setETagSupport(ETagSupportEnum theETagSupport) {
        if (theETagSupport == null) {
            throw new NullPointerException("theETagSupport can not be null");
        }
        this.myETagSupport = theETagSupport;
    }

    public void setFhirContext(FhirContext theFhirContext) {
        Validate.notNull((Object)theFhirContext, (String)"FhirContext must not be null", (Object[])new Object[0]);
        this.myFhirContext = theFhirContext;
    }

    public void setImplementationDescription(String theImplementationDescription) {
        this.myImplementationDescription = theImplementationDescription;
    }

    public void setInterceptors(IServerInterceptor ... theList) {
        this.myInterceptors.clear();
        if (theList != null) {
            this.myInterceptors.addAll(Arrays.asList(theList));
        }
    }

    public void setInterceptors(List<IServerInterceptor> theList) {
        this.myInterceptors.clear();
        if (theList != null) {
            this.myInterceptors.addAll(theList);
        }
    }

    public void setPagingProvider(IPagingProvider thePagingProvider) {
        this.myPagingProvider = thePagingProvider;
    }

    public void setPlainProviders(Collection<Object> theProviders) {
        this.myPlainProviders = theProviders;
    }

    public void setPlainProviders(Object ... theProv) {
        this.setPlainProviders(Arrays.asList(theProv));
    }

    public void setProviders(Object ... theProviders) {
        this.myPlainProviders = Arrays.asList(theProviders);
    }

    public void setResourceProviders(Collection<IResourceProvider> theResourceProviders) {
        this.myResourceProviders = theResourceProviders;
    }

    public void setResourceProviders(IResourceProvider ... theResourceProviders) {
        this.myResourceProviders = Arrays.asList(theResourceProviders);
    }

    public void setServerAddressStrategy(IServerAddressStrategy theServerAddressStrategy) {
        Validate.notNull((Object)theServerAddressStrategy, (String)"Server address strategy can not be null", (Object[])new Object[0]);
        this.myServerAddressStrategy = theServerAddressStrategy;
    }

    public void setServerConformanceProvider(Object theServerConformanceProvider) {
        if (this.myStarted) {
            throw new IllegalStateException("Server is already started");
        }
        this.myServerConformanceProvider = theServerConformanceProvider;
    }

    public void setServerName(String theServerName) {
        this.myServerName = theServerName;
    }

    public void setServerVersion(String theServerVersion) {
        this.myServerVersion = theServerVersion;
    }

    public void setUseBrowserFriendlyContentTypes(boolean theUseBrowserFriendlyContentTypes) {
        this.myUseBrowserFriendlyContentTypes = theUseBrowserFriendlyContentTypes;
    }

    public void unregisterInterceptor(IServerInterceptor theInterceptor) {
        Validate.notNull((Object)theInterceptor, (String)"Interceptor can not be null", (Object[])new Object[0]);
        this.myInterceptors.remove(theInterceptor);
    }

    private void writeExceptionToResponse(HttpServletResponse theResponse, BaseServerResponseException theException) throws IOException {
        theResponse.setStatus(theException.getStatusCode());
        this.addHeadersToResponse(theResponse);
        theResponse.setContentType("text/plain");
        theResponse.setCharacterEncoding("UTF-8");
        theResponse.getWriter().write(theException.getMessage());
    }

    private static boolean partIsOperation(String nextString) {
        return nextString.length() > 0 && (nextString.charAt(0) == '_' || nextString.charAt(0) == '$');
    }

    public static enum NarrativeModeEnum {
        NORMAL,
        ONLY,
        SUPPRESS;


        public static NarrativeModeEnum valueOfCaseInsensitive(String theCode) {
            return NarrativeModeEnum.valueOf(NarrativeModeEnum.class, theCode.toUpperCase());
        }
    }
}

