/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.method.Request;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.AddProfileTagEnum;
import ca.uhn.fhir.rest.server.Constants;
import ca.uhn.fhir.rest.server.ETagSupportEnum;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.DateUtils;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestfulServerUtils {
    private static final Logger ourLog = LoggerFactory.getLogger(RestfulServerUtils.class);

    static Integer tryToExtractNamedParameter(HttpServletRequest theRequest, String name) {
        String countString = theRequest.getParameter(name);
        Integer count = null;
        if (StringUtils.isNotBlank((CharSequence)countString)) {
            try {
                count = Integer.parseInt(countString);
            }
            catch (NumberFormatException e) {
                ourLog.debug("Failed to parse _count value '{}': {}", (Object)countString, (Object)e);
            }
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamResponseAsResource(RestfulServer theServer, HttpServletResponse theHttpResponse, IResource theResource, EncodingEnum theResponseEncoding, boolean thePrettyPrint, boolean theRequestIsBrowser, RestfulServer.NarrativeModeEnum theNarrativeMode, int stausCode, boolean theRespondGzip, String theServerBase, boolean theAddContentLocationHeader) throws IOException {
        TagList list;
        EncodingEnum responseEncoding;
        theHttpResponse.setStatus(stausCode);
        if (theAddContentLocationHeader && theResource.getId() != null && theResource.getId().hasIdPart() && StringUtils.isNotBlank((CharSequence)theServerBase)) {
            String resName = theServer.getFhirContext().getResourceDefinition(theResource).getName();
            IdDt fullId = theResource.getId().withServerBase(theServerBase, resName);
            theHttpResponse.addHeader("Content-Location", fullId.getValue());
        }
        if (theServer.getETagSupport() == ETagSupportEnum.ENABLED && theResource.getId().hasVersionIdPart()) {
            theHttpResponse.addHeader("ETag", "W/\"" + theResource.getId().getVersionIdPart() + '\"');
        }
        if (theServer.getAddProfileTag() != AddProfileTagEnum.NEVER) {
            RuntimeResourceDefinition def = theServer.getFhirContext().getResourceDefinition(theResource);
            if (theServer.getAddProfileTag() == AddProfileTagEnum.ALWAYS || !def.isStandardProfile()) {
                RestfulServerUtils.addProfileToBundleEntry(theServer.getFhirContext(), theResource, theServerBase);
            }
        }
        if (theResource instanceof IBaseBinary && theResponseEncoding == null) {
            IBaseBinary bin = (IBaseBinary)((Object)theResource);
            if (StringUtils.isNotBlank((CharSequence)bin.getContentType())) {
                theHttpResponse.setContentType(bin.getContentType());
            } else {
                theHttpResponse.setContentType("application/octet-stream");
            }
            if (bin.getContent() == null || bin.getContent().length == 0) {
                return;
            }
            theHttpResponse.addHeader("Content-Disposition", "Attachment;");
            theHttpResponse.setContentLength(bin.getContent().length);
            ServletOutputStream oos = theHttpResponse.getOutputStream();
            oos.write(bin.getContent());
            oos.close();
            return;
        }
        EncodingEnum encodingEnum = responseEncoding = theResponseEncoding != null ? theResponseEncoding : theServer.getDefaultResponseEncoding();
        if (theRequestIsBrowser && theServer.isUseBrowserFriendlyContentTypes()) {
            theHttpResponse.setContentType(responseEncoding.getBrowserFriendlyBundleContentType());
        } else if (theNarrativeMode == RestfulServer.NarrativeModeEnum.ONLY) {
            theHttpResponse.setContentType("text/html");
        } else {
            theHttpResponse.setContentType(responseEncoding.getResourceContentType());
        }
        theHttpResponse.setCharacterEncoding("UTF-8");
        theServer.addHeadersToResponse(theHttpResponse);
        InstantDt lastUpdated = ResourceMetadataKeyEnum.UPDATED.get(theResource);
        if (lastUpdated != null && !lastUpdated.isEmpty()) {
            theHttpResponse.addHeader("Last-Modified", DateUtils.formatDate((Date)((Date)lastUpdated.getValue())));
        }
        if ((list = (TagList)theResource.getResourceMetadata().get(ResourceMetadataKeyEnum.TAG_LIST)) != null) {
            for (Tag tag : list) {
                if (!StringUtils.isNotBlank((CharSequence)tag.getTerm())) continue;
                theHttpResponse.addHeader("Category", tag.toHeaderValue());
            }
        }
        Writer writer = RestfulServerUtils.getWriter(theHttpResponse, theRespondGzip);
        try {
            if (theNarrativeMode == RestfulServer.NarrativeModeEnum.ONLY) {
                writer.append(theResource.getText().getDiv().getValueAsString());
            } else {
                IParser parser = RestfulServerUtils.getNewParser(theServer.getFhirContext(), responseEncoding, thePrettyPrint, theNarrativeMode);
                parser.setServerBaseUrl(theServerBase);
                parser.encodeResourceToWriter(theResource, writer);
            }
        }
        finally {
            writer.close();
        }
    }

    public static boolean prettyPrintResponse(RestfulServer theServer, Request theRequest) {
        boolean prettyPrint;
        Map<String, String[]> requestParams = theRequest.getParameters();
        String[] pretty = requestParams.remove("_pretty");
        if (pretty != null && pretty.length > 0) {
            prettyPrint = "true".equals(pretty[0]);
        } else {
            prettyPrint = theServer.isDefaultPrettyPrint();
            Enumeration acceptValues = theRequest.getServletRequest().getHeaders("Accept");
            if (acceptValues != null) {
                while (acceptValues.hasMoreElements()) {
                    String nextAcceptHeaderValue = (String)acceptValues.nextElement();
                    if (!nextAcceptHeaderValue.contains("pretty=true")) continue;
                    prettyPrint = true;
                }
            }
        }
        return prettyPrint;
    }

    static Writer getWriter(HttpServletResponse theHttpResponse, boolean theRespondGzip) throws UnsupportedEncodingException, IOException {
        Writer writer;
        if (theRespondGzip) {
            theHttpResponse.addHeader("Content-Encoding", "gzip");
            writer = new OutputStreamWriter((OutputStream)new GZIPOutputStream((OutputStream)theHttpResponse.getOutputStream()), "UTF-8");
        } else {
            writer = theHttpResponse.getWriter();
        }
        return writer;
    }

    public static EncodingEnum determineRequestEncoding(Request theReq) {
        EncodingEnum retVal = RestfulServerUtils.determineRequestEncodingNoDefault(theReq);
        if (retVal != null) {
            return retVal;
        }
        return EncodingEnum.XML;
    }

    public static EncodingEnum determineRequestEncodingNoDefault(Request theReq) {
        EncodingEnum retVal = null;
        Enumeration acceptValues = theReq.getServletRequest().getHeaders("Content-Type");
        if (acceptValues != null) {
            block0: while (acceptValues.hasMoreElements() && retVal == null) {
                String nextAcceptHeaderValue = (String)acceptValues.nextElement();
                if (nextAcceptHeaderValue == null || !StringUtils.isNotBlank((CharSequence)nextAcceptHeaderValue)) continue;
                for (String nextPart : nextAcceptHeaderValue.split(",")) {
                    int scIdx = nextPart.indexOf(59);
                    if (scIdx == 0) continue;
                    if (scIdx != -1) {
                        nextPart = nextPart.substring(0, scIdx);
                    }
                    if ((retVal = Constants.FORMAT_VAL_TO_ENCODING.get(nextPart = nextPart.trim())) != null) continue block0;
                }
            }
        }
        return retVal;
    }

    public static String createPagingLink(Set<Include> theIncludes, String theServerBase, String theSearchId, int theOffset, int theCount, EncodingEnum theResponseEncoding, boolean thePrettyPrint) {
        try {
            StringBuilder b = new StringBuilder();
            b.append(theServerBase);
            b.append('?');
            b.append("_getpages");
            b.append('=');
            b.append(URLEncoder.encode(theSearchId, "UTF-8"));
            b.append('&');
            b.append("_getpagesoffset");
            b.append('=');
            b.append(theOffset);
            b.append('&');
            b.append("_count");
            b.append('=');
            b.append(theCount);
            if (theResponseEncoding != null) {
                b.append('&');
                b.append("_format");
                b.append('=');
                b.append(theResponseEncoding.getRequestContentType());
            }
            if (thePrettyPrint) {
                b.append('&');
                b.append("_pretty");
                b.append('=');
                b.append("true");
            }
            if (theIncludes != null) {
                for (Include nextInclude : theIncludes) {
                    if (!StringUtils.isNotBlank((CharSequence)nextInclude.getValue())) continue;
                    b.append('&');
                    b.append("_include");
                    b.append('=');
                    b.append(URLEncoder.encode(nextInclude.getValue(), "UTF-8"));
                }
            }
            return b.toString();
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UTF-8 not supported", e);
        }
    }

    public static void addProfileToBundleEntry(FhirContext theContext, IResource theResource, String theServerBase) {
        RuntimeResourceDefinition nextDef;
        String profile;
        TagList tl = ResourceMetadataKeyEnum.TAG_LIST.get(theResource);
        if (tl == null) {
            tl = new TagList();
            ResourceMetadataKeyEnum.TAG_LIST.put(theResource, tl);
        }
        if (StringUtils.isNotBlank((CharSequence)(profile = (nextDef = theContext.getResourceDefinition(theResource)).getResourceProfile(theServerBase)))) {
            tl.add(new Tag("http://hl7.org/fhir/tag/profile", profile, null));
        }
    }

    public static RestfulServer.NarrativeModeEnum determineNarrativeMode(RequestDetails theRequest) {
        Map<String, String[]> requestParams = theRequest.getParameters();
        String[] narrative = requestParams.remove("_narrative");
        RestfulServer.NarrativeModeEnum narrativeMode = null;
        if (narrative != null && narrative.length > 0) {
            try {
                narrativeMode = RestfulServer.NarrativeModeEnum.valueOfCaseInsensitive(narrative[0]);
            }
            catch (IllegalArgumentException e) {
                ourLog.debug("Invalid {} parameger: {}", (Object)"_narrative", (Object)narrative[0]);
                narrativeMode = null;
            }
        }
        if (narrativeMode == null) {
            narrativeMode = RestfulServer.NarrativeModeEnum.NORMAL;
        }
        return narrativeMode;
    }

    public static EncodingEnum determineResponseEncodingWithDefault(RestfulServer theServer, HttpServletRequest theReq) {
        EncodingEnum retVal = RestfulServerUtils.determineResponseEncodingNoDefault(theReq);
        if (retVal == null) {
            retVal = theServer.getDefaultResponseEncoding();
        }
        return retVal;
    }

    public static IParser getNewParser(FhirContext theContext, EncodingEnum theResponseEncoding, boolean thePrettyPrint, RestfulServer.NarrativeModeEnum theNarrativeMode) {
        IParser parser;
        switch (theResponseEncoding) {
            case JSON: {
                parser = theContext.newJsonParser();
                break;
            }
            default: {
                parser = theContext.newXmlParser();
            }
        }
        return parser.setPrettyPrint(thePrettyPrint).setSuppressNarratives(theNarrativeMode == RestfulServer.NarrativeModeEnum.SUPPRESS);
    }

    public static EncodingEnum determineResponseEncodingNoDefault(HttpServletRequest theReq) {
        Enumeration acceptValues;
        String[] format = theReq.getParameterValues("_format");
        if (format != null) {
            for (String nextFormat : format) {
                EncodingEnum retVal = Constants.FORMAT_VAL_TO_ENCODING.get(nextFormat);
                if (retVal == null) continue;
                return retVal;
            }
        }
        if ((acceptValues = theReq.getHeaders("Accept")) != null) {
            while (acceptValues.hasMoreElements()) {
                String nextAcceptHeaderValue = (String)acceptValues.nextElement();
                if (nextAcceptHeaderValue == null || !StringUtils.isNotBlank((CharSequence)nextAcceptHeaderValue)) continue;
                for (String nextPart : nextAcceptHeaderValue.split(",")) {
                    EncodingEnum retVal;
                    int scIdx = nextPart.indexOf(59);
                    if (scIdx == 0) continue;
                    if (scIdx != -1) {
                        nextPart = nextPart.substring(0, scIdx);
                    }
                    if ((retVal = Constants.FORMAT_VAL_TO_ENCODING.get(nextPart = nextPart.trim())) == null) continue;
                    return retVal;
                }
            }
        }
        return null;
    }

    public static Integer extractCountParameter(HttpServletRequest theRequest) {
        return RestfulServerUtils.tryToExtractNamedParameter(theRequest, "_count");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void streamResponseAsBundle(RestfulServer theServer, HttpServletResponse theHttpResponse, Bundle bundle, EncodingEnum theResponseEncoding, String theServerBase, boolean thePrettyPrint, RestfulServer.NarrativeModeEnum theNarrativeMode, boolean theRespondGzip, boolean theRequestIsBrowser) throws IOException {
        EncodingEnum responseEncoding;
        assert (!theServerBase.endsWith("/"));
        theHttpResponse.setStatus(200);
        EncodingEnum encodingEnum = responseEncoding = theResponseEncoding != null ? theResponseEncoding : theServer.getDefaultResponseEncoding();
        if (theRequestIsBrowser && theServer.isUseBrowserFriendlyContentTypes()) {
            theHttpResponse.setContentType(responseEncoding.getBrowserFriendlyBundleContentType());
        } else if (theNarrativeMode == RestfulServer.NarrativeModeEnum.ONLY) {
            theHttpResponse.setContentType("text/html");
        } else {
            theHttpResponse.setContentType(responseEncoding.getBundleContentType());
        }
        theHttpResponse.setCharacterEncoding("UTF-8");
        theServer.addHeadersToResponse(theHttpResponse);
        Writer writer = RestfulServerUtils.getWriter(theHttpResponse, theRespondGzip);
        try {
            if (theNarrativeMode == RestfulServer.NarrativeModeEnum.ONLY) {
                for (IResource next : bundle.toListOfResources()) {
                    writer.append(next.getText().getDiv().getValueAsString());
                    writer.append("<hr/>");
                }
            } else {
                IParser parser = RestfulServerUtils.getNewParser(theServer.getFhirContext(), responseEncoding, thePrettyPrint, theNarrativeMode);
                parser.setServerBaseUrl(theServerBase);
                parser.encodeBundleToWriter(bundle, writer);
            }
        }
        finally {
            writer.close();
        }
    }

    public static void validateResourceListNotNull(List<IResource> theResourceList) {
        if (theResourceList == null) {
            throw new InternalErrorException("IBundleProvider returned a null list of resources - This is not allowed");
        }
    }
}

