/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server;

import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.rest.server.IBundleProvider;
import java.util.Collections;
import java.util.List;

public class SimpleBundleProvider
implements IBundleProvider {
    private List<IResource> myList;

    public SimpleBundleProvider(List<IResource> theList) {
        this.myList = theList;
    }

    public SimpleBundleProvider(IResource theResource) {
        this.myList = Collections.singletonList(theResource);
    }

    public SimpleBundleProvider() {
        this.myList = Collections.emptyList();
    }

    @Override
    public List<IResource> getResources(int theFromIndex, int theToIndex) {
        return this.myList.subList(theFromIndex, Math.min(theToIndex, this.myList.size()));
    }

    @Override
    public int size() {
        return this.myList.size();
    }

    @Override
    public InstantDt getPublished() {
        return InstantDt.withCurrentTime();
    }

    @Override
    public Integer preferredPageSize() {
        return null;
    }
}

