/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.exceptions;

import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.base.composite.BaseIdentifierDt;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;

public class ResourceGoneException
extends BaseServerResponseException {
    public static final int STATUS_CODE = 410;
    private static final long serialVersionUID = 1L;

    public ResourceGoneException(IdDt theId) {
        super(410, "Resource " + (theId != null ? theId.getValue() : "") + " is gone/deleted");
    }

    public ResourceGoneException(Class<? extends IResource> theClass, BaseIdentifierDt thePatientId) {
        super(410, "Resource of type " + theClass.getSimpleName() + " with ID " + thePatientId + " is gone/deleted");
    }

    public ResourceGoneException(Class<? extends IResource> theClass, IdDt thePatientId) {
        super(410, "Resource of type " + theClass.getSimpleName() + " with ID " + thePatientId + " is gone/deleted");
    }

    public ResourceGoneException(String theMessage, BaseOperationOutcome theOperationOutcome) {
        super(410, theMessage, theOperationOutcome);
    }

    public ResourceGoneException(String theMessage) {
        super(410, theMessage);
    }
}

