/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.rest.method.Request;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.RestfulServer;
import ca.uhn.fhir.rest.server.RestfulServerUtils;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import java.io.IOException;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionHandlingInterceptor
extends InterceptorAdapter {
    private static final Logger ourLog = LoggerFactory.getLogger(ExceptionHandlingInterceptor.class);
    private Class<?>[] myReturnStackTracesForExceptionTypes;

    public ExceptionHandlingInterceptor setReturnStackTracesForExceptionTypes(Class<?> ... theExceptionTypes) {
        this.myReturnStackTracesForExceptionTypes = theExceptionTypes;
        return this;
    }

    @Override
    public boolean handleException(RequestDetails theRequestDetails, Throwable theException, HttpServletRequest theRequest, HttpServletResponse theResponse) throws ServletException, IOException {
        Map<String, String[]> additional;
        BaseOperationOutcome oo = null;
        int statusCode = 500;
        FhirContext ctx = theRequestDetails.getServer().getFhirContext();
        if (theException instanceof BaseServerResponseException) {
            oo = ((BaseServerResponseException)theException).getOperationOutcome();
            statusCode = ((BaseServerResponseException)theException).getStatusCode();
        }
        if (oo == null) {
            try {
                oo = (BaseOperationOutcome)ctx.getResourceDefinition("OperationOutcome").getImplementingClass().newInstance();
            }
            catch (Exception e1) {
                ourLog.error("Failed to instantiate OperationOutcome resource instance", (Throwable)e1);
                throw new ServletException("Failed to instantiate OperationOutcome resource instance", (Throwable)e1);
            }
            BaseOperationOutcome.BaseIssue issue = oo.addIssue();
            issue.getSeverityElement().setValue("error");
            if (theException instanceof InternalErrorException) {
                ourLog.error("Failure during REST processing", theException);
                this.populateDetails(theException, issue);
            } else if (theException instanceof BaseServerResponseException) {
                ourLog.warn("Failure during REST processing: {}", theException);
                BaseServerResponseException baseServerResponseException = (BaseServerResponseException)theException;
                statusCode = baseServerResponseException.getStatusCode();
                this.populateDetails(theException, issue);
                if (baseServerResponseException.getAdditionalMessages() != null) {
                    for (String next : baseServerResponseException.getAdditionalMessages()) {
                        BaseOperationOutcome.BaseIssue issue2 = oo.addIssue();
                        issue2.getSeverityElement().setValue("error");
                        issue2.setDetails(next);
                    }
                }
            } else {
                ourLog.error("Failure during REST processing: " + theException.toString(), theException);
                this.populateDetails(theException, issue);
                statusCode = 500;
            }
        } else {
            ourLog.error("Unknown error during processing", theException);
        }
        if (theException instanceof BaseServerResponseException && (additional = ((BaseServerResponseException)theException).getAssociatedHeaders()) != null) {
            for (Map.Entry<String, String[]> next : additional.entrySet()) {
                if (!StringUtils.isNotBlank((CharSequence)next.getKey()) || next.getValue() == null) continue;
                String nextKey = next.getKey();
                for (String nextValue : next.getValue()) {
                    theResponse.addHeader(nextKey, nextValue);
                }
            }
        }
        boolean requestIsBrowser = RestfulServer.requestIsBrowser(theRequest);
        String fhirServerBase = ((Request)theRequestDetails).getFhirServerBase();
        RestfulServerUtils.streamResponseAsResource(theRequestDetails.getServer(), theResponse, oo, RestfulServerUtils.determineResponseEncodingNoDefault(theRequest), true, requestIsBrowser, RestfulServer.NarrativeModeEnum.NORMAL, statusCode, false, fhirServerBase, false);
        return false;
    }

    private void populateDetails(Throwable theException, BaseOperationOutcome.BaseIssue issue) {
        if (this.myReturnStackTracesForExceptionTypes != null) {
            for (Class<?> next : this.myReturnStackTracesForExceptionTypes) {
                if (!next.isAssignableFrom(theException.getClass())) continue;
                issue.getDetailsElement().setValue(theException.getMessage() + "\n\n" + ExceptionUtils.getStackTrace((Throwable)theException));
                return;
            }
        }
        issue.getDetailsElement().setValue(theException.getMessage());
    }
}

