/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.interceptor;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.rest.method.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.AuthenticationException;
import ca.uhn.fhir.rest.server.interceptor.InterceptorAdapter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.StrLookup;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingInterceptor
extends InterceptorAdapter {
    private static final Logger ourLog = LoggerFactory.getLogger(LoggingInterceptor.class);
    private Logger myLogger = ourLog;
    private String myMessageFormat = "${operationType} - ${idOrResourceName}";

    @Override
    public boolean incomingRequestPostProcessed(RequestDetails theRequestDetails, HttpServletRequest theRequest, HttpServletResponse theResponse) throws AuthenticationException {
        MyLookup lookup = new MyLookup(theRequest, theRequestDetails);
        StrSubstitutor subs = new StrSubstitutor((StrLookup)lookup, "${", "}", '\\');
        String line = subs.replace(this.myMessageFormat);
        this.myLogger.info(line);
        return true;
    }

    public void setLogger(Logger theLogger) {
        Validate.notNull((Object)theLogger, (String)"Logger can not be null", (Object[])new Object[0]);
        this.myLogger = theLogger;
    }

    public void setLoggerName(String theLoggerName) {
        Validate.notBlank((CharSequence)theLoggerName, (String)"Logger name can not be null/empty", (Object[])new Object[0]);
        this.myLogger = LoggerFactory.getLogger((String)theLoggerName);
    }

    public void setMessageFormat(String theMessageFormat) {
        Validate.notBlank((CharSequence)theMessageFormat, (String)"Message format can not be null/empty", (Object[])new Object[0]);
        this.myMessageFormat = theMessageFormat;
    }

    private static final class MyLookup
    extends StrLookup<String> {
        private final HttpServletRequest myRequest;
        private final RequestDetails myRequestDetails;

        private MyLookup(HttpServletRequest theRequest, RequestDetails theRequestDetails) {
            this.myRequest = theRequest;
            this.myRequestDetails = theRequestDetails;
        }

        public String lookup(String theKey) {
            if ("operationType".equals(theKey)) {
                if (this.myRequestDetails.getResourceOperationType() != null) {
                    return this.myRequestDetails.getResourceOperationType().getCode();
                }
                if (this.myRequestDetails.getSystemOperationType() != null) {
                    return this.myRequestDetails.getSystemOperationType().getCode();
                }
                if (this.myRequestDetails.getOtherOperationType() != null) {
                    return this.myRequestDetails.getOtherOperationType().getCode();
                }
                return "";
            }
            if ("id".equals(theKey)) {
                if (this.myRequestDetails.getId() != null) {
                    return this.myRequestDetails.getId().getValue();
                }
                return "";
            }
            if ("servletPath".equals(theKey)) {
                return StringUtils.defaultString((String)this.myRequest.getServletPath());
            }
            if ("idOrResourceName".equals(theKey)) {
                if (this.myRequestDetails.getId() != null) {
                    return this.myRequestDetails.getId().getValue();
                }
                if (this.myRequestDetails.getResourceName() != null) {
                    return this.myRequestDetails.getResourceName();
                }
                return "";
            }
            if (theKey.equals("requestParameters")) {
                StringBuilder b = new StringBuilder();
                for (Map.Entry<String, String[]> next : this.myRequestDetails.getParameters().entrySet()) {
                    for (String nextValue : next.getValue()) {
                        if (b.length() == 0) {
                            b.append('?');
                        } else {
                            b.append('&');
                        }
                        try {
                            b.append(URLEncoder.encode(next.getKey(), "UTF-8"));
                            b.append('=');
                            b.append(URLEncoder.encode(nextValue, "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            throw new ConfigurationException("UTF-8 not supported", e);
                        }
                    }
                }
                return b.toString();
            }
            if (theKey.startsWith("requestHeader.")) {
                String val = this.myRequest.getHeader(theKey.substring("requestHeader.".length()));
                return StringUtils.defaultString((String)val);
            }
            if (theKey.startsWith("remoteAddr")) {
                return StringUtils.defaultString((String)this.myRequest.getRemoteAddr());
            }
            return "!VAL!";
        }
    }
}

