/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.model.api.ICompositeElement;
import ca.uhn.fhir.model.api.IElement;
import java.util.ArrayList;
import java.util.List;

public class ElementUtil {
    public static boolean isEmpty(Object ... theElements) {
        if (theElements == null) {
            return true;
        }
        for (int i = 0; i < theElements.length; ++i) {
            Object next = theElements[i];
            if (next instanceof List) {
                if (ElementUtil.isEmpty((List)next)) continue;
                return false;
            }
            if (next instanceof String && !((String)next).isEmpty()) {
                return false;
            }
            if (next == null || ((IElement)next).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(IElement ... theElements) {
        if (theElements == null) {
            return true;
        }
        for (int i = 0; i < theElements.length; ++i) {
            IElement next = theElements[i];
            if (next == null || next.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmpty(List<? extends IElement> theElements) {
        if (theElements == null) {
            return true;
        }
        for (int i = 0; i < theElements.size(); ++i) {
            IElement next = theElements.get(i);
            if (next == null || next.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public static <T extends IElement> List<T> allPopulatedChildElements(Class<T> theType, Object ... theElements) {
        ArrayList retVal = new ArrayList();
        for (Object next : theElements) {
            if (next == null) continue;
            if (next instanceof IElement) {
                ElementUtil.addElement(retVal, (IElement)next, theType);
                continue;
            }
            if (next instanceof List) {
                for (Object nextElement : (List)next) {
                    if (!(nextElement instanceof IElement)) {
                        throw new IllegalArgumentException("Found element of " + nextElement.getClass());
                    }
                    ElementUtil.addElement(retVal, (IElement)nextElement, theType);
                }
                continue;
            }
            throw new IllegalArgumentException("Found element of " + next.getClass());
        }
        return retVal;
    }

    private static <T extends IElement> void addElement(ArrayList<T> retVal, IElement next, Class<T> theType) {
        if (theType == null || theType.isAssignableFrom(next.getClass())) {
            retVal.add(next);
        }
        if (next instanceof ICompositeElement) {
            retVal.addAll(((ICompositeElement)next).getAllPopulatedChildElementsOfType(theType));
        }
    }
}

