/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildDirectResource;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.model.base.composite.BaseContainedDt;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.util.IModelVisitor;
import ca.uhn.fhir.util.ResourceReferenceInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.IBase;
import org.hl7.fhir.instance.model.IBaseResource;

public class FhirTerser {
    private FhirContext myContext;

    public FhirTerser(FhirContext theContext) {
        this.myContext = theContext;
    }

    private <T extends IBase> void addUndeclaredExtensions(IBase theElement, BaseRuntimeElementDefinition<?> theDefinition, BaseRuntimeChildDefinition theChildDefinition, IModelVisitor theCallback) {
        if (theElement instanceof ISupportsUndeclaredExtensions) {
            ISupportsUndeclaredExtensions containingElement = (ISupportsUndeclaredExtensions)theElement;
            for (ExtensionDt nextExt : containingElement.getUndeclaredExtensions()) {
                theCallback.acceptUndeclaredExtension(containingElement, null, theChildDefinition, theDefinition, nextExt);
                this.addUndeclaredExtensions(nextExt, theDefinition, theChildDefinition, theCallback);
            }
        }
    }

    public <T extends IBase> List<T> getAllPopulatedChildElementsOfType(IBaseResource theResource, final Class<T> theType) {
        final ArrayList retVal = new ArrayList();
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        this.visit(theResource, null, null, def, new IModelVisitor(){

            @Override
            public void acceptElement(IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition) {
                if (theElement == null || theElement.isEmpty()) {
                    return;
                }
                if (theType.isAssignableFrom(theElement.getClass())) {
                    retVal.add(theElement);
                }
            }

            @Override
            public void acceptUndeclaredExtension(ISupportsUndeclaredExtensions theContainingElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition, ExtensionDt theNextExt) {
                if (theType.isAssignableFrom(theNextExt.getClass())) {
                    retVal.add(theNextExt);
                }
                if (theNextExt.getValue() != null && theType.isAssignableFrom(theNextExt.getValue().getClass())) {
                    retVal.add(theNextExt.getValue());
                }
            }
        });
        return retVal;
    }

    public <T extends IBase> List<ResourceReferenceInfo> getAllResourceReferences(final IBaseResource theResource) {
        final ArrayList<ResourceReferenceInfo> retVal = new ArrayList<ResourceReferenceInfo>();
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        this.visit(theResource, null, null, def, new IModelVisitor(){

            @Override
            public void acceptElement(IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition) {
                if (theElement == null || theElement.isEmpty()) {
                    return;
                }
                if (BaseResourceReferenceDt.class.isAssignableFrom(theElement.getClass())) {
                    retVal.add(new ResourceReferenceInfo(theResource, thePathToElement, (BaseResourceReferenceDt)theElement));
                }
            }

            @Override
            public void acceptUndeclaredExtension(ISupportsUndeclaredExtensions theContainingElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition, ExtensionDt theNextExt) {
                if (theNextExt.getValue() != null && BaseResourceReferenceDt.class.isAssignableFrom(theNextExt.getValue().getClass())) {
                    retVal.add(new ResourceReferenceInfo(theResource, thePathToElement, (BaseResourceReferenceDt)theNextExt.getValue()));
                }
            }
        });
        return retVal;
    }

    private BaseRuntimeChildDefinition getDefinition(BaseRuntimeElementCompositeDefinition<?> theCurrentDef, List<String> theSubList) {
        BaseRuntimeChildDefinition nextDef = theCurrentDef.getChildByNameOrThrowDataFormatException(theSubList.get(0));
        if (theSubList.size() == 1) {
            return nextDef;
        }
        BaseRuntimeElementCompositeDefinition cmp = (BaseRuntimeElementCompositeDefinition)nextDef.getChildByName(theSubList.get(0));
        return this.getDefinition(cmp, theSubList.subList(1, theSubList.size()));
    }

    public BaseRuntimeChildDefinition getDefinition(Class<? extends IResource> theResourceType, String thePath) {
        RuntimeResourceDefinition def;
        RuntimeResourceDefinition currentDef = def = this.myContext.getResourceDefinition(theResourceType);
        List<String> parts = Arrays.asList(thePath.split("\\."));
        List<String> subList = parts.subList(1, parts.size());
        if (subList.size() < 1) {
            throw new ConfigurationException("Invalid path: " + thePath);
        }
        return this.getDefinition(currentDef, subList);
    }

    private List<Object> getValues(BaseRuntimeElementCompositeDefinition<?> theCurrentDef, Object theCurrentObj, List<String> theSubList) {
        String name = theSubList.get(0);
        BaseRuntimeChildDefinition nextDef = theCurrentDef.getChildByNameOrThrowDataFormatException(name);
        List<IBase> values = nextDef.getAccessor().getValues(theCurrentObj);
        ArrayList<Object> retVal = new ArrayList<Object>();
        if (theSubList.size() == 1) {
            if (nextDef instanceof RuntimeChildChoiceDefinition) {
                for (IBase next : values) {
                    if (next == null) continue;
                    if (name.endsWith("[x]")) {
                        retVal.add(next);
                        continue;
                    }
                    String childName = nextDef.getChildNameByDatatype(next.getClass());
                    if (!theSubList.get(0).equals(childName)) continue;
                    retVal.add(next);
                }
            } else {
                retVal.addAll(values);
            }
        } else {
            for (IBase nextElement : values) {
                BaseRuntimeElementCompositeDefinition nextChildDef = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(nextElement.getClass());
                List<Object> foundValues = this.getValues(nextChildDef, nextElement, theSubList.subList(1, theSubList.size()));
                retVal.addAll(foundValues);
            }
        }
        return retVal;
    }

    public List<Object> getValues(IBaseResource theResource, String thePath) {
        RuntimeResourceDefinition def;
        RuntimeResourceDefinition currentDef = def = this.myContext.getResourceDefinition(theResource);
        IBaseResource currentObj = theResource;
        List<String> parts = Arrays.asList(thePath.split("\\."));
        List<String> subList = parts.subList(1, parts.size());
        if (subList.size() < 1) {
            throw new ConfigurationException("Invalid path: " + thePath);
        }
        return this.getValues(currentDef, currentObj, subList);
    }

    private List<String> addNameToList(List<String> theCurrentList, BaseRuntimeChildDefinition theChildDefinition) {
        if (theChildDefinition == null) {
            return null;
        }
        if (theCurrentList == null || theCurrentList.isEmpty()) {
            return new ArrayList<String>(Arrays.asList(theChildDefinition.getElementName()));
        }
        ArrayList<String> newList = new ArrayList<String>(theCurrentList);
        newList.add(theChildDefinition.getElementName());
        return newList;
    }

    private void visit(IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition, IModelVisitor theCallback) {
        List<String> pathToElement = this.addNameToList(thePathToElement, theChildDefinition);
        theCallback.acceptElement(theElement, pathToElement, theChildDefinition, theDefinition);
        this.addUndeclaredExtensions(theElement, theDefinition, theChildDefinition, theCallback);
        switch (theDefinition.getChildType()) {
            case PRIMITIVE_XHTML: 
            case PRIMITIVE_DATATYPE: {
                break;
            }
            case RESOURCE_REF: {
                IResource theResource;
                BaseResourceReferenceDt resRefDt = (BaseResourceReferenceDt)theElement;
                if (resRefDt.getReference().getValue() != null || resRefDt.getResource() == null || (theResource = resRefDt.getResource()).getId() != null && !theResource.getId().isEmpty() && !theResource.getId().isLocal()) break;
                RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
                this.visit(theResource, pathToElement, null, def, theCallback);
                break;
            }
            case RESOURCE: 
            case RESOURCE_BLOCK: 
            case COMPOSITE_DATATYPE: {
                BaseRuntimeElementCompositeDefinition childDef = (BaseRuntimeElementCompositeDefinition)theDefinition;
                for (BaseRuntimeChildDefinition baseRuntimeChildDefinition : childDef.getChildrenAndExtension()) {
                    List<IBase> values = baseRuntimeChildDefinition.getAccessor().getValues(theElement);
                    if (values == null) continue;
                    for (IBase nextValue : values) {
                        if (nextValue == null || nextValue.isEmpty()) continue;
                        BaseRuntimeElementDefinition<?> childElementDef = baseRuntimeChildDefinition.getChildElementDefinitionByDatatype(nextValue.getClass());
                        if (childElementDef == null) {
                            StringBuilder b = new StringBuilder();
                            b.append("Found value of type[");
                            b.append(nextValue.getClass().getSimpleName());
                            b.append("] which is not valid for field[");
                            b.append(baseRuntimeChildDefinition.getElementName());
                            b.append("] in ");
                            b.append(childDef.getName());
                            b.append(" - Valid types: ");
                            Iterator<String> iter = new TreeSet<String>(baseRuntimeChildDefinition.getValidChildNames()).iterator();
                            while (iter.hasNext()) {
                                BaseRuntimeElementDefinition<?> childByName = baseRuntimeChildDefinition.getChildByName(iter.next());
                                b.append(childByName.getImplementingClass().getSimpleName());
                                if (!iter.hasNext()) continue;
                                b.append(", ");
                            }
                            throw new DataFormatException(b.toString());
                        }
                        if (baseRuntimeChildDefinition instanceof RuntimeChildDirectResource) {
                            theCallback.acceptElement(nextValue, null, baseRuntimeChildDefinition, childElementDef);
                            continue;
                        }
                        this.visit(nextValue, pathToElement, baseRuntimeChildDefinition, childElementDef, theCallback);
                    }
                }
                break;
            }
            case CONTAINED_RESOURCES: {
                BaseContainedDt value = (BaseContainedDt)theElement;
                for (IResource iResource : value.getContainedResources()) {
                    RuntimeResourceDefinition def = this.myContext.getResourceDefinition(iResource);
                    this.visit(iResource, pathToElement, null, def, theCallback);
                }
                break;
            }
            case EXTENSION_DECLARED: 
            case UNDECL_EXT: {
                throw new IllegalStateException("state should not happen: " + (Object)((Object)theDefinition.getChildType()));
            }
        }
    }

    public void visit(IBaseResource theResource, IModelVisitor theVisitor) {
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition(theResource);
        this.visit(theResource, null, null, def, theVisitor);
    }

    public Object getSingleValueOrNull(IBase theTarget, String thePath) {
        Validate.notNull((Object)theTarget, (String)"theTarget must not be null", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)thePath, (String)"thePath must not be empty", (Object[])new Object[0]);
        BaseRuntimeElementDefinition<?> def = this.myContext.getElementDefinition(theTarget.getClass());
        if (!(def instanceof BaseRuntimeElementCompositeDefinition)) {
            throw new IllegalArgumentException("Target is not a composite type: " + theTarget.getClass().getName());
        }
        BaseRuntimeElementCompositeDefinition currentDef = (BaseRuntimeElementCompositeDefinition)def;
        IBase currentObj = theTarget;
        List<String> parts = Arrays.asList(thePath.split("\\."));
        List<Object> retVal = this.getValues(currentDef, currentObj, parts);
        if (retVal.isEmpty()) {
            return null;
        }
        return retVal.get(0);
    }
}

