/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.LinkedHashSet;

public class ReflectionUtil {
    public static Class<?> getGenericCollectionTypeOfField(Field next) {
        Class type;
        ParameterizedType collectionType = (ParameterizedType)next.getGenericType();
        Type firstArg = collectionType.getActualTypeArguments()[0];
        if (ParameterizedType.class.isAssignableFrom(firstArg.getClass())) {
            ParameterizedType pt = (ParameterizedType)firstArg;
            type = (Class)pt.getRawType();
        } else {
            type = (Class)firstArg;
        }
        return type;
    }

    public static Class<?> getGenericCollectionTypeOfMethodParameter(Method theMethod, int theParamIndex) {
        Class type;
        Type genericParameterType = theMethod.getGenericParameterTypes()[theParamIndex];
        if (Class.class.equals((Object)genericParameterType)) {
            return null;
        }
        ParameterizedType collectionType = (ParameterizedType)genericParameterType;
        Type firstArg = collectionType.getActualTypeArguments()[0];
        if (ParameterizedType.class.isAssignableFrom(firstArg.getClass())) {
            ParameterizedType pt = (ParameterizedType)firstArg;
            type = (Class)pt.getRawType();
        } else {
            type = (Class)firstArg;
        }
        return type;
    }

    public static Class<?> getGenericCollectionTypeOfMethodReturnType(Method theMethod) {
        Class type;
        Type genericReturnType = theMethod.getGenericReturnType();
        if (!(genericReturnType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType collectionType = (ParameterizedType)genericReturnType;
        Type firstArg = collectionType.getActualTypeArguments()[0];
        if (ParameterizedType.class.isAssignableFrom(firstArg.getClass())) {
            ParameterizedType pt = (ParameterizedType)firstArg;
            type = (Class)pt.getRawType();
        } else {
            if (firstArg instanceof TypeVariable) {
                Type decl = ((TypeVariable)firstArg).getBounds()[0];
                return (Class)decl;
            }
            if (firstArg instanceof WildcardType) {
                Type decl = ((WildcardType)firstArg).getUpperBounds()[0];
                return (Class)decl;
            }
            type = (Class)firstArg;
        }
        return type;
    }

    public static LinkedHashSet<Method> getDeclaredMethods(Class<?> theClazz) {
        LinkedHashSet<Method> retVal = new LinkedHashSet<Method>();
        for (Method next : theClazz.getDeclaredMethods()) {
            try {
                Method method = theClazz.getMethod(next.getName(), next.getParameterTypes());
                retVal.add(method);
            }
            catch (NoSuchMethodException e) {
                retVal.add(next);
            }
            catch (SecurityException e) {
                retVal.add(next);
            }
        }
        return retVal;
    }
}

