/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.IBaseResource;

public class ResourceReferenceInfo {
    private String myOwningResource;
    private String myName;
    private BaseResourceReferenceDt myResource;

    public ResourceReferenceInfo(IBaseResource theOwningResource, List<String> thePathToElement, BaseResourceReferenceDt theResource) {
        this.myOwningResource = theOwningResource.getClass().getAnnotation(ResourceDef.class).name();
        this.myResource = theResource;
        if (thePathToElement != null && !thePathToElement.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            thePathToElement.iterator();
            Iterator<String> iterator = thePathToElement.iterator();
            while (iterator.hasNext()) {
                sb.append(iterator.next());
                if (!iterator.hasNext()) continue;
                sb.append(".");
            }
            this.myName = sb.toString();
        } else {
            this.myName = null;
        }
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("name", (Object)this.myName);
        b.append("resource", (Object)this.myResource.getReference());
        return b.build();
    }

    public String getName() {
        return this.myName;
    }

    public BaseResourceReferenceDt getResourceReference() {
        return this.myResource;
    }

    public boolean matchesIncludeSet(Set<Include> theIncludes) {
        if (theIncludes == null) {
            return false;
        }
        for (Include include : theIncludes) {
            if (!this.matchesInclude(include)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesInclude(Include theInclude) {
        if (theInclude.getValue().equals("*")) {
            return true;
        }
        if (theInclude.getValue().indexOf(58) != -1) {
            return theInclude.getValue().equals(this.myOwningResource + ':' + this.myName);
        }
        return theInclude.getValue().equals(this.myOwningResource + '.' + this.myName);
    }
}

