/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UrlUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(UrlUtil.class);

    public static String constructAbsoluteUrl(String theBase, String theEndpoint) {
        if (theEndpoint == null) {
            return null;
        }
        if (UrlUtil.isAbsolute(theEndpoint)) {
            return theEndpoint;
        }
        if (theBase == null) {
            return theEndpoint;
        }
        try {
            return new URL(new URL(theBase), theEndpoint).toString();
        }
        catch (MalformedURLException e) {
            ourLog.warn("Failed to resolve relative URL[" + theEndpoint + "] against absolute base[" + theBase + "]", (Throwable)e);
            return theEndpoint;
        }
    }

    public static boolean isAbsolute(String theValue) {
        String value = theValue.toLowerCase();
        return value.startsWith("http://") || value.startsWith("https://");
    }

    public static String constructRelativeUrl(String theParentExtensionUrl, String theExtensionUrl) {
        if (theParentExtensionUrl == null) {
            return theExtensionUrl;
        }
        if (theExtensionUrl == null) {
            return theExtensionUrl;
        }
        int parentLastSlashIdx = theParentExtensionUrl.lastIndexOf(47);
        int childLastSlashIdx = theExtensionUrl.lastIndexOf(47);
        if (parentLastSlashIdx == -1 || childLastSlashIdx == -1) {
            return theExtensionUrl;
        }
        if (parentLastSlashIdx != childLastSlashIdx) {
            return theExtensionUrl;
        }
        if (!theParentExtensionUrl.substring(0, parentLastSlashIdx).equals(theExtensionUrl.substring(0, parentLastSlashIdx))) {
            return theExtensionUrl;
        }
        if (theExtensionUrl.length() > parentLastSlashIdx) {
            return theExtensionUrl.substring(parentLastSlashIdx + 1);
        }
        return theExtensionUrl;
    }

    public static boolean isValid(String theUrl) {
        int slashOffset;
        if (theUrl == null || theUrl.length() < 8) {
            return false;
        }
        String url = theUrl.toLowerCase();
        if (url.charAt(0) != 'h') {
            return false;
        }
        if (url.charAt(1) != 't') {
            return false;
        }
        if (url.charAt(2) != 't') {
            return false;
        }
        if (url.charAt(3) != 'p') {
            return false;
        }
        if (url.charAt(4) == ':') {
            slashOffset = 5;
        } else if (url.charAt(4) == 's') {
            if (url.charAt(5) != ':') {
                return false;
            }
            slashOffset = 6;
        } else {
            return false;
        }
        if (url.charAt(slashOffset) != '/') {
            return false;
        }
        return url.charAt(slashOffset + 1) == '/';
    }

    public static String unescape(String theString) {
        if (theString == null) {
            return null;
        }
        if (theString.indexOf(37) == -1) {
            return theString;
        }
        try {
            return URLDecoder.decode(theString, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new Error("UTF-8 not supported, this shouldn't happen", e);
        }
    }
}

