/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(VersionUtil.class);
    private static String ourVersion;

    public static String getVersion() {
        return ourVersion;
    }

    private static void initialize() {
        InputStream is = null;
        try {
            is = VersionUtil.class.getResourceAsStream("/ca/uhn/fhir/hapi-version.properties");
            Properties p = new Properties();
            p.load(is);
            ourVersion = p.getProperty("version");
            ourLog.info("HAPI FHIR version is: " + ourVersion);
        }
        catch (IOException e) {
            ourLog.warn("Unable to determine HAPI version information", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    static {
        VersionUtil.initialize();
    }
}

