/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import com.ctc.wstx.stax.WstxInputFactory;
import com.ctc.wstx.stax.WstxOutputFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.lang3.StringEscapeUtils;
import org.codehaus.stax2.io.EscapingWriterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlUtil {
    private static final Attributes.Name BUNDLE_SYMBOLIC_NAME = new Attributes.Name("Bundle-SymbolicName");
    private static final Attributes.Name BUNDLE_VENDOR = new Attributes.Name("Bundle-Vendor");
    private static final Attributes.Name BUNDLE_VERSION = new Attributes.Name("Bundle-Version");
    private static final Attributes.Name IMPLEMENTATION_TITLE = new Attributes.Name("Implementation-Title");
    private static final Attributes.Name IMPLEMENTATION_VENDOR = new Attributes.Name("Implementation-Vendor");
    private static final Attributes.Name IMPLEMENTATION_VERSION = new Attributes.Name("Implementation-Version");
    private static volatile boolean ourHaveLoggedStaxImplementation;
    private static volatile XMLInputFactory ourInputFactory;
    private static final Logger ourLog;
    private static volatile XMLOutputFactory ourOutputFactory;
    private static final Map<String, Integer> VALID_ENTITY_NAMES;
    private static final ExtendedEntityReplacingXmlResolver XML_RESOLVER;

    public static XMLEventReader createXmlReader(Reader reader) throws FactoryConfigurationError, XMLStreamException {
        XMLInputFactory inputFactory = XmlUtil.getOrCreateInputFactory();
        XMLEventReader er = inputFactory.createXMLEventReader(reader);
        return er;
    }

    public static XMLStreamWriter createXmlStreamWriter(Writer theWriter) throws FactoryConfigurationError, XMLStreamException {
        XMLOutputFactory outputFactory = XmlUtil.getOrCreateOutputFactory();
        XMLStreamWriter retVal = outputFactory.createXMLStreamWriter(theWriter);
        return retVal;
    }

    public static XMLEventWriter createXmlWriter(Writer theWriter) throws FactoryConfigurationError, XMLStreamException {
        XMLOutputFactory outputFactory = XmlUtil.getOrCreateOutputFactory();
        XMLEventWriter retVal = outputFactory.createXMLEventWriter(theWriter);
        return retVal;
    }

    private static XMLInputFactory getOrCreateInputFactory() throws FactoryConfigurationError {
        if (ourInputFactory == null) {
            XMLInputFactory inputFactory = XMLInputFactory.newInstance();
            if (!ourHaveLoggedStaxImplementation) {
                XmlUtil.logStaxImplementation(inputFactory.getClass());
            }
            try {
                Class.forName("com.ctc.wstx.stax.WstxInputFactory");
                if (inputFactory instanceof WstxInputFactory) {
                    inputFactory.setProperty("com.ctc.wstx.undeclaredEntityResolver", XML_RESOLVER);
                }
            }
            catch (ClassNotFoundException e) {
                ourLog.debug("WstxOutputFactory (Woodstox) not found on classpath");
            }
            ourInputFactory = inputFactory;
        }
        return ourInputFactory;
    }

    private static XMLOutputFactory getOrCreateOutputFactory() throws FactoryConfigurationError {
        if (ourOutputFactory == null) {
            XMLOutputFactory outputFactory = XMLOutputFactory.newInstance();
            if (!ourHaveLoggedStaxImplementation) {
                XmlUtil.logStaxImplementation(outputFactory.getClass());
            }
            try {
                Class.forName("com.ctc.wstx.stax.WstxOutputFactory");
                if (outputFactory instanceof WstxOutputFactory) {
                    outputFactory.setProperty("org.codehaus.stax2.textEscaper", new MyEscaper());
                }
            }
            catch (ClassNotFoundException e) {
                ourLog.debug("WstxOutputFactory (Woodstox) not found on classpath");
            }
            ourOutputFactory = outputFactory;
        }
        return ourOutputFactory;
    }

    private static URL getRootUrlForClass(Class<?> cls) {
        URL url;
        ClassLoader classLoader = cls.getClassLoader();
        String resource = cls.getName().replace('.', '/') + ".class";
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((url = classLoader.getResource(resource)) == null) {
            return null;
        }
        String file = url.getFile();
        if (file.endsWith(resource)) {
            try {
                return new URL(url.getProtocol(), url.getHost(), url.getPort(), file.substring(0, file.length() - resource.length()));
            }
            catch (MalformedURLException ex) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logStaxImplementation(Class<?> theClass) {
        block14: {
            try {
                String version;
                String vendor;
                int i;
                Manifest manifest;
                URL rootUrl = XmlUtil.getRootUrlForClass(theClass);
                if (rootUrl == null) {
                    ourLog.info("Unable to determine location of StAX implementation containing class");
                    break block14;
                }
                URL metaInfUrl = new URL(rootUrl, "META-INF/MANIFEST.MF");
                InputStream is = metaInfUrl.openStream();
                try {
                    manifest = new Manifest(is);
                }
                finally {
                    is.close();
                }
                Attributes attrs = manifest.getMainAttributes();
                String title = attrs.getValue(IMPLEMENTATION_TITLE);
                String symbolicName = attrs.getValue(BUNDLE_SYMBOLIC_NAME);
                if (symbolicName != null && (i = symbolicName.indexOf(59)) != -1) {
                    symbolicName = symbolicName.substring(0, i);
                }
                if ((vendor = attrs.getValue(IMPLEMENTATION_VENDOR)) == null) {
                    vendor = attrs.getValue(BUNDLE_VENDOR);
                }
                if ((version = attrs.getValue(IMPLEMENTATION_VERSION)) == null) {
                    version = attrs.getValue(BUNDLE_VERSION);
                }
                if (ourLog.isDebugEnabled()) {
                    ourLog.debug("FHIR XML procesing will use StAX implementation at {}\n  Title:         {}\n  Symbolic name: {}\n  Vendor:        {}\n  Version:       {}", new Object[]{rootUrl, title, symbolicName, vendor, version});
                } else {
                    ourLog.info("FHIR XML procesing will use StAX implementation '{}' version '{}'", (Object)title, (Object)version);
                }
            }
            catch (Throwable e) {
                ourLog.info("Unable to determine StAX implementation: " + e.getMessage());
            }
            finally {
                ourHaveLoggedStaxImplementation = true;
            }
        }
    }

    public static void main(String[] args) {
        System.out.println(Character.toString('\u00a7'));
    }

    static {
        ourLog = LoggerFactory.getLogger(XmlUtil.class);
        XML_RESOLVER = new ExtendedEntityReplacingXmlResolver();
        HashMap<String, Integer> validEntityNames = new HashMap<String, Integer>();
        validEntityNames.put("nbsp", 160);
        validEntityNames.put("iexcl", 161);
        validEntityNames.put("cent", 162);
        validEntityNames.put("pound", 163);
        validEntityNames.put("curren", 164);
        validEntityNames.put("yen", 165);
        validEntityNames.put("brvbar", 166);
        validEntityNames.put("sect", 167);
        validEntityNames.put("uml", 168);
        validEntityNames.put("copy", 169);
        validEntityNames.put("ordf", 170);
        validEntityNames.put("laquo", 171);
        validEntityNames.put("not", 172);
        validEntityNames.put("shy", 173);
        validEntityNames.put("reg", 174);
        validEntityNames.put("macr", 175);
        validEntityNames.put("deg", 176);
        validEntityNames.put("plusmn", 177);
        validEntityNames.put("sup2", 178);
        validEntityNames.put("sup3", 179);
        validEntityNames.put("acute", 180);
        validEntityNames.put("micro", 181);
        validEntityNames.put("para", 182);
        validEntityNames.put("middot", 183);
        validEntityNames.put("cedil", 184);
        validEntityNames.put("sup1", 185);
        validEntityNames.put("ordm", 186);
        validEntityNames.put("raquo", 187);
        validEntityNames.put("frac14", 188);
        validEntityNames.put("frac12", 189);
        validEntityNames.put("frac34", 190);
        validEntityNames.put("iquest", 191);
        validEntityNames.put("Agrave", 192);
        validEntityNames.put("Aacute", 193);
        validEntityNames.put("Acirc", 194);
        validEntityNames.put("Atilde", 195);
        validEntityNames.put("Auml", 196);
        validEntityNames.put("Aring", 197);
        validEntityNames.put("AElig", 198);
        validEntityNames.put("Ccedil", 199);
        validEntityNames.put("Egrave", 200);
        validEntityNames.put("Eacute", 201);
        validEntityNames.put("Ecirc", 202);
        validEntityNames.put("Euml", 203);
        validEntityNames.put("Igrave", 204);
        validEntityNames.put("Iacute", 205);
        validEntityNames.put("Icirc", 206);
        validEntityNames.put("Iuml", 207);
        validEntityNames.put("ETH", 208);
        validEntityNames.put("Ntilde", 209);
        validEntityNames.put("Ograve", 210);
        validEntityNames.put("Oacute", 211);
        validEntityNames.put("Ocirc", 212);
        validEntityNames.put("Otilde", 213);
        validEntityNames.put("Ouml", 214);
        validEntityNames.put("times", 215);
        validEntityNames.put("Oslash", 216);
        validEntityNames.put("Ugrave", 217);
        validEntityNames.put("Uacute", 218);
        validEntityNames.put("Ucirc", 219);
        validEntityNames.put("Uuml", 220);
        validEntityNames.put("Yacute", 221);
        validEntityNames.put("THORN", 222);
        validEntityNames.put("szlig", 223);
        validEntityNames.put("agrave", 224);
        validEntityNames.put("aacute", 225);
        validEntityNames.put("acirc", 226);
        validEntityNames.put("atilde", 227);
        validEntityNames.put("auml", 228);
        validEntityNames.put("aring", 229);
        validEntityNames.put("aelig", 230);
        validEntityNames.put("ccedil", 231);
        validEntityNames.put("egrave", 232);
        validEntityNames.put("eacute", 233);
        validEntityNames.put("ecirc", 234);
        validEntityNames.put("euml", 235);
        validEntityNames.put("igrave", 236);
        validEntityNames.put("iacute", 237);
        validEntityNames.put("icirc", 238);
        validEntityNames.put("iuml", 239);
        validEntityNames.put("eth", 240);
        validEntityNames.put("ntilde", 241);
        validEntityNames.put("ograve", 242);
        validEntityNames.put("oacute", 243);
        validEntityNames.put("ocirc", 244);
        validEntityNames.put("otilde", 245);
        validEntityNames.put("ouml", 246);
        validEntityNames.put("divide", 247);
        validEntityNames.put("oslash", 248);
        validEntityNames.put("ugrave", 249);
        validEntityNames.put("uacute", 250);
        validEntityNames.put("ucirc", 251);
        validEntityNames.put("uuml", 252);
        validEntityNames.put("yacute", 253);
        validEntityNames.put("thorn", 254);
        validEntityNames.put("yuml", 255);
        VALID_ENTITY_NAMES = Collections.unmodifiableMap(validEntityNames);
    }

    public static class MyEscaper
    implements EscapingWriterFactory {
        public Writer createEscapingWriterFor(OutputStream theOut, String theEnc) throws UnsupportedEncodingException {
            return this.createEscapingWriterFor(new OutputStreamWriter(theOut), theEnc);
        }

        public Writer createEscapingWriterFor(final Writer theW, String theEnc) throws UnsupportedEncodingException {
            return new Writer(){

                @Override
                public void close() throws IOException {
                    theW.close();
                }

                @Override
                public void flush() throws IOException {
                    theW.flush();
                }

                @Override
                public void write(char[] theCbuf, int theOff, int theLen) throws IOException {
                    boolean hasEscapable = false;
                    block3: for (int i = 0; i < theLen && !hasEscapable; ++i) {
                        char nextChar = theCbuf[i + theOff];
                        switch (nextChar) {
                            case '\"': 
                            case '&': 
                            case '<': 
                            case '>': {
                                hasEscapable = true;
                                continue block3;
                            }
                        }
                    }
                    if (!hasEscapable) {
                        theW.write(theCbuf, theOff, theLen);
                        return;
                    }
                    String escaped = StringEscapeUtils.escapeXml10((String)new String(theCbuf, theOff, theLen));
                    theW.write(escaped.toCharArray());
                }
            };
        }
    }

    private static final class ExtendedEntityReplacingXmlResolver
    implements XMLResolver {
        private ExtendedEntityReplacingXmlResolver() {
        }

        @Override
        public Object resolveEntity(String thePublicID, String theSystemID, String theBaseURI, String theNamespace) throws XMLStreamException {
            if (thePublicID == null && theSystemID == null && theNamespace != null && VALID_ENTITY_NAMES.containsKey(theNamespace)) {
                return new String(Character.toChars((Integer)VALID_ENTITY_NAMES.get(theNamespace)));
            }
            return null;
        }
    }
}

