/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.validation.IValidator;
import ca.uhn.fhir.validation.SchemaBaseValidator;
import ca.uhn.fhir.validation.SchematronBaseValidator;
import ca.uhn.fhir.validation.ValidationContext;
import ca.uhn.fhir.validation.ValidationFailureException;
import ca.uhn.fhir.validation.ValidationResult;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirValidator {
    private static final Logger ourLog = LoggerFactory.getLogger(FhirValidator.class);
    private static final String I18N_KEY_NO_PHLOC_WARNING = FhirValidator.class.getName() + ".noPhlocWarningOnStartup";
    private static final String I18N_KEY_NO_PHLOC_ERROR = FhirValidator.class.getName() + ".noPhlocError";
    private FhirContext myContext;
    private List<IValidator> myValidators = new ArrayList<IValidator>();
    private static volatile Boolean ourPhlocPresentOnClasspath;

    public FhirValidator(FhirContext theFhirContext) {
        this.myContext = theFhirContext;
        this.setValidateAgainstStandardSchema(true);
        if (ourPhlocPresentOnClasspath == null) {
            try {
                Class.forName("com.phloc.schematron.ISchematronResource");
                ourPhlocPresentOnClasspath = true;
            }
            catch (ClassNotFoundException e) {
                ourLog.info(theFhirContext.getLocalizer().getMessage(I18N_KEY_NO_PHLOC_WARNING, new Object[0]));
                ourPhlocPresentOnClasspath = false;
            }
        }
        if (ourPhlocPresentOnClasspath.booleanValue()) {
            this.setValidateAgainstStandardSchematron(true);
        }
    }

    private void addOrRemoveValidator(boolean theValidateAgainstStandardSchema, Class<? extends IValidator> type, IValidator instance) {
        if (theValidateAgainstStandardSchema) {
            boolean found = this.haveValidatorOfType(type);
            if (!found) {
                this.myValidators.add(instance);
            }
        } else {
            Iterator<IValidator> iter = this.myValidators.iterator();
            while (iter.hasNext()) {
                IValidator next = iter.next();
                if (!next.getClass().equals(type)) continue;
                iter.remove();
            }
        }
    }

    private boolean haveValidatorOfType(Class<? extends IValidator> type) {
        boolean found = false;
        for (IValidator next : this.myValidators) {
            if (!next.getClass().equals(type)) continue;
            found = true;
        }
        return found;
    }

    public boolean isValidateAgainstStandardSchema() {
        return this.haveValidatorOfType(SchemaBaseValidator.class);
    }

    public boolean isValidateAgainstStandardSchematron() {
        return this.haveValidatorOfType(SchematronBaseValidator.class);
    }

    public void setValidateAgainstStandardSchema(boolean theValidateAgainstStandardSchema) {
        this.addOrRemoveValidator(theValidateAgainstStandardSchema, SchemaBaseValidator.class, new SchemaBaseValidator(this.myContext));
    }

    public void setValidateAgainstStandardSchematron(boolean theValidateAgainstStandardSchematron) {
        if (theValidateAgainstStandardSchematron && !ourPhlocPresentOnClasspath.booleanValue()) {
            throw new IllegalArgumentException(this.myContext.getLocalizer().getMessage(I18N_KEY_NO_PHLOC_ERROR, new Object[0]));
        }
        this.addOrRemoveValidator(theValidateAgainstStandardSchematron, SchematronBaseValidator.class, new SchematronBaseValidator(this.myContext));
    }

    @Deprecated
    public void validate(Bundle theBundle) {
        Validate.notNull((Object)theBundle, (String)"theBundle must not be null", (Object[])new Object[0]);
        ValidationContext<Bundle> ctx = ValidationContext.forBundle(this.myContext, theBundle);
        for (IValidator next : this.myValidators) {
            next.validateBundle(ctx);
        }
        BaseOperationOutcome oo = ctx.getOperationOutcome();
        if (oo != null && oo.getIssue().size() > 0) {
            throw new ValidationFailureException(oo);
        }
    }

    @Deprecated
    public void validate(IResource theResource) throws ValidationFailureException {
        ValidationResult validationResult = this.validateWithResult(theResource);
        if (!validationResult.isSuccessful()) {
            throw new ValidationFailureException(validationResult.getOperationOutcome());
        }
    }

    public ValidationResult validateWithResult(Bundle theBundle) {
        Validate.notNull((Object)theBundle, (String)"theBundle must not be null", (Object[])new Object[0]);
        ValidationContext<Bundle> ctx = ValidationContext.forBundle(this.myContext, theBundle);
        for (IValidator next : this.myValidators) {
            next.validateBundle(ctx);
        }
        BaseOperationOutcome oo = ctx.getOperationOutcome();
        return ValidationResult.valueOf(oo);
    }

    public ValidationResult validateWithResult(IResource theResource) {
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        ValidationContext<IResource> ctx = ValidationContext.forResource(this.myContext, theResource);
        for (IValidator next : this.myValidators) {
            next.validateResource(ctx);
        }
        BaseOperationOutcome oo = ctx.getOperationOutcome();
        return ValidationResult.valueOf(oo);
    }
}

