/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidator;
import ca.uhn.fhir.validation.LSInputImpl;
import ca.uhn.fhir.validation.ValidationContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.io.input.BOMInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class SchemaBaseValidator
implements IValidator {
    private static final Logger ourLog = LoggerFactory.getLogger(SchemaBaseValidator.class);
    private static final Set<String> SCHEMA_NAMES;
    private Map<String, Schema> myKeyToSchema = new HashMap<String, Schema>();
    private FhirContext myCtx;

    SchemaBaseValidator(FhirContext theContext) {
        this.myCtx = theContext;
    }

    private void doValidate(ValidationContext<?> theContext, String schemaName) {
        Schema schema = this.loadSchema("dstu", schemaName);
        try {
            Validator validator = schema.newValidator();
            MyErrorHandler handler = new MyErrorHandler(theContext);
            validator.setErrorHandler(handler);
            String encodedResource = theContext.getXmlEncodedResource();
            validator.validate(new StreamSource(new StringReader(encodedResource)));
        }
        catch (SAXException e) {
            throw new ConfigurationException("Could not apply schema file", e);
        }
        catch (IOException e) {
            throw new ConfigurationException("Could not load/parse schema file", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Schema loadSchema(String theVersion, String theSchemaName) {
        String key = theVersion + "-" + theSchemaName;
        Map<String, Schema> map = this.myKeyToSchema;
        synchronized (map) {
            Schema schema = this.myKeyToSchema.get(key);
            if (schema != null) {
                return schema;
            }
            Source baseSource = this.loadXml("dstu", null, theSchemaName);
            SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            schemaFactory.setResourceResolver(new MyResourceResolver("dstu"));
            try {
                schema = schemaFactory.newSchema(new Source[]{baseSource});
            }
            catch (SAXException e) {
                throw new ConfigurationException("Could not load/parse schema file: " + theSchemaName, e);
            }
            this.myKeyToSchema.put(key, schema);
            return schema;
        }
    }

    private Source loadXml(String theVersion, String theSystemId, String theSchemaName) {
        String pathToBase = this.myCtx.getVersion().getPathToSchemaDefinitions() + '/' + theSchemaName;
        ourLog.debug("Going to load resource: {}", (Object)pathToBase);
        InputStream baseIs = FhirValidator.class.getClassLoader().getResourceAsStream(pathToBase);
        if (baseIs == null) {
            throw new InternalErrorException("No FHIR-BASE schema found");
        }
        baseIs = new BOMInputStream(baseIs, false);
        InputStreamReader baseReader = new InputStreamReader(baseIs, Charset.forName("UTF-8"));
        StreamSource baseSource = new StreamSource(baseReader, theSystemId);
        return baseSource;
    }

    @Override
    public void validateBundle(ValidationContext<Bundle> theContext) {
        if (this.myCtx.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1)) {
            this.doValidate(theContext, "fhir-single.xsd");
        } else {
            this.doValidate(theContext, "fhir-atom-single.xsd");
        }
    }

    @Override
    public void validateResource(ValidationContext<IResource> theContext) {
        this.doValidate(theContext, "fhir-single.xsd");
    }

    static {
        HashSet<String> sn = new HashSet<String>();
        sn.add("xml.xsd");
        sn.add("xhtml1-strict.xsd");
        sn.add("fhir-single.xsd");
        sn.add("fhir-xhtml.xsd");
        sn.add("tombstone.xsd");
        sn.add("opensearch.xsd");
        sn.add("opensearchscore.xsd");
        sn.add("xmldsig-core-schema.xsd");
        SCHEMA_NAMES = Collections.unmodifiableSet(sn);
    }

    private final class MyResourceResolver
    implements LSResourceResolver {
        private String myVersion;

        private MyResourceResolver(String theVersion) {
            this.myVersion = theVersion;
        }

        @Override
        public LSInput resolveResource(String theType, String theNamespaceURI, String thePublicId, String theSystemId, String theBaseURI) {
            if (theSystemId != null && SCHEMA_NAMES.contains(theSystemId)) {
                LSInputImpl input = new LSInputImpl();
                input.setPublicId(thePublicId);
                input.setSystemId(theSystemId);
                input.setBaseURI(theBaseURI);
                String pathToBase = SchemaBaseValidator.this.myCtx.getVersion().getPathToSchemaDefinitions() + '/' + theSystemId;
                ourLog.debug("Loading referenced schema file: " + pathToBase);
                InputStream baseIs = FhirValidator.class.getClassLoader().getResourceAsStream(pathToBase);
                if (baseIs == null) {
                    throw new InternalErrorException("Schema file not found: " + pathToBase);
                }
                input.setByteStream(baseIs);
                return input;
            }
            throw new ConfigurationException("Unknown schema: " + theSystemId);
        }
    }

    private static class MyErrorHandler
    implements ErrorHandler {
        private ValidationContext<?> myContext;

        public MyErrorHandler(ValidationContext<?> theContext) {
            this.myContext = theContext;
        }

        private void addIssue(SAXParseException theException, String severity) {
            BaseOperationOutcome.BaseIssue issue = this.myContext.getOperationOutcome().addIssue();
            issue.getSeverityElement().setValue(severity);
            issue.getDetailsElement().setValue(theException.getLocalizedMessage());
            issue.addLocation("Line[" + theException.getLineNumber() + "] Col[" + theException.getColumnNumber() + "]");
        }

        @Override
        public void error(SAXParseException theException) throws SAXException {
            this.addIssue(theException, "error");
        }

        @Override
        public void fatalError(SAXParseException theException) throws SAXException {
            this.addIssue(theException, "fatal");
        }

        @Override
        public void warning(SAXParseException theException) throws SAXException {
            this.addIssue(theException, "warning");
        }
    }
}

