/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.BundleEntry;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.validation.FhirValidator;
import ca.uhn.fhir.validation.IValidator;
import ca.uhn.fhir.validation.ValidationContext;
import com.phloc.commons.error.IResourceError;
import com.phloc.commons.error.IResourceErrorGroup;
import com.phloc.schematron.ISchematronResource;
import com.phloc.schematron.SchematronHelper;
import com.phloc.schematron.xslt.SchematronResourceSCH;
import java.io.InputStream;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.hl7.fhir.instance.model.IBaseResource;
import org.oclc.purl.dsdl.svrl.SchematronOutputType;

public class SchematronBaseValidator
implements IValidator {
    private Map<Class<? extends IBaseResource>, ISchematronResource> myClassToSchematron = new HashMap<Class<? extends IBaseResource>, ISchematronResource>();
    private FhirContext myCtx;

    SchematronBaseValidator(FhirContext theContext) {
        this.myCtx = theContext;
    }

    @Override
    public void validateResource(ValidationContext<IResource> theCtx) {
        StreamSource source;
        ISchematronResource sch = this.getSchematron(theCtx);
        SchematronOutputType results = SchematronHelper.applySchematron((ISchematronResource)sch, (Source)(source = new StreamSource(new StringReader(theCtx.getXmlEncodedResource()))));
        if (results == null) {
            return;
        }
        IResourceErrorGroup errors = SchematronHelper.convertToResourceErrorGroup((SchematronOutputType)results, (String)theCtx.getFhirContext().getResourceDefinition(theCtx.getResource()).getBaseDefinition().getName());
        if (errors.getAllErrors().containsOnlySuccess()) {
            return;
        }
        block6: for (IResourceError next : errors.getAllErrors().getAllResourceErrors()) {
            BaseOperationOutcome.BaseIssue issue = theCtx.getOperationOutcome().addIssue();
            switch (next.getErrorLevel()) {
                case ERROR: {
                    issue.getSeverityElement().setValue("error");
                    break;
                }
                case FATAL_ERROR: {
                    issue.getSeverityElement().setValue("fatal");
                    break;
                }
                case WARN: {
                    issue.getSeverityElement().setValue("warning");
                    break;
                }
                case INFO: 
                case SUCCESS: {
                    continue block6;
                }
            }
            issue.getDetailsElement().setValue(next.getAsString(Locale.getDefault()));
        }
    }

    private ISchematronResource getSchematron(ValidationContext<IResource> theCtx) {
        Class<?> resource = theCtx.getResource().getClass();
        Class baseResourceClass = theCtx.getFhirContext().getResourceDefinition(resource).getBaseDefinition().getImplementingClass();
        return this.getSchematronAndCache(theCtx, "dstu", baseResourceClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ISchematronResource getSchematronAndCache(ValidationContext<IResource> theCtx, String theVersion, Class<? extends IBaseResource> theClass) {
        Map<Class<? extends IBaseResource>, ISchematronResource> map = this.myClassToSchematron;
        synchronized (map) {
            ISchematronResource retVal = this.myClassToSchematron.get(theClass);
            if (retVal != null) {
                return retVal;
            }
            String pathToBase = this.myCtx.getVersion().getPathToSchemaDefinitions() + '/' + theCtx.getFhirContext().getResourceDefinition(theCtx.getResource()).getBaseDefinition().getName().toLowerCase() + ".sch";
            InputStream baseIs = FhirValidator.class.getClassLoader().getResourceAsStream(pathToBase);
            if (baseIs == null) {
                throw new InternalErrorException("No schematron found for resource type: " + theCtx.getFhirContext().getResourceDefinition(theCtx.getResource()).getBaseDefinition().getImplementingClass().getCanonicalName());
            }
            retVal = SchematronResourceSCH.fromClassPath((String)pathToBase);
            this.myClassToSchematron.put(theClass, retVal);
            return retVal;
        }
    }

    @Override
    public void validateBundle(ValidationContext<Bundle> theContext) {
        for (BundleEntry next : theContext.getResource().getEntries()) {
            if (next.getResource() == null) continue;
            ValidationContext<IResource> ctx = ValidationContext.newChild(theContext, next.getResource());
            this.validateResource(ctx);
        }
    }
}

