/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ValidationContext<T> {
    private final IEncoder myEncoder;
    private final FhirContext myFhirContext;
    private BaseOperationOutcome myOperationOutcome;
    private final T myResource;
    private String myXmlEncodedResource;
    private static final Logger ourLog = LoggerFactory.getLogger(ValidationContext.class);

    private ValidationContext(FhirContext theContext, T theResource, IEncoder theEncoder) {
        this.myFhirContext = theContext;
        this.myResource = theResource;
        this.myEncoder = theEncoder;
    }

    public FhirContext getFhirContext() {
        return this.myFhirContext;
    }

    public BaseOperationOutcome getOperationOutcome() {
        if (this.myOperationOutcome == null) {
            try {
                this.myOperationOutcome = (BaseOperationOutcome)this.myFhirContext.getResourceDefinition("OperationOutcome").getImplementingClass().newInstance();
            }
            catch (Exception e1) {
                ourLog.error("Failed to instantiate OperationOutcome resource instance", (Throwable)e1);
                throw new InternalErrorException("Failed to instantiate OperationOutcome resource instance", (Throwable)e1);
            }
        }
        return this.myOperationOutcome;
    }

    public T getResource() {
        return this.myResource;
    }

    public String getXmlEncodedResource() {
        if (this.myXmlEncodedResource == null) {
            this.myXmlEncodedResource = this.myEncoder.encode();
        }
        return this.myXmlEncodedResource;
    }

    public static ValidationContext<Bundle> forBundle(final FhirContext theContext, final Bundle theBundle) {
        return new ValidationContext<Bundle>(theContext, theBundle, new IEncoder(){

            @Override
            public String encode() {
                return theContext.newXmlParser().encodeBundleToString(theBundle);
            }
        });
    }

    public static ValidationContext<IResource> forResource(final FhirContext theContext, final IResource theResource) {
        return new ValidationContext<IResource>(theContext, theResource, new IEncoder(){

            @Override
            public String encode() {
                return theContext.newXmlParser().encodeResourceToString(theResource);
            }
        });
    }

    public static ValidationContext<IResource> newChild(ValidationContext<Bundle> theContext, IResource theResource) {
        ValidationContext<IResource> retVal = ValidationContext.forResource(theContext.getFhirContext(), theResource);
        retVal.myOperationOutcome = theContext.getOperationOutcome();
        return retVal;
    }

    private static interface IEncoder {
        public String encode();
    }
}

