/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import ca.uhn.fhir.model.base.resource.BaseOperationOutcome;

public class ValidationResult {
    private BaseOperationOutcome myOperationOutcome;
    private boolean isSuccessful;

    private ValidationResult(BaseOperationOutcome myOperationOutcome, boolean isSuccessful) {
        this.myOperationOutcome = myOperationOutcome;
        this.isSuccessful = isSuccessful;
    }

    public static ValidationResult valueOf(BaseOperationOutcome myOperationOutcome) {
        boolean noIssues = myOperationOutcome == null || myOperationOutcome.getIssue().isEmpty();
        return new ValidationResult(myOperationOutcome, noIssues);
    }

    public BaseOperationOutcome getOperationOutcome() {
        return this.myOperationOutcome;
    }

    public String toString() {
        return "ValidationResult{myOperationOutcome=" + this.myOperationOutcome + ", isSuccessful=" + this.isSuccessful + ", description='" + this.toDescription() + '\'' + '}';
    }

    private String toDescription() {
        StringBuilder b = new StringBuilder(100);
        if (this.myOperationOutcome != null && this.myOperationOutcome.getIssue().size() > 0) {
            BaseOperationOutcome.BaseIssue issueFirstRep = this.myOperationOutcome.getIssueFirstRep();
            b.append((String)issueFirstRep.getDetailsElement().getValue());
            b.append(" - ");
            b.append((String)issueFirstRep.getLocationFirstRep().getValue());
        } else {
            b.append("No issues");
        }
        return b.toString();
    }

    public boolean isSuccessful() {
        return this.isSuccessful;
    }
}

