/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildContainedResources;
import ca.uhn.fhir.context.RuntimeChildExtension;
import ca.uhn.fhir.context.RuntimeChildNarrativeDefinition;
import ca.uhn.fhir.context.RuntimeChildUndeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.XhtmlDt;
import ca.uhn.fhir.narrative.INarrativeGenerator;
import ca.uhn.fhir.parser.BaseParser;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.ParseLocation;
import ca.uhn.fhir.parser.ParserState;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.util.ElementUtil;
import ca.uhn.fhir.util.NonPrettyPrintWriterWrapper;
import ca.uhn.fhir.util.PrettyPrintWriterWrapper;
import ca.uhn.fhir.util.XmlUtil;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseHasModifierExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IBaseXhtml;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.INarrative;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlParser
extends BaseParser {
    static final String ATOM_NS = "http://www.w3.org/2005/Atom";
    static final String FHIR_NS = "http://hl7.org/fhir";
    static final String OPENSEARCH_NS = "http://a9.com/-/spec/opensearch/1.1/";
    private static final Logger ourLog = LoggerFactory.getLogger(XmlParser.class);
    static final String RESREF_DISPLAY = "display";
    static final String RESREF_REFERENCE = "reference";
    static final String TOMBSTONES_NS = "http://purl.org/atompub/tombstones/1.0";
    static final String XHTML_NS = "http://www.w3.org/1999/xhtml";
    private FhirContext myContext;
    private boolean myPrettyPrint;

    public XmlParser(FhirContext theContext, IParserErrorHandler theParserErrorHandler) {
        super(theContext, theParserErrorHandler);
        this.myContext = theContext;
    }

    private XMLEventReader createStreamReader(Reader theReader) {
        try {
            return XmlUtil.createXmlReader(theReader);
        }
        catch (FactoryConfigurationError e1) {
            throw new ConfigurationException("Failed to initialize STaX event factory", e1);
        }
        catch (XMLStreamException e1) {
            throw new DataFormatException(e1);
        }
    }

    private XMLStreamWriter createXmlWriter(Writer theWriter) throws XMLStreamException {
        XMLStreamWriter eventWriter = XmlUtil.createXmlStreamWriter(theWriter);
        eventWriter = this.decorateStreamWriter(eventWriter);
        return eventWriter;
    }

    private XMLStreamWriter decorateStreamWriter(XMLStreamWriter eventWriter) {
        if (this.myPrettyPrint) {
            PrettyPrintWriterWrapper retVal = new PrettyPrintWriterWrapper(eventWriter);
            return retVal;
        }
        NonPrettyPrintWriterWrapper retVal = new NonPrettyPrintWriterWrapper(eventWriter);
        return retVal;
    }

    @Override
    public void doEncodeResourceToWriter(IBaseResource theResource, Writer theWriter) throws DataFormatException {
        try {
            XMLStreamWriter eventWriter = this.createXmlWriter(theWriter);
            this.encodeResourceToXmlStreamWriter(theResource, eventWriter, false, false);
            eventWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new ConfigurationException("Failed to initialize STaX event factory", e);
        }
    }

    @Override
    public <T extends IBaseResource> T doParseResource(Class<T> theResourceType, Reader theReader) {
        XMLEventReader streamReader = this.createStreamReader(theReader);
        return this.parseResource(theResourceType, streamReader);
    }

    private <T> T doXmlLoop(XMLEventReader streamReader, ParserState<T> parserState) {
        ourLog.trace("Entering XML parsing loop with state: {}", parserState);
        try {
            ArrayList<String> heldComments = new ArrayList<String>(1);
            while (streamReader.hasNext()) {
                XMLEvent nextEvent = streamReader.nextEvent();
                try {
                    switch (nextEvent.getEventType()) {
                        case 1: {
                            Iterator<Attribute> attributes;
                            String url;
                            Attribute urlAttr;
                            StartElement elem = nextEvent.asStartElement();
                            String namespaceURI = elem.getName().getNamespaceURI();
                            if ("extension".equals(elem.getName().getLocalPart())) {
                                urlAttr = elem.getAttributeByName(new QName("url"));
                                if (urlAttr == null || StringUtils.isBlank((CharSequence)urlAttr.getValue())) {
                                    this.getErrorHandler().missingRequiredElement(new ParseLocation("extension"), "url");
                                    url = null;
                                } else {
                                    url = urlAttr.getValue();
                                }
                                parserState.enteringNewElementExtension(elem, url, false, this.getServerBaseUrl());
                            } else if ("modifierExtension".equals(elem.getName().getLocalPart())) {
                                urlAttr = elem.getAttributeByName(new QName("url"));
                                if (urlAttr == null || StringUtils.isBlank((CharSequence)urlAttr.getValue())) {
                                    this.getErrorHandler().missingRequiredElement(new ParseLocation("modifierExtension"), "url");
                                    url = null;
                                } else {
                                    url = urlAttr.getValue();
                                }
                                parserState.enteringNewElementExtension(elem, url, true, this.getServerBaseUrl());
                            } else {
                                String elementName = elem.getName().getLocalPart();
                                parserState.enteringNewElement(namespaceURI, elementName);
                            }
                            if (!heldComments.isEmpty()) {
                                for (String next : heldComments) {
                                    parserState.commentPre(next);
                                }
                                heldComments.clear();
                            }
                            Iterator<Attribute> iter = attributes = elem.getAttributes();
                            while (iter.hasNext()) {
                                Attribute next = iter.next();
                                parserState.attributeValue(next.getName().getLocalPart(), next.getValue());
                            }
                            break;
                        }
                        case 2: 
                        case 8: {
                            if (!heldComments.isEmpty()) {
                                for (String next : heldComments) {
                                    parserState.commentPost(next);
                                }
                                heldComments.clear();
                            }
                            parserState.endingElement();
                            break;
                        }
                        case 4: {
                            parserState.string(nextEvent.asCharacters().getData());
                            break;
                        }
                        case 5: {
                            Comment comment = (Comment)nextEvent;
                            String commentText = comment.getText();
                            heldComments.add(commentText);
                            break;
                        }
                    }
                    parserState.xmlEvent(nextEvent);
                }
                catch (DataFormatException e) {
                    throw new DataFormatException("DataFormatException at [" + nextEvent.getLocation().toString() + "]: " + e.getMessage(), e);
                }
            }
            return parserState.getObject();
        }
        catch (XMLStreamException e) {
            throw new DataFormatException(e);
        }
    }

    private void encodeChildElementToStreamWriter(IBaseResource theResource, XMLStreamWriter theEventWriter, IBase theElement, String childName, BaseRuntimeElementDefinition<?> childDef, String theExtensionUrl, boolean theIncludedResource, boolean theSubResource, BaseParser.CompositeChildElement theParent) throws XMLStreamException, DataFormatException {
        if ((theElement == null || theElement.isEmpty()) && !this.isChildContained(childDef, theIncludedResource)) {
            return;
        }
        this.writeCommentsPre(theEventWriter, theElement);
        switch (childDef.getChildType()) {
            case ID_DATATYPE: {
                String encodedValue;
                IIdType value = (IIdType)IIdType.class.cast(theElement);
                String string = encodedValue = "id".equals(childName) ? value.getIdPart() : value.getValue();
                if (!StringUtils.isNotBlank((CharSequence)encodedValue) && !BaseParser.hasExtensions(value)) break;
                theEventWriter.writeStartElement(childName);
                if (StringUtils.isNotBlank((CharSequence)encodedValue)) {
                    theEventWriter.writeAttribute("value", encodedValue);
                }
                this.encodeExtensionsIfPresent(theResource, theEventWriter, theElement, theIncludedResource, theSubResource);
                theEventWriter.writeEndElement();
                break;
            }
            case PRIMITIVE_DATATYPE: {
                IPrimitiveType pd = (IPrimitiveType)IPrimitiveType.class.cast(theElement);
                String value = pd.getValueAsString();
                if (value == null && !BaseParser.hasExtensions(pd)) break;
                theEventWriter.writeStartElement(childName);
                String elementId = this.getCompositeElementId(theElement);
                if (StringUtils.isNotBlank((CharSequence)elementId)) {
                    theEventWriter.writeAttribute("id", elementId);
                }
                if (value != null) {
                    theEventWriter.writeAttribute("value", value);
                }
                this.encodeExtensionsIfPresent(theResource, theEventWriter, theElement, theIncludedResource, theSubResource);
                theEventWriter.writeEndElement();
                break;
            }
            case RESOURCE_BLOCK: 
            case COMPOSITE_DATATYPE: {
                theEventWriter.writeStartElement(childName);
                String elementId = this.getCompositeElementId(theElement);
                if (StringUtils.isNotBlank((CharSequence)elementId)) {
                    theEventWriter.writeAttribute("id", elementId);
                }
                if (StringUtils.isNotBlank((CharSequence)theExtensionUrl)) {
                    theEventWriter.writeAttribute("url", theExtensionUrl);
                }
                this.encodeCompositeElementToStreamWriter(theResource, theElement, theEventWriter, theIncludedResource, theSubResource, theParent);
                theEventWriter.writeEndElement();
                break;
            }
            case CONTAINED_RESOURCE_LIST: 
            case CONTAINED_RESOURCES: {
                for (IBaseResource next : this.getContainedResources().getContainedResources()) {
                    IIdType resourceId = this.getContainedResources().getResourceId(next);
                    theEventWriter.writeStartElement("contained");
                    this.encodeResourceToXmlStreamWriter(next, theEventWriter, true, false, this.fixContainedResourceId(resourceId.getValue()));
                    theEventWriter.writeEndElement();
                }
                break;
            }
            case RESOURCE: {
                theEventWriter.writeStartElement(childName);
                IBaseResource resource = (IBaseResource)theElement;
                this.encodeResourceToXmlStreamWriter(resource, theEventWriter, false, true);
                theEventWriter.writeEndElement();
                break;
            }
            case PRIMITIVE_XHTML: {
                XhtmlDt dt = (XhtmlDt)XhtmlDt.class.cast(theElement);
                if (!dt.hasContent()) break;
                this.encodeXhtml(dt, theEventWriter);
                break;
            }
            case PRIMITIVE_XHTML_HL7ORG: {
                IBaseXhtml dt = (IBaseXhtml)IBaseXhtml.class.cast(theElement);
                if (dt.isEmpty()) break;
                XhtmlDt hdt = new XhtmlDt();
                hdt.setValueAsString(dt.getValueAsString());
                this.encodeXhtml(hdt, theEventWriter);
                break;
            }
            case EXTENSION_DECLARED: 
            case UNDECL_EXT: {
                throw new IllegalStateException("state should not happen: " + childDef.getName());
            }
        }
        this.writeCommentsPost(theEventWriter, theElement);
    }

    private void encodeCompositeElementToStreamWriter(IBaseResource theResource, IBase theElement, XMLStreamWriter theEventWriter, boolean theContainedResource, boolean theSubResource, BaseParser.CompositeChildElement theParent) throws XMLStreamException, DataFormatException {
        for (BaseParser.CompositeChildElement nextChildElem : super.compositeChildIterator(theElement, theContainedResource, theSubResource, theParent)) {
            BaseRuntimeChildDefinition nextChild = nextChildElem.getDef();
            if (nextChild.getElementName().equals("url") && theElement instanceof IBaseExtension) continue;
            if (nextChild instanceof RuntimeChildNarrativeDefinition) {
                INarrativeGenerator gen = this.myContext.getNarrativeGenerator();
                INarrative narr = theResource instanceof IResource ? ((IResource)theResource).getText() : (theResource instanceof IDomainResource ? ((IDomainResource)theResource).getText() : null);
                if (gen != null && narr.isEmpty()) {
                    gen.generateNarrative(this.myContext, theResource, narr);
                }
                if (narr != null && !narr.isEmpty()) {
                    RuntimeChildNarrativeDefinition child = (RuntimeChildNarrativeDefinition)nextChild;
                    String childName = nextChild.getChildNameByDatatype(child.getDatatype());
                    BaseRuntimeElementDefinition<?> type = child.getChildByName(childName);
                    this.encodeChildElementToStreamWriter(theResource, theEventWriter, narr, childName, type, null, theContainedResource, theSubResource, nextChildElem);
                    continue;
                }
            }
            if (nextChild instanceof RuntimeChildContainedResources) {
                this.encodeChildElementToStreamWriter(theResource, theEventWriter, null, nextChild.getChildNameByDatatype(null), nextChild.getChildElementDefinitionByDatatype(null), null, theContainedResource, theSubResource, nextChildElem);
                continue;
            }
            List<IBase> values = nextChild.getAccessor().getValues(theElement);
            if ((values = super.preProcessValues(nextChild, theResource, values, nextChildElem)) == null || values.isEmpty()) continue;
            for (IBase nextValue : values) {
                BaseParser.ChildNameAndDef childNameAndDef;
                if (nextValue == null || nextValue.isEmpty() || (childNameAndDef = super.getChildNameAndDef(nextChild, nextValue)) == null) continue;
                String childName = childNameAndDef.getChildName();
                BaseRuntimeElementDefinition<?> childDef = childNameAndDef.getChildDef();
                String extensionUrl = this.getExtensionUrl(nextChild.getExtensionUrl());
                if (extensionUrl != null && !childName.equals("extension")) {
                    this.encodeExtension(theResource, theEventWriter, theContainedResource, theSubResource, nextChildElem, nextChild, nextValue, childName, extensionUrl, childDef);
                    continue;
                }
                if (nextChild instanceof RuntimeChildExtension) {
                    IBaseExtension extension = (IBaseExtension)nextValue;
                    if ((extension.getValue() == null || extension.getValue().isEmpty()) && extension.getExtension().isEmpty()) continue;
                    this.encodeChildElementToStreamWriter(theResource, theEventWriter, nextValue, childName, childDef, this.getExtensionUrl(extension.getUrl()), theContainedResource, theSubResource, nextChildElem);
                    continue;
                }
                if (nextChild instanceof RuntimeChildNarrativeDefinition && theContainedResource) continue;
                this.encodeChildElementToStreamWriter(theResource, theEventWriter, nextValue, childName, childDef, extensionUrl, theContainedResource, theSubResource, nextChildElem);
            }
        }
    }

    private void encodeExtension(IBaseResource theResource, XMLStreamWriter theEventWriter, boolean theContainedResource, boolean theSubResource, BaseParser.CompositeChildElement nextChildElem, BaseRuntimeChildDefinition nextChild, IBase nextValue, String childName, String extensionUrl, BaseRuntimeElementDefinition<?> childDef) throws XMLStreamException {
        BaseRuntimeDeclaredChildDefinition extDef = (BaseRuntimeDeclaredChildDefinition)nextChild;
        if (extDef.isModifier()) {
            theEventWriter.writeStartElement("modifierExtension");
        } else {
            theEventWriter.writeStartElement("extension");
        }
        String elementId = this.getCompositeElementId(nextValue);
        if (StringUtils.isNotBlank((CharSequence)elementId)) {
            theEventWriter.writeAttribute("id", elementId);
        }
        theEventWriter.writeAttribute("url", extensionUrl);
        this.encodeChildElementToStreamWriter(theResource, theEventWriter, nextValue, childName, childDef, null, theContainedResource, theSubResource, nextChildElem);
        theEventWriter.writeEndElement();
    }

    private void encodeExtensionsIfPresent(IBaseResource theResource, XMLStreamWriter theWriter, IBase theElement, boolean theIncludedResource, boolean theSubResource) throws XMLStreamException, DataFormatException {
        Object res;
        if (theElement instanceof ISupportsUndeclaredExtensions) {
            res = (ISupportsUndeclaredExtensions)theElement;
            this.encodeUndeclaredExtensions(theResource, theWriter, this.toBaseExtensionList(res.getUndeclaredExtensions()), "extension", theIncludedResource, theSubResource);
            this.encodeUndeclaredExtensions(theResource, theWriter, this.toBaseExtensionList(res.getUndeclaredModifierExtensions()), "modifierExtension", theIncludedResource, theSubResource);
        }
        if (theElement instanceof IBaseHasExtensions) {
            res = (IBaseHasExtensions)((Object)theElement);
            this.encodeUndeclaredExtensions(theResource, theWriter, res.getExtension(), "extension", theIncludedResource, theSubResource);
        }
        if (theElement instanceof IBaseHasModifierExtensions) {
            res = (IBaseHasModifierExtensions)((Object)theElement);
            this.encodeUndeclaredExtensions(theResource, theWriter, res.getModifierExtension(), "modifierExtension", theIncludedResource, theSubResource);
        }
    }

    private void encodeResourceToXmlStreamWriter(IBaseResource theResource, XMLStreamWriter theEventWriter, boolean theIncludedResource, boolean theSubResource) throws XMLStreamException, DataFormatException {
        IIdType resourceId = null;
        if (StringUtils.isNotBlank((CharSequence)theResource.getIdElement().getIdPart())) {
            resourceId = theResource.getIdElement();
            if (theResource.getIdElement().getValue().startsWith("urn:")) {
                resourceId = null;
            }
        }
        if (!theIncludedResource) {
            if (!super.shouldEncodeResourceId(theResource, theSubResource)) {
                resourceId = null;
            } else if (!theSubResource && this.getEncodeForceResourceId() != null) {
                resourceId = this.getEncodeForceResourceId();
            }
        }
        this.encodeResourceToXmlStreamWriter(theResource, theEventWriter, theIncludedResource, theSubResource, resourceId);
    }

    private void encodeResourceToXmlStreamWriter(IBaseResource theResource, XMLStreamWriter theEventWriter, boolean theContainedResource, boolean theSubResource, IIdType theResourceId) throws XMLStreamException {
        RuntimeResourceDefinition resDef;
        if (!theContainedResource) {
            super.containResourcesForEncoding(theResource);
        }
        if ((resDef = this.myContext.getResourceDefinition(theResource)) == null) {
            throw new ConfigurationException("Unknown resource type: " + theResource.getClass());
        }
        theEventWriter.writeStartElement(resDef.getName());
        theEventWriter.writeDefaultNamespace(FHIR_NS);
        if (theResource instanceof IAnyResource) {
            if (theResourceId != null) {
                this.writeCommentsPre(theEventWriter, theResourceId);
                theEventWriter.writeStartElement("id");
                theEventWriter.writeAttribute("value", theResourceId.getIdPart());
                this.encodeExtensionsIfPresent(theResource, theEventWriter, theResourceId, false, false);
                theEventWriter.writeEndElement();
                this.writeCommentsPost(theEventWriter, theResourceId);
            }
            this.encodeCompositeElementToStreamWriter(theResource, theResource, theEventWriter, theContainedResource, theSubResource, new BaseParser.CompositeChildElement(resDef, theSubResource));
        } else {
            IResource resource = (IResource)theResource;
            if (theResourceId != null) {
                theEventWriter.writeStartElement("id");
                theEventWriter.writeAttribute("value", theResourceId.getIdPart());
                this.encodeExtensionsIfPresent(theResource, theEventWriter, theResourceId, false, false);
                theEventWriter.writeEndElement();
                this.writeCommentsPost(theEventWriter, theResourceId);
            }
            InstantDt updated = (InstantDt)resource.getResourceMetadata().get(ResourceMetadataKeyEnum.UPDATED);
            IdDt resourceId = resource.getId();
            String versionIdPart = resourceId.getVersionIdPart();
            if (StringUtils.isBlank((CharSequence)versionIdPart)) {
                versionIdPart = ResourceMetadataKeyEnum.VERSION.get(resource);
            }
            List<BaseCodingDt> securityLabels = XmlParser.extractMetadataListNotNull(resource, ResourceMetadataKeyEnum.SECURITY_LABELS);
            List<IIdType> profiles = XmlParser.extractMetadataListNotNull(resource, ResourceMetadataKeyEnum.PROFILES);
            profiles = super.getProfileTagsForEncoding(resource, profiles);
            TagList tags = this.getMetaTagsForEncoding(resource);
            if (super.shouldEncodeResourceMeta(resource) && !ElementUtil.isEmpty(versionIdPart, updated, securityLabels, tags, profiles)) {
                theEventWriter.writeStartElement("meta");
                this.writeOptionalTagWithValue(theEventWriter, "versionId", versionIdPart);
                if (updated != null) {
                    this.writeOptionalTagWithValue(theEventWriter, "lastUpdated", updated.getValueAsString());
                }
                for (IIdType profile : profiles) {
                    theEventWriter.writeStartElement("profile");
                    theEventWriter.writeAttribute("value", profile.getValue());
                    theEventWriter.writeEndElement();
                }
                for (BaseCodingDt securityLabel : securityLabels) {
                    theEventWriter.writeStartElement("security");
                    this.encodeCompositeElementToStreamWriter(resource, securityLabel, theEventWriter, theContainedResource, theSubResource, null);
                    theEventWriter.writeEndElement();
                }
                if (tags != null) {
                    for (Tag tag : tags) {
                        if (tag.isEmpty()) continue;
                        theEventWriter.writeStartElement("tag");
                        this.writeOptionalTagWithValue(theEventWriter, "system", tag.getScheme());
                        this.writeOptionalTagWithValue(theEventWriter, "code", tag.getTerm());
                        this.writeOptionalTagWithValue(theEventWriter, RESREF_DISPLAY, tag.getLabel());
                        theEventWriter.writeEndElement();
                    }
                }
                theEventWriter.writeEndElement();
            }
            if (theResource instanceof IBaseBinary) {
                IBaseBinary bin = (IBaseBinary)theResource;
                this.writeOptionalTagWithValue(theEventWriter, "contentType", bin.getContentType());
                this.writeOptionalTagWithValue(theEventWriter, "content", bin.getContentAsBase64());
            } else {
                this.encodeCompositeElementToStreamWriter(theResource, theResource, theEventWriter, theContainedResource, theSubResource, new BaseParser.CompositeChildElement(resDef, theSubResource));
            }
        }
        theEventWriter.writeEndElement();
    }

    private void encodeUndeclaredExtensions(IBaseResource theResource, XMLStreamWriter theEventWriter, List<? extends IBaseExtension<?, ?>> theExtensions, String tagName, boolean theIncludedResource, boolean theSubResource) throws XMLStreamException, DataFormatException {
        for (IBaseExtension<?, ?> next : theExtensions) {
            if (next == null || ElementUtil.isEmpty(next.getValue()) && next.getExtension().isEmpty()) continue;
            this.writeCommentsPre(theEventWriter, next);
            theEventWriter.writeStartElement(tagName);
            String elementId = this.getCompositeElementId(next);
            if (StringUtils.isNotBlank((CharSequence)elementId)) {
                theEventWriter.writeAttribute("id", elementId);
            }
            String url = this.getExtensionUrl(next.getUrl());
            theEventWriter.writeAttribute("url", url);
            if (next.getValue() != null) {
                BaseRuntimeElementDefinition<?> childDef;
                IBaseDatatype value = next.getValue();
                RuntimeChildUndeclaredExtensionDefinition extDef = this.myContext.getRuntimeChildUndeclaredExtensionDefinition();
                String childName = extDef.getChildNameByDatatype(value.getClass());
                if (childName == null) {
                    childDef = this.myContext.getElementDefinition(value.getClass());
                    if (childDef == null) {
                        throw new ConfigurationException("Unable to encode extension, unrecognized child element type: " + value.getClass().getCanonicalName());
                    }
                    childName = RuntimeChildUndeclaredExtensionDefinition.createExtensionChildName(childDef);
                } else {
                    childDef = extDef.getChildElementDefinitionByDatatype(value.getClass());
                    if (childDef == null) {
                        throw new ConfigurationException("Unable to encode extension, unrecognized child element type: " + value.getClass().getCanonicalName());
                    }
                }
                this.encodeChildElementToStreamWriter(theResource, theEventWriter, value, childName, childDef, null, theIncludedResource, theSubResource, null);
            }
            this.encodeExtensionsIfPresent(theResource, theEventWriter, next, theIncludedResource, theSubResource);
            theEventWriter.writeEndElement();
            this.writeCommentsPost(theEventWriter, next);
        }
    }

    private void encodeXhtml(XhtmlDt theDt, XMLStreamWriter theEventWriter) throws XMLStreamException {
        if (theDt == null || theDt.getValue() == null) {
            return;
        }
        boolean firstElement = true;
        block10: for (XMLEvent event : (List)theDt.getValue()) {
            switch (event.getEventType()) {
                case 10: {
                    Attribute attr = (Attribute)event;
                    if (StringUtils.isBlank((CharSequence)attr.getName().getPrefix())) {
                        if (StringUtils.isBlank((CharSequence)attr.getName().getNamespaceURI())) {
                            theEventWriter.writeAttribute(attr.getName().getLocalPart(), attr.getValue());
                            break;
                        }
                        theEventWriter.writeAttribute(attr.getName().getNamespaceURI(), attr.getName().getLocalPart(), attr.getValue());
                        break;
                    }
                    theEventWriter.writeAttribute(attr.getName().getPrefix(), attr.getName().getNamespaceURI(), attr.getName().getLocalPart(), attr.getValue());
                    break;
                }
                case 12: {
                    theEventWriter.writeCData(((Characters)event).getData());
                    break;
                }
                case 4: 
                case 6: {
                    String data = ((Characters)event).getData();
                    theEventWriter.writeCharacters(data);
                    break;
                }
                case 5: {
                    theEventWriter.writeComment(((Comment)event).getText());
                    break;
                }
                case 2: {
                    theEventWriter.writeEndElement();
                    break;
                }
                case 9: {
                    EntityReference er = (EntityReference)event;
                    theEventWriter.writeEntityRef(er.getName());
                    break;
                }
                case 13: {
                    Namespace ns = (Namespace)event;
                    theEventWriter.writeNamespace(ns.getPrefix(), ns.getNamespaceURI());
                    break;
                }
                case 1: {
                    StartElement se = event.asStartElement();
                    if (firstElement) {
                        if (StringUtils.isBlank((CharSequence)se.getName().getPrefix())) {
                            String namespaceURI = se.getName().getNamespaceURI();
                            if (StringUtils.isBlank((CharSequence)namespaceURI)) {
                                namespaceURI = XHTML_NS;
                            }
                            theEventWriter.writeStartElement(se.getName().getLocalPart());
                            theEventWriter.writeDefaultNamespace(namespaceURI);
                        } else {
                            String prefix = se.getName().getPrefix();
                            String namespaceURI = se.getName().getNamespaceURI();
                            theEventWriter.writeStartElement(prefix, se.getName().getLocalPart(), namespaceURI);
                            theEventWriter.writeNamespace(prefix, namespaceURI);
                        }
                        firstElement = false;
                        break;
                    }
                    if (StringUtils.isBlank((CharSequence)se.getName().getPrefix())) {
                        if (StringUtils.isBlank((CharSequence)se.getName().getNamespaceURI())) {
                            theEventWriter.writeStartElement(se.getName().getLocalPart());
                        } else if (StringUtils.isBlank((CharSequence)se.getName().getPrefix())) {
                            theEventWriter.writeStartElement(se.getName().getLocalPart());
                        } else {
                            theEventWriter.writeStartElement(se.getName().getNamespaceURI(), se.getName().getLocalPart());
                        }
                    } else {
                        theEventWriter.writeStartElement(se.getName().getPrefix(), se.getName().getLocalPart(), se.getName().getNamespaceURI());
                    }
                    Iterator<Attribute> attrIter = se.getAttributes();
                    while (attrIter.hasNext()) {
                        Attribute next = attrIter.next();
                        theEventWriter.writeAttribute(next.getName().getLocalPart(), next.getValue());
                    }
                    continue block10;
                }
            }
        }
    }

    @Override
    public EncodingEnum getEncoding() {
        return EncodingEnum.XML;
    }

    private <T extends IBaseResource> T parseResource(Class<T> theResourceType, XMLEventReader theStreamReader) {
        ParserState<T> parserState = ParserState.getPreResourceInstance(this, theResourceType, this.myContext, false, this.getErrorHandler());
        return (T)((IBaseResource)this.doXmlLoop(theStreamReader, parserState));
    }

    @Override
    public IParser setPrettyPrint(boolean thePrettyPrint) {
        this.myPrettyPrint = thePrettyPrint;
        return this;
    }

    private <Q extends IBaseExtension<?, ?>> List<IBaseExtension<?, ?>> toBaseExtensionList(List<Q> theList) {
        ArrayList retVal = new ArrayList(theList.size());
        retVal.addAll(theList);
        return retVal;
    }

    private void writeCommentsPost(XMLStreamWriter theEventWriter, IBase theElement) throws XMLStreamException {
        if (theElement != null && theElement.hasFormatComment()) {
            for (String next : theElement.getFormatCommentsPost()) {
                if (!StringUtils.isNotBlank((CharSequence)next)) continue;
                theEventWriter.writeComment(next);
            }
        }
    }

    private void writeCommentsPre(XMLStreamWriter theEventWriter, IBase theElement) throws XMLStreamException {
        if (theElement != null && theElement.hasFormatComment()) {
            for (String next : theElement.getFormatCommentsPre()) {
                if (!StringUtils.isNotBlank((CharSequence)next)) continue;
                theEventWriter.writeComment(next);
            }
        }
    }

    private void writeOptionalTagWithValue(XMLStreamWriter theEventWriter, String theName, String theValue) throws XMLStreamException {
        if (StringUtils.isNotBlank((CharSequence)theValue)) {
            theEventWriter.writeStartElement(theName);
            theEventWriter.writeAttribute("value", theValue);
            theEventWriter.writeEndElement();
        }
    }
}

