/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.support.IContextValidationSupport;
import ca.uhn.fhir.util.CoverageIgnore;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javassist.Modifier;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtil {
    private static final ConcurrentHashMap<String, Object> ourFhirServerVersions = new ConcurrentHashMap();
    private static final Logger ourLog = LoggerFactory.getLogger(ReflectionUtil.class);

    public static LinkedHashSet<Method> getDeclaredMethods(Class<?> theClazz) {
        LinkedHashSet<Method> retVal = new LinkedHashSet<Method>();
        for (Method next : theClazz.getDeclaredMethods()) {
            try {
                Method method = theClazz.getMethod(next.getName(), next.getParameterTypes());
                retVal.add(method);
            }
            catch (NoSuchMethodException e) {
                retVal.add(next);
            }
            catch (SecurityException e) {
                retVal.add(next);
            }
        }
        return retVal;
    }

    public static Class<?> getGenericCollectionTypeOfField(Field next) {
        Class type;
        ParameterizedType collectionType = (ParameterizedType)next.getGenericType();
        Type firstArg = collectionType.getActualTypeArguments()[0];
        if (ParameterizedType.class.isAssignableFrom(firstArg.getClass())) {
            ParameterizedType pt = (ParameterizedType)firstArg;
            type = (Class)pt.getRawType();
        } else {
            type = (Class)firstArg;
        }
        return type;
    }

    public static Class<?> getGenericCollectionTypeOfFieldWithSecondOrderForList(Field next) {
        if (!List.class.isAssignableFrom(next.getType())) {
            return ReflectionUtil.getGenericCollectionTypeOfField(next);
        }
        ParameterizedType collectionType = (ParameterizedType)next.getGenericType();
        Type firstArg = collectionType.getActualTypeArguments()[0];
        if (ParameterizedType.class.isAssignableFrom(firstArg.getClass())) {
            ParameterizedType pt = (ParameterizedType)firstArg;
            Type pt2 = pt.getActualTypeArguments()[0];
            return (Class)pt2;
        }
        Class type = (Class)firstArg;
        return type;
    }

    public static Class<?> getGenericCollectionTypeOfMethodParameter(Method theMethod, int theParamIndex) {
        Class type;
        Type genericParameterType = theMethod.getGenericParameterTypes()[theParamIndex];
        if (Class.class.equals((Object)genericParameterType)) {
            return null;
        }
        ParameterizedType collectionType = (ParameterizedType)genericParameterType;
        Type firstArg = collectionType.getActualTypeArguments()[0];
        if (ParameterizedType.class.isAssignableFrom(firstArg.getClass())) {
            ParameterizedType pt = (ParameterizedType)firstArg;
            type = (Class)pt.getRawType();
        } else {
            type = (Class)firstArg;
        }
        return type;
    }

    public static Class<?> getGenericCollectionTypeOfMethodReturnType(Method theMethod) {
        Class type;
        Type genericReturnType = theMethod.getGenericReturnType();
        if (!(genericReturnType instanceof ParameterizedType)) {
            return null;
        }
        ParameterizedType collectionType = (ParameterizedType)genericReturnType;
        Type firstArg = collectionType.getActualTypeArguments()[0];
        if (ParameterizedType.class.isAssignableFrom(firstArg.getClass())) {
            ParameterizedType pt = (ParameterizedType)firstArg;
            type = (Class)pt.getRawType();
        } else {
            if (firstArg instanceof TypeVariable) {
                Type decl = ((TypeVariable)firstArg).getBounds()[0];
                return (Class)decl;
            }
            if (firstArg instanceof WildcardType) {
                Type decl = ((WildcardType)firstArg).getUpperBounds()[0];
                return (Class)decl;
            }
            type = (Class)firstArg;
        }
        return type;
    }

    public static boolean isInstantiable(Class<?> theType) {
        return !theType.isInterface() && !Modifier.isAbstract((int)theType.getModifiers());
    }

    @CoverageIgnore
    public static <T> T newInstance(Class<T> theType) {
        Validate.notNull(theType, (String)"theType must not be null", (Object[])new Object[0]);
        try {
            return theType.newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to instantiate " + theType.getName(), e);
        }
    }

    public static <T> T newInstance(Class<T> theType, Class<?> theArgumentType, Object theArgument) {
        Validate.notNull(theType, (String)"theType must not be null", (Object[])new Object[0]);
        try {
            Constructor<T> constructor = theType.getConstructor(theArgumentType);
            return constructor.newInstance(theArgument);
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to instantiate " + theType.getName(), e);
        }
    }

    public static Object newInstanceOfFhirServerType(String theType) {
        String errorMessage = "Unable to instantiate server framework. Please make sure that hapi-fhir-server library is on your classpath!";
        String wantedType = "ca.uhn.fhir.rest.api.server.IFhirVersionServer";
        Object fhirServerVersion = ReflectionUtil.newInstanceOfType(theType, errorMessage, wantedType);
        return fhirServerVersion;
    }

    public static <EVS_IN, EVS_OUT, SDT, CST, CDCT, IST> IContextValidationSupport<EVS_IN, EVS_OUT, SDT, CST, CDCT, IST> newInstanceOfFhirProfileValidationSupport(String theType) {
        String errorMessage = "Unable to instantiate validation support! Please make sure that hapi-fhir-validation and the appropriate structures JAR are on your classpath!";
        String wantedType = "ca.uhn.fhir.context.support.IContextValidationSupport";
        Object fhirServerVersion = ReflectionUtil.newInstanceOfType(theType, errorMessage, wantedType);
        return (IContextValidationSupport)fhirServerVersion;
    }

    private static Object newInstanceOfType(String theType, String errorMessage, String wantedType) {
        Object fhirServerVersion = ourFhirServerVersions.get(theType);
        if (fhirServerVersion == null) {
            try {
                Class<?> type = Class.forName(theType);
                Class<?> serverType = Class.forName(wantedType);
                Validate.isTrue((boolean)serverType.isAssignableFrom(type));
                fhirServerVersion = type.newInstance();
            }
            catch (Exception e) {
                throw new ConfigurationException(errorMessage, e);
            }
            ourFhirServerVersions.put(theType, fhirServerVersion);
        }
        return fhirServerVersion;
    }

    public static <T> T newInstanceOrReturnNull(String theClassName, Class<T> theType) {
        try {
            Class<?> clazz = Class.forName(theClassName);
            if (!theType.isAssignableFrom(clazz)) {
                throw new ConfigurationException(theClassName + " is not assignable to " + theType);
            }
            return (T)clazz.newInstance();
        }
        catch (ConfigurationException e) {
            throw e;
        }
        catch (Exception e) {
            ourLog.info("Failed to instantiate {}: {}", (Object)theClassName, (Object)e.toString());
            return null;
        }
    }
}

