/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.annotation.ProvidesResources;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProvidedResourceScanner {
    private static final Logger ourLog = LoggerFactory.getLogger(ProvidedResourceScanner.class);
    private FhirContext myContext;

    public ProvidedResourceScanner(FhirContext theContext) {
        this.myContext = theContext;
    }

    public void scanForProvidedResources(Object theProvider) {
        ProvidesResources annotation = theProvider.getClass().getAnnotation(ProvidesResources.class);
        if (annotation == null) {
            return;
        }
        for (Class<?> clazz : annotation.resources()) {
            if (IBaseResource.class.isAssignableFrom(clazz)) {
                this.myContext.getResourceDefinition(clazz);
                continue;
            }
            ourLog.warn(clazz.getSimpleName() + "is not assignable from IResource");
        }
    }

    public void removeProvidedResources(Object theProvider) {
        ProvidesResources annotation = theProvider.getClass().getAnnotation(ProvidesResources.class);
        if (annotation == null) {
            return;
        }
        for (Class<?> clazz : annotation.resources()) {
            if (IBaseResource.class.isAssignableFrom(clazz)) continue;
            ourLog.warn(clazz.getSimpleName() + "is not assignable from IResource");
        }
    }
}

