/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context.support;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.server.exceptions.ResourceNotFoundException;
import ca.uhn.fhir.util.ParametersUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseParameters;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public interface IContextValidationSupport<EVS_IN, EVS_OUT, SDT, CST, CDCT, IST> {
    public EVS_OUT expandValueSet(FhirContext var1, EVS_IN var2);

    public List<IBaseResource> fetchAllConformanceResources(FhirContext var1);

    public List<SDT> fetchAllStructureDefinitions(FhirContext var1);

    public CST fetchCodeSystem(FhirContext var1, String var2);

    public <T extends IBaseResource> T fetchResource(FhirContext var1, Class<T> var2, String var3);

    public SDT fetchStructureDefinition(FhirContext var1, String var2);

    public boolean isCodeSystemSupported(FhirContext var1, String var2);

    public CodeValidationResult<CDCT, IST> validateCode(FhirContext var1, String var2, String var3, String var4);

    public LookupCodeResult lookupCode(FhirContext var1, String var2, String var3);

    public static class LookupCodeResult {
        private String myCodeDisplay;
        private boolean myCodeIsAbstract;
        private String myCodeSystemDisplayName;
        private String myCodeSystemVersion;
        private boolean myFound;
        private String mySearchedForCode;
        private String mySearchedForSystem;
        private List<BaseConceptProperty> myProperties;
        private List<ConceptDesignation> myDesignations;

        public List<BaseConceptProperty> getProperties() {
            if (this.myProperties == null) {
                this.myProperties = new ArrayList<BaseConceptProperty>();
            }
            return this.myProperties;
        }

        public void setProperties(List<BaseConceptProperty> theProperties) {
            this.myProperties = theProperties;
        }

        @Nonnull
        public List<ConceptDesignation> getDesignations() {
            if (this.myDesignations == null) {
                this.myDesignations = new ArrayList<ConceptDesignation>();
            }
            return this.myDesignations;
        }

        public String getCodeDisplay() {
            return this.myCodeDisplay;
        }

        public void setCodeDisplay(String theCodeDisplay) {
            this.myCodeDisplay = theCodeDisplay;
        }

        public String getCodeSystemDisplayName() {
            return this.myCodeSystemDisplayName;
        }

        public void setCodeSystemDisplayName(String theCodeSystemDisplayName) {
            this.myCodeSystemDisplayName = theCodeSystemDisplayName;
        }

        public String getCodeSystemVersion() {
            return this.myCodeSystemVersion;
        }

        public void setCodeSystemVersion(String theCodeSystemVersion) {
            this.myCodeSystemVersion = theCodeSystemVersion;
        }

        public String getSearchedForCode() {
            return this.mySearchedForCode;
        }

        public LookupCodeResult setSearchedForCode(String theSearchedForCode) {
            this.mySearchedForCode = theSearchedForCode;
            return this;
        }

        public String getSearchedForSystem() {
            return this.mySearchedForSystem;
        }

        public LookupCodeResult setSearchedForSystem(String theSearchedForSystem) {
            this.mySearchedForSystem = theSearchedForSystem;
            return this;
        }

        public boolean isCodeIsAbstract() {
            return this.myCodeIsAbstract;
        }

        public void setCodeIsAbstract(boolean theCodeIsAbstract) {
            this.myCodeIsAbstract = theCodeIsAbstract;
        }

        public boolean isFound() {
            return this.myFound;
        }

        public LookupCodeResult setFound(boolean theFound) {
            this.myFound = theFound;
            return this;
        }

        public void throwNotFoundIfAppropriate() {
            if (!this.isFound()) {
                throw new ResourceNotFoundException("Unable to find code[" + this.getSearchedForCode() + "] in system[" + this.getSearchedForSystem() + "]");
            }
        }

        public IBaseParameters toParameters(FhirContext theContext, List<? extends IPrimitiveType<String>> theProperties) {
            IBaseParameters retVal = ParametersUtil.newInstance(theContext);
            if (StringUtils.isNotBlank((CharSequence)this.getCodeSystemDisplayName())) {
                ParametersUtil.addParameterToParametersString(theContext, retVal, "name", this.getCodeSystemDisplayName());
            }
            if (StringUtils.isNotBlank((CharSequence)this.getCodeSystemVersion())) {
                ParametersUtil.addParameterToParametersString(theContext, retVal, "version", this.getCodeSystemVersion());
            }
            ParametersUtil.addParameterToParametersString(theContext, retVal, "display", this.getCodeDisplay());
            ParametersUtil.addParameterToParametersBoolean(theContext, retVal, "abstract", this.isCodeIsAbstract());
            if (this.myProperties != null) {
                Set properties = Collections.emptySet();
                if (theProperties != null) {
                    properties = theProperties.stream().map(IPrimitiveType::getValueAsString).collect(Collectors.toSet());
                }
                for (BaseConceptProperty next : this.myProperties) {
                    BaseConceptProperty prop;
                    if (!properties.isEmpty() && !properties.contains(next.getPropertyName())) continue;
                    IBase property = ParametersUtil.addParameterToParameters(theContext, retVal, "property");
                    ParametersUtil.addPartCode(theContext, property, "code", next.getPropertyName());
                    if (next instanceof StringConceptProperty) {
                        prop = (StringConceptProperty)next;
                        ParametersUtil.addPartString(theContext, property, "value", ((StringConceptProperty)prop).getValue());
                        continue;
                    }
                    if (next instanceof CodingConceptProperty) {
                        prop = (CodingConceptProperty)next;
                        ParametersUtil.addPartCoding(theContext, property, "value", ((CodingConceptProperty)prop).getCodeSystem(), ((CodingConceptProperty)prop).getCode(), ((CodingConceptProperty)prop).getDisplay());
                        continue;
                    }
                    throw new IllegalStateException("Don't know how to handle " + next.getClass());
                }
            }
            if (this.myDesignations != null) {
                for (ConceptDesignation next : this.myDesignations) {
                    IBase property = ParametersUtil.addParameterToParameters(theContext, retVal, "designation");
                    ParametersUtil.addPartCode(theContext, property, "language", next.getLanguage());
                    ParametersUtil.addPartCoding(theContext, property, "use", next.getUseSystem(), next.getUseCode(), next.getUseDisplay());
                    ParametersUtil.addPartString(theContext, property, "value", next.getValue());
                }
            }
            return retVal;
        }

        public static LookupCodeResult notFound(String theSearchedForSystem, String theSearchedForCode) {
            return new LookupCodeResult().setFound(false).setSearchedForSystem(theSearchedForSystem).setSearchedForCode(theSearchedForCode);
        }
    }

    public static abstract class CodeValidationResult<CDCT, IST> {
        private CDCT myDefinition;
        private String myMessage;
        private IST mySeverity;
        private String myCodeSystemName;
        private String myCodeSystemVersion;
        private List<BaseConceptProperty> myProperties;

        public CodeValidationResult(CDCT theNext) {
            this.myDefinition = theNext;
        }

        public CodeValidationResult(IST severity, String message) {
            this.mySeverity = severity;
            this.myMessage = message;
        }

        public CodeValidationResult(IST severity, String message, CDCT definition) {
            this.mySeverity = severity;
            this.myMessage = message;
            this.myDefinition = definition;
        }

        public CDCT asConceptDefinition() {
            return this.myDefinition;
        }

        public String getCodeSystemName() {
            return this.myCodeSystemName;
        }

        public void setCodeSystemName(String theCodeSystemName) {
            this.myCodeSystemName = theCodeSystemName;
        }

        public String getCodeSystemVersion() {
            return this.myCodeSystemVersion;
        }

        public void setCodeSystemVersion(String theCodeSystemVersion) {
            this.myCodeSystemVersion = theCodeSystemVersion;
        }

        public String getMessage() {
            return this.myMessage;
        }

        public List<BaseConceptProperty> getProperties() {
            return this.myProperties;
        }

        public void setProperties(List<BaseConceptProperty> theProperties) {
            this.myProperties = theProperties;
        }

        public IST getSeverity() {
            return this.mySeverity;
        }

        public boolean isOk() {
            return this.myDefinition != null;
        }

        public LookupCodeResult asLookupCodeResult(String theSearchedForSystem, String theSearchedForCode) {
            LookupCodeResult retVal = new LookupCodeResult();
            retVal.setSearchedForSystem(theSearchedForSystem);
            retVal.setSearchedForCode(theSearchedForCode);
            if (this.isOk()) {
                retVal.setFound(true);
                retVal.setCodeDisplay(this.getDisplay());
                retVal.setCodeSystemDisplayName(this.getCodeSystemName());
                retVal.setCodeSystemVersion(this.getCodeSystemVersion());
            }
            return retVal;
        }

        protected abstract String getDisplay();
    }

    public static class CodingConceptProperty
    extends BaseConceptProperty {
        private final String myCode;
        private final String myCodeSystem;
        private final String myDisplay;

        public CodingConceptProperty(String theName, String theCodeSystem, String theCode, String theDisplay) {
            super(theName);
            this.myCodeSystem = theCodeSystem;
            this.myCode = theCode;
            this.myDisplay = theDisplay;
        }

        public String getCode() {
            return this.myCode;
        }

        public String getCodeSystem() {
            return this.myCodeSystem;
        }

        public String getDisplay() {
            return this.myDisplay;
        }
    }

    public static class StringConceptProperty
    extends BaseConceptProperty {
        private final String myValue;

        public StringConceptProperty(String theName, String theValue) {
            super(theName);
            this.myValue = theValue;
        }

        public String getValue() {
            return this.myValue;
        }
    }

    public static abstract class BaseConceptProperty {
        private final String myPropertyName;

        protected BaseConceptProperty(String thePropertyName) {
            this.myPropertyName = thePropertyName;
        }

        public String getPropertyName() {
            return this.myPropertyName;
        }
    }

    public static class ConceptDesignation {
        private String myLanguage;
        private String myUseSystem;
        private String myUseCode;
        private String myUseDisplay;
        private String myValue;

        public String getLanguage() {
            return this.myLanguage;
        }

        public ConceptDesignation setLanguage(String theLanguage) {
            this.myLanguage = theLanguage;
            return this;
        }

        public String getUseSystem() {
            return this.myUseSystem;
        }

        public ConceptDesignation setUseSystem(String theUseSystem) {
            this.myUseSystem = theUseSystem;
            return this;
        }

        public String getUseCode() {
            return this.myUseCode;
        }

        public ConceptDesignation setUseCode(String theUseCode) {
            this.myUseCode = theUseCode;
            return this;
        }

        public String getUseDisplay() {
            return this.myUseDisplay;
        }

        public ConceptDesignation setUseDisplay(String theUseDisplay) {
            this.myUseDisplay = theUseDisplay;
            return this;
        }

        public String getValue() {
            return this.myValue;
        }

        public ConceptDesignation setValue(String theValue) {
            this.myValue = theValue;
            return this;
        }
    }
}

