/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.i18n;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.util.UrlUtil;
import ca.uhn.fhir.util.VersionUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HapiLocalizer {
    public static final String UNKNOWN_I18N_KEY_MESSAGE = "!MESSAGE!";
    private static final Logger ourLog = LoggerFactory.getLogger(HapiLocalizer.class);
    private static boolean ourFailOnMissingMessage;
    private final Map<String, MessageFormat> myKeyToMessageFormat = new ConcurrentHashMap<String, MessageFormat>();
    private List<ResourceBundle> myBundle = new ArrayList<ResourceBundle>();
    private final Map<String, String> myHardcodedMessages = new HashMap<String, String>();
    private String[] myBundleNames;

    public HapiLocalizer() {
        this(HapiLocalizer.class.getPackage().getName() + ".hapi-messages");
    }

    public HapiLocalizer(String ... theBundleNames) {
        this.myBundleNames = theBundleNames;
        this.init();
        this.addMessage("hapi.version", VersionUtil.getVersion());
    }

    protected void addMessage(String theKey, String theMessage) {
        this.myHardcodedMessages.put(theKey, theMessage);
    }

    public Set<String> getAllKeys() {
        HashSet<String> retVal = new HashSet<String>();
        for (ResourceBundle nextBundle : this.myBundle) {
            Enumeration<String> keysEnum = nextBundle.getKeys();
            while (keysEnum.hasMoreElements()) {
                retVal.add(keysEnum.nextElement());
            }
        }
        return retVal;
    }

    public String getFormatString(String theQualifiedKey) {
        String formatString = this.myHardcodedMessages.get(theQualifiedKey);
        if (StringUtils.isBlank((CharSequence)formatString)) {
            for (ResourceBundle nextBundle : this.myBundle) {
                if (nextBundle.containsKey(theQualifiedKey)) {
                    formatString = nextBundle.getString(theQualifiedKey);
                    formatString = StringUtils.trim((String)formatString);
                }
                if (!StringUtils.isNotBlank((CharSequence)formatString)) continue;
                break;
            }
        }
        if (formatString == null) {
            ourLog.warn("Unknown localization key: {}", (Object)theQualifiedKey);
            if (ourFailOnMissingMessage) {
                throw new ConfigurationException("Unknown localization key: " + theQualifiedKey);
            }
            formatString = UNKNOWN_I18N_KEY_MESSAGE;
        }
        return formatString;
    }

    public String getMessage(Class<?> theType, String theKey, Object ... theParameters) {
        return this.getMessage(HapiLocalizer.toKey(theType, theKey), theParameters);
    }

    public String getMessageSanitized(Class<?> theType, String theKey, Object ... theParameters) {
        if (theParameters != null) {
            for (int i = 0; i < theParameters.length; ++i) {
                if (!(theParameters[i] instanceof CharSequence)) continue;
                theParameters[i] = UrlUtil.sanitizeUrlPart((CharSequence)theParameters[i]);
            }
        }
        return this.getMessage(HapiLocalizer.toKey(theType, theKey), theParameters);
    }

    public String getMessage(String theQualifiedKey, Object ... theParameters) {
        if (theParameters != null && theParameters.length > 0) {
            MessageFormat format = this.myKeyToMessageFormat.get(theQualifiedKey);
            if (format != null) {
                return format.format(theParameters);
            }
            String formatString = this.getFormatString(theQualifiedKey);
            format = this.newMessageFormat(formatString);
            this.myKeyToMessageFormat.put(theQualifiedKey, format);
            return format.format(theParameters);
        }
        return this.getFormatString(theQualifiedKey);
    }

    MessageFormat newMessageFormat(String theFormatString) {
        StringBuilder pattern = new StringBuilder(theFormatString.trim());
        for (int i = 0; i < pattern.length() - 1; ++i) {
            char nextChar;
            if (pattern.charAt(i) != '{' || (nextChar = pattern.charAt(i + 1)) >= '0' && nextChar <= '9') continue;
            pattern.replace(i, i + 1, "'{'");
            int closeBraceIndex = pattern.indexOf("}", i);
            if (closeBraceIndex <= 0) continue;
            i = closeBraceIndex;
            pattern.replace(i, i + 1, "'}'");
        }
        return new MessageFormat(pattern.toString());
    }

    protected void init() {
        for (String nextName : this.myBundleNames) {
            this.myBundle.add(ResourceBundle.getBundle(nextName));
        }
    }

    public static void setOurFailOnMissingMessage(boolean ourFailOnMissingMessage) {
        HapiLocalizer.ourFailOnMissingMessage = ourFailOnMissingMessage;
    }

    public static String toKey(Class<?> theType, String theKey) {
        return theType.getName() + '.' + theKey;
    }
}

