/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseDatatype;

public abstract class BaseElement
implements ISupportsUndeclaredExtensions {
    private static final long serialVersionUID = -3092659584634499332L;
    private List<String> myFormatCommentsPost;
    private List<String> myFormatCommentsPre;
    @Child(name="extension", type={ExtensionDt.class}, order=0, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Additional Content defined by implementations", formalDefinition="May be used to represent additional information that is not part of the basic definition of the resource. In order to make the use of extensions safe and manageable, there is a strict set of governance  applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension.")
    private List<ExtensionDt> myUndeclaredExtensions;
    @Child(name="modifierExtension", type={ExtensionDt.class}, order=1, min=0, max=-1, modifier=true, summary=false)
    @Description(shortDefinition="Extensions that cannot be ignored", formalDefinition="May be used to represent additional information that is not part of the basic definition of the resource, and that modifies the understanding of the element that contains it. Usually modifier elements provide negation or qualification. In order to make the use of extensions safe and manageable, there is a strict set of governance applied to the definition and use of extensions. Though any implementer is allowed to define an extension, there is a set of requirements that SHALL be met as part of the definition of the extension. Applications processing a resource are required to check for modifier extensions.")
    private List<ExtensionDt> myUndeclaredModifierExtensions;

    @Override
    public ExtensionDt addUndeclaredExtension(boolean theIsModifier, String theUrl) {
        Validate.notEmpty((CharSequence)theUrl, (String)"URL must be populated", (Object[])new Object[0]);
        ExtensionDt retVal = new ExtensionDt(theIsModifier, theUrl);
        if (theIsModifier) {
            this.getUndeclaredModifierExtensions();
            this.myUndeclaredModifierExtensions.add(retVal);
        } else {
            this.getUndeclaredExtensions();
            this.myUndeclaredExtensions.add(retVal);
        }
        return retVal;
    }

    @Override
    public ExtensionDt addUndeclaredExtension(boolean theIsModifier, String theUrl, IBaseDatatype theValue) {
        Validate.notEmpty((CharSequence)theUrl, (String)"URL must be populated", (Object[])new Object[0]);
        Validate.notNull((Object)theValue, (String)"Value must not be null", (Object[])new Object[0]);
        ExtensionDt retVal = new ExtensionDt(theIsModifier, theUrl, theValue);
        if (theIsModifier) {
            this.getUndeclaredModifierExtensions();
            this.myUndeclaredModifierExtensions.add(retVal);
        } else {
            this.getUndeclaredExtensions();
            this.myUndeclaredExtensions.add(retVal);
        }
        return retVal;
    }

    @Override
    public void addUndeclaredExtension(ExtensionDt theExtension) {
        Validate.notNull((Object)theExtension, (String)"Extension can not be null", (Object[])new Object[0]);
        if (theExtension.isModifier()) {
            this.getUndeclaredModifierExtensions();
            this.myUndeclaredModifierExtensions.add(theExtension);
        } else {
            this.getUndeclaredExtensions();
            this.myUndeclaredExtensions.add(theExtension);
        }
    }

    @Override
    public List<ExtensionDt> getAllUndeclaredExtensions() {
        ArrayList<ExtensionDt> retVal = new ArrayList<ExtensionDt>();
        if (this.myUndeclaredExtensions != null) {
            retVal.addAll(this.myUndeclaredExtensions);
        }
        if (this.myUndeclaredModifierExtensions != null) {
            retVal.addAll(this.myUndeclaredModifierExtensions);
        }
        return Collections.unmodifiableList(retVal);
    }

    @Override
    public List<String> getFormatCommentsPost() {
        if (this.myFormatCommentsPost == null) {
            this.myFormatCommentsPost = new ArrayList<String>();
        }
        return this.myFormatCommentsPost;
    }

    @Override
    public List<String> getFormatCommentsPre() {
        if (this.myFormatCommentsPre == null) {
            this.myFormatCommentsPre = new ArrayList<String>();
        }
        return this.myFormatCommentsPre;
    }

    @Override
    public List<ExtensionDt> getUndeclaredExtensions() {
        if (this.myUndeclaredExtensions == null) {
            this.myUndeclaredExtensions = new ArrayList<ExtensionDt>();
        }
        return this.myUndeclaredExtensions;
    }

    @Override
    public List<ExtensionDt> getUndeclaredExtensionsByUrl(String theUrl) {
        Validate.notNull((Object)theUrl, (String)"URL can not be null", (Object[])new Object[0]);
        ArrayList<ExtensionDt> retVal = new ArrayList<ExtensionDt>();
        for (ExtensionDt next : this.getAllUndeclaredExtensions()) {
            if (!theUrl.equals(next.getUrlAsString())) continue;
            retVal.add(next);
        }
        return Collections.unmodifiableList(retVal);
    }

    @Override
    public List<ExtensionDt> getUndeclaredModifierExtensions() {
        if (this.myUndeclaredModifierExtensions == null) {
            this.myUndeclaredModifierExtensions = new ArrayList<ExtensionDt>();
        }
        return this.myUndeclaredModifierExtensions;
    }

    @Override
    public boolean hasFormatComment() {
        return this.myFormatCommentsPre != null && !this.myFormatCommentsPre.isEmpty() || this.myFormatCommentsPost != null && !this.myFormatCommentsPost.isEmpty();
    }

    protected boolean isBaseEmpty() {
        if (this.myUndeclaredExtensions != null) {
            for (ExtensionDt next : this.myUndeclaredExtensions) {
                if (next == null || next.isEmpty()) continue;
                return false;
            }
        }
        if (this.myUndeclaredModifierExtensions != null) {
            for (ExtensionDt next : this.myUndeclaredModifierExtensions) {
                if (next == null || next.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }
}

