/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.exceptions;

import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.util.CoverageIgnore;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

@CoverageIgnore
public class NonFhirResponseException
extends BaseServerResponseException {
    private static final long serialVersionUID = 1L;

    NonFhirResponseException(int theStatusCode, String theMessage) {
        super(theStatusCode, theMessage);
    }

    public static NonFhirResponseException newInstance(int theStatusCode, String theContentType, InputStream theInputStream) {
        return NonFhirResponseException.newInstance(theStatusCode, theContentType, new InputStreamReader(theInputStream, Charsets.UTF_8));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NonFhirResponseException newInstance(int theStatusCode, String theContentType, Reader theReader) {
        String responseBody = "";
        try {
            responseBody = IOUtils.toString((Reader)theReader);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                theReader.close();
            }
            catch (IOException iOException) {}
        }
        NonFhirResponseException retVal = StringUtils.isBlank((CharSequence)theContentType) ? new NonFhirResponseException(theStatusCode, "Response contains no Content-Type") : (theContentType.contains("text") ? new NonFhirResponseException(theStatusCode, "Response contains non FHIR Content-Type '" + theContentType + "' : " + responseBody) : new NonFhirResponseException(theStatusCode, "Response contains non FHIR Content-Type '" + theContentType + "'"));
        retVal.setResponseBody(responseBody);
        return retVal;
    }
}

