/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.param;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public enum ParamPrefixEnum {
    APPROXIMATE("ap"),
    ENDS_BEFORE("eb"),
    EQUAL("eq"),
    GREATERTHAN("gt"),
    GREATERTHAN_OR_EQUALS("ge"),
    LESSTHAN("lt"),
    LESSTHAN_OR_EQUALS("le"),
    NOT_EQUAL("ne"),
    STARTS_AFTER("sa");

    private static final Map<String, ParamPrefixEnum> VALUE_TO_PREFIX;
    private final String myValue;

    private ParamPrefixEnum(String theValue) {
        this.myValue = theValue;
    }

    public String getValue() {
        return this.myValue;
    }

    public static ParamPrefixEnum forValue(String theValue) {
        return VALUE_TO_PREFIX.get(theValue);
    }

    static {
        HashMap<String, ParamPrefixEnum> valueToPrefix = new HashMap<String, ParamPrefixEnum>();
        for (ParamPrefixEnum next : ParamPrefixEnum.values()) {
            valueToPrefix.put(next.getValue(), next);
        }
        VALUE_TO_PREFIX = Collections.unmodifiableMap(valueToPrefix);
    }
}

