/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.util;

import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AsyncUtil {
    private static final Logger ourLog = LoggerFactory.getLogger(AsyncUtil.class);

    private AsyncUtil() {
    }

    public static boolean sleep(long theMillis) {
        try {
            Thread.sleep(theMillis);
            return true;
        }
        catch (InterruptedException theE) {
            Thread.currentThread().interrupt();
            ourLog.warn("Sleep for {}ms was interrupted", (Object)theMillis);
            return false;
        }
    }

    public static boolean awaitLatchAndThrowInternalErrorExceptionOnInterrupt(CountDownLatch theInitialCollectionLatch, long theTime, TimeUnit theTimeUnit) {
        try {
            return theInitialCollectionLatch.await(theTime, theTimeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new InternalErrorException(e);
        }
    }

    public static boolean awaitLatchAndIgnoreInterrupt(CountDownLatch theInitialCollectionLatch, long theTime, TimeUnit theTimeUnit) {
        try {
            return theInitialCollectionLatch.await(theTime, theTimeUnit);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            ourLog.warn("Interrupted while waiting for latch");
            return false;
        }
    }
}

