/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildContainedResources;
import ca.uhn.fhir.context.RuntimeChildExtension;
import ca.uhn.fhir.context.RuntimeChildNarrativeDefinition;
import ca.uhn.fhir.context.RuntimeChildUndeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.narrative.INarrativeGenerator;
import ca.uhn.fhir.parser.BaseParser;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.ParserState;
import ca.uhn.fhir.rest.api.EncodingEnum;
import ca.uhn.fhir.util.ElementUtil;
import ca.uhn.fhir.util.rdf.RDFUtil;
import java.io.Reader;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.system.StreamRDF;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseHasModifierExtensions;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.INarrative;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RDFParser
extends BaseParser {
    private static final String FHIR_NS = "http://hl7.org/fhir";
    private static final Logger logger = LoggerFactory.getLogger(RDFParser.class);
    private FhirContext context;
    private Lang lang;

    public RDFParser(FhirContext context, IParserErrorHandler parserErrorHandler, Lang lang) {
        super(context, parserErrorHandler);
        this.context = context;
        this.lang = lang;
    }

    @Override
    protected void doEncodeResourceToWriter(IBaseResource resource, Writer writer, BaseParser.EncodeContext encodeContext) {
        StreamRDF eventWriter = RDFUtil.createRDFWriter(writer, this.lang);
        eventWriter.base(FHIR_NS);
        this.encodeResourceToRDFStreamWriter(resource, eventWriter, encodeContext);
    }

    @Override
    protected <T extends IBaseResource> T doParseResource(Class<T> resourceType, Reader reader) throws DataFormatException {
        StreamRDF streamReader = RDFUtil.createRDFReader(reader, this.lang);
        streamReader.base(FHIR_NS);
        return this.parseResource(resourceType, streamReader);
    }

    @Override
    public EncodingEnum getEncoding() {
        return EncodingEnum.RDF;
    }

    @Override
    public IParser setPrettyPrint(boolean prettyPrint) {
        return this;
    }

    private void encodeResourceToRDFStreamWriter(IBaseResource resource, StreamRDF streamWriter, boolean containedResource, IIdType resourceId, BaseParser.EncodeContext encodeContext) {
        RuntimeResourceDefinition resDef = this.context.getResourceDefinition(resource);
        if (resDef == null) {
            throw new ConfigurationException("Unknown resource type: " + resource.getClass());
        }
        if (!containedResource) {
            super.containResourcesForEncoding(resource);
        }
        if (resource instanceof IAnyResource) {
            if (resourceId != null) {
                this.writeCommentsPre(streamWriter, resourceId);
                streamWriter.start();
                streamWriter.triple(RDFUtil.triple("<value> " + resourceId.getIdPart() + " </value>"));
                streamWriter.finish();
                this.writeCommentsPost(streamWriter, resourceId);
            }
            this.encodeCompositeElementToStreamWriter(resource, resource, streamWriter, containedResource, new BaseParser.CompositeChildElement(resDef, encodeContext), encodeContext);
        } else {
            if (resourceId != null) {
                streamWriter.start();
                streamWriter.triple(RDFUtil.triple("<value> " + resourceId.getIdPart() + " </value>"));
                this.encodeExtensionsIfPresent(resource, streamWriter, resourceId, false, encodeContext);
                streamWriter.finish();
                this.writeCommentsPost(streamWriter, resourceId);
            }
            if (resource instanceof IBaseBinary) {
                IBaseBinary bin = (IBaseBinary)resource;
                streamWriter.triple(RDFUtil.triple("<contentType> " + bin.getContentType() + " </contentType>"));
                streamWriter.triple(RDFUtil.triple("<content> " + bin.getContentAsBase64() + " </content>"));
            } else {
                this.encodeCompositeElementToStreamWriter(resource, resource, streamWriter, containedResource, new BaseParser.CompositeChildElement(resDef, encodeContext), encodeContext);
            }
        }
        streamWriter.finish();
    }

    private void writeCommentsPre(StreamRDF eventWriter, IBase element) {
        if (element != null && element.hasFormatComment()) {
            for (String next : element.getFormatCommentsPre()) {
                if (!StringUtils.isNotBlank((CharSequence)next)) continue;
                eventWriter.base(next);
            }
        }
    }

    private void writeCommentsPost(StreamRDF eventWriter, IBase element) {
        if (element != null && element.hasFormatComment()) {
            for (String next : element.getFormatCommentsPost()) {
                if (!StringUtils.isNotBlank((CharSequence)next)) continue;
                eventWriter.base(next);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void encodeChildElementToStreamWriter(IBaseResource resource, StreamRDF eventWriter, BaseRuntimeChildDefinition childDefinition, IBase element, String childName, BaseRuntimeElementDefinition<?> childDef, String extensionUrl, boolean includedResource, BaseParser.CompositeChildElement parent, BaseParser.EncodeContext encodeContext) {
        String childGenericName = childDefinition.getElementName();
        encodeContext.pushPath(childGenericName, false);
        try {
            if ((element == null || element.isEmpty()) && !this.isChildContained(childDef, includedResource)) {
                return;
            }
            this.writeCommentsPre(eventWriter, element);
            switch (childDef.getChildType()) {
                case ID_DATATYPE: {
                    String encodedValue;
                    IIdType value = (IIdType)element;
                    assert (value != null);
                    String string = encodedValue = "id".equals(childName) ? value.getIdPart() : value.getValue();
                    if (!StringUtils.isNotBlank((CharSequence)encodedValue) && RDFParser.hasNoExtensions(value)) break;
                    eventWriter.start();
                    if (StringUtils.isNotBlank((CharSequence)encodedValue)) {
                        eventWriter.triple(RDFUtil.triple("<value> " + encodedValue + " </value>"));
                    }
                    this.encodeExtensionsIfPresent(resource, eventWriter, element, includedResource, encodeContext);
                    eventWriter.finish();
                    break;
                }
                case PRIMITIVE_DATATYPE: {
                    IPrimitiveType pd = (IPrimitiveType)element;
                    assert (pd != null);
                    String value = pd.getValueAsString();
                    if (value == null && RDFParser.hasNoExtensions(pd)) break;
                    eventWriter.start();
                    String elementId = this.getCompositeElementId(element);
                    if (StringUtils.isNotBlank((CharSequence)elementId)) {
                        eventWriter.triple(RDFUtil.triple("<id> " + elementId + " </id>"));
                    }
                    if (value != null) {
                        eventWriter.triple(RDFUtil.triple("<value> " + value + " </value>"));
                    }
                    this.encodeExtensionsIfPresent(resource, eventWriter, element, includedResource, encodeContext);
                    eventWriter.finish();
                    break;
                }
                case RESOURCE_BLOCK: 
                case COMPOSITE_DATATYPE: {
                    eventWriter.start();
                    String elementId = this.getCompositeElementId(element);
                    if (StringUtils.isNotBlank((CharSequence)elementId)) {
                        eventWriter.triple(RDFUtil.triple("<id> " + elementId + " </id>"));
                    }
                    if (StringUtils.isNotBlank((CharSequence)extensionUrl)) {
                        eventWriter.triple(RDFUtil.triple("<url> " + extensionUrl + " </url>"));
                    }
                    this.encodeCompositeElementToStreamWriter(resource, element, eventWriter, includedResource, parent, encodeContext);
                    eventWriter.finish();
                    break;
                }
                case CONTAINED_RESOURCE_LIST: 
                case CONTAINED_RESOURCES: {
                    for (IBaseResource next : this.getContainedResources().getContainedResources()) {
                        IIdType resourceId = this.getContainedResources().getResourceId(next);
                        eventWriter.start();
                        this.encodeResourceToRDFStreamWriter(next, eventWriter, true, this.fixContainedResourceId(resourceId.getValue()), encodeContext);
                        eventWriter.finish();
                    }
                    break;
                }
                case RESOURCE: {
                    IBaseResource baseResource = (IBaseResource)element;
                    String resourceName = this.context.getResourceDefinition(baseResource).getName();
                    if (!super.shouldEncodeResource(resourceName)) break;
                    eventWriter.start();
                    encodeContext.pushPath(resourceName, true);
                    this.encodeResourceToRDFStreamWriter(resource, eventWriter, encodeContext);
                    encodeContext.popPath();
                    eventWriter.finish();
                    break;
                }
                case EXTENSION_DECLARED: 
                case UNDECL_EXT: {
                    throw new IllegalStateException("state should not happen: " + childDef.getName());
                }
            }
            this.writeCommentsPost(eventWriter, element);
        }
        finally {
            encodeContext.popPath();
        }
    }

    private void encodeResourceToRDFStreamWriter(IBaseResource resource, StreamRDF eventWriter, BaseParser.EncodeContext encodeContext) {
        IIdType resourceId = null;
        if (StringUtils.isNotBlank((CharSequence)resource.getIdElement().getIdPart())) {
            resourceId = resource.getIdElement();
            if (resource.getIdElement().getValue().startsWith("urn:")) {
                resourceId = null;
            }
        }
        if (!super.shouldEncodeResourceId(resource, encodeContext)) {
            resourceId = null;
        } else if (encodeContext.getResourcePath().size() == 1 && this.getEncodeForceResourceId() != null) {
            resourceId = this.getEncodeForceResourceId();
        }
        this.encodeResourceToRDFStreamWriter(resource, eventWriter, false, resourceId, encodeContext);
    }

    private void encodeUndeclaredExtensions(IBaseResource resource, StreamRDF eventWriter, List<? extends IBaseExtension<?, ?>> extensions, boolean includedResource, BaseParser.EncodeContext encodeContext) {
        for (IBaseExtension<?, ?> next : extensions) {
            if (next == null || ElementUtil.isEmpty(next.getValue()) && next.getExtension().isEmpty()) continue;
            this.writeCommentsPre(eventWriter, next);
            eventWriter.start();
            String elementId = this.getCompositeElementId(next);
            if (StringUtils.isNotBlank((CharSequence)elementId)) {
                eventWriter.triple(RDFUtil.triple("<id> " + elementId + " </id>"));
            }
            String url = this.getExtensionUrl(next.getUrl());
            eventWriter.triple(RDFUtil.triple("<url> " + url + " </url>"));
            if (next.getValue() != null) {
                BaseRuntimeElementDefinition<?> childDef;
                IBaseDatatype value = next.getValue();
                RuntimeChildUndeclaredExtensionDefinition extDef = this.context.getRuntimeChildUndeclaredExtensionDefinition();
                String childName = extDef.getChildNameByDatatype(value.getClass());
                if (childName == null) {
                    childDef = this.context.getElementDefinition(value.getClass());
                    if (childDef == null) {
                        throw new ConfigurationException("Unable to encode extension, unrecognized child element type: " + value.getClass().getCanonicalName());
                    }
                    childName = RuntimeChildUndeclaredExtensionDefinition.createExtensionChildName(childDef);
                } else {
                    childDef = extDef.getChildElementDefinitionByDatatype(value.getClass());
                    if (childDef == null) {
                        throw new ConfigurationException("Unable to encode extension, unrecognized child element type: " + value.getClass().getCanonicalName());
                    }
                }
                this.encodeChildElementToStreamWriter(resource, eventWriter, extDef, value, childName, childDef, null, includedResource, null, encodeContext);
            }
            this.encodeExtensionsIfPresent(resource, eventWriter, next, includedResource, encodeContext);
            eventWriter.finish();
            this.writeCommentsPost(eventWriter, next);
        }
    }

    private void encodeExtensionsIfPresent(IBaseResource resource, StreamRDF writer, IBase element, boolean includedResource, BaseParser.EncodeContext encodeContext) {
        Object res;
        if (element instanceof ISupportsUndeclaredExtensions) {
            res = (ISupportsUndeclaredExtensions)element;
            this.encodeUndeclaredExtensions(resource, writer, this.toBaseExtensionList(res.getUndeclaredExtensions()), includedResource, encodeContext);
            this.encodeUndeclaredExtensions(resource, writer, this.toBaseExtensionList(res.getUndeclaredModifierExtensions()), includedResource, encodeContext);
        }
        if (element instanceof IBaseHasExtensions) {
            res = (IBaseHasExtensions)element;
            this.encodeUndeclaredExtensions(resource, writer, res.getExtension(), includedResource, encodeContext);
        }
        if (element instanceof IBaseHasModifierExtensions) {
            res = (IBaseHasModifierExtensions)((Object)element);
            this.encodeUndeclaredExtensions(resource, writer, res.getModifierExtension(), includedResource, encodeContext);
        }
    }

    private void encodeExtension(IBaseResource resource, StreamRDF eventWriter, boolean containedResource, BaseParser.CompositeChildElement nextChildElem, BaseRuntimeChildDefinition nextChild, IBase nextValue, String childName, String extensionUrl, BaseRuntimeElementDefinition<?> childDef, BaseParser.EncodeContext encodeContext) {
        BaseRuntimeDeclaredChildDefinition extDef = (BaseRuntimeDeclaredChildDefinition)nextChild;
        eventWriter.start();
        String elementId = this.getCompositeElementId(nextValue);
        if (StringUtils.isNotBlank((CharSequence)elementId)) {
            eventWriter.triple(RDFUtil.triple("<id> " + elementId + " </id>"));
        }
        eventWriter.triple(RDFUtil.triple("<url> " + extensionUrl + " </url>"));
        this.encodeChildElementToStreamWriter(resource, eventWriter, nextChild, nextValue, childName, childDef, null, containedResource, nextChildElem, encodeContext);
        eventWriter.finish();
    }

    private void encodeCompositeElementToStreamWriter(IBaseResource resource, IBase element, StreamRDF streamRDF, boolean containedResource, BaseParser.CompositeChildElement parent, BaseParser.EncodeContext encodeContext) {
        for (BaseParser.CompositeChildElement nextChildElem : super.compositeChildIterator(element, containedResource, parent, encodeContext)) {
            BaseRuntimeChildDefinition nextChild = nextChildElem.getDef();
            if (nextChild.getElementName().equals("url") && element instanceof IBaseExtension) continue;
            if (nextChild instanceof RuntimeChildNarrativeDefinition) {
                INarrativeGenerator gen = this.context.getNarrativeGenerator();
                INarrative narr = resource instanceof IResource ? ((IResource)resource).getText() : (resource instanceof IDomainResource ? ((IDomainResource)resource).getText() : null);
                assert (narr != null);
                if (gen != null && narr.isEmpty()) {
                    gen.populateResourceNarrative(this.context, resource);
                }
                if (!narr.isEmpty()) {
                    RuntimeChildNarrativeDefinition child = (RuntimeChildNarrativeDefinition)nextChild;
                    String childName = nextChild.getChildNameByDatatype(child.getDatatype());
                    BaseRuntimeElementDefinition<?> type = child.getChildByName(childName);
                    this.encodeChildElementToStreamWriter(resource, streamRDF, nextChild, narr, childName, type, null, containedResource, nextChildElem, encodeContext);
                    continue;
                }
            }
            if (nextChild instanceof RuntimeChildContainedResources) {
                this.encodeChildElementToStreamWriter(resource, streamRDF, nextChild, null, nextChild.getChildNameByDatatype(null), nextChild.getChildElementDefinitionByDatatype(null), null, containedResource, nextChildElem, encodeContext);
                continue;
            }
            List<IBase> values = nextChild.getAccessor().getValues(element);
            if ((values = super.preProcessValues(nextChild, resource, values, nextChildElem, encodeContext)) == null || values.isEmpty()) continue;
            for (IBase nextValue : values) {
                BaseParser.ChildNameAndDef childNameAndDef;
                if (nextValue == null || nextValue.isEmpty() || (childNameAndDef = super.getChildNameAndDef(nextChild, nextValue)) == null) continue;
                String childName = childNameAndDef.getChildName();
                BaseRuntimeElementDefinition<?> childDef = childNameAndDef.getChildDef();
                String extensionUrl = this.getExtensionUrl(nextChild.getExtensionUrl());
                if (extensionUrl != null && !childName.equals("extension")) {
                    this.encodeExtension(resource, streamRDF, containedResource, nextChildElem, nextChild, nextValue, childName, extensionUrl, childDef, encodeContext);
                    continue;
                }
                if (nextChild instanceof RuntimeChildExtension) {
                    IBaseExtension extension = (IBaseExtension)nextValue;
                    if ((extension.getValue() == null || extension.getValue().isEmpty()) && extension.getExtension().isEmpty()) continue;
                    this.encodeChildElementToStreamWriter(resource, streamRDF, nextChild, nextValue, childName, childDef, this.getExtensionUrl(extension.getUrl()), containedResource, nextChildElem, encodeContext);
                    continue;
                }
                if (nextChild instanceof RuntimeChildNarrativeDefinition && containedResource) continue;
                this.encodeChildElementToStreamWriter(resource, streamRDF, nextChild, nextValue, childName, childDef, extensionUrl, containedResource, nextChildElem, encodeContext);
            }
        }
    }

    private <Q extends IBaseExtension<?, ?>> List<IBaseExtension<?, ?>> toBaseExtensionList(List<Q> theList) {
        ArrayList retVal = new ArrayList(theList.size());
        retVal.addAll(theList);
        return retVal;
    }

    private <T extends IBaseResource> T parseResource(Class<T> resourceType, StreamRDF streamReader) {
        ParserState<T> parserState = ParserState.getPreResourceInstance(this, resourceType, this.context, false, this.getErrorHandler());
        return (T)((IBaseResource)this.doRDFLoop(streamReader, parserState));
    }

    private <T> T doRDFLoop(StreamRDF streamReader, ParserState<T> parserState) {
        logger.trace("Entering RDF parsing loop with state: {}", parserState);
        return parserState.getObject();
    }
}

