/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser.json.jackson;

import ca.uhn.fhir.parser.json.JsonLikeWriter;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.core.util.Separators;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;

public class JacksonWriter
extends JsonLikeWriter {
    private JsonGenerator myJsonGenerator;

    public JacksonWriter(JsonFactory theJsonFactory, Writer theWriter) throws IOException {
        this.myJsonGenerator = theJsonFactory.createGenerator(theWriter);
        this.setWriter(theWriter);
    }

    public JacksonWriter() {
    }

    @Override
    public JsonLikeWriter init() {
        if (this.isPrettyPrint()) {
            DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter(){

                public DefaultPrettyPrinter withSeparators(Separators separators) {
                    this._separators = separators;
                    this._objectFieldValueSeparatorWithSpaces = separators.getObjectFieldValueSeparator() + " ";
                    return this;
                }
            };
            prettyPrinter = prettyPrinter.withObjectIndenter((DefaultPrettyPrinter.Indenter)new DefaultIndenter("  ", "\n"));
            this.myJsonGenerator.setPrettyPrinter((PrettyPrinter)prettyPrinter);
        }
        return this;
    }

    @Override
    public JsonLikeWriter flush() {
        return this;
    }

    @Override
    public void close() throws IOException {
        this.myJsonGenerator.close();
    }

    @Override
    public JsonLikeWriter beginObject() throws IOException {
        this.myJsonGenerator.writeStartObject();
        return this;
    }

    @Override
    public JsonLikeWriter beginObject(String name) throws IOException {
        this.myJsonGenerator.writeObjectFieldStart(name);
        return this;
    }

    @Override
    public JsonLikeWriter beginArray(String name) throws IOException {
        this.myJsonGenerator.writeArrayFieldStart(name);
        return this;
    }

    @Override
    public JsonLikeWriter write(String value) throws IOException {
        this.myJsonGenerator.writeObject((Object)value);
        return this;
    }

    @Override
    public JsonLikeWriter write(BigInteger value) throws IOException {
        this.myJsonGenerator.writeObject((Object)value);
        return this;
    }

    @Override
    public JsonLikeWriter write(BigDecimal value) throws IOException {
        this.myJsonGenerator.writeObject((Object)value);
        return this;
    }

    @Override
    public JsonLikeWriter write(long value) throws IOException {
        this.myJsonGenerator.writeObject((Object)value);
        return this;
    }

    @Override
    public JsonLikeWriter write(double value) throws IOException {
        this.myJsonGenerator.writeObject((Object)value);
        return this;
    }

    @Override
    public JsonLikeWriter write(Boolean value) throws IOException {
        this.myJsonGenerator.writeObject((Object)value);
        return this;
    }

    @Override
    public JsonLikeWriter write(boolean value) throws IOException {
        this.myJsonGenerator.writeObject((Object)value);
        return this;
    }

    @Override
    public JsonLikeWriter writeNull() throws IOException {
        this.myJsonGenerator.writeNull();
        return this;
    }

    @Override
    public JsonLikeWriter write(String name, String value) throws IOException {
        this.myJsonGenerator.writeObjectField(name, (Object)value);
        return this;
    }

    @Override
    public JsonLikeWriter write(String name, BigInteger value) throws IOException {
        this.myJsonGenerator.writeObjectField(name, (Object)value);
        return this;
    }

    @Override
    public JsonLikeWriter write(String name, BigDecimal value) throws IOException {
        this.myJsonGenerator.writeObjectField(name, (Object)value);
        return this;
    }

    @Override
    public JsonLikeWriter write(String name, long value) throws IOException {
        this.myJsonGenerator.writeObjectField(name, (Object)value);
        return this;
    }

    @Override
    public JsonLikeWriter write(String name, double value) throws IOException {
        this.myJsonGenerator.writeObjectField(name, (Object)value);
        return this;
    }

    @Override
    public JsonLikeWriter write(String name, Boolean value) throws IOException {
        this.myJsonGenerator.writeObjectField(name, (Object)value);
        return this;
    }

    @Override
    public JsonLikeWriter write(String name, boolean value) throws IOException {
        this.myJsonGenerator.writeObjectField(name, (Object)value);
        return this;
    }

    @Override
    public JsonLikeWriter endObject() throws IOException {
        this.myJsonGenerator.writeEndObject();
        return this;
    }

    @Override
    public JsonLikeWriter endArray() throws IOException {
        this.myJsonGenerator.writeEndArray();
        return this;
    }

    @Override
    public JsonLikeWriter endBlock() throws IOException {
        this.myJsonGenerator.writeEndObject();
        return this;
    }
}

