/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.api;

import ca.uhn.fhir.util.CoverageIgnore;
import java.util.HashMap;
import java.util.Map;

@CoverageIgnore
public enum RestOperationTypeEnum {
    ADD_TAGS("add-tags"),
    DELETE_TAGS("delete-tags"),
    GET_TAGS("get-tags"),
    GET_PAGE("get-page"),
    GRAPHQL_REQUEST("graphql-request"),
    EXTENDED_OPERATION_SERVER("extended-operation-server"),
    EXTENDED_OPERATION_TYPE("extended-operation-type"),
    EXTENDED_OPERATION_INSTANCE("extended-operation-instance"),
    CREATE("create"),
    DELETE("delete"),
    HISTORY_INSTANCE("history-instance"),
    HISTORY_SYSTEM("history-system"),
    HISTORY_TYPE("history-type"),
    READ("read"),
    SEARCH_SYSTEM("search-system"),
    SEARCH_TYPE("search-type"),
    TRANSACTION("transaction"),
    UPDATE("update"),
    VALIDATE("validate"),
    VREAD("vread"),
    METADATA("metadata"),
    META_ADD("$meta-add"),
    META("$meta"),
    META_DELETE("$meta-delete"),
    PATCH("patch");

    private static Map<String, RestOperationTypeEnum> CODE_TO_ENUM;
    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/type-restful-operation";
    public static final String VALUESET_NAME = "RestfulOperationType";
    private final String myCode;

    private RestOperationTypeEnum(String theCode) {
        this.myCode = theCode;
    }

    public RestOperationTypeEnum forCode(String theCode) {
        RestOperationTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    public String getCode() {
        return this.myCode;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, RestOperationTypeEnum>();
        for (RestOperationTypeEnum next : RestOperationTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
        }
    }
}

