/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.validation;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.util.OperationOutcomeUtil;
import ca.uhn.fhir.validation.ResultSeverityEnum;
import ca.uhn.fhir.validation.SingleValidationMessage;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;

public class ValidationResult {
    public static final int ERROR_DISPLAY_LIMIT_DEFAULT = 1;
    private final FhirContext myCtx;
    private final boolean myIsSuccessful;
    private final List<SingleValidationMessage> myMessages;
    private int myErrorDisplayLimit = 1;
    private static final String ourNewLine = System.getProperty("line.separator");

    public ValidationResult(FhirContext theCtx, List<SingleValidationMessage> theMessages) {
        boolean successful = true;
        this.myCtx = theCtx;
        this.myMessages = theMessages;
        for (SingleValidationMessage next : this.myMessages) {
            if (next.getSeverity() != null && next.getSeverity().ordinal() <= ResultSeverityEnum.WARNING.ordinal()) continue;
            successful = false;
            break;
        }
        this.myIsSuccessful = successful;
    }

    public List<SingleValidationMessage> getMessages() {
        return Collections.unmodifiableList(this.myMessages);
    }

    public boolean isSuccessful() {
        return this.myIsSuccessful;
    }

    private String toDescription() {
        if (this.myMessages.isEmpty()) {
            return "No issues";
        }
        StringBuilder b = new StringBuilder(100 * this.myMessages.size());
        int shownMsgQty = Math.min(this.myErrorDisplayLimit, this.myMessages.size());
        if (shownMsgQty < this.myMessages.size()) {
            b.append("(showing first ").append(shownMsgQty).append(" messages out of ").append(this.myMessages.size()).append(" total)").append(ourNewLine);
        }
        for (int i = 0; i < shownMsgQty; ++i) {
            SingleValidationMessage nextMsg = this.myMessages.get(i);
            b.append(ourNewLine);
            if (nextMsg.getSeverity() != null) {
                b.append(nextMsg.getSeverity().name());
                b.append(" - ");
            }
            b.append(nextMsg.getMessage());
            b.append(" - ");
            b.append(nextMsg.getLocationString());
        }
        return b.toString();
    }

    @Deprecated
    public IBaseOperationOutcome getOperationOutcome() {
        return this.toOperationOutcome();
    }

    public IBaseOperationOutcome toOperationOutcome() {
        IBaseOperationOutcome oo = (IBaseOperationOutcome)this.myCtx.getResourceDefinition("OperationOutcome").newInstance();
        this.populateOperationOutcome(oo);
        return oo;
    }

    public void populateOperationOutcome(IBaseOperationOutcome theOperationOutcome) {
        for (SingleValidationMessage next : this.myMessages) {
            String unknown;
            String location = StringUtils.isNotBlank((CharSequence)next.getLocationString()) ? next.getLocationString() : (next.getLocationLine() != null || next.getLocationCol() != null ? "Line[" + next.getLocationLine() + "] Col[" + next.getLocationCol() + "]" : null);
            String severity = next.getSeverity() != null ? next.getSeverity().getCode() : null;
            IBase issue = OperationOutcomeUtil.addIssue(this.myCtx, theOperationOutcome, severity, next.getMessage(), location, "processing");
            if (next.getLocationLine() == null && next.getLocationCol() == null) continue;
            String line = unknown = "(unknown)";
            if (next.getLocationLine() != null && next.getLocationLine() != -1) {
                line = next.getLocationLine().toString();
            }
            String col = unknown;
            if (next.getLocationCol() != null && next.getLocationCol() != -1) {
                col = next.getLocationCol().toString();
            }
            if (unknown.equals(line) && unknown.equals(col)) continue;
            OperationOutcomeUtil.addLocationToIssue(this.myCtx, issue, "Line " + line + ", Col " + col);
        }
        if (this.myMessages.isEmpty()) {
            String message = this.myCtx.getLocalizer().getMessage(ValidationResult.class, "noIssuesDetected", new Object[0]);
            OperationOutcomeUtil.addIssue(this.myCtx, theOperationOutcome, "information", message, null, "informational");
        }
    }

    public String toString() {
        return "ValidationResult{messageCount=" + this.myMessages.size() + ", isSuccessful=" + this.myIsSuccessful + ", description='" + this.toDescription() + '\'' + '}';
    }

    public FhirContext getContext() {
        return this.myCtx;
    }

    public int getErrorDisplayLimit() {
        return this.myErrorDisplayLimit;
    }

    public void setErrorDisplayLimit(int theErrorDisplayLimit) {
        this.myErrorDisplayLimit = theErrorDisplayLimit;
    }
}

