/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.ComboSearchParamType;
import ca.uhn.fhir.context.phonetic.IPhoneticEncoder;
import ca.uhn.fhir.rest.api.RestSearchParameterTypeEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IIdType;

public class RuntimeSearchParam {
    private final IIdType myId;
    private final Set<String> myBase;
    private final String myDescription;
    private final String myName;
    private final RestSearchParameterTypeEnum myParamType;
    private final String myPath;
    private final Set<String> myTargets;
    private final Set<String> myProvidesMembershipInCompartments;
    private final RuntimeSearchParamStatusEnum myStatus;
    private final String myUri;
    private final Map<String, List<IBaseExtension<?, ?>>> myExtensions = new HashMap();
    private final ComboSearchParamType myComboSearchParamType;
    private final List<Component> myComponents;
    private IPhoneticEncoder myPhoneticEncoder;

    public RuntimeSearchParam(IIdType theId, String theUri, String theName, String theDescription, String thePath, RestSearchParameterTypeEnum theParamType, Set<String> theProvidesMembershipInCompartments, Set<String> theTargets, RuntimeSearchParamStatusEnum theStatus, Collection<String> theBase) {
        this(theId, theUri, theName, theDescription, thePath, theParamType, theProvidesMembershipInCompartments, theTargets, theStatus, null, Collections.emptyList(), theBase);
    }

    public RuntimeSearchParam(RuntimeSearchParam theSp) {
        this(theSp.getId(), theSp.getUri(), theSp.getName(), theSp.getDescription(), theSp.getPath(), theSp.getParamType(), theSp.getProvidesMembershipInCompartments(), theSp.getTargets(), theSp.getStatus(), theSp.getComboSearchParamType(), theSp.getComponents(), theSp.getBase());
    }

    public RuntimeSearchParam(IIdType theId, String theUri, String theName, String theDescription, String thePath, RestSearchParameterTypeEnum theParamType, Set<String> theProvidesMembershipInCompartments, Set<String> theTargets, RuntimeSearchParamStatusEnum theStatus, ComboSearchParamType theComboSearchParamType, List<Component> theComponents, Collection<String> theBase) {
        this.myId = theId;
        this.myUri = theUri;
        this.myName = theName;
        this.myDescription = theDescription;
        this.myPath = thePath;
        this.myParamType = theParamType;
        this.myStatus = theStatus;
        this.myProvidesMembershipInCompartments = theProvidesMembershipInCompartments != null && !theProvidesMembershipInCompartments.isEmpty() ? Collections.unmodifiableSet(theProvidesMembershipInCompartments) : null;
        this.myTargets = theTargets != null && !theTargets.isEmpty() ? Collections.unmodifiableSet(theTargets) : Collections.emptySet();
        if (theBase == null || theBase.isEmpty()) {
            int indexOf;
            HashSet<String> base = new HashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)thePath) && (indexOf = thePath.indexOf(46)) != -1) {
                base.add(StringUtils.trim((String)thePath.substring(0, indexOf)));
            }
            this.myBase = Collections.unmodifiableSet(base);
        } else {
            this.myBase = Collections.unmodifiableSet(new HashSet<String>(theBase));
        }
        this.myComboSearchParamType = theComboSearchParamType;
        this.myComponents = theComponents != null ? Collections.unmodifiableList(theComponents) : Collections.emptyList();
    }

    public List<Component> getComponents() {
        return this.myComponents;
    }

    @Nullable
    public ComboSearchParamType getComboSearchParamType() {
        return this.myComboSearchParamType;
    }

    @Nonnull
    public List<IBaseExtension<?, ?>> getExtensions(String theKey) {
        List<IBaseExtension<Object, Object>> retVal = this.myExtensions.get(theKey);
        retVal = retVal != null ? Collections.unmodifiableList(retVal) : Collections.emptyList();
        return retVal;
    }

    public RuntimeSearchParam addExtension(String theKey, IBaseExtension theValue) {
        List valuesList = this.myExtensions.computeIfAbsent(theKey, k -> new ArrayList());
        valuesList.add(theValue);
        return this;
    }

    public String toString() {
        return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("base", this.myBase).append("name", (Object)this.myName).append("path", (Object)this.myPath).append("id", (Object)this.myId).append("uri", (Object)this.myUri).toString();
    }

    public IIdType getId() {
        return this.myId;
    }

    public String getUri() {
        return this.myUri;
    }

    public boolean equals(Object theO) {
        if (this == theO) {
            return true;
        }
        if (theO == null || this.getClass() != theO.getClass()) {
            return false;
        }
        RuntimeSearchParam that = (RuntimeSearchParam)theO;
        return new EqualsBuilder().append((Object)this.getId(), (Object)that.getId()).append((Object)this.getName(), (Object)that.getName()).append((Object)this.getPath(), (Object)that.getPath()).append((Object)this.getUri(), (Object)that.getUri()).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append((Object)this.getId()).append((Object)this.getName()).append((Object)this.getPath()).append((Object)this.getUri()).toHashCode();
    }

    public Set<String> getBase() {
        return this.myBase;
    }

    @Nonnull
    public Set<String> getTargets() {
        return this.myTargets;
    }

    public boolean hasTargets() {
        return !this.myTargets.isEmpty();
    }

    public RuntimeSearchParamStatusEnum getStatus() {
        return this.myStatus;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public String getName() {
        return this.myName;
    }

    public RestSearchParameterTypeEnum getParamType() {
        return this.myParamType;
    }

    public String getPath() {
        return this.myPath;
    }

    public List<String> getPathsSplit() {
        return this.getPathsSplitForResourceType(null);
    }

    public Set<String> getProvidesMembershipInCompartments() {
        return this.myProvidesMembershipInCompartments;
    }

    public RuntimeSearchParam setPhoneticEncoder(IPhoneticEncoder thePhoneticEncoder) {
        this.myPhoneticEncoder = thePhoneticEncoder;
        return this;
    }

    public String encode(String theString) {
        if (this.myPhoneticEncoder == null || theString == null) {
            return theString;
        }
        return this.myPhoneticEncoder.encode(theString);
    }

    public List<String> getPathsSplitForResourceType(@Nullable String theResourceName) {
        String path = this.getPath();
        if (path.indexOf(124) == -1) {
            if (theResourceName != null && !RuntimeSearchParam.pathMatchesResourceType(theResourceName, path)) {
                return Collections.emptyList();
            }
            return Collections.singletonList(path);
        }
        ArrayList<String> retVal = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(path, "|");
        while (tok.hasMoreElements()) {
            String nextPath = tok.nextToken().trim();
            if (theResourceName != null && !RuntimeSearchParam.pathMatchesResourceType(theResourceName, nextPath)) continue;
            retVal.add(nextPath.trim());
        }
        return retVal;
    }

    static boolean pathMatchesResourceType(String theResourceName, String thePath) {
        for (int i = 0; i < thePath.length() - 1; ++i) {
            char nextChar = thePath.charAt(i);
            if (Character.isLowerCase(nextChar)) {
                return true;
            }
            if (!Character.isLetter(nextChar)) continue;
            if (RuntimeSearchParam.fhirPathExpressionStartsWith(theResourceName, thePath, i)) {
                return true;
            }
            if (RuntimeSearchParam.fhirPathExpressionStartsWith("Resource", thePath, i)) {
                return true;
            }
            return RuntimeSearchParam.fhirPathExpressionStartsWith("DomainResource", thePath, i);
        }
        return false;
    }

    private static boolean fhirPathExpressionStartsWith(String theResourceName, String thePath, int theStartingIndex) {
        if (thePath.startsWith(theResourceName, theStartingIndex) && thePath.length() > theResourceName.length()) {
            for (int i = theResourceName.length() + theStartingIndex; i < thePath.length(); ++i) {
                char nextChar = thePath.charAt(i);
                if (nextChar == '.') {
                    return true;
                }
                if (nextChar == ' ') continue;
                return false;
            }
        }
        return false;
    }

    public static enum RuntimeSearchParamStatusEnum {
        ACTIVE,
        DRAFT,
        RETIRED,
        UNKNOWN;

    }

    public static class Component {
        private final String myExpression;
        private final String myReference;

        public Component(String theExpression, String theReference) {
            this.myExpression = theExpression;
            this.myReference = theReference;
        }

        public String toString() {
            return new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE).append("expression", (Object)this.myExpression).append("reference", (Object)this.myReference).toString();
        }

        public String getExpression() {
            return this.myExpression;
        }

        public String getReference() {
            return this.myReference;
        }
    }
}

