/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.IFhirValidatorFactory;
import ca.uhn.fhir.context.ModelScanner;
import ca.uhn.fhir.context.ParserOptions;
import ca.uhn.fhir.context.PerformanceOptionsEnum;
import ca.uhn.fhir.context.RuntimeChildUndeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.context.api.AddProfileTagEnum;
import ca.uhn.fhir.context.support.DefaultProfileValidationSupport;
import ca.uhn.fhir.context.support.IValidationSupport;
import ca.uhn.fhir.fhirpath.IFhirPath;
import ca.uhn.fhir.i18n.HapiLocalizer;
import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IFhirVersion;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.view.ViewGenerator;
import ca.uhn.fhir.narrative.INarrativeGenerator;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.JsonParser;
import ca.uhn.fhir.parser.LenientErrorHandler;
import ca.uhn.fhir.parser.NDJsonParser;
import ca.uhn.fhir.parser.RDFParser;
import ca.uhn.fhir.parser.XmlParser;
import ca.uhn.fhir.rest.api.IVersionSpecificBundleFactory;
import ca.uhn.fhir.rest.client.api.IGenericClient;
import ca.uhn.fhir.rest.client.api.IRestfulClient;
import ca.uhn.fhir.rest.client.api.IRestfulClientFactory;
import ca.uhn.fhir.system.HapiSystemProperties;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.ReflectionUtil;
import ca.uhn.fhir.util.VersionUtil;
import ca.uhn.fhir.validation.FhirValidator;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.jena.riot.Lang;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirContext {
    private static final List<Class<? extends IBaseResource>> EMPTY_LIST = Collections.emptyList();
    private static final Map<FhirVersionEnum, FhirContext> ourStaticContexts = Collections.synchronizedMap(new EnumMap(FhirVersionEnum.class));
    private static final Logger ourLog = LoggerFactory.getLogger(FhirContext.class);
    private final IFhirVersion myVersion;
    private final Map<String, Class<? extends IBaseResource>> myDefaultTypeForProfile = new HashMap<String, Class<? extends IBaseResource>>();
    private final Set<PerformanceOptionsEnum> myPerformanceOptions = new HashSet<PerformanceOptionsEnum>();
    private final Collection<Class<? extends IBaseResource>> myResourceTypesToScan;
    private AddProfileTagEnum myAddProfileTagWhenEncoding = AddProfileTagEnum.ONLY_FOR_CUSTOM;
    private volatile Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> myClassToElementDefinition = Collections.emptyMap();
    private ArrayList<Class<? extends IBase>> myCustomTypes;
    private volatile Map<String, RuntimeResourceDefinition> myIdToResourceDefinition = Collections.emptyMap();
    private volatile boolean myInitialized;
    private volatile boolean myInitializing = false;
    private HapiLocalizer myLocalizer = new HapiLocalizer();
    private volatile Map<String, BaseRuntimeElementDefinition<?>> myNameToElementDefinition = Collections.emptyMap();
    private volatile Map<String, RuntimeResourceDefinition> myNameToResourceDefinition = Collections.emptyMap();
    private volatile Map<String, Class<? extends IBaseResource>> myNameToResourceType;
    private volatile INarrativeGenerator myNarrativeGenerator;
    private volatile IParserErrorHandler myParserErrorHandler = new LenientErrorHandler();
    private ParserOptions myParserOptions = new ParserOptions();
    private volatile IRestfulClientFactory myRestfulClientFactory;
    private volatile RuntimeChildUndeclaredExtensionDefinition myRuntimeChildUndeclaredExtensionDefinition;
    private IValidationSupport myValidationSupport;
    private Map<FhirVersionEnum, Map<String, Class<? extends IBaseResource>>> myVersionToNameToResourceType = Collections.emptyMap();
    private volatile Set<String> myResourceNames;
    private volatile Boolean myFormatXmlSupported;
    private volatile Boolean myFormatJsonSupported;
    private volatile Boolean myFormatNDJsonSupported;
    private volatile Boolean myFormatRdfSupported;
    private IFhirValidatorFactory myFhirValidatorFactory = FhirValidator::new;

    @Deprecated
    public FhirContext() {
        this(EMPTY_LIST);
    }

    @Deprecated
    public FhirContext(Class<? extends IBaseResource> theResourceType) {
        this(FhirContext.toCollection(theResourceType));
    }

    @Deprecated
    public FhirContext(Class<?> ... theResourceTypes) {
        this(FhirContext.toCollection(theResourceTypes));
    }

    @Deprecated
    public FhirContext(Collection<Class<? extends IBaseResource>> theResourceTypes) {
        this(null, theResourceTypes);
    }

    public FhirContext(FhirVersionEnum theVersion) {
        this(theVersion, null);
    }

    private FhirContext(FhirVersionEnum theVersion, Collection<Class<? extends IBaseResource>> theResourceTypes) {
        VersionUtil.getVersion();
        if (theVersion != null) {
            if (!theVersion.isPresentOnClasspath()) {
                throw new IllegalStateException(Msg.code(1680) + this.getLocalizer().getMessage(FhirContext.class, "noStructuresForSpecifiedVersion", theVersion.name()));
            }
            this.myVersion = theVersion.getVersionImplementation();
        } else if (FhirVersionEnum.DSTU2.isPresentOnClasspath()) {
            this.myVersion = FhirVersionEnum.DSTU2.getVersionImplementation();
        } else if (FhirVersionEnum.DSTU2_HL7ORG.isPresentOnClasspath()) {
            this.myVersion = FhirVersionEnum.DSTU2_HL7ORG.getVersionImplementation();
        } else if (FhirVersionEnum.DSTU2_1.isPresentOnClasspath()) {
            this.myVersion = FhirVersionEnum.DSTU2_1.getVersionImplementation();
        } else if (FhirVersionEnum.DSTU3.isPresentOnClasspath()) {
            this.myVersion = FhirVersionEnum.DSTU3.getVersionImplementation();
        } else if (FhirVersionEnum.R4.isPresentOnClasspath()) {
            this.myVersion = FhirVersionEnum.R4.getVersionImplementation();
        } else if (FhirVersionEnum.R4B.isPresentOnClasspath()) {
            this.myVersion = FhirVersionEnum.R4B.getVersionImplementation();
        } else {
            throw new IllegalStateException(Msg.code(1681) + this.getLocalizer().getMessage(FhirContext.class, "noStructures", new Object[0]));
        }
        if (theVersion == null) {
            ourLog.info("Creating new FhirContext with auto-detected version [{}]. It is recommended to explicitly select a version for future compatibility by invoking FhirContext.forDstuX()", (Object)this.myVersion.getVersion().name());
        } else if (HapiSystemProperties.isUnitTestModeEnabled()) {
            String calledAt = ExceptionUtils.getStackFrames((Throwable)new Throwable())[4];
            ourLog.info("Creating new FHIR context for FHIR version [{}]{}", (Object)this.myVersion.getVersion().name(), (Object)calledAt);
        } else {
            ourLog.info("Creating new FHIR context for FHIR version [{}]", (Object)this.myVersion.getVersion().name());
        }
        this.myResourceTypesToScan = theResourceTypes;
        try {
            Class<?> clazz = Class.forName("ca.uhn.fhir.android.AndroidMarker");
            ourLog.info("Android mode detected, configuring FhirContext for Android operation");
            try {
                Method method = clazz.getMethod("configureContext", FhirContext.class);
                method.invoke(null, this);
            }
            catch (Throwable e) {
                ourLog.warn("Failed to configure context for Android operation", e);
            }
        }
        catch (ClassNotFoundException e) {
            ourLog.trace("Android mode not detected");
        }
    }

    public static FhirContext forDstu2Cached() {
        return FhirContext.forCached(FhirVersionEnum.DSTU2);
    }

    public static FhirContext forDstu2Hl7OrgCached() {
        return FhirContext.forCached(FhirVersionEnum.DSTU2_HL7ORG);
    }

    public static FhirContext forDstu3Cached() {
        return FhirContext.forCached(FhirVersionEnum.DSTU3);
    }

    public static FhirContext forR4Cached() {
        return FhirContext.forCached(FhirVersionEnum.R4);
    }

    public static FhirContext forR4BCached() {
        return FhirContext.forCached(FhirVersionEnum.R4B);
    }

    public static FhirContext forR5Cached() {
        return FhirContext.forCached(FhirVersionEnum.R5);
    }

    private String createUnknownResourceNameError(String theResourceName, FhirVersionEnum theVersion) {
        return this.getLocalizer().getMessage(FhirContext.class, "unknownResourceName", new Object[]{theResourceName, theVersion});
    }

    private void ensureCustomTypeList() {
        this.myClassToElementDefinition.clear();
        if (this.myCustomTypes == null) {
            this.myCustomTypes = new ArrayList();
        }
    }

    public AddProfileTagEnum getAddProfileTagWhenEncoding() {
        return this.myAddProfileTagWhenEncoding;
    }

    public void setAddProfileTagWhenEncoding(AddProfileTagEnum theAddProfileTagWhenEncoding) {
        Validate.notNull((Object)((Object)theAddProfileTagWhenEncoding), (String)"theAddProfileTagWhenEncoding must not be null", (Object[])new Object[0]);
        this.myAddProfileTagWhenEncoding = theAddProfileTagWhenEncoding;
    }

    Collection<RuntimeResourceDefinition> getAllResourceDefinitions() {
        this.validateInitialized();
        return this.myNameToResourceDefinition.values();
    }

    public Class<? extends IBaseResource> getDefaultTypeForProfile(String theProfile) {
        this.validateInitialized();
        return this.myDefaultTypeForProfile.get(theProfile);
    }

    public BaseRuntimeElementDefinition<?> getElementDefinition(Class<? extends IBase> theElementType) {
        this.validateInitialized();
        BaseRuntimeElementDefinition<?> retVal = this.myClassToElementDefinition.get(theElementType);
        if (retVal == null) {
            retVal = this.scanDatatype(theElementType);
        }
        return retVal;
    }

    @Nullable
    public BaseRuntimeElementDefinition<?> getElementDefinition(String theElementName) {
        this.validateInitialized();
        return this.myNameToElementDefinition.get(theElementName.toLowerCase());
    }

    public Collection<BaseRuntimeElementDefinition<?>> getElementDefinitions() {
        this.validateInitialized();
        return Collections.unmodifiableCollection(this.myClassToElementDefinition.values());
    }

    public HapiLocalizer getLocalizer() {
        if (this.myLocalizer == null) {
            this.myLocalizer = new HapiLocalizer();
        }
        return this.myLocalizer;
    }

    public void setLocalizer(HapiLocalizer theMessages) {
        this.myLocalizer = theMessages;
    }

    public INarrativeGenerator getNarrativeGenerator() {
        return this.myNarrativeGenerator;
    }

    public FhirContext setNarrativeGenerator(INarrativeGenerator theNarrativeGenerator) {
        this.myNarrativeGenerator = theNarrativeGenerator;
        return this;
    }

    public ParserOptions getParserOptions() {
        return this.myParserOptions;
    }

    public void setParserOptions(ParserOptions theParserOptions) {
        Validate.notNull((Object)theParserOptions, (String)"theParserOptions must not be null", (Object[])new Object[0]);
        this.myParserOptions = theParserOptions;
    }

    public Set<PerformanceOptionsEnum> getPerformanceOptions() {
        return this.myPerformanceOptions;
    }

    public void setPerformanceOptions(Collection<PerformanceOptionsEnum> theOptions) {
        this.myPerformanceOptions.clear();
        if (theOptions != null) {
            this.myPerformanceOptions.addAll(theOptions);
        }
    }

    public void setPerformanceOptions(PerformanceOptionsEnum ... thePerformanceOptions) {
        List<PerformanceOptionsEnum> asList = null;
        if (thePerformanceOptions != null) {
            asList = Arrays.asList(thePerformanceOptions);
        }
        this.setPerformanceOptions(asList);
    }

    public RuntimeResourceDefinition getResourceDefinition(Class<? extends IBaseResource> theResourceType) {
        this.validateInitialized();
        Validate.notNull(theResourceType, (String)"theResourceType can not be null", (Object[])new Object[0]);
        if (Modifier.isAbstract(theResourceType.getModifiers())) {
            throw new IllegalArgumentException(Msg.code(1682) + "Can not scan abstract or interface class (resource definitions must be concrete classes): " + theResourceType.getName());
        }
        RuntimeResourceDefinition retVal = (RuntimeResourceDefinition)this.myClassToElementDefinition.get(theResourceType);
        if (retVal == null) {
            retVal = this.scanResourceType(theResourceType);
        }
        return retVal;
    }

    public RuntimeResourceDefinition getResourceDefinition(FhirVersionEnum theVersion, String theResourceName) {
        Class<? extends IBaseResource> resourceType;
        Validate.notNull((Object)((Object)theVersion), (String)"theVersion can not be null", (Object[])new Object[0]);
        this.validateInitialized();
        if (theVersion.equals((Object)this.myVersion.getVersion())) {
            return this.getResourceDefinition(theResourceName);
        }
        Map<String, Class<? extends IBaseResource>> nameToType = this.myVersionToNameToResourceType.get((Object)theVersion);
        if (nameToType == null) {
            nameToType = new HashMap<String, Class<? extends IBaseResource>>();
            HashMap existing = new HashMap();
            ModelScanner.scanVersionPropertyFile(null, nameToType, theVersion, existing);
            HashMap<FhirVersionEnum, Map<String, Class<? extends IBaseResource>>> newVersionToNameToResourceType = new HashMap<FhirVersionEnum, Map<String, Class<? extends IBaseResource>>>();
            newVersionToNameToResourceType.putAll(this.myVersionToNameToResourceType);
            newVersionToNameToResourceType.put(theVersion, nameToType);
            this.myVersionToNameToResourceType = newVersionToNameToResourceType;
        }
        if ((resourceType = nameToType.get(theResourceName.toLowerCase())) == null) {
            throw new DataFormatException(Msg.code(1683) + this.createUnknownResourceNameError(theResourceName, theVersion));
        }
        return this.getResourceDefinition(resourceType);
    }

    public RuntimeResourceDefinition getResourceDefinition(IBaseResource theResource) {
        this.validateInitialized();
        Validate.notNull((Object)theResource, (String)"theResource must not be null", (Object[])new Object[0]);
        return this.getResourceDefinition(theResource.getClass());
    }

    public String getResourceType(Class<? extends IBaseResource> theResourceType) {
        return this.getResourceDefinition(theResourceType).getName();
    }

    public String getResourceType(IBaseResource theResource) {
        return this.getResourceDefinition(theResource).getName();
    }

    public String getResourceType(String theResourceName) throws DataFormatException {
        return this.getResourceDefinition(theResourceName).getName();
    }

    public RuntimeResourceDefinition getResourceDefinition(String theResourceName) throws DataFormatException {
        this.validateInitialized();
        Validate.notBlank((CharSequence)theResourceName, (String)"theResourceName must not be blank", (Object[])new Object[0]);
        String resourceName = theResourceName.toLowerCase();
        RuntimeResourceDefinition retVal = this.myNameToResourceDefinition.get(resourceName);
        if (retVal == null) {
            Class<? extends IBaseResource> clazz = this.myNameToResourceType.get(resourceName.toLowerCase());
            if (clazz == null) {
                throw new DataFormatException(Msg.code(1684) + this.createUnknownResourceNameError(theResourceName, this.myVersion.getVersion()));
            }
            if (IBaseResource.class.isAssignableFrom(clazz)) {
                retVal = this.scanResourceType(clazz);
            }
        }
        return retVal;
    }

    public RuntimeResourceDefinition getResourceDefinitionById(String theId) {
        this.validateInitialized();
        return this.myIdToResourceDefinition.get(theId);
    }

    public Collection<RuntimeResourceDefinition> getResourceDefinitionsWithExplicitId() {
        this.validateInitialized();
        return this.myIdToResourceDefinition.values();
    }

    public Set<String> getResourceTypes() {
        Set<String> resourceNames = this.myResourceNames;
        if (resourceNames == null) {
            this.myResourceNames = resourceNames = this.buildResourceNames();
        }
        return resourceNames;
    }

    @Nonnull
    private Set<String> buildResourceNames() {
        HashSet<String> retVal = new HashSet<String>();
        Properties props = new Properties();
        try (InputStream propFile = this.myVersion.getFhirVersionPropertiesFile();){
            props.load(propFile);
        }
        catch (IOException e) {
            throw new ConfigurationException(Msg.code(1685) + "Failed to load version properties file", e);
        }
        Enumeration<?> propNames = props.propertyNames();
        while (propNames.hasMoreElements()) {
            String next = (String)propNames.nextElement();
            if (!next.startsWith("resource.")) continue;
            retVal.add(next.substring("resource.".length()).trim());
        }
        return retVal;
    }

    public IRestfulClientFactory getRestfulClientFactory() {
        if (this.myRestfulClientFactory == null) {
            try {
                this.myRestfulClientFactory = (IRestfulClientFactory)ReflectionUtil.newInstance(Class.forName("ca.uhn.fhir.rest.client.apache.ApacheRestfulClientFactory"), FhirContext.class, this);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException(Msg.code(1686) + "hapi-fhir-client does not appear to be on the classpath");
            }
        }
        return this.myRestfulClientFactory;
    }

    public void setRestfulClientFactory(IRestfulClientFactory theRestfulClientFactory) {
        Validate.notNull((Object)theRestfulClientFactory, (String)"theRestfulClientFactory must not be null", (Object[])new Object[0]);
        this.myRestfulClientFactory = theRestfulClientFactory;
    }

    public RuntimeChildUndeclaredExtensionDefinition getRuntimeChildUndeclaredExtensionDefinition() {
        this.validateInitialized();
        return this.myRuntimeChildUndeclaredExtensionDefinition;
    }

    public IValidationSupport getValidationSupport() {
        IValidationSupport retVal = this.myValidationSupport;
        if (retVal == null) {
            retVal = new DefaultProfileValidationSupport(this);
            String inMemoryTermSvcType = "org.hl7.fhir.common.hapi.validation.support.InMemoryTerminologyServerValidationSupport";
            String commonCodeSystemsSupportType = "org.hl7.fhir.common.hapi.validation.support.CommonCodeSystemsTerminologyService";
            if (ReflectionUtil.typeExists(inMemoryTermSvcType)) {
                IValidationSupport inMemoryTermSvc = ReflectionUtil.newInstanceOrReturnNull(inMemoryTermSvcType, IValidationSupport.class, new Class[]{FhirContext.class}, new Object[]{this});
                IValidationSupport commonCodeSystemsSupport = ReflectionUtil.newInstanceOrReturnNull(commonCodeSystemsSupportType, IValidationSupport.class, new Class[]{FhirContext.class}, new Object[]{this});
                retVal = ReflectionUtil.newInstanceOrReturnNull("org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain", IValidationSupport.class, new Class[]{IValidationSupport[].class}, new Object[]{new IValidationSupport[]{retVal, inMemoryTermSvc, commonCodeSystemsSupport}});
                assert (retVal != null) : "Failed to instantiate org.hl7.fhir.common.hapi.validation.support.ValidationSupportChain";
            }
            this.myValidationSupport = retVal;
        }
        return retVal;
    }

    public void setValidationSupport(IValidationSupport theValidationSupport) {
        this.myValidationSupport = theValidationSupport;
    }

    public IFhirVersion getVersion() {
        return this.myVersion;
    }

    public boolean hasDefaultTypeForProfile() {
        this.validateInitialized();
        return !this.myDefaultTypeForProfile.isEmpty();
    }

    public boolean isFormatXmlSupported() {
        Boolean retVal = this.myFormatXmlSupported;
        if (retVal == null) {
            this.myFormatXmlSupported = retVal = Boolean.valueOf(FhirContext.tryToInitParser(() -> this.newXmlParser()));
        }
        return retVal;
    }

    public boolean isFormatJsonSupported() {
        Boolean retVal = this.myFormatJsonSupported;
        if (retVal == null) {
            this.myFormatJsonSupported = retVal = Boolean.valueOf(FhirContext.tryToInitParser(() -> this.newJsonParser()));
        }
        return retVal;
    }

    public boolean isFormatNDJsonSupported() {
        Boolean retVal = this.myFormatNDJsonSupported;
        if (retVal == null) {
            this.myFormatNDJsonSupported = retVal = Boolean.valueOf(FhirContext.tryToInitParser(() -> this.newNDJsonParser()));
        }
        return retVal;
    }

    public boolean isFormatRdfSupported() {
        Boolean retVal = this.myFormatRdfSupported;
        if (retVal == null) {
            this.myFormatRdfSupported = retVal = Boolean.valueOf(FhirContext.tryToInitParser(() -> this.newRDFParser()));
        }
        return retVal;
    }

    public IVersionSpecificBundleFactory newBundleFactory() {
        return this.myVersion.newBundleFactory(this);
    }

    @Deprecated
    public IFhirPath newFluentPath() {
        return this.newFhirPath();
    }

    public IFhirPath newFhirPath() {
        return this.myVersion.createFhirPathExecutor(this);
    }

    public IParser newJsonParser() {
        return new JsonParser(this, this.myParserErrorHandler);
    }

    public IParser newNDJsonParser() {
        return new NDJsonParser(this, this.myParserErrorHandler);
    }

    public IParser newRDFParser() {
        return new RDFParser(this, this.myParserErrorHandler, Lang.TURTLE);
    }

    public <T extends IRestfulClient> T newRestfulClient(Class<T> theClientType, String theServerBase) {
        return this.getRestfulClientFactory().newClient(theClientType, theServerBase);
    }

    public IGenericClient newRestfulGenericClient(String theServerBase) {
        return this.getRestfulClientFactory().newGenericClient(theServerBase);
    }

    public FhirTerser newTerser() {
        return new FhirTerser(this);
    }

    public FhirValidator newValidator() {
        return this.myFhirValidatorFactory.newFhirValidator(this);
    }

    public ViewGenerator newViewGenerator() {
        return new ViewGenerator(this);
    }

    public IParser newXmlParser() {
        return new XmlParser(this, this.myParserErrorHandler);
    }

    public void registerCustomType(Class<? extends IBase> theType) {
        Validate.notNull(theType, (String)"theType must not be null", (Object[])new Object[0]);
        this.ensureCustomTypeList();
        this.myCustomTypes.add(theType);
    }

    public void registerCustomTypes(Collection<Class<? extends IBase>> theTypes) {
        Validate.notNull(theTypes, (String)"theTypes must not be null", (Object[])new Object[0]);
        Validate.noNullElements((Object[])theTypes.toArray(), (String)"theTypes must not contain any null elements", (Object[])new Object[0]);
        this.ensureCustomTypeList();
        this.myCustomTypes.addAll(theTypes);
    }

    private BaseRuntimeElementDefinition<?> scanDatatype(Class<? extends IElement> theResourceType) {
        ArrayList<Class<? extends IElement>> resourceTypes = new ArrayList<Class<? extends IElement>>();
        resourceTypes.add(theResourceType);
        Map<Class<IBase>, BaseRuntimeElementDefinition<?>> defs = this.scanResourceTypes(resourceTypes);
        return defs.get(theResourceType);
    }

    private RuntimeResourceDefinition scanResourceType(Class<? extends IBaseResource> theResourceType) {
        ArrayList<Class<? extends IElement>> resourceTypes = new ArrayList<Class<? extends IElement>>();
        resourceTypes.add(theResourceType);
        Map<Class<IBase>, BaseRuntimeElementDefinition<?>> defs = this.scanResourceTypes(resourceTypes);
        return (RuntimeResourceDefinition)defs.get(theResourceType);
    }

    private synchronized Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> scanResourceTypes(Collection<Class<? extends IElement>> theResourceTypes) {
        ArrayList<Class<? extends IBase>> typesToScan = new ArrayList<Class<? extends IBase>>();
        if (theResourceTypes != null) {
            typesToScan.addAll(theResourceTypes);
        }
        if (this.myCustomTypes != null) {
            typesToScan.addAll(this.myCustomTypes);
            this.myCustomTypes = null;
        }
        ModelScanner scanner = new ModelScanner(this, this.myVersion.getVersion(), this.myClassToElementDefinition, typesToScan);
        if (this.myRuntimeChildUndeclaredExtensionDefinition == null) {
            this.myRuntimeChildUndeclaredExtensionDefinition = scanner.getRuntimeChildUndeclaredExtensionDefinition();
        }
        HashMap nameToElementDefinition = new HashMap();
        nameToElementDefinition.putAll(this.myNameToElementDefinition);
        for (Map.Entry<String, BaseRuntimeElementDefinition<?>> next : scanner.getNameToElementDefinitions().entrySet()) {
            if (nameToElementDefinition.containsKey(next.getKey())) continue;
            nameToElementDefinition.put(next.getKey().toLowerCase(), (BaseRuntimeElementDefinition)next.getValue());
        }
        HashMap<String, RuntimeResourceDefinition> nameToResourceDefinition = new HashMap<String, RuntimeResourceDefinition>();
        nameToResourceDefinition.putAll(this.myNameToResourceDefinition);
        for (Map.Entry entry : scanner.getNameToResourceDefinition().entrySet()) {
            if (nameToResourceDefinition.containsKey(entry.getKey())) continue;
            nameToResourceDefinition.put((String)entry.getKey(), (RuntimeResourceDefinition)entry.getValue());
        }
        HashMap classToElementDefinition = new HashMap();
        classToElementDefinition.putAll(this.myClassToElementDefinition);
        classToElementDefinition.putAll(scanner.getClassToElementDefinitions());
        for (BaseRuntimeElementDefinition next : classToElementDefinition.values()) {
            if (!(next instanceof RuntimeResourceDefinition) || !"Bundle".equals(next.getName()) || IBaseBundle.class.isAssignableFrom(next.getImplementingClass())) continue;
            throw new ConfigurationException(Msg.code(1687) + "Resource type declares resource name Bundle but does not implement IBaseBundle");
        }
        HashMap<String, RuntimeResourceDefinition> hashMap = new HashMap<String, RuntimeResourceDefinition>();
        hashMap.putAll(this.myIdToResourceDefinition);
        hashMap.putAll(scanner.getIdToResourceDefinition());
        this.myNameToElementDefinition = nameToElementDefinition;
        this.myClassToElementDefinition = classToElementDefinition;
        this.myIdToResourceDefinition = hashMap;
        this.myNameToResourceDefinition = nameToResourceDefinition;
        this.myNameToResourceType = scanner.getNameToResourceType();
        this.myInitialized = true;
        return classToElementDefinition;
    }

    public void setDefaultTypeForProfile(String theProfile, Class<? extends IBaseResource> theClass) {
        Validate.notBlank((CharSequence)theProfile, (String)"theProfile must not be null or empty", (Object[])new Object[0]);
        if (theClass == null) {
            this.myDefaultTypeForProfile.remove(theProfile);
        } else {
            this.myDefaultTypeForProfile.put(theProfile, theClass);
        }
    }

    public FhirContext setParserErrorHandler(IParserErrorHandler theParserErrorHandler) {
        Validate.notNull((Object)theParserErrorHandler, (String)"theParserErrorHandler must not be null", (Object[])new Object[0]);
        this.myParserErrorHandler = theParserErrorHandler;
        return this;
    }

    public FhirContext setFhirValidatorFactory(IFhirValidatorFactory theFhirValidatorFactory) {
        this.myFhirValidatorFactory = theFhirValidatorFactory;
        return this;
    }

    private List<Class<? extends IElement>> toElementList(Collection<Class<? extends IBaseResource>> theResourceTypes) {
        if (theResourceTypes == null) {
            return null;
        }
        ArrayList<Class<? extends IElement>> resTypes = new ArrayList<Class<? extends IElement>>();
        for (Class<? extends IBaseResource> next : theResourceTypes) {
            resTypes.add(next);
        }
        return resTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateInitialized() {
        if (!this.myInitialized) {
            FhirContext fhirContext = this;
            synchronized (fhirContext) {
                if (!this.myInitialized && !this.myInitializing) {
                    this.myInitializing = true;
                    this.scanResourceTypes(this.toElementList(this.myResourceTypesToScan));
                }
            }
        }
    }

    public String toString() {
        return "FhirContext[" + this.myVersion.getVersion().name() + "]";
    }

    @Deprecated(since="6.6.0", forRemoval=true)
    public IPrimitiveType<Boolean> getPrimitiveBoolean(Boolean theValue) {
        return this.newPrimitiveBoolean(theValue);
    }

    public IPrimitiveType<Boolean> newPrimitiveBoolean(Boolean theValue) {
        IPrimitiveType retval = (IPrimitiveType)this.getElementDefinition("boolean").newInstance();
        retval.setValue(theValue);
        return retval;
    }

    public IPrimitiveType<String> newPrimitiveString(String theValue) {
        IPrimitiveType retval = (IPrimitiveType)this.getElementDefinition("string").newInstance();
        retval.setValue(theValue);
        return retval;
    }

    private static boolean tryToInitParser(Runnable run) {
        boolean retVal;
        try {
            run.run();
            retVal = true;
        }
        catch (Exception | NoClassDefFoundError | UnsupportedClassVersionError e) {
            retVal = false;
        }
        return retVal;
    }

    public static FhirContext forDstu2() {
        return new FhirContext(FhirVersionEnum.DSTU2);
    }

    public static FhirContext forDstu2Hl7Org() {
        return new FhirContext(FhirVersionEnum.DSTU2_HL7ORG);
    }

    public static FhirContext forDstu2_1() {
        return new FhirContext(FhirVersionEnum.DSTU2_1);
    }

    public static FhirContext forDstu3() {
        return new FhirContext(FhirVersionEnum.DSTU3);
    }

    public static FhirContext forR4() {
        return new FhirContext(FhirVersionEnum.R4);
    }

    public static FhirContext forR4B() {
        return new FhirContext(FhirVersionEnum.R4B);
    }

    public static FhirContext forR5() {
        return new FhirContext(FhirVersionEnum.R5);
    }

    public static FhirContext forCached(FhirVersionEnum theFhirVersionEnum) {
        return ourStaticContexts.computeIfAbsent(theFhirVersionEnum, v -> new FhirContext((FhirVersionEnum)((Object)v)));
    }

    private static Collection<Class<? extends IBaseResource>> toCollection(Class<? extends IBaseResource> theResourceType) {
        ArrayList<Class<? extends IBaseResource>> retVal = new ArrayList<Class<? extends IBaseResource>>(1);
        retVal.add(theResourceType);
        return retVal;
    }

    private static List<Class<? extends IBaseResource>> toCollection(Class<?>[] theResourceTypes) {
        ArrayList<Class<? extends IBaseResource>> retVal = new ArrayList<Class<? extends IBaseResource>>(1);
        for (Class<?> clazz : theResourceTypes) {
            if (!IResource.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(Msg.code(1688) + clazz.getCanonicalName() + " is not an instance of " + IResource.class.getSimpleName());
            }
            retVal.add(clazz);
        }
        return retVal;
    }
}

