/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.method;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.rest.api.MethodOutcome;
import ca.uhn.fhir.rest.client.exceptions.InvalidResponseException;
import ca.uhn.fhir.rest.client.method.BaseMethodBinding;
import ca.uhn.fhir.rest.client.method.MethodUtil;
import ca.uhn.fhir.util.BundleUtil;
import ca.uhn.fhir.util.ReflectionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBaseBundle;
import org.hl7.fhir.instance.model.api.IBaseOperationOutcome;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseResourceReturningMethodBinding
extends BaseMethodBinding<Object> {
    protected static final Set<String> ALLOWED_PARAMS;
    private static final Logger ourLog;
    private MethodReturnTypeEnum myMethodReturnType;
    private Class<?> myResourceListCollectionType;
    private String myResourceName;
    private Class<? extends IBaseResource> myResourceType;
    private List<Class<? extends IBaseResource>> myPreferTypesList;

    public BaseResourceReturningMethodBinding(Class<?> theReturnResourceType, Method theMethod, FhirContext theContext, Object theProvider) {
        super(theMethod, theContext, theProvider);
        Class<?> methodReturnType = theMethod.getReturnType();
        if (Collection.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.LIST_OF_RESOURCES;
            Class collectionType = ReflectionUtil.getGenericCollectionTypeOfMethodReturnType((Method)theMethod);
            if (collectionType != null && !Object.class.equals((Object)collectionType) && !IBaseResource.class.isAssignableFrom(collectionType)) {
                throw new ConfigurationException("Method " + theMethod.getDeclaringClass().getSimpleName() + "#" + theMethod.getName() + " returns an invalid collection generic type: " + collectionType);
            }
            this.myResourceListCollectionType = collectionType;
        } else if (IBaseResource.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = !Modifier.isAbstract(methodReturnType.getModifiers()) && theContext.getResourceDefinition(methodReturnType).isBundle() ? MethodReturnTypeEnum.BUNDLE_RESOURCE : MethodReturnTypeEnum.RESOURCE;
        } else if (MethodOutcome.class.isAssignableFrom(methodReturnType)) {
            this.myMethodReturnType = MethodReturnTypeEnum.METHOD_OUTCOME;
        } else {
            throw new ConfigurationException("Invalid return type '" + methodReturnType.getCanonicalName() + "' on method '" + theMethod.getName() + "' on type: " + theMethod.getDeclaringClass().getCanonicalName());
        }
        if (theReturnResourceType != null && IBaseResource.class.isAssignableFrom(theReturnResourceType) && !Modifier.isAbstract(theReturnResourceType.getModifiers()) && !Modifier.isInterface(theReturnResourceType.getModifiers())) {
            this.myResourceType = theReturnResourceType;
            this.myResourceName = theContext.getResourceType(this.myResourceType);
        }
        this.myPreferTypesList = this.createPreferTypesList();
    }

    public MethodReturnTypeEnum getMethodReturnType() {
        return this.myMethodReturnType;
    }

    @Override
    public String getResourceName() {
        return this.myResourceName;
    }

    protected abstract BundleTypeEnum getResponseBundleType();

    public abstract ReturnTypeEnum getReturnType();

    @Override
    public Object invokeClient(String theResponseMimeType, InputStream theResponseInputStream, int theResponseStatusCode, Map<String, List<String>> theHeaders) throws IOException {
        if (204 == theResponseStatusCode) {
            return this.toReturnType(null);
        }
        IParser parser = this.createAppropriateParserForParsingResponse(theResponseMimeType, theResponseInputStream, theResponseStatusCode, this.myPreferTypesList);
        switch (this.getReturnType()) {
            case BUNDLE: {
                Class type = this.getContext().getResourceDefinition("Bundle").getImplementingClass();
                IBaseBundle bundle = (IBaseBundle)parser.parseResource(type, theResponseInputStream);
                List listOfResources = BundleUtil.toListOfResources((FhirContext)this.getContext(), (IBaseBundle)bundle);
                switch (this.getMethodReturnType()) {
                    case BUNDLE_RESOURCE: {
                        return bundle;
                    }
                    case LIST_OF_RESOURCES: {
                        if (this.myResourceListCollectionType != null) {
                            Iterator iter = listOfResources.iterator();
                            while (iter.hasNext()) {
                                IBaseResource next = (IBaseResource)iter.next();
                                if (this.myResourceListCollectionType.isAssignableFrom(next.getClass())) continue;
                                ourLog.debug("Not returning resource of type {} because it is not a subclass or instance of {}", next.getClass(), this.myResourceListCollectionType);
                                iter.remove();
                            }
                        }
                        return listOfResources;
                    }
                    case RESOURCE: {
                        List list = BundleUtil.toListOfResources((FhirContext)this.getContext(), (IBaseBundle)bundle);
                        if (list.size() == 0) {
                            return null;
                        }
                        if (list.size() == 1) {
                            return list.get(0);
                        }
                        throw new InvalidResponseException(theResponseStatusCode, "FHIR server call returned a bundle with multiple resources, but this method is only able to returns one.");
                    }
                }
                break;
            }
            case RESOURCE: {
                IBaseResource resource = this.myResourceType != null ? parser.parseResource(this.myResourceType, theResponseInputStream) : parser.parseResource(theResponseInputStream);
                MethodUtil.parseClientRequestResourceHeaders(null, theHeaders, resource);
                return this.toReturnType(resource);
            }
        }
        throw new IllegalStateException("Should not get here!");
    }

    private Object toReturnType(IBaseResource resource) {
        Object retVal = null;
        switch (this.getMethodReturnType()) {
            case LIST_OF_RESOURCES: {
                retVal = Collections.emptyList();
                if (resource == null) break;
                retVal = Collections.singletonList(resource);
                break;
            }
            case RESOURCE: {
                retVal = resource;
                break;
            }
            case BUNDLE_RESOURCE: {
                retVal = resource;
                break;
            }
            case METHOD_OUTCOME: {
                MethodOutcome outcome = new MethodOutcome();
                outcome.setOperationOutcome((IBaseOperationOutcome)resource);
                retVal = outcome;
            }
        }
        return retVal;
    }

    private List<Class<? extends IBaseResource>> createPreferTypesList() {
        ArrayList preferTypes = null;
        if (this.myResourceType != null && !BaseMethodBinding.isResourceInterface(this.myResourceType)) {
            preferTypes = new ArrayList(1);
            preferTypes.add(this.myResourceType);
        } else if (this.myResourceListCollectionType != null && IBaseResource.class.isAssignableFrom(this.myResourceListCollectionType) && !BaseMethodBinding.isResourceInterface(this.myResourceListCollectionType)) {
            preferTypes = new ArrayList(1);
            preferTypes.add(this.myResourceListCollectionType);
        }
        return preferTypes;
    }

    protected boolean isAddContentLocationHeader() {
        return true;
    }

    protected void setResourceName(String theResourceName) {
        this.myResourceName = theResourceName;
    }

    static {
        ourLog = LoggerFactory.getLogger(BaseResourceReturningMethodBinding.class);
        HashSet<String> set = new HashSet<String>();
        set.add("_format");
        set.add("_narrative");
        set.add("_pretty");
        set.add("_sort");
        set.add("_sort:asc");
        set.add("_sort:desc");
        set.add("_count");
        set.add("_offset");
        set.add("_summary");
        set.add("_elements");
        ALLOWED_PARAMS = Collections.unmodifiableSet(set);
    }

    public static enum MethodReturnTypeEnum {
        BUNDLE_RESOURCE,
        LIST_OF_RESOURCES,
        METHOD_OUTCOME,
        RESOURCE;

    }

    public static enum ReturnTypeEnum {
        BUNDLE,
        RESOURCE;

    }

    public static class ResourceOrDstu1Bundle {
        private final IBaseResource myResource;

        public ResourceOrDstu1Bundle(IBaseResource theResource) {
            this.myResource = theResource;
        }

        public IBaseResource getResource() {
            return this.myResource;
        }
    }
}

