/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.client.apache;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.apache.ApacheHttpClient;
import ca.uhn.fhir.rest.client.api.Header;
import ca.uhn.fhir.rest.client.api.IHttpClient;
import ca.uhn.fhir.rest.client.impl.RestfulClientFactory;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

public class ApacheRestfulClientFactory
extends RestfulClientFactory {
    private HttpClient myHttpClient;
    private HttpHost myProxy;

    public ApacheRestfulClientFactory() {
    }

    public ApacheRestfulClientFactory(FhirContext theContext) {
        super(theContext);
    }

    @Override
    protected synchronized ApacheHttpClient getHttpClient(String theServerBase) {
        return new ApacheHttpClient(this.getNativeHttpClient(), new StringBuilder(theServerBase), null, null, null, null);
    }

    public synchronized IHttpClient getHttpClient(StringBuilder theUrl, Map<String, List<String>> theIfNoneExistParams, String theIfNoneExistString, RequestTypeEnum theRequestType, List<Header> theHeaders) {
        return new ApacheHttpClient(this.getNativeHttpClient(), theUrl, theIfNoneExistParams, theIfNoneExistString, theRequestType, theHeaders);
    }

    public HttpClient getNativeHttpClient() {
        if (this.myHttpClient == null) {
            PoolingHttpClientConnectionManager connectionManager = new PoolingHttpClientConnectionManager(5000L, TimeUnit.MILLISECONDS);
            connectionManager.setMaxTotal(this.getPoolMaxTotal());
            connectionManager.setDefaultMaxPerRoute(this.getPoolMaxPerRoute());
            RequestConfig defaultRequestConfig = RequestConfig.custom().setSocketTimeout(this.getSocketTimeout()).setConnectTimeout(this.getConnectTimeout()).setConnectionRequestTimeout(this.getConnectionRequestTimeout()).setStaleConnectionCheckEnabled(true).setProxy(this.myProxy).build();
            HttpClientBuilder builder = this.getHttpClientBuilder().useSystemProperties().setConnectionManager((HttpClientConnectionManager)connectionManager).setDefaultRequestConfig(defaultRequestConfig).disableCookieManagement();
            if (this.myProxy != null && StringUtils.isNotBlank((CharSequence)this.getProxyUsername()) && StringUtils.isNotBlank((CharSequence)this.getProxyPassword())) {
                BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
                credsProvider.setCredentials(new AuthScope(this.myProxy.getHostName(), this.myProxy.getPort()), (Credentials)new UsernamePasswordCredentials(this.getProxyUsername(), this.getProxyPassword()));
                builder.setProxyAuthenticationStrategy((AuthenticationStrategy)new ProxyAuthenticationStrategy());
                builder.setDefaultCredentialsProvider((CredentialsProvider)credsProvider);
            }
            this.myHttpClient = builder.build();
        }
        return this.myHttpClient;
    }

    protected HttpClientBuilder getHttpClientBuilder() {
        return HttpClients.custom();
    }

    @Override
    protected void resetHttpClient() {
        this.myHttpClient = null;
    }

    public synchronized void setHttpClient(Object theHttpClient) {
        this.myHttpClient = (HttpClient)theHttpClient;
    }

    public void setProxy(String theHost, Integer thePort) {
        this.myProxy = theHost != null ? new HttpHost(theHost, thePort.intValue(), "http") : null;
    }
}

