/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.convertors;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.convertors.VersionConvertorAdvisor40;
import org.hl7.fhir.convertors.VersionConvertorConstants;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.Address;
import org.hl7.fhir.instance.model.Annotation;
import org.hl7.fhir.instance.model.Appointment;
import org.hl7.fhir.instance.model.AppointmentResponse;
import org.hl7.fhir.instance.model.AuditEvent;
import org.hl7.fhir.instance.model.BackboneElement;
import org.hl7.fhir.instance.model.Base64BinaryType;
import org.hl7.fhir.instance.model.Basic;
import org.hl7.fhir.instance.model.Bundle;
import org.hl7.fhir.instance.model.CarePlan;
import org.hl7.fhir.instance.model.CodeType;
import org.hl7.fhir.instance.model.CodeableConcept;
import org.hl7.fhir.instance.model.Coding;
import org.hl7.fhir.instance.model.Communication;
import org.hl7.fhir.instance.model.CommunicationRequest;
import org.hl7.fhir.instance.model.Composition;
import org.hl7.fhir.instance.model.ConceptMap;
import org.hl7.fhir.instance.model.Condition;
import org.hl7.fhir.instance.model.Conformance;
import org.hl7.fhir.instance.model.ContactPoint;
import org.hl7.fhir.instance.model.Count;
import org.hl7.fhir.instance.model.DataElement;
import org.hl7.fhir.instance.model.DateTimeType;
import org.hl7.fhir.instance.model.DecimalType;
import org.hl7.fhir.instance.model.DetectedIssue;
import org.hl7.fhir.instance.model.DeviceMetric;
import org.hl7.fhir.instance.model.DeviceUseStatement;
import org.hl7.fhir.instance.model.DiagnosticReport;
import org.hl7.fhir.instance.model.DocumentManifest;
import org.hl7.fhir.instance.model.DocumentReference;
import org.hl7.fhir.instance.model.DomainResource;
import org.hl7.fhir.instance.model.ElementDefinition;
import org.hl7.fhir.instance.model.Encounter;
import org.hl7.fhir.instance.model.EnrollmentRequest;
import org.hl7.fhir.instance.model.Enumeration;
import org.hl7.fhir.instance.model.Enumerations;
import org.hl7.fhir.instance.model.EpisodeOfCare;
import org.hl7.fhir.instance.model.FamilyMemberHistory;
import org.hl7.fhir.instance.model.Flag;
import org.hl7.fhir.instance.model.Group;
import org.hl7.fhir.instance.model.HealthcareService;
import org.hl7.fhir.instance.model.HumanName;
import org.hl7.fhir.instance.model.IdType;
import org.hl7.fhir.instance.model.Identifier;
import org.hl7.fhir.instance.model.ImplementationGuide;
import org.hl7.fhir.instance.model.IntegerType;
import org.hl7.fhir.instance.model.List_;
import org.hl7.fhir.instance.model.Location;
import org.hl7.fhir.instance.model.MedicationDispense;
import org.hl7.fhir.instance.model.MedicationOrder;
import org.hl7.fhir.instance.model.MedicationStatement;
import org.hl7.fhir.instance.model.MessageHeader;
import org.hl7.fhir.instance.model.NamingSystem;
import org.hl7.fhir.instance.model.Narrative;
import org.hl7.fhir.instance.model.Observation;
import org.hl7.fhir.instance.model.OidType;
import org.hl7.fhir.instance.model.OperationDefinition;
import org.hl7.fhir.instance.model.OperationOutcome;
import org.hl7.fhir.instance.model.Organization;
import org.hl7.fhir.instance.model.Parameters;
import org.hl7.fhir.instance.model.Patient;
import org.hl7.fhir.instance.model.Period;
import org.hl7.fhir.instance.model.Person;
import org.hl7.fhir.instance.model.Practitioner;
import org.hl7.fhir.instance.model.Quantity;
import org.hl7.fhir.instance.model.Questionnaire;
import org.hl7.fhir.instance.model.QuestionnaireResponse;
import org.hl7.fhir.instance.model.Range;
import org.hl7.fhir.instance.model.Reference;
import org.hl7.fhir.instance.model.RiskAssessment;
import org.hl7.fhir.instance.model.Schedule;
import org.hl7.fhir.instance.model.SearchParameter;
import org.hl7.fhir.instance.model.Signature;
import org.hl7.fhir.instance.model.SimpleQuantity;
import org.hl7.fhir.instance.model.Slot;
import org.hl7.fhir.instance.model.StructureDefinition;
import org.hl7.fhir.instance.model.Subscription;
import org.hl7.fhir.instance.model.Substance;
import org.hl7.fhir.instance.model.SupplyDelivery;
import org.hl7.fhir.instance.model.SupplyRequest;
import org.hl7.fhir.instance.model.TestScript;
import org.hl7.fhir.instance.model.Timing;
import org.hl7.fhir.instance.model.UnsignedIntType;
import org.hl7.fhir.instance.model.UriType;
import org.hl7.fhir.instance.model.UuidType;
import org.hl7.fhir.instance.model.ValueSet;
import org.hl7.fhir.instance.utils.ToolingExtensions;
import org.hl7.fhir.r4.conformance.ProfileUtilities;
import org.hl7.fhir.r4.model.Address;
import org.hl7.fhir.r4.model.Age;
import org.hl7.fhir.r4.model.Appointment;
import org.hl7.fhir.r4.model.AppointmentResponse;
import org.hl7.fhir.r4.model.Attachment;
import org.hl7.fhir.r4.model.AuditEvent;
import org.hl7.fhir.r4.model.Binary;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Bundle;
import org.hl7.fhir.r4.model.CanonicalType;
import org.hl7.fhir.r4.model.CapabilityStatement;
import org.hl7.fhir.r4.model.CarePlan;
import org.hl7.fhir.r4.model.CodeSystem;
import org.hl7.fhir.r4.model.Communication;
import org.hl7.fhir.r4.model.CommunicationRequest;
import org.hl7.fhir.r4.model.Composition;
import org.hl7.fhir.r4.model.ConceptMap;
import org.hl7.fhir.r4.model.Condition;
import org.hl7.fhir.r4.model.ContactDetail;
import org.hl7.fhir.r4.model.ContactPoint;
import org.hl7.fhir.r4.model.DateType;
import org.hl7.fhir.r4.model.DetectedIssue;
import org.hl7.fhir.r4.model.DeviceMetric;
import org.hl7.fhir.r4.model.DiagnosticReport;
import org.hl7.fhir.r4.model.Distance;
import org.hl7.fhir.r4.model.DocumentManifest;
import org.hl7.fhir.r4.model.DocumentReference;
import org.hl7.fhir.r4.model.Dosage;
import org.hl7.fhir.r4.model.Duration;
import org.hl7.fhir.r4.model.Element;
import org.hl7.fhir.r4.model.ElementDefinition;
import org.hl7.fhir.r4.model.Encounter;
import org.hl7.fhir.r4.model.EnrollmentResponse;
import org.hl7.fhir.r4.model.Enumerations;
import org.hl7.fhir.r4.model.EpisodeOfCare;
import org.hl7.fhir.r4.model.Extension;
import org.hl7.fhir.r4.model.FamilyMemberHistory;
import org.hl7.fhir.r4.model.Flag;
import org.hl7.fhir.r4.model.Group;
import org.hl7.fhir.r4.model.HealthcareService;
import org.hl7.fhir.r4.model.HumanName;
import org.hl7.fhir.r4.model.Identifier;
import org.hl7.fhir.r4.model.Immunization;
import org.hl7.fhir.r4.model.ImplementationGuide;
import org.hl7.fhir.r4.model.InstantType;
import org.hl7.fhir.r4.model.ListResource;
import org.hl7.fhir.r4.model.Location;
import org.hl7.fhir.r4.model.MarkdownType;
import org.hl7.fhir.r4.model.MedicationDispense;
import org.hl7.fhir.r4.model.MedicationStatement;
import org.hl7.fhir.r4.model.MessageHeader;
import org.hl7.fhir.r4.model.Meta;
import org.hl7.fhir.r4.model.Money;
import org.hl7.fhir.r4.model.NamingSystem;
import org.hl7.fhir.r4.model.Narrative;
import org.hl7.fhir.r4.model.Observation;
import org.hl7.fhir.r4.model.OperationDefinition;
import org.hl7.fhir.r4.model.OperationOutcome;
import org.hl7.fhir.r4.model.Organization;
import org.hl7.fhir.r4.model.Parameters;
import org.hl7.fhir.r4.model.Patient;
import org.hl7.fhir.r4.model.Person;
import org.hl7.fhir.r4.model.PositiveIntType;
import org.hl7.fhir.r4.model.Practitioner;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.QuestionnaireResponse;
import org.hl7.fhir.r4.model.Ratio;
import org.hl7.fhir.r4.model.Resource;
import org.hl7.fhir.r4.model.RiskAssessment;
import org.hl7.fhir.r4.model.SampledData;
import org.hl7.fhir.r4.model.SearchParameter;
import org.hl7.fhir.r4.model.Slot;
import org.hl7.fhir.r4.model.StringType;
import org.hl7.fhir.r4.model.StructureDefinition;
import org.hl7.fhir.r4.model.Subscription;
import org.hl7.fhir.r4.model.Substance;
import org.hl7.fhir.r4.model.SupplyDelivery;
import org.hl7.fhir.r4.model.SupplyRequest;
import org.hl7.fhir.r4.model.TerminologyCapabilities;
import org.hl7.fhir.r4.model.TestScript;
import org.hl7.fhir.r4.model.TimeType;
import org.hl7.fhir.r4.model.Timing;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.model.UrlType;
import org.hl7.fhir.r4.model.UsageContext;
import org.hl7.fhir.r4.model.ValueSet;
import org.hl7.fhir.r4.terminologies.CodeSystemUtilities;
import org.hl7.fhir.utilities.Utilities;

public class VersionConvertor_10_40 {
    private static List<String> CANONICAL_URLS = new ArrayList<String>();
    public VersionConvertorAdvisor40 advisor;

    public VersionConvertor_10_40(VersionConvertorAdvisor40 advisor) {
        this.advisor = advisor;
    }

    public void copyElement(org.hl7.fhir.instance.model.Element src, Element tgt) throws FHIRException {
        tgt.setId(src.getId());
        for (org.hl7.fhir.instance.model.Extension e : src.getExtension()) {
            tgt.addExtension(this.convertExtension(e));
        }
    }

    public void copyElement(Element src, org.hl7.fhir.instance.model.Element tgt) throws FHIRException {
        tgt.setId(src.getId());
        for (Extension e : src.getExtension()) {
            tgt.addExtension(this.convertExtension(e));
        }
    }

    public void copyElement(org.hl7.fhir.r4.model.DomainResource src, org.hl7.fhir.instance.model.Element tgt) throws FHIRException {
        tgt.setId(src.getId());
        for (Extension e : src.getExtension()) {
            tgt.addExtension(this.convertExtension(e));
        }
    }

    public void copyBackboneElement(BackboneElement src, org.hl7.fhir.r4.model.BackboneElement tgt) throws FHIRException {
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (org.hl7.fhir.instance.model.Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(this.convertExtension(e));
        }
    }

    public void copyBackboneElement(org.hl7.fhir.r4.model.BackboneElement src, BackboneElement tgt) throws FHIRException {
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (Extension e : src.getModifierExtension()) {
            tgt.addModifierExtension(this.convertExtension(e));
        }
    }

    public org.hl7.fhir.r4.model.Base64BinaryType convertBase64Binary(Base64BinaryType src) throws FHIRException {
        org.hl7.fhir.r4.model.Base64BinaryType tgt = new org.hl7.fhir.r4.model.Base64BinaryType((byte[])src.getValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public Base64BinaryType convertBase64Binary(org.hl7.fhir.r4.model.Base64BinaryType src) throws FHIRException {
        Base64BinaryType tgt = new Base64BinaryType((byte[])src.getValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public BooleanType convertBoolean(org.hl7.fhir.instance.model.BooleanType src) throws FHIRException {
        BooleanType tgt = new BooleanType((Boolean)src.getValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.instance.model.BooleanType convertBoolean(BooleanType src) throws FHIRException {
        org.hl7.fhir.instance.model.BooleanType tgt = new org.hl7.fhir.instance.model.BooleanType((Boolean)src.getValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.r4.model.CodeType convertCode(CodeType src) throws FHIRException {
        org.hl7.fhir.r4.model.CodeType tgt = new org.hl7.fhir.r4.model.CodeType((String)src.getValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public CodeType convertCode(org.hl7.fhir.r4.model.CodeType src) throws FHIRException {
        CodeType tgt = new CodeType((String)src.getValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.r4.model.UriType convertCodeToUri(CodeType src) throws FHIRException {
        org.hl7.fhir.r4.model.UriType tgt = new org.hl7.fhir.r4.model.UriType((String)src.getValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public CodeType convertUriToCode(org.hl7.fhir.r4.model.UriType src) throws FHIRException {
        CodeType tgt = new CodeType((String)src.getValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public DateType convertDate(org.hl7.fhir.instance.model.DateType src) throws FHIRException {
        DateType tgt = new DateType(src.getValueAsString());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public DateType convertDate(DateTimeType src) throws FHIRException {
        DateType tgt = new DateType(src.getValueAsString());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.r4.model.DateTimeType convertDateToDateTime(org.hl7.fhir.instance.model.DateType src) throws FHIRException {
        org.hl7.fhir.r4.model.DateTimeType tgt = new org.hl7.fhir.r4.model.DateTimeType(src.getValueAsString());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.instance.model.DateType convertDateTimeToDate(org.hl7.fhir.r4.model.DateTimeType src) throws FHIRException {
        org.hl7.fhir.instance.model.DateType tgt = new org.hl7.fhir.instance.model.DateType(src.getValueAsString());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.instance.model.DateType convertDate(DateType src) throws FHIRException {
        org.hl7.fhir.instance.model.DateType tgt = new org.hl7.fhir.instance.model.DateType(src.getValueAsString());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.instance.model.DateType convertDate(org.hl7.fhir.r4.model.DateTimeType src) throws FHIRException {
        org.hl7.fhir.instance.model.DateType tgt = new org.hl7.fhir.instance.model.DateType(src.getValueAsString());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.r4.model.DateTimeType convertDateTime(DateTimeType src) throws FHIRException {
        org.hl7.fhir.r4.model.DateTimeType tgt = new org.hl7.fhir.r4.model.DateTimeType(src.getValueAsString());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public DateTimeType convertDateTime(org.hl7.fhir.r4.model.DateTimeType src) throws FHIRException {
        DateTimeType tgt = new DateTimeType(src.getValueAsString());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.r4.model.DecimalType convertDecimal(DecimalType src) throws FHIRException {
        org.hl7.fhir.r4.model.DecimalType tgt = new org.hl7.fhir.r4.model.DecimalType((BigDecimal)src.getValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public DecimalType convertDecimal(org.hl7.fhir.r4.model.DecimalType src) throws FHIRException {
        DecimalType tgt = new DecimalType((BigDecimal)src.getValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.r4.model.IdType convertId(IdType src) throws FHIRException {
        org.hl7.fhir.r4.model.IdType tgt = new org.hl7.fhir.r4.model.IdType(src.getValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public IdType convertId(org.hl7.fhir.r4.model.IdType src) throws FHIRException {
        IdType tgt = new IdType(src.getValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public InstantType convertInstant(org.hl7.fhir.instance.model.InstantType src) throws FHIRException {
        InstantType tgt = new InstantType((Date)src.getValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.instance.model.InstantType convertInstant(InstantType src) throws FHIRException {
        org.hl7.fhir.instance.model.InstantType tgt = new org.hl7.fhir.instance.model.InstantType((Date)src.getValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.r4.model.IntegerType convertInteger(IntegerType src) throws FHIRException {
        org.hl7.fhir.r4.model.IntegerType tgt = new org.hl7.fhir.r4.model.IntegerType(((Integer)src.getValue()).intValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public IntegerType convertInteger(org.hl7.fhir.r4.model.IntegerType src) throws FHIRException {
        IntegerType tgt = new IntegerType(((Integer)src.getValue()).intValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public MarkdownType convertMarkdown(org.hl7.fhir.instance.model.MarkdownType src) throws FHIRException {
        MarkdownType tgt = new MarkdownType((String)src.getValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.instance.model.MarkdownType convertMarkdown(MarkdownType src) throws FHIRException {
        org.hl7.fhir.instance.model.MarkdownType tgt = new org.hl7.fhir.instance.model.MarkdownType((String)src.getValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.r4.model.OidType convertOid(OidType src) throws FHIRException {
        org.hl7.fhir.r4.model.OidType tgt = new org.hl7.fhir.r4.model.OidType((String)src.getValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public OidType convertOid(org.hl7.fhir.r4.model.OidType src) throws FHIRException {
        OidType tgt = new OidType((String)src.getValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public PositiveIntType convertPositiveInt(org.hl7.fhir.instance.model.PositiveIntType src) throws FHIRException {
        PositiveIntType tgt = new PositiveIntType(((Integer)src.getValue()).intValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.instance.model.PositiveIntType convertPositiveInt(PositiveIntType src) throws FHIRException {
        org.hl7.fhir.instance.model.PositiveIntType tgt = new org.hl7.fhir.instance.model.PositiveIntType(((Integer)src.getValue()).intValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public StringType convertString(org.hl7.fhir.instance.model.StringType src) throws FHIRException {
        StringType tgt = new StringType((String)src.getValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.instance.model.StringType convertString(StringType src) throws FHIRException {
        org.hl7.fhir.instance.model.StringType tgt = new org.hl7.fhir.instance.model.StringType((String)src.getValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public TimeType convertTime(org.hl7.fhir.instance.model.TimeType src) throws FHIRException {
        TimeType tgt = new TimeType((String)src.getValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.instance.model.TimeType convertTime(TimeType src) throws FHIRException {
        org.hl7.fhir.instance.model.TimeType tgt = new org.hl7.fhir.instance.model.TimeType((String)src.getValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.r4.model.UnsignedIntType convertUnsignedInt(UnsignedIntType src) throws FHIRException {
        org.hl7.fhir.r4.model.UnsignedIntType tgt = new org.hl7.fhir.r4.model.UnsignedIntType(((Integer)src.getValue()).intValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public UnsignedIntType convertUnsignedInt(org.hl7.fhir.r4.model.UnsignedIntType src) throws FHIRException {
        UnsignedIntType tgt = new UnsignedIntType(((Integer)src.getValue()).intValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.r4.model.UriType convertUri(UriType src) throws FHIRException {
        org.hl7.fhir.r4.model.UriType tgt = new org.hl7.fhir.r4.model.UriType((String)src.getValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public UrlType convertUriToUrl(UriType src) throws FHIRException {
        UrlType tgt = new UrlType((String)src.getValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public UriType convertUri(org.hl7.fhir.r4.model.UriType src) throws FHIRException {
        UriType tgt = new UriType((String)src.getValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public org.hl7.fhir.r4.model.UuidType convertUuid(UuidType src) throws FHIRException {
        org.hl7.fhir.r4.model.UuidType tgt = new org.hl7.fhir.r4.model.UuidType((String)src.getValue());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        return tgt;
    }

    public UuidType convertUuid(org.hl7.fhir.r4.model.UuidType src) throws FHIRException {
        UuidType tgt = new UuidType((String)src.getValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        return tgt;
    }

    public Extension convertExtension(org.hl7.fhir.instance.model.Extension src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Extension tgt = new Extension();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setUrl(src.getUrl());
        if (src.hasValue()) {
            if (CANONICAL_URLS.contains(src.getUrl()) && src.getValue() instanceof Reference) {
                tgt.setValue((Type)this.convertReferenceToCanonical((Reference)src.getValue()));
            } else {
                tgt.setValue(this.convertType(src.getValue()));
            }
        }
        return tgt;
    }

    public org.hl7.fhir.instance.model.Extension convertExtension(Extension src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Extension tgt = new org.hl7.fhir.instance.model.Extension();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setUrl(src.getUrl());
        if (src.hasValue()) {
            if (CANONICAL_URLS.contains(src.getUrl()) && src.getValue() instanceof CanonicalType) {
                tgt.setValue((org.hl7.fhir.instance.model.Type)this.convertCanonicalToReference((CanonicalType)src.getValue()));
            } else {
                tgt.setValue(this.convertType(src.getValue()));
            }
        }
        tgt.setValue(this.convertType(src.getValue()));
        return tgt;
    }

    public Narrative convertNarrative(org.hl7.fhir.instance.model.Narrative src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Narrative tgt = new Narrative();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setStatus(this.convertNarrativeStatus(src.getStatus()));
        tgt.setDiv(src.getDiv());
        return tgt;
    }

    public org.hl7.fhir.instance.model.Narrative convertNarrative(Narrative src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Narrative tgt = new org.hl7.fhir.instance.model.Narrative();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setStatus(this.convertNarrativeStatus(src.getStatus()));
        tgt.setDiv(src.getDiv());
        return tgt;
    }

    public Narrative.NarrativeStatus convertNarrativeStatus(Narrative.NarrativeStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GENERATED: {
                return Narrative.NarrativeStatus.GENERATED;
            }
            case EXTENSIONS: {
                return Narrative.NarrativeStatus.EXTENSIONS;
            }
            case ADDITIONAL: {
                return Narrative.NarrativeStatus.ADDITIONAL;
            }
            case EMPTY: {
                return Narrative.NarrativeStatus.EMPTY;
            }
        }
        return Narrative.NarrativeStatus.NULL;
    }

    public Narrative.NarrativeStatus convertNarrativeStatus(Narrative.NarrativeStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GENERATED: {
                return Narrative.NarrativeStatus.GENERATED;
            }
            case EXTENSIONS: {
                return Narrative.NarrativeStatus.EXTENSIONS;
            }
            case ADDITIONAL: {
                return Narrative.NarrativeStatus.ADDITIONAL;
            }
            case EMPTY: {
                return Narrative.NarrativeStatus.EMPTY;
            }
        }
        return Narrative.NarrativeStatus.NULL;
    }

    public org.hl7.fhir.r4.model.Annotation convertAnnotation(Annotation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Annotation tgt = new org.hl7.fhir.r4.model.Annotation();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setAuthor(this.convertType(src.getAuthor()));
        tgt.setTime(src.getTime());
        tgt.setText(src.getText());
        return tgt;
    }

    public Annotation convertAnnotation(org.hl7.fhir.r4.model.Annotation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Annotation tgt = new Annotation();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setAuthor(this.convertType(src.getAuthor()));
        tgt.setTime(src.getTime());
        tgt.setText(src.getText());
        return tgt;
    }

    public Attachment convertAttachment(org.hl7.fhir.instance.model.Attachment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Attachment tgt = new Attachment();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setContentType(src.getContentType());
        tgt.setLanguage(src.getLanguage());
        tgt.setData(src.getData());
        tgt.setUrl(src.getUrl());
        tgt.setSize(src.getSize());
        tgt.setHash(src.getHash());
        tgt.setTitle(src.getTitle());
        tgt.setCreation(src.getCreation());
        return tgt;
    }

    public org.hl7.fhir.instance.model.Attachment convertAttachment(Attachment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Attachment tgt = new org.hl7.fhir.instance.model.Attachment();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setContentType(src.getContentType());
        tgt.setLanguage(src.getLanguage());
        tgt.setData(src.getData());
        tgt.setUrl(src.getUrl());
        tgt.setSize(src.getSize());
        tgt.setHash(src.getHash());
        tgt.setTitle(src.getTitle());
        tgt.setCreation(src.getCreation());
        return tgt;
    }

    public org.hl7.fhir.r4.model.CodeableConcept convertCodeableConcept(CodeableConcept src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.CodeableConcept tgt = new org.hl7.fhir.r4.model.CodeableConcept();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (Coding t : src.getCoding()) {
            tgt.addCoding(this.convertCoding(t));
        }
        tgt.setText(src.getText());
        return tgt;
    }

    public CodeableConcept convertCodeableConcept(org.hl7.fhir.r4.model.CodeableConcept src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CodeableConcept tgt = new CodeableConcept();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (org.hl7.fhir.r4.model.Coding t : src.getCoding()) {
            tgt.addCoding(this.convertCoding(t));
        }
        tgt.setText(src.getText());
        return tgt;
    }

    public org.hl7.fhir.r4.model.Coding convertCoding(Coding src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Coding tgt = new org.hl7.fhir.r4.model.Coding();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setSystem(src.getSystem());
        tgt.setVersion(src.getVersion());
        tgt.setCode(src.getCode());
        tgt.setDisplay(src.getDisplay());
        tgt.setUserSelected(src.getUserSelected());
        return tgt;
    }

    public Coding convertCoding(org.hl7.fhir.r4.model.Coding src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Coding tgt = new Coding();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setSystem(src.getSystem());
        tgt.setVersion(src.getVersion());
        tgt.setCode(src.getCode());
        tgt.setDisplay(src.getDisplay());
        tgt.setUserSelected(src.getUserSelected());
        return tgt;
    }

    public Identifier convertIdentifier(org.hl7.fhir.instance.model.Identifier src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Identifier tgt = new Identifier();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setUse(this.convertIdentifierUse(src.getUse()));
        tgt.setType(this.convertCodeableConcept(src.getType()));
        tgt.setSystem(src.getSystem());
        tgt.setValue(src.getValue());
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        tgt.setAssigner(this.convertReference(src.getAssigner()));
        return tgt;
    }

    public org.hl7.fhir.instance.model.Identifier convertIdentifier(Identifier src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Identifier tgt = new org.hl7.fhir.instance.model.Identifier();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        if (src.hasUse()) {
            tgt.setUse(this.convertIdentifierUse(src.getUse()));
        }
        if (src.hasType()) {
            tgt.setType(this.convertCodeableConcept(src.getType()));
        }
        if (src.hasSystem()) {
            tgt.setSystem(src.getSystem());
        }
        if (src.hasValue()) {
            tgt.setValue(src.getValue());
        }
        if (src.hasPeriod()) {
            tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        }
        if (src.hasAssigner()) {
            tgt.setAssigner(this.convertReference(src.getAssigner()));
        }
        return tgt;
    }

    public Identifier.IdentifierUse convertIdentifierUse(Identifier.IdentifierUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case USUAL: {
                return Identifier.IdentifierUse.USUAL;
            }
            case OFFICIAL: {
                return Identifier.IdentifierUse.OFFICIAL;
            }
            case TEMP: {
                return Identifier.IdentifierUse.TEMP;
            }
            case SECONDARY: {
                return Identifier.IdentifierUse.SECONDARY;
            }
        }
        return Identifier.IdentifierUse.NULL;
    }

    public Identifier.IdentifierUse convertIdentifierUse(Identifier.IdentifierUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case USUAL: {
                return Identifier.IdentifierUse.USUAL;
            }
            case OFFICIAL: {
                return Identifier.IdentifierUse.OFFICIAL;
            }
            case TEMP: {
                return Identifier.IdentifierUse.TEMP;
            }
            case SECONDARY: {
                return Identifier.IdentifierUse.SECONDARY;
            }
        }
        return Identifier.IdentifierUse.NULL;
    }

    public org.hl7.fhir.r4.model.Period convertPeriod(Period src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Period tgt = new org.hl7.fhir.r4.model.Period();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setStart(src.getStart());
        tgt.setEnd(src.getEnd());
        return tgt;
    }

    public Period convertPeriod(org.hl7.fhir.r4.model.Period src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Period tgt = new Period();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setStart(src.getStart());
        tgt.setEnd(src.getEnd());
        return tgt;
    }

    public Quantity convertQuantity(org.hl7.fhir.instance.model.Quantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Quantity tgt = new Quantity();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setValue(src.getValue());
        tgt.setComparator(this.convertQuantityComparator(src.getComparator()));
        tgt.setUnit(src.getUnit());
        tgt.setSystem(src.getSystem());
        tgt.setCode(src.getCode());
        return tgt;
    }

    public org.hl7.fhir.instance.model.Quantity convertQuantity(Quantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Quantity tgt = new org.hl7.fhir.instance.model.Quantity();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setValue(src.getValue());
        tgt.setComparator(this.convertQuantityComparator(src.getComparator()));
        tgt.setUnit(src.getUnit());
        tgt.setSystem(src.getSystem());
        tgt.setCode(src.getCode());
        return tgt;
    }

    public Quantity.QuantityComparator convertQuantityComparator(Quantity.QuantityComparator src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case LESS_THAN: {
                return Quantity.QuantityComparator.LESS_THAN;
            }
            case LESS_OR_EQUAL: {
                return Quantity.QuantityComparator.LESS_OR_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return Quantity.QuantityComparator.GREATER_OR_EQUAL;
            }
            case GREATER_THAN: {
                return Quantity.QuantityComparator.GREATER_THAN;
            }
        }
        return Quantity.QuantityComparator.NULL;
    }

    public Quantity.QuantityComparator convertQuantityComparator(Quantity.QuantityComparator src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case LESS_THAN: {
                return Quantity.QuantityComparator.LESS_THAN;
            }
            case LESS_OR_EQUAL: {
                return Quantity.QuantityComparator.LESS_OR_EQUAL;
            }
            case GREATER_OR_EQUAL: {
                return Quantity.QuantityComparator.GREATER_OR_EQUAL;
            }
            case GREATER_THAN: {
                return Quantity.QuantityComparator.GREATER_THAN;
            }
        }
        return Quantity.QuantityComparator.NULL;
    }

    public org.hl7.fhir.r4.model.Range convertRange(Range src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Range tgt = new org.hl7.fhir.r4.model.Range();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setLow(this.convertSimpleQuantity(src.getLow()));
        tgt.setHigh(this.convertSimpleQuantity(src.getHigh()));
        return tgt;
    }

    public Range convertRange(org.hl7.fhir.r4.model.Range src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Range tgt = new Range();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setLow(this.convertSimpleQuantity(src.getLow()));
        tgt.setHigh(this.convertSimpleQuantity(src.getHigh()));
        return tgt;
    }

    public Ratio convertRatio(org.hl7.fhir.instance.model.Ratio src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Ratio tgt = new Ratio();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setNumerator(this.convertQuantity(src.getNumerator()));
        tgt.setDenominator(this.convertQuantity(src.getDenominator()));
        return tgt;
    }

    public org.hl7.fhir.instance.model.Ratio convertRatio(Ratio src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Ratio tgt = new org.hl7.fhir.instance.model.Ratio();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setNumerator(this.convertQuantity(src.getNumerator()));
        tgt.setDenominator(this.convertQuantity(src.getDenominator()));
        return tgt;
    }

    public org.hl7.fhir.r4.model.Reference convertReference(Reference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Reference tgt = new org.hl7.fhir.r4.model.Reference();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setReference(src.getReference());
        tgt.setDisplay(src.getDisplay());
        return tgt;
    }

    public Reference convertReference(org.hl7.fhir.r4.model.Reference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Reference tgt = new Reference();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setReference(src.getReference());
        tgt.setDisplay(src.getDisplay());
        return tgt;
    }

    public SampledData convertSampledData(org.hl7.fhir.instance.model.SampledData src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SampledData tgt = new SampledData();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setOrigin(this.convertSimpleQuantity(src.getOrigin()));
        tgt.setPeriod(src.getPeriod());
        tgt.setFactor(src.getFactor());
        tgt.setLowerLimit(src.getLowerLimit());
        tgt.setUpperLimit(src.getUpperLimit());
        tgt.setDimensions(src.getDimensions());
        tgt.setData(src.getData());
        return tgt;
    }

    public org.hl7.fhir.instance.model.SampledData convertSampledData(SampledData src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.SampledData tgt = new org.hl7.fhir.instance.model.SampledData();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setOrigin(this.convertSimpleQuantity(src.getOrigin()));
        tgt.setPeriod(src.getPeriod());
        tgt.setFactor(src.getFactor());
        tgt.setLowerLimit(src.getLowerLimit());
        tgt.setUpperLimit(src.getUpperLimit());
        tgt.setDimensions(src.getDimensions());
        tgt.setData(src.getData());
        return tgt;
    }

    public org.hl7.fhir.r4.model.Signature convertSignature(Signature src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Signature tgt = new org.hl7.fhir.r4.model.Signature();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (Coding t : src.getType()) {
            tgt.addType(this.convertCoding(t));
        }
        tgt.setWhen(src.getWhen());
        if (src.hasWhoUriType()) {
            tgt.setWho(new org.hl7.fhir.r4.model.Reference((String)src.getWhoUriType().getValue()));
        } else {
            tgt.setWho(this.convertReference(src.getWhoReference()));
        }
        tgt.setSigFormat(src.getContentType());
        tgt.setData(src.getBlob());
        return tgt;
    }

    public Signature convertSignature(org.hl7.fhir.r4.model.Signature src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Signature tgt = new Signature();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (org.hl7.fhir.r4.model.Coding t : src.getType()) {
            tgt.addType(this.convertCoding(t));
        }
        tgt.setWhen(src.getWhen());
        tgt.setWho(this.convertType((Type)src.getWho()));
        tgt.setContentType(src.getSigFormat());
        tgt.setBlob(src.getData());
        return tgt;
    }

    public Address convertAddress(org.hl7.fhir.instance.model.Address src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Address tgt = new Address();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setUse(this.convertAddressUse(src.getUse()));
        tgt.setType(this.convertAddressType(src.getType()));
        tgt.setText(src.getText());
        for (org.hl7.fhir.instance.model.StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        tgt.setCity(src.getCity());
        tgt.setDistrict(src.getDistrict());
        tgt.setState(src.getState());
        tgt.setPostalCode(src.getPostalCode());
        tgt.setCountry(src.getCountry());
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public org.hl7.fhir.instance.model.Address convertAddress(Address src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Address tgt = new org.hl7.fhir.instance.model.Address();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setUse(this.convertAddressUse(src.getUse()));
        tgt.setType(this.convertAddressType(src.getType()));
        tgt.setText(src.getText());
        for (StringType t : src.getLine()) {
            tgt.addLine((String)t.getValue());
        }
        tgt.setCity(src.getCity());
        tgt.setDistrict(src.getDistrict());
        tgt.setState(src.getState());
        tgt.setPostalCode(src.getPostalCode());
        tgt.setCountry(src.getCountry());
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public Address.AddressUse convertAddressUse(Address.AddressUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HOME: {
                return Address.AddressUse.HOME;
            }
            case WORK: {
                return Address.AddressUse.WORK;
            }
            case TEMP: {
                return Address.AddressUse.TEMP;
            }
            case OLD: {
                return Address.AddressUse.OLD;
            }
        }
        return Address.AddressUse.NULL;
    }

    public Address.AddressUse convertAddressUse(Address.AddressUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HOME: {
                return Address.AddressUse.HOME;
            }
            case WORK: {
                return Address.AddressUse.WORK;
            }
            case TEMP: {
                return Address.AddressUse.TEMP;
            }
            case OLD: {
                return Address.AddressUse.OLD;
            }
        }
        return Address.AddressUse.NULL;
    }

    public Address.AddressType convertAddressType(Address.AddressType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case POSTAL: {
                return Address.AddressType.POSTAL;
            }
            case PHYSICAL: {
                return Address.AddressType.PHYSICAL;
            }
            case BOTH: {
                return Address.AddressType.BOTH;
            }
        }
        return Address.AddressType.NULL;
    }

    public Address.AddressType convertAddressType(Address.AddressType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case POSTAL: {
                return Address.AddressType.POSTAL;
            }
            case PHYSICAL: {
                return Address.AddressType.PHYSICAL;
            }
            case BOTH: {
                return Address.AddressType.BOTH;
            }
        }
        return Address.AddressType.NULL;
    }

    public org.hl7.fhir.r4.model.ContactPoint convertContactPoint(ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.ContactPoint tgt = new org.hl7.fhir.r4.model.ContactPoint();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setSystem(this.convertContactPointSystem(src.getSystem()));
        tgt.setValue(src.getValue());
        tgt.setUse(this.convertContactPointUse(src.getUse()));
        if (src.hasRank()) {
            tgt.setRank(src.getRank());
        }
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public ContactPoint convertContactPoint(org.hl7.fhir.r4.model.ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactPoint tgt = new ContactPoint();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        if (src.hasSystem()) {
            tgt.setSystem(this.convertContactPointSystem(src.getSystem()));
        }
        tgt.setValue(src.getValue());
        tgt.setUse(this.convertContactPointUse(src.getUse()));
        tgt.setRank(src.getRank());
        if (src.hasPeriod()) {
            tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        }
        return tgt;
    }

    public ContactPoint.ContactPointSystem convertContactPointSystem(ContactPoint.ContactPointSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PHONE: {
                return ContactPoint.ContactPointSystem.PHONE;
            }
            case FAX: {
                return ContactPoint.ContactPointSystem.FAX;
            }
            case EMAIL: {
                return ContactPoint.ContactPointSystem.EMAIL;
            }
            case PAGER: {
                return ContactPoint.ContactPointSystem.PAGER;
            }
            case OTHER: {
                return ContactPoint.ContactPointSystem.OTHER;
            }
        }
        return ContactPoint.ContactPointSystem.NULL;
    }

    public ContactPoint.ContactPointSystem convertContactPointSystem(ContactPoint.ContactPointSystem src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PHONE: {
                return ContactPoint.ContactPointSystem.PHONE;
            }
            case FAX: {
                return ContactPoint.ContactPointSystem.FAX;
            }
            case EMAIL: {
                return ContactPoint.ContactPointSystem.EMAIL;
            }
            case PAGER: {
                return ContactPoint.ContactPointSystem.PAGER;
            }
            case OTHER: {
                return ContactPoint.ContactPointSystem.OTHER;
            }
            case URL: {
                return ContactPoint.ContactPointSystem.OTHER;
            }
        }
        return ContactPoint.ContactPointSystem.NULL;
    }

    public ContactPoint.ContactPointUse convertContactPointUse(ContactPoint.ContactPointUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HOME: {
                return ContactPoint.ContactPointUse.HOME;
            }
            case WORK: {
                return ContactPoint.ContactPointUse.WORK;
            }
            case TEMP: {
                return ContactPoint.ContactPointUse.TEMP;
            }
            case OLD: {
                return ContactPoint.ContactPointUse.OLD;
            }
            case MOBILE: {
                return ContactPoint.ContactPointUse.MOBILE;
            }
        }
        return ContactPoint.ContactPointUse.NULL;
    }

    public ContactPoint.ContactPointUse convertContactPointUse(ContactPoint.ContactPointUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HOME: {
                return ContactPoint.ContactPointUse.HOME;
            }
            case WORK: {
                return ContactPoint.ContactPointUse.WORK;
            }
            case TEMP: {
                return ContactPoint.ContactPointUse.TEMP;
            }
            case OLD: {
                return ContactPoint.ContactPointUse.OLD;
            }
            case MOBILE: {
                return ContactPoint.ContactPointUse.MOBILE;
            }
        }
        return ContactPoint.ContactPointUse.NULL;
    }

    public ElementDefinition convertElementDefinition(org.hl7.fhir.instance.model.ElementDefinition src, List<String> slicePaths, List<org.hl7.fhir.instance.model.ElementDefinition> context, int pos) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition tgt = new ElementDefinition();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setPath(src.getPath());
        for (Enumeration t : src.getRepresentation()) {
            tgt.addRepresentation(this.convertPropertyRepresentation((ElementDefinition.PropertyRepresentation)t.getValue()));
        }
        if (src.hasName()) {
            if (slicePaths.contains(src.getPath())) {
                tgt.setSliceName(src.getName());
            }
            tgt.setId(src.getName());
        }
        if (src.hasLabel()) {
            tgt.setLabel(src.getLabel());
        }
        for (Enumeration t : src.getCode()) {
            tgt.addCode(this.convertCoding((Coding)t));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(this.convertElementDefinitionSlicingComponent(src.getSlicing(), context, pos));
        }
        if (src.hasShort()) {
            tgt.setShort(src.getShort());
        }
        if (src.hasDefinition()) {
            tgt.setDefinition(src.getDefinition());
        }
        if (src.hasComments()) {
            tgt.setComment(src.getComments());
        }
        if (src.hasRequirements()) {
            tgt.setRequirements(src.getRequirements());
        }
        for (Enumeration t : src.getAlias()) {
            tgt.addAlias((String)t.getValue());
        }
        if (src.hasMin()) {
            tgt.setMin(src.getMin());
        }
        if (src.hasMax()) {
            tgt.setMax(src.getMax());
        }
        if (src.hasBase()) {
            tgt.setBase(this.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasNameReference()) {
            tgt.setContentReference("#" + src.getNameReference());
        }
        for (Enumeration t : src.getType()) {
            this.convertElementDefinitionTypeComponent((ElementDefinition.TypeRefComponent)t, tgt.getType());
        }
        if (src.hasDefaultValue()) {
            tgt.setDefaultValue(this.convertType(src.getDefaultValue()));
        }
        if (src.hasMeaningWhenMissing()) {
            tgt.setMeaningWhenMissing(src.getMeaningWhenMissing());
        }
        if (src.hasFixed()) {
            tgt.setFixed(this.convertType(src.getFixed()));
        }
        if (src.hasPattern()) {
            tgt.setPattern(this.convertType(src.getPattern()));
        }
        if (src.hasExample()) {
            tgt.addExample().setLabel("General").setValue(this.convertType(src.getExample()));
        }
        if (src.hasMinValue()) {
            tgt.setMinValue(this.convertType(src.getMinValue()));
        }
        if (src.hasMaxValue()) {
            tgt.setMaxValue(this.convertType(src.getMaxValue()));
        }
        if (src.hasMaxLength()) {
            tgt.setMaxLength(src.getMaxLength());
        }
        for (Enumeration t : src.getCondition()) {
            tgt.addCondition(t.getValue());
        }
        for (Enumeration t : src.getConstraint()) {
            tgt.addConstraint(this.convertElementDefinitionConstraintComponent((ElementDefinition.ElementDefinitionConstraintComponent)t));
        }
        if (src.hasMustSupport()) {
            tgt.setMustSupport(src.getMustSupport());
        }
        if (src.hasIsModifier()) {
            tgt.setIsModifier(src.getIsModifier());
        }
        if (tgt.getIsModifier()) {
            String reason = ToolingExtensions.readStringExtension((org.hl7.fhir.instance.model.Element)src, (String)"http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.isModifierReason");
            if (Utilities.noString((String)reason)) {
                reason = "No Modifier Reason provideed in previous versions of FHIR";
            }
            tgt.setIsModifierReason(reason);
        }
        if (src.hasIsSummary()) {
            tgt.setIsSummary(src.getIsSummary());
        }
        if (src.hasBinding()) {
            tgt.setBinding(this.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (Enumeration t : src.getMapping()) {
            tgt.addMapping(this.convertElementDefinitionMappingComponent((ElementDefinition.ElementDefinitionMappingComponent)t));
        }
        if (!tgt.hasId()) {
            tgt.setId(tgt.getPath());
        }
        return tgt;
    }

    public org.hl7.fhir.instance.model.ElementDefinition convertElementDefinition(ElementDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.ElementDefinition tgt = new org.hl7.fhir.instance.model.ElementDefinition();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setPath(src.getPath());
        for (org.hl7.fhir.r4.model.Enumeration t : src.getRepresentation()) {
            tgt.addRepresentation(this.convertPropertyRepresentation((ElementDefinition.PropertyRepresentation)t.getValue()));
        }
        if (src.hasSliceName()) {
            tgt.setName(src.getSliceName());
        } else {
            tgt.setName(src.getId());
        }
        tgt.setLabel(src.getLabel());
        for (org.hl7.fhir.r4.model.Enumeration t : src.getCode()) {
            tgt.addCode(this.convertCoding((org.hl7.fhir.r4.model.Coding)t));
        }
        if (src.hasSlicing()) {
            tgt.setSlicing(this.convertElementDefinitionSlicingComponent(src.getSlicing()));
        }
        tgt.setShort(src.getShort());
        tgt.setDefinition(src.getDefinition());
        tgt.setComments(src.getComment());
        tgt.setRequirements(src.getRequirements());
        for (org.hl7.fhir.r4.model.Enumeration t : src.getAlias()) {
            tgt.addAlias((String)t.getValue());
        }
        tgt.setMin(src.getMin());
        tgt.setMax(src.getMax());
        if (src.hasBase()) {
            tgt.setBase(this.convertElementDefinitionBaseComponent(src.getBase()));
        }
        if (src.hasContentReference()) {
            tgt.setNameReference(src.getContentReference().substring(1));
        }
        for (org.hl7.fhir.r4.model.Enumeration t : src.getType()) {
            this.convertElementDefinitionTypeComponent((ElementDefinition.TypeRefComponent)t, tgt.getType());
        }
        tgt.setDefaultValue(this.convertType(src.getDefaultValue()));
        tgt.setMeaningWhenMissing(src.getMeaningWhenMissing());
        tgt.setFixed(this.convertType(src.getFixed()));
        tgt.setPattern(this.convertType(src.getPattern()));
        if (src.hasExample()) {
            tgt.setExample(this.convertType(src.getExampleFirstRep().getValue()));
        }
        tgt.setMinValue(this.convertType(src.getMinValue()));
        tgt.setMaxValue(this.convertType(src.getMaxValue()));
        tgt.setMaxLength(src.getMaxLength());
        for (org.hl7.fhir.r4.model.Enumeration t : src.getCondition()) {
            tgt.addCondition(t.getValue());
        }
        for (org.hl7.fhir.r4.model.Enumeration t : src.getConstraint()) {
            tgt.addConstraint(this.convertElementDefinitionConstraintComponent((ElementDefinition.ElementDefinitionConstraintComponent)t));
        }
        tgt.setMustSupport(src.getMustSupport());
        tgt.setIsModifier(src.getIsModifier());
        if (src.hasIsModifierReason() && !"No Modifier Reason provideed in previous versions of FHIR".equals(src.getIsModifierReason())) {
            ToolingExtensions.setStringExtension((org.hl7.fhir.instance.model.Element)tgt, (String)"http://hl7.org/fhir/4.0/StructureDefinition/extension-ElementDefinition.isModifierReason", (String)src.getIsModifierReason());
        }
        tgt.setIsSummary(src.getIsSummary());
        if (src.hasBinding()) {
            tgt.setBinding(this.convertElementDefinitionBindingComponent(src.getBinding()));
        }
        for (org.hl7.fhir.r4.model.Enumeration t : src.getMapping()) {
            tgt.addMapping(this.convertElementDefinitionMappingComponent((ElementDefinition.ElementDefinitionMappingComponent)t));
        }
        return tgt;
    }

    public ElementDefinition.PropertyRepresentation convertPropertyRepresentation(ElementDefinition.PropertyRepresentation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case XMLATTR: {
                return ElementDefinition.PropertyRepresentation.XMLATTR;
            }
        }
        return ElementDefinition.PropertyRepresentation.NULL;
    }

    public ElementDefinition.PropertyRepresentation convertPropertyRepresentation(ElementDefinition.PropertyRepresentation src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case XMLATTR: {
                return ElementDefinition.PropertyRepresentation.XMLATTR;
            }
        }
        return ElementDefinition.PropertyRepresentation.NULL;
    }

    public ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src, List<org.hl7.fhir.instance.model.ElementDefinition> context, int pos) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        org.hl7.fhir.instance.model.ElementDefinition slicingElement = context.get(pos);
        for (org.hl7.fhir.instance.model.StringType t : src.getDiscriminator()) {
            boolean isExists = false;
            if (!t.asStringValue().contains("@")) {
                int slices = 0;
                boolean existsSlicePresent = false;
                boolean notExistsSlicePresent = false;
                String existsPath = slicingElement.getPath() + "." + t.asStringValue();
                for (int i = pos + 1; i < context.size(); ++i) {
                    org.hl7.fhir.instance.model.ElementDefinition e = context.get(i);
                    if (e.getPath().equals(slicingElement.getPath())) {
                        ++slices;
                        continue;
                    }
                    if (!e.getPath().startsWith(slicingElement.getPath() + ".")) break;
                    if (!e.getPath().equals(existsPath)) continue;
                    if (e.hasMin() && e.getMin() > 0) {
                        existsSlicePresent = true;
                        continue;
                    }
                    if (!e.hasMax() || !e.getMax().equals("0")) continue;
                    notExistsSlicePresent = true;
                }
                isExists = slices == 2 && existsSlicePresent && notExistsSlicePresent || slices == 1 && existsSlicePresent != notExistsSlicePresent;
            }
            tgt.addDiscriminator(ProfileUtilities.interpretR2Discriminator((String)((String)t.getValue()), (boolean)isExists));
        }
        tgt.setDescription(src.getDescription());
        tgt.setOrdered(src.getOrdered());
        tgt.setRules(this.convertSlicingRules(src.getRules()));
        return tgt;
    }

    public ElementDefinition.ElementDefinitionSlicingComponent convertElementDefinitionSlicingComponent(ElementDefinition.ElementDefinitionSlicingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionSlicingComponent tgt = new ElementDefinition.ElementDefinitionSlicingComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent t : src.getDiscriminator()) {
            tgt.addDiscriminator(ProfileUtilities.buildR2Discriminator((ElementDefinition.ElementDefinitionSlicingDiscriminatorComponent)t));
        }
        tgt.setDescription(src.getDescription());
        tgt.setOrdered(src.getOrdered());
        tgt.setRules(this.convertSlicingRules(src.getRules()));
        return tgt;
    }

    public ElementDefinition.SlicingRules convertSlicingRules(ElementDefinition.SlicingRules src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CLOSED: {
                return ElementDefinition.SlicingRules.CLOSED;
            }
            case OPEN: {
                return ElementDefinition.SlicingRules.OPEN;
            }
            case OPENATEND: {
                return ElementDefinition.SlicingRules.OPENATEND;
            }
        }
        return ElementDefinition.SlicingRules.NULL;
    }

    public ElementDefinition.SlicingRules convertSlicingRules(ElementDefinition.SlicingRules src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CLOSED: {
                return ElementDefinition.SlicingRules.CLOSED;
            }
            case OPEN: {
                return ElementDefinition.SlicingRules.OPEN;
            }
            case OPENATEND: {
                return ElementDefinition.SlicingRules.OPENATEND;
            }
        }
        return ElementDefinition.SlicingRules.NULL;
    }

    public ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setPath(src.getPath());
        tgt.setMin(src.getMin());
        tgt.setMax(src.getMax());
        return tgt;
    }

    public ElementDefinition.ElementDefinitionBaseComponent convertElementDefinitionBaseComponent(ElementDefinition.ElementDefinitionBaseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBaseComponent tgt = new ElementDefinition.ElementDefinitionBaseComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setPath(src.getPath());
        tgt.setMin(src.getMin());
        tgt.setMax(src.getMax());
        return tgt;
    }

    public void convertElementDefinitionTypeComponent(ElementDefinition.TypeRefComponent src, List<ElementDefinition.TypeRefComponent> list) throws FHIRException {
        if (src == null) {
            return;
        }
        ElementDefinition.TypeRefComponent tgt = null;
        for (ElementDefinition.TypeRefComponent t : list) {
            if (!t.getCode().equals(src.getCode())) continue;
            tgt = t;
        }
        if (tgt == null) {
            tgt = new ElementDefinition.TypeRefComponent();
            list.add(tgt);
            this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
            tgt.setCode(src.getCode());
        }
        if (tgt.hasTarget()) {
            for (UriType u : src.getProfile()) {
                tgt.addTargetProfile((String)u.getValue());
            }
        } else {
            for (UriType u : src.getProfile()) {
                tgt.addProfile((String)u.getValue());
            }
        }
        for (ElementDefinition.TypeRefComponent t : src.getAggregation()) {
            ElementDefinition.AggregationMode a = this.convertAggregationMode((ElementDefinition.AggregationMode)t.getValue());
            if (tgt.hasAggregation(a)) continue;
            tgt.addAggregation(a);
        }
    }

    public void convertElementDefinitionTypeComponent(ElementDefinition.TypeRefComponent src, List<ElementDefinition.TypeRefComponent> list) throws FHIRException {
        if (src == null) {
            return;
        }
        ElementDefinition.TypeRefComponent tgt = new ElementDefinition.TypeRefComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setCode(src.getCode());
        list.add(tgt);
        if (src.hasTarget()) {
            for (org.hl7.fhir.r4.model.UriType u : src.getTargetProfile()) {
                tgt.addProfile((String)u.getValue());
            }
        } else {
            for (org.hl7.fhir.r4.model.UriType u : src.getProfile()) {
                tgt.addProfile((String)u.getValue());
            }
        }
    }

    public ElementDefinition.AggregationMode convertAggregationMode(ElementDefinition.AggregationMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CONTAINED: {
                return ElementDefinition.AggregationMode.CONTAINED;
            }
            case REFERENCED: {
                return ElementDefinition.AggregationMode.REFERENCED;
            }
            case BUNDLED: {
                return ElementDefinition.AggregationMode.BUNDLED;
            }
        }
        return ElementDefinition.AggregationMode.NULL;
    }

    public ElementDefinition.AggregationMode convertAggregationMode(ElementDefinition.AggregationMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CONTAINED: {
                return ElementDefinition.AggregationMode.CONTAINED;
            }
            case REFERENCED: {
                return ElementDefinition.AggregationMode.REFERENCED;
            }
            case BUNDLED: {
                return ElementDefinition.AggregationMode.BUNDLED;
            }
        }
        return ElementDefinition.AggregationMode.NULL;
    }

    public ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setKey(src.getKey());
        tgt.setRequirements(src.getRequirements());
        tgt.setSeverity(this.convertConstraintSeverity(src.getSeverity()));
        tgt.setHuman(src.getHuman());
        tgt.setExpression(ToolingExtensions.readStringExtension((org.hl7.fhir.instance.model.Element)src, (String)"http://hl7.org/fhir/StructureDefinition/structuredefinition-expression"));
        tgt.setXpath(src.getXpath());
        return tgt;
    }

    public ElementDefinition.ElementDefinitionConstraintComponent convertElementDefinitionConstraintComponent(ElementDefinition.ElementDefinitionConstraintComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionConstraintComponent tgt = new ElementDefinition.ElementDefinitionConstraintComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setKey(src.getKey());
        tgt.setRequirements(src.getRequirements());
        tgt.setSeverity(this.convertConstraintSeverity(src.getSeverity()));
        tgt.setHuman(src.getHuman());
        if (src.hasExpression()) {
            ToolingExtensions.addStringExtension((org.hl7.fhir.instance.model.Element)tgt, (String)"http://hl7.org/fhir/StructureDefinition/structuredefinition-expression", (String)src.getExpression());
        }
        tgt.setXpath(src.getXpath());
        return tgt;
    }

    public ElementDefinition.ConstraintSeverity convertConstraintSeverity(ElementDefinition.ConstraintSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ERROR: {
                return ElementDefinition.ConstraintSeverity.ERROR;
            }
            case WARNING: {
                return ElementDefinition.ConstraintSeverity.WARNING;
            }
        }
        return ElementDefinition.ConstraintSeverity.NULL;
    }

    public ElementDefinition.ConstraintSeverity convertConstraintSeverity(ElementDefinition.ConstraintSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ERROR: {
                return ElementDefinition.ConstraintSeverity.ERROR;
            }
            case WARNING: {
                return ElementDefinition.ConstraintSeverity.WARNING;
            }
        }
        return ElementDefinition.ConstraintSeverity.NULL;
    }

    public ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setStrength(this.convertBindingStrength(src.getStrength()));
        tgt.setDescription(src.getDescription());
        Type vs = this.convertType(src.getValueSet());
        if (vs != null) {
            tgt.setValueSet(vs instanceof org.hl7.fhir.r4.model.Reference ? ((org.hl7.fhir.r4.model.Reference)vs).getReference() : vs.primitiveValue());
            tgt.setValueSet(VersionConvertorConstants.refToVS(tgt.getValueSet()));
        }
        return tgt;
    }

    public ElementDefinition.ElementDefinitionBindingComponent convertElementDefinitionBindingComponent(ElementDefinition.ElementDefinitionBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionBindingComponent tgt = new ElementDefinition.ElementDefinitionBindingComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setStrength(this.convertBindingStrength(src.getStrength()));
        tgt.setDescription(src.getDescription());
        if (src.hasValueSet()) {
            String vsr = VersionConvertorConstants.vsToRef(src.getValueSet());
            if (vsr != null) {
                tgt.setValueSet((org.hl7.fhir.instance.model.Type)new UriType(vsr));
            } else {
                tgt.setValueSet((org.hl7.fhir.instance.model.Type)new Reference(src.getValueSet()));
            }
        }
        return tgt;
    }

    public Enumerations.BindingStrength convertBindingStrength(Enumerations.BindingStrength src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REQUIRED: {
                return Enumerations.BindingStrength.REQUIRED;
            }
            case EXTENSIBLE: {
                return Enumerations.BindingStrength.EXTENSIBLE;
            }
            case PREFERRED: {
                return Enumerations.BindingStrength.PREFERRED;
            }
            case EXAMPLE: {
                return Enumerations.BindingStrength.EXAMPLE;
            }
        }
        return Enumerations.BindingStrength.NULL;
    }

    public Enumerations.BindingStrength convertBindingStrength(Enumerations.BindingStrength src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REQUIRED: {
                return Enumerations.BindingStrength.REQUIRED;
            }
            case EXTENSIBLE: {
                return Enumerations.BindingStrength.EXTENSIBLE;
            }
            case PREFERRED: {
                return Enumerations.BindingStrength.PREFERRED;
            }
            case EXAMPLE: {
                return Enumerations.BindingStrength.EXAMPLE;
            }
        }
        return Enumerations.BindingStrength.NULL;
    }

    public ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setIdentity(src.getIdentity());
        tgt.setLanguage(src.getLanguage());
        tgt.setMap(src.getMap());
        return tgt;
    }

    public ElementDefinition.ElementDefinitionMappingComponent convertElementDefinitionMappingComponent(ElementDefinition.ElementDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ElementDefinition.ElementDefinitionMappingComponent tgt = new ElementDefinition.ElementDefinitionMappingComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setIdentity(src.getIdentity());
        tgt.setLanguage(src.getLanguage());
        tgt.setMap(src.getMap());
        return tgt;
    }

    public org.hl7.fhir.r4.model.HumanName convertHumanName(HumanName src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.HumanName tgt = new org.hl7.fhir.r4.model.HumanName();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setUse(this.convertNameUse(src.getUse()));
        tgt.setText(src.getText());
        for (org.hl7.fhir.instance.model.StringType t : src.getFamily()) {
            tgt.setFamily((String)t.getValue());
        }
        for (org.hl7.fhir.instance.model.StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (org.hl7.fhir.instance.model.StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (org.hl7.fhir.instance.model.StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public HumanName convertHumanName(org.hl7.fhir.r4.model.HumanName src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HumanName tgt = new HumanName();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setUse(this.convertNameUse(src.getUse()));
        tgt.setText(src.getText());
        if (src.hasFamily()) {
            tgt.addFamily(src.getFamily());
        }
        for (StringType t : src.getGiven()) {
            tgt.addGiven((String)t.getValue());
        }
        for (StringType t : src.getPrefix()) {
            tgt.addPrefix((String)t.getValue());
        }
        for (StringType t : src.getSuffix()) {
            tgt.addSuffix((String)t.getValue());
        }
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public HumanName.NameUse convertNameUse(HumanName.NameUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case USUAL: {
                return HumanName.NameUse.USUAL;
            }
            case OFFICIAL: {
                return HumanName.NameUse.OFFICIAL;
            }
            case TEMP: {
                return HumanName.NameUse.TEMP;
            }
            case NICKNAME: {
                return HumanName.NameUse.NICKNAME;
            }
            case ANONYMOUS: {
                return HumanName.NameUse.ANONYMOUS;
            }
            case OLD: {
                return HumanName.NameUse.OLD;
            }
            case MAIDEN: {
                return HumanName.NameUse.MAIDEN;
            }
        }
        return HumanName.NameUse.NULL;
    }

    public HumanName.NameUse convertNameUse(HumanName.NameUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case USUAL: {
                return HumanName.NameUse.USUAL;
            }
            case OFFICIAL: {
                return HumanName.NameUse.OFFICIAL;
            }
            case TEMP: {
                return HumanName.NameUse.TEMP;
            }
            case NICKNAME: {
                return HumanName.NameUse.NICKNAME;
            }
            case ANONYMOUS: {
                return HumanName.NameUse.ANONYMOUS;
            }
            case OLD: {
                return HumanName.NameUse.OLD;
            }
            case MAIDEN: {
                return HumanName.NameUse.MAIDEN;
            }
        }
        return HumanName.NameUse.NULL;
    }

    public Meta convertMeta(org.hl7.fhir.instance.model.Meta src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Meta tgt = new Meta();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setVersionId(src.getVersionId());
        tgt.setLastUpdated(src.getLastUpdated());
        for (UriType t : src.getProfile()) {
            tgt.addProfile((String)t.getValue());
        }
        for (UriType t : src.getSecurity()) {
            tgt.addSecurity(this.convertCoding((Coding)t));
        }
        for (UriType t : src.getTag()) {
            tgt.addTag(this.convertCoding((Coding)t));
        }
        return tgt;
    }

    public org.hl7.fhir.instance.model.Meta convertMeta(Meta src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Meta tgt = new org.hl7.fhir.instance.model.Meta();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setVersionId(src.getVersionId());
        tgt.setLastUpdated(src.getLastUpdated());
        for (org.hl7.fhir.r4.model.UriType t : src.getProfile()) {
            tgt.addProfile((String)t.getValue());
        }
        for (org.hl7.fhir.r4.model.UriType t : src.getSecurity()) {
            tgt.addSecurity(this.convertCoding((org.hl7.fhir.r4.model.Coding)t));
        }
        for (org.hl7.fhir.r4.model.UriType t : src.getTag()) {
            tgt.addTag(this.convertCoding((org.hl7.fhir.r4.model.Coding)t));
        }
        return tgt;
    }

    public Timing convertTiming(org.hl7.fhir.instance.model.Timing src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing tgt = new Timing();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        tgt.setRepeat(this.convertTimingRepeatComponent(src.getRepeat()));
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        return tgt;
    }

    public org.hl7.fhir.instance.model.Timing convertTiming(Timing src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Timing tgt = new org.hl7.fhir.instance.model.Timing();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (org.hl7.fhir.r4.model.DateTimeType t : src.getEvent()) {
            tgt.addEvent((Date)t.getValue());
        }
        tgt.setRepeat(this.convertTimingRepeatComponent(src.getRepeat()));
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        return tgt;
    }

    public Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setBounds(this.convertType(src.getBounds()));
        tgt.setCount(src.getCount());
        tgt.setDuration(src.getDuration());
        tgt.setDurationMax(src.getDurationMax());
        tgt.setDurationUnit(this.convertUnitsOfTime(src.getDurationUnits()));
        tgt.setFrequency(src.getFrequency());
        tgt.setFrequencyMax(src.getFrequencyMax());
        tgt.setPeriod(src.getPeriod());
        tgt.setPeriodMax(src.getPeriodMax());
        tgt.setPeriodUnit(this.convertUnitsOfTime(src.getPeriodUnits()));
        tgt.addWhen(this.convertEventTiming(src.getWhen()));
        return tgt;
    }

    public Timing.TimingRepeatComponent convertTimingRepeatComponent(Timing.TimingRepeatComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Timing.TimingRepeatComponent tgt = new Timing.TimingRepeatComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setBounds(this.convertType(src.getBounds()));
        tgt.setCount(src.getCount());
        tgt.setDuration(src.getDuration());
        tgt.setDurationMax(src.getDurationMax());
        tgt.setDurationUnits(this.convertUnitsOfTime(src.getDurationUnit()));
        tgt.setFrequency(src.getFrequency());
        tgt.setFrequencyMax(src.getFrequencyMax());
        tgt.setPeriod(src.getPeriod());
        tgt.setPeriodMax(src.getPeriodMax());
        tgt.setPeriodUnits(this.convertUnitsOfTime(src.getPeriodUnit()));
        for (org.hl7.fhir.r4.model.Enumeration t : src.getWhen()) {
            tgt.setWhen(this.convertEventTiming((Timing.EventTiming)t.getValue()));
        }
        return tgt;
    }

    public Timing.UnitsOfTime convertUnitsOfTime(Timing.UnitsOfTime src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case S: {
                return Timing.UnitsOfTime.S;
            }
            case MIN: {
                return Timing.UnitsOfTime.MIN;
            }
            case H: {
                return Timing.UnitsOfTime.H;
            }
            case D: {
                return Timing.UnitsOfTime.D;
            }
            case WK: {
                return Timing.UnitsOfTime.WK;
            }
            case MO: {
                return Timing.UnitsOfTime.MO;
            }
            case A: {
                return Timing.UnitsOfTime.A;
            }
        }
        return Timing.UnitsOfTime.NULL;
    }

    public Timing.UnitsOfTime convertUnitsOfTime(Timing.UnitsOfTime src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case S: {
                return Timing.UnitsOfTime.S;
            }
            case MIN: {
                return Timing.UnitsOfTime.MIN;
            }
            case H: {
                return Timing.UnitsOfTime.H;
            }
            case D: {
                return Timing.UnitsOfTime.D;
            }
            case WK: {
                return Timing.UnitsOfTime.WK;
            }
            case MO: {
                return Timing.UnitsOfTime.MO;
            }
            case A: {
                return Timing.UnitsOfTime.A;
            }
        }
        return Timing.UnitsOfTime.NULL;
    }

    public Timing.EventTiming convertEventTiming(Timing.EventTiming src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HS: {
                return Timing.EventTiming.HS;
            }
            case WAKE: {
                return Timing.EventTiming.WAKE;
            }
            case C: {
                return Timing.EventTiming.C;
            }
            case CM: {
                return Timing.EventTiming.CM;
            }
            case CD: {
                return Timing.EventTiming.CD;
            }
            case CV: {
                return Timing.EventTiming.CV;
            }
            case AC: {
                return Timing.EventTiming.AC;
            }
            case ACM: {
                return Timing.EventTiming.ACM;
            }
            case ACD: {
                return Timing.EventTiming.ACD;
            }
            case ACV: {
                return Timing.EventTiming.ACV;
            }
            case PC: {
                return Timing.EventTiming.PC;
            }
            case PCM: {
                return Timing.EventTiming.PCM;
            }
            case PCD: {
                return Timing.EventTiming.PCD;
            }
            case PCV: {
                return Timing.EventTiming.PCV;
            }
        }
        return Timing.EventTiming.NULL;
    }

    public Timing.EventTiming convertEventTiming(Timing.EventTiming src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HS: {
                return Timing.EventTiming.HS;
            }
            case WAKE: {
                return Timing.EventTiming.WAKE;
            }
            case C: {
                return Timing.EventTiming.C;
            }
            case CM: {
                return Timing.EventTiming.CM;
            }
            case CD: {
                return Timing.EventTiming.CD;
            }
            case CV: {
                return Timing.EventTiming.CV;
            }
            case AC: {
                return Timing.EventTiming.AC;
            }
            case ACM: {
                return Timing.EventTiming.ACM;
            }
            case ACD: {
                return Timing.EventTiming.ACD;
            }
            case ACV: {
                return Timing.EventTiming.ACV;
            }
            case PC: {
                return Timing.EventTiming.PC;
            }
            case PCM: {
                return Timing.EventTiming.PCM;
            }
            case PCD: {
                return Timing.EventTiming.PCD;
            }
            case PCV: {
                return Timing.EventTiming.PCV;
            }
        }
        return Timing.EventTiming.NULL;
    }

    public Age convertAge(org.hl7.fhir.instance.model.Age src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Age tgt = new Age();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setValue(src.getValue());
        tgt.setComparator(this.convertQuantityComparator(src.getComparator()));
        tgt.setUnit(src.getUnit());
        tgt.setSystem(src.getSystem());
        tgt.setCode(src.getCode());
        return tgt;
    }

    public org.hl7.fhir.instance.model.Age convertAge(Age src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Age tgt = new org.hl7.fhir.instance.model.Age();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setValue(src.getValue());
        tgt.setComparator(this.convertQuantityComparator(src.getComparator()));
        tgt.setUnit(src.getUnit());
        tgt.setSystem(src.getSystem());
        tgt.setCode(src.getCode());
        return tgt;
    }

    public org.hl7.fhir.r4.model.Count convertCount(Count src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Count tgt = new org.hl7.fhir.r4.model.Count();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setValue(src.getValue());
        tgt.setComparator(this.convertQuantityComparator(src.getComparator()));
        tgt.setUnit(src.getUnit());
        tgt.setSystem(src.getSystem());
        tgt.setCode(src.getCode());
        return tgt;
    }

    public Count convertCount(org.hl7.fhir.r4.model.Count src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Count tgt = new Count();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setValue(src.getValue());
        tgt.setComparator(this.convertQuantityComparator(src.getComparator()));
        tgt.setUnit(src.getUnit());
        tgt.setSystem(src.getSystem());
        tgt.setCode(src.getCode());
        return tgt;
    }

    public Distance convertDistance(org.hl7.fhir.instance.model.Distance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Distance tgt = new Distance();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setValue(src.getValue());
        tgt.setComparator(this.convertQuantityComparator(src.getComparator()));
        tgt.setUnit(src.getUnit());
        tgt.setSystem(src.getSystem());
        tgt.setCode(src.getCode());
        return tgt;
    }

    public org.hl7.fhir.instance.model.Distance convertDistance(Distance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Distance tgt = new org.hl7.fhir.instance.model.Distance();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setValue(src.getValue());
        tgt.setComparator(this.convertQuantityComparator(src.getComparator()));
        tgt.setUnit(src.getUnit());
        tgt.setSystem(src.getSystem());
        tgt.setCode(src.getCode());
        return tgt;
    }

    public Duration convertDuration(org.hl7.fhir.instance.model.Duration src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Duration tgt = new Duration();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setValue(src.getValue());
        tgt.setComparator(this.convertQuantityComparator(src.getComparator()));
        tgt.setUnit(src.getUnit());
        tgt.setSystem(src.getSystem());
        tgt.setCode(src.getCode());
        return tgt;
    }

    public org.hl7.fhir.instance.model.Duration convertDuration(Duration src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Duration tgt = new org.hl7.fhir.instance.model.Duration();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setValue(src.getValue());
        tgt.setComparator(this.convertQuantityComparator(src.getComparator()));
        tgt.setUnit(src.getUnit());
        tgt.setSystem(src.getSystem());
        tgt.setCode(src.getCode());
        return tgt;
    }

    public Money convertMoney(org.hl7.fhir.instance.model.Money src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Money tgt = new Money();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setValue(src.getValue());
        tgt.setCurrency(src.getCode());
        return tgt;
    }

    public org.hl7.fhir.instance.model.Money convertMoney(Money src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Money tgt = new org.hl7.fhir.instance.model.Money();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setValue(src.getValue());
        tgt.setCode(src.getCurrency());
        return tgt;
    }

    public Quantity convertSimpleQuantity(SimpleQuantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.SimpleQuantity tgt = new org.hl7.fhir.r4.model.SimpleQuantity();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setValue(src.getValue());
        tgt.setComparator(this.convertQuantityComparator(src.getComparator()));
        tgt.setUnit(src.getUnit());
        tgt.setSystem(src.getSystem());
        tgt.setCode(src.getCode());
        return tgt;
    }

    public SimpleQuantity convertSimpleQuantity(Quantity src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SimpleQuantity tgt = new SimpleQuantity();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setValue(src.getValue());
        tgt.setComparator(this.convertQuantityComparator(src.getComparator()));
        tgt.setUnit(src.getUnit());
        tgt.setSystem(src.getSystem());
        tgt.setCode(src.getCode());
        return tgt;
    }

    public Type convertType(org.hl7.fhir.instance.model.Type src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof Base64BinaryType) {
            return this.convertBase64Binary((Base64BinaryType)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.BooleanType) {
            return this.convertBoolean((org.hl7.fhir.instance.model.BooleanType)src);
        }
        if (src instanceof CodeType) {
            return this.convertCode((CodeType)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.DateType) {
            return this.convertDate((org.hl7.fhir.instance.model.DateType)src);
        }
        if (src instanceof DateTimeType) {
            return this.convertDateTime((DateTimeType)src);
        }
        if (src instanceof DecimalType) {
            return this.convertDecimal((DecimalType)src);
        }
        if (src instanceof IdType) {
            return this.convertId((IdType)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.InstantType) {
            return this.convertInstant((org.hl7.fhir.instance.model.InstantType)src);
        }
        if (src instanceof IntegerType) {
            return this.convertInteger((IntegerType)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.MarkdownType) {
            return this.convertMarkdown((org.hl7.fhir.instance.model.MarkdownType)src);
        }
        if (src instanceof OidType) {
            return this.convertOid((OidType)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.PositiveIntType) {
            return this.convertPositiveInt((org.hl7.fhir.instance.model.PositiveIntType)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.StringType) {
            return this.convertString((org.hl7.fhir.instance.model.StringType)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.TimeType) {
            return this.convertTime((org.hl7.fhir.instance.model.TimeType)src);
        }
        if (src instanceof UnsignedIntType) {
            return this.convertUnsignedInt((UnsignedIntType)src);
        }
        if (src instanceof UriType) {
            return this.convertUri((UriType)src);
        }
        if (src instanceof UuidType) {
            return this.convertUuid((UuidType)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Extension) {
            return this.convertExtension((org.hl7.fhir.instance.model.Extension)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Narrative) {
            return this.convertNarrative((org.hl7.fhir.instance.model.Narrative)src);
        }
        if (src instanceof Annotation) {
            return this.convertAnnotation((Annotation)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Attachment) {
            return this.convertAttachment((org.hl7.fhir.instance.model.Attachment)src);
        }
        if (src instanceof CodeableConcept) {
            return this.convertCodeableConcept((CodeableConcept)src);
        }
        if (src instanceof Coding) {
            return this.convertCoding((Coding)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Identifier) {
            return this.convertIdentifier((org.hl7.fhir.instance.model.Identifier)src);
        }
        if (src instanceof Period) {
            return this.convertPeriod((Period)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Quantity) {
            return this.convertQuantity((org.hl7.fhir.instance.model.Quantity)src);
        }
        if (src instanceof Range) {
            return this.convertRange((Range)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Ratio) {
            return this.convertRatio((org.hl7.fhir.instance.model.Ratio)src);
        }
        if (src instanceof Reference) {
            return this.convertReference((Reference)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.SampledData) {
            return this.convertSampledData((org.hl7.fhir.instance.model.SampledData)src);
        }
        if (src instanceof Signature) {
            return this.convertSignature((Signature)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Address) {
            return this.convertAddress((org.hl7.fhir.instance.model.Address)src);
        }
        if (src instanceof ContactPoint) {
            return this.convertContactPoint((ContactPoint)src);
        }
        if (src instanceof HumanName) {
            return this.convertHumanName((HumanName)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Meta) {
            return this.convertMeta((org.hl7.fhir.instance.model.Meta)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Timing) {
            return this.convertTiming((org.hl7.fhir.instance.model.Timing)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Age) {
            return this.convertAge((org.hl7.fhir.instance.model.Age)src);
        }
        if (src instanceof Count) {
            return this.convertCount((Count)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Distance) {
            return this.convertDistance((org.hl7.fhir.instance.model.Distance)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Duration) {
            return this.convertDuration((org.hl7.fhir.instance.model.Duration)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Money) {
            return this.convertMoney((org.hl7.fhir.instance.model.Money)src);
        }
        if (src instanceof SimpleQuantity) {
            return this.convertSimpleQuantity((SimpleQuantity)src);
        }
        throw new FHIRException("Unknown type " + src.fhirType());
    }

    public org.hl7.fhir.instance.model.Type convertType(Type src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof org.hl7.fhir.r4.model.Base64BinaryType) {
            return this.convertBase64Binary((org.hl7.fhir.r4.model.Base64BinaryType)src);
        }
        if (src instanceof BooleanType) {
            return this.convertBoolean((BooleanType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CodeType) {
            return this.convertCode((org.hl7.fhir.r4.model.CodeType)src);
        }
        if (src instanceof DateType) {
            return this.convertDate((DateType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.DateTimeType) {
            return this.convertDateTime((org.hl7.fhir.r4.model.DateTimeType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.DecimalType) {
            return this.convertDecimal((org.hl7.fhir.r4.model.DecimalType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.IdType) {
            return this.convertId((org.hl7.fhir.r4.model.IdType)src);
        }
        if (src instanceof InstantType) {
            return this.convertInstant((InstantType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.IntegerType) {
            return this.convertInteger((org.hl7.fhir.r4.model.IntegerType)src);
        }
        if (src instanceof MarkdownType) {
            return this.convertMarkdown((MarkdownType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.OidType) {
            return this.convertOid((org.hl7.fhir.r4.model.OidType)src);
        }
        if (src instanceof PositiveIntType) {
            return this.convertPositiveInt((PositiveIntType)src);
        }
        if (src instanceof StringType) {
            return this.convertString((StringType)src);
        }
        if (src instanceof TimeType) {
            return this.convertTime((TimeType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.UnsignedIntType) {
            return this.convertUnsignedInt((org.hl7.fhir.r4.model.UnsignedIntType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.UriType) {
            return this.convertUri((org.hl7.fhir.r4.model.UriType)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.UuidType) {
            return this.convertUuid((org.hl7.fhir.r4.model.UuidType)src);
        }
        if (src instanceof Extension) {
            return this.convertExtension((Extension)src);
        }
        if (src instanceof Narrative) {
            return this.convertNarrative((Narrative)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Annotation) {
            return this.convertAnnotation((org.hl7.fhir.r4.model.Annotation)src);
        }
        if (src instanceof Attachment) {
            return this.convertAttachment((Attachment)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CodeableConcept) {
            return this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Coding) {
            return this.convertCoding((org.hl7.fhir.r4.model.Coding)src);
        }
        if (src instanceof Identifier) {
            return this.convertIdentifier((Identifier)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Period) {
            return this.convertPeriod((org.hl7.fhir.r4.model.Period)src);
        }
        if (src instanceof Quantity) {
            return this.convertQuantity((Quantity)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Range) {
            return this.convertRange((org.hl7.fhir.r4.model.Range)src);
        }
        if (src instanceof Ratio) {
            return this.convertRatio((Ratio)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Reference) {
            return this.convertReference((org.hl7.fhir.r4.model.Reference)src);
        }
        if (src instanceof SampledData) {
            return this.convertSampledData((SampledData)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Signature) {
            return this.convertSignature((org.hl7.fhir.r4.model.Signature)src);
        }
        if (src instanceof Address) {
            return this.convertAddress((Address)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ContactPoint) {
            return this.convertContactPoint((org.hl7.fhir.r4.model.ContactPoint)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.HumanName) {
            return this.convertHumanName((org.hl7.fhir.r4.model.HumanName)src);
        }
        if (src instanceof Meta) {
            return this.convertMeta((Meta)src);
        }
        if (src instanceof Timing) {
            return this.convertTiming((Timing)src);
        }
        if (src instanceof Age) {
            return this.convertAge((Age)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Count) {
            return this.convertCount((org.hl7.fhir.r4.model.Count)src);
        }
        if (src instanceof Distance) {
            return this.convertDistance((Distance)src);
        }
        if (src instanceof Duration) {
            return this.convertDuration((Duration)src);
        }
        if (src instanceof Money) {
            return this.convertMoney((Money)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.SimpleQuantity) {
            return this.convertSimpleQuantity((Quantity)((org.hl7.fhir.r4.model.SimpleQuantity)src));
        }
        throw new FHIRException("Unknown type " + src.fhirType());
    }

    public void copyDomainResource(DomainResource src, org.hl7.fhir.r4.model.DomainResource tgt) throws FHIRException {
        this.copyResource((org.hl7.fhir.instance.model.Resource)src, (Resource)tgt);
        tgt.setText(this.convertNarrative(src.getText()));
        for (org.hl7.fhir.instance.model.Resource t : src.getContained()) {
            tgt.addContained(this.convertResource(t));
        }
        for (org.hl7.fhir.instance.model.Resource t : src.getExtension()) {
            tgt.addExtension(this.convertExtension((org.hl7.fhir.instance.model.Extension)t));
        }
        for (org.hl7.fhir.instance.model.Resource t : src.getModifierExtension()) {
            tgt.addModifierExtension(this.convertExtension((org.hl7.fhir.instance.model.Extension)t));
        }
    }

    public void copyDomainResource(org.hl7.fhir.r4.model.DomainResource src, DomainResource tgt) throws FHIRException {
        this.copyResource((Resource)src, (org.hl7.fhir.instance.model.Resource)tgt);
        tgt.setText(this.convertNarrative(src.getText()));
        for (Resource t : src.getContained()) {
            tgt.addContained(this.convertResource(t));
        }
        for (Resource t : src.getExtension()) {
            tgt.addExtension(this.convertExtension((Extension)t));
        }
        for (Resource t : src.getModifierExtension()) {
            tgt.addModifierExtension(this.convertExtension((Extension)t));
        }
    }

    public org.hl7.fhir.r4.model.Parameters convertParameters(Parameters src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Parameters tgt = new org.hl7.fhir.r4.model.Parameters();
        this.copyResource((org.hl7.fhir.instance.model.Resource)src, (Resource)tgt);
        for (Parameters.ParametersParameterComponent t : src.getParameter()) {
            tgt.addParameter(this.convertParametersParameterComponent(t));
        }
        return tgt;
    }

    public Parameters convertParameters(org.hl7.fhir.r4.model.Parameters src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Parameters tgt = new Parameters();
        this.copyResource((Resource)src, (org.hl7.fhir.instance.model.Resource)tgt);
        for (Parameters.ParametersParameterComponent t : src.getParameter()) {
            tgt.addParameter(this.convertParametersParameterComponent(t));
        }
        return tgt;
    }

    public Parameters.ParametersParameterComponent convertParametersParameterComponent(Parameters.ParametersParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Parameters.ParametersParameterComponent tgt = new Parameters.ParametersParameterComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        tgt.setValue(this.convertType(src.getValue()));
        tgt.setResource(this.convertResource(src.getResource()));
        for (Parameters.ParametersParameterComponent t : src.getPart()) {
            tgt.addPart(this.convertParametersParameterComponent(t));
        }
        return tgt;
    }

    public Parameters.ParametersParameterComponent convertParametersParameterComponent(Parameters.ParametersParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Parameters.ParametersParameterComponent tgt = new Parameters.ParametersParameterComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        tgt.setValue(this.convertType(src.getValue()));
        tgt.setResource(this.convertResource(src.getResource()));
        for (Parameters.ParametersParameterComponent t : src.getPart()) {
            tgt.addPart(this.convertParametersParameterComponent(t));
        }
        return tgt;
    }

    public void copyResource(org.hl7.fhir.instance.model.Resource src, Resource tgt) throws FHIRException {
        tgt.setId(src.getId());
        tgt.setMeta(this.convertMeta(src.getMeta()));
        tgt.setImplicitRules(src.getImplicitRules());
        tgt.setLanguage(src.getLanguage());
    }

    public void copyResource(Resource src, org.hl7.fhir.instance.model.Resource tgt) throws FHIRException {
        tgt.setId(src.getId());
        if (src.hasMeta()) {
            tgt.setMeta(this.convertMeta(src.getMeta()));
        }
        if (src.hasImplicitRules()) {
            tgt.setImplicitRules(src.getImplicitRules());
        }
        if (src.hasLanguage()) {
            tgt.setLanguage(src.getLanguage());
        }
    }

    public Enumerations.AdministrativeGender convertAdministrativeGender(Enumerations.AdministrativeGender src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MALE: {
                return Enumerations.AdministrativeGender.MALE;
            }
            case FEMALE: {
                return Enumerations.AdministrativeGender.FEMALE;
            }
            case OTHER: {
                return Enumerations.AdministrativeGender.OTHER;
            }
            case UNKNOWN: {
                return Enumerations.AdministrativeGender.UNKNOWN;
            }
        }
        return Enumerations.AdministrativeGender.NULL;
    }

    public Enumerations.AdministrativeGender convertAdministrativeGender(Enumerations.AdministrativeGender src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MALE: {
                return Enumerations.AdministrativeGender.MALE;
            }
            case FEMALE: {
                return Enumerations.AdministrativeGender.FEMALE;
            }
            case OTHER: {
                return Enumerations.AdministrativeGender.OTHER;
            }
            case UNKNOWN: {
                return Enumerations.AdministrativeGender.UNKNOWN;
            }
        }
        return Enumerations.AdministrativeGender.NULL;
    }

    public Enumerations.SearchParamType convertSearchParamType(Enumerations.SearchParamType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NUMBER: {
                return Enumerations.SearchParamType.NUMBER;
            }
            case DATE: {
                return Enumerations.SearchParamType.DATE;
            }
            case STRING: {
                return Enumerations.SearchParamType.STRING;
            }
            case TOKEN: {
                return Enumerations.SearchParamType.TOKEN;
            }
            case REFERENCE: {
                return Enumerations.SearchParamType.REFERENCE;
            }
            case COMPOSITE: {
                return Enumerations.SearchParamType.COMPOSITE;
            }
            case QUANTITY: {
                return Enumerations.SearchParamType.QUANTITY;
            }
            case URI: {
                return Enumerations.SearchParamType.URI;
            }
        }
        return Enumerations.SearchParamType.NULL;
    }

    public Enumerations.SearchParamType convertSearchParamType(Enumerations.SearchParamType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NUMBER: {
                return Enumerations.SearchParamType.NUMBER;
            }
            case DATE: {
                return Enumerations.SearchParamType.DATE;
            }
            case STRING: {
                return Enumerations.SearchParamType.STRING;
            }
            case TOKEN: {
                return Enumerations.SearchParamType.TOKEN;
            }
            case REFERENCE: {
                return Enumerations.SearchParamType.REFERENCE;
            }
            case COMPOSITE: {
                return Enumerations.SearchParamType.COMPOSITE;
            }
            case QUANTITY: {
                return Enumerations.SearchParamType.QUANTITY;
            }
            case URI: {
                return Enumerations.SearchParamType.URI;
            }
        }
        return Enumerations.SearchParamType.NULL;
    }

    public Appointment convertAppointment(org.hl7.fhir.instance.model.Appointment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Appointment tgt = new Appointment();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setStatus(this.convertAppointmentStatus(src.getStatus()));
        if (src.hasType()) {
            tgt.addServiceType(this.convertCodeableConcept(src.getType()));
        }
        tgt.setPriority(src.getPriority());
        tgt.setDescription(src.getDescription());
        tgt.setStart(src.getStart());
        tgt.setEnd(src.getEnd());
        tgt.setMinutesDuration(src.getMinutesDuration());
        for (org.hl7.fhir.instance.model.Identifier t : src.getSlot()) {
            tgt.addSlot(this.convertReference((Reference)t));
        }
        tgt.setComment(src.getComment());
        for (org.hl7.fhir.instance.model.Identifier t : src.getParticipant()) {
            tgt.addParticipant(this.convertAppointmentParticipantComponent((Appointment.AppointmentParticipantComponent)t));
        }
        return tgt;
    }

    public org.hl7.fhir.instance.model.Appointment convertAppointment(Appointment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Appointment tgt = new org.hl7.fhir.instance.model.Appointment();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setStatus(this.convertAppointmentStatus(src.getStatus()));
        for (Identifier t : src.getServiceType()) {
            tgt.setType(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setPriority(src.getPriority());
        tgt.setDescription(src.getDescription());
        tgt.setStart(src.getStart());
        tgt.setEnd(src.getEnd());
        tgt.setMinutesDuration(src.getMinutesDuration());
        for (Identifier t : src.getSlot()) {
            tgt.addSlot(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        tgt.setComment(src.getComment());
        for (Identifier t : src.getParticipant()) {
            tgt.addParticipant(this.convertAppointmentParticipantComponent((Appointment.AppointmentParticipantComponent)t));
        }
        return tgt;
    }

    public Appointment.AppointmentStatus convertAppointmentStatus(Appointment.AppointmentStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PROPOSED: {
                return Appointment.AppointmentStatus.PROPOSED;
            }
            case PENDING: {
                return Appointment.AppointmentStatus.PENDING;
            }
            case BOOKED: {
                return Appointment.AppointmentStatus.BOOKED;
            }
            case ARRIVED: {
                return Appointment.AppointmentStatus.ARRIVED;
            }
            case FULFILLED: {
                return Appointment.AppointmentStatus.FULFILLED;
            }
            case CANCELLED: {
                return Appointment.AppointmentStatus.CANCELLED;
            }
            case NOSHOW: {
                return Appointment.AppointmentStatus.NOSHOW;
            }
        }
        return Appointment.AppointmentStatus.NULL;
    }

    public Appointment.AppointmentStatus convertAppointmentStatus(Appointment.AppointmentStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PROPOSED: {
                return Appointment.AppointmentStatus.PROPOSED;
            }
            case PENDING: {
                return Appointment.AppointmentStatus.PENDING;
            }
            case BOOKED: {
                return Appointment.AppointmentStatus.BOOKED;
            }
            case ARRIVED: {
                return Appointment.AppointmentStatus.ARRIVED;
            }
            case FULFILLED: {
                return Appointment.AppointmentStatus.FULFILLED;
            }
            case CANCELLED: {
                return Appointment.AppointmentStatus.CANCELLED;
            }
            case NOSHOW: {
                return Appointment.AppointmentStatus.NOSHOW;
            }
        }
        return Appointment.AppointmentStatus.NULL;
    }

    public Appointment.AppointmentParticipantComponent convertAppointmentParticipantComponent(Appointment.AppointmentParticipantComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Appointment.AppointmentParticipantComponent tgt = new Appointment.AppointmentParticipantComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (CodeableConcept t : src.getType()) {
            tgt.addType(this.convertCodeableConcept(t));
        }
        tgt.setActor(this.convertReference(src.getActor()));
        tgt.setRequired(this.convertParticipantRequired(src.getRequired()));
        tgt.setStatus(this.convertParticipationStatus(src.getStatus()));
        return tgt;
    }

    public Appointment.AppointmentParticipantComponent convertAppointmentParticipantComponent(Appointment.AppointmentParticipantComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Appointment.AppointmentParticipantComponent tgt = new Appointment.AppointmentParticipantComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getType()) {
            tgt.addType(this.convertCodeableConcept(t));
        }
        tgt.setActor(this.convertReference(src.getActor()));
        tgt.setRequired(this.convertParticipantRequired(src.getRequired()));
        tgt.setStatus(this.convertParticipationStatus(src.getStatus()));
        return tgt;
    }

    public Appointment.ParticipantRequired convertParticipantRequired(Appointment.ParticipantRequired src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REQUIRED: {
                return Appointment.ParticipantRequired.REQUIRED;
            }
            case OPTIONAL: {
                return Appointment.ParticipantRequired.OPTIONAL;
            }
            case INFORMATIONONLY: {
                return Appointment.ParticipantRequired.INFORMATIONONLY;
            }
        }
        return Appointment.ParticipantRequired.NULL;
    }

    public Appointment.ParticipantRequired convertParticipantRequired(Appointment.ParticipantRequired src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REQUIRED: {
                return Appointment.ParticipantRequired.REQUIRED;
            }
            case OPTIONAL: {
                return Appointment.ParticipantRequired.OPTIONAL;
            }
            case INFORMATIONONLY: {
                return Appointment.ParticipantRequired.INFORMATIONONLY;
            }
        }
        return Appointment.ParticipantRequired.NULL;
    }

    public Appointment.ParticipationStatus convertParticipationStatus(Appointment.ParticipationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACCEPTED: {
                return Appointment.ParticipationStatus.ACCEPTED;
            }
            case DECLINED: {
                return Appointment.ParticipationStatus.DECLINED;
            }
            case TENTATIVE: {
                return Appointment.ParticipationStatus.TENTATIVE;
            }
            case NEEDSACTION: {
                return Appointment.ParticipationStatus.NEEDSACTION;
            }
        }
        return Appointment.ParticipationStatus.NULL;
    }

    public Appointment.ParticipationStatus convertParticipationStatus(Appointment.ParticipationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACCEPTED: {
                return Appointment.ParticipationStatus.ACCEPTED;
            }
            case DECLINED: {
                return Appointment.ParticipationStatus.DECLINED;
            }
            case TENTATIVE: {
                return Appointment.ParticipationStatus.TENTATIVE;
            }
            case NEEDSACTION: {
                return Appointment.ParticipationStatus.NEEDSACTION;
            }
        }
        return Appointment.ParticipationStatus.NULL;
    }

    public AppointmentResponse convertAppointmentResponse(org.hl7.fhir.instance.model.AppointmentResponse src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AppointmentResponse tgt = new AppointmentResponse();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setAppointment(this.convertReference(src.getAppointment()));
        tgt.setStart(src.getStart());
        tgt.setEnd(src.getEnd());
        for (org.hl7.fhir.instance.model.Identifier t : src.getParticipantType()) {
            tgt.addParticipantType(this.convertCodeableConcept((CodeableConcept)t));
        }
        tgt.setActor(this.convertReference(src.getActor()));
        tgt.setParticipantStatus(this.convertParticipantStatus(src.getParticipantStatus()));
        tgt.setComment(src.getComment());
        return tgt;
    }

    private AppointmentResponse.ParticipantStatus convertParticipantStatus(AppointmentResponse.ParticipantStatus src) {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACCEPTED: {
                return AppointmentResponse.ParticipantStatus.ACCEPTED;
            }
            case DECLINED: {
                return AppointmentResponse.ParticipantStatus.DECLINED;
            }
            case TENTATIVE: {
                return AppointmentResponse.ParticipantStatus.TENTATIVE;
            }
            case INPROCESS: {
                return AppointmentResponse.ParticipantStatus.ACCEPTED;
            }
            case COMPLETED: {
                return AppointmentResponse.ParticipantStatus.ACCEPTED;
            }
            case NEEDSACTION: {
                return AppointmentResponse.ParticipantStatus.NEEDSACTION;
            }
        }
        return AppointmentResponse.ParticipantStatus.NULL;
    }

    private AppointmentResponse.ParticipantStatus convertParticipantStatus(AppointmentResponse.ParticipantStatus src) {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACCEPTED: {
                return AppointmentResponse.ParticipantStatus.ACCEPTED;
            }
            case DECLINED: {
                return AppointmentResponse.ParticipantStatus.DECLINED;
            }
            case TENTATIVE: {
                return AppointmentResponse.ParticipantStatus.TENTATIVE;
            }
            case NEEDSACTION: {
                return AppointmentResponse.ParticipantStatus.NEEDSACTION;
            }
        }
        return AppointmentResponse.ParticipantStatus.NULL;
    }

    public org.hl7.fhir.instance.model.AppointmentResponse convertAppointmentResponse(AppointmentResponse src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.AppointmentResponse tgt = new org.hl7.fhir.instance.model.AppointmentResponse();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setAppointment(this.convertReference(src.getAppointment()));
        tgt.setStart(src.getStart());
        tgt.setEnd(src.getEnd());
        for (Identifier t : src.getParticipantType()) {
            tgt.addParticipantType(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setActor(this.convertReference(src.getActor()));
        tgt.setParticipantStatus(this.convertParticipantStatus(src.getParticipantStatus()));
        tgt.setComment(src.getComment());
        return tgt;
    }

    public org.hl7.fhir.r4.model.AuditEvent convertAuditEvent(AuditEvent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.AuditEvent tgt = new org.hl7.fhir.r4.model.AuditEvent();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasEvent()) {
            tgt.setType(this.convertCoding(src.getEvent().getType()));
            for (AuditEvent.AuditEventParticipantComponent t : src.getEvent().getSubtype()) {
                tgt.addSubtype(this.convertCoding((Coding)t));
            }
            tgt.setAction(this.convertAuditEventAction(src.getEvent().getAction()));
            tgt.setRecorded(src.getEvent().getDateTime());
            tgt.setOutcome(this.convertAuditEventOutcome(src.getEvent().getOutcome()));
            tgt.setOutcomeDesc(src.getEvent().getOutcomeDesc());
            for (AuditEvent.AuditEventParticipantComponent t : src.getEvent().getPurposeOfEvent()) {
                tgt.addPurposeOfEvent().addCoding(this.convertCoding((Coding)t));
            }
        }
        for (AuditEvent.AuditEventParticipantComponent t : src.getParticipant()) {
            tgt.addAgent(this.convertAuditEventAgentComponent(t));
        }
        tgt.setSource(this.convertAuditEventSourceComponent(src.getSource()));
        for (AuditEvent.AuditEventParticipantComponent t : src.getObject()) {
            tgt.addEntity(this.convertAuditEventEntityComponent((AuditEvent.AuditEventObjectComponent)t));
        }
        return tgt;
    }

    public AuditEvent convertAuditEvent(org.hl7.fhir.r4.model.AuditEvent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent tgt = new AuditEvent();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.getEvent().setType(this.convertCoding(src.getType()));
        for (org.hl7.fhir.r4.model.Coding t : src.getSubtype()) {
            tgt.getEvent().addSubtype(this.convertCoding(t));
        }
        tgt.getEvent().setAction(this.convertAuditEventAction(src.getAction()));
        tgt.getEvent().setDateTime(src.getRecorded());
        tgt.getEvent().setOutcome(this.convertAuditEventOutcome(src.getOutcome()));
        tgt.getEvent().setOutcomeDesc(src.getOutcomeDesc());
        for (org.hl7.fhir.r4.model.Coding t : src.getPurposeOfEvent()) {
            for (org.hl7.fhir.r4.model.Coding cc : t.getCoding()) {
                tgt.getEvent().addPurposeOfEvent(this.convertCoding(cc));
            }
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getAgent()) {
            tgt.addParticipant(this.convertAuditEventAgentComponent((AuditEvent.AuditEventAgentComponent)t));
        }
        tgt.setSource(this.convertAuditEventSourceComponent(src.getSource()));
        for (org.hl7.fhir.r4.model.Coding t : src.getEntity()) {
            tgt.addObject(this.convertAuditEventEntityComponent((AuditEvent.AuditEventEntityComponent)t));
        }
        return tgt;
    }

    public AuditEvent.AuditEventAction convertAuditEventAction(AuditEvent.AuditEventAction src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case C: {
                return AuditEvent.AuditEventAction.C;
            }
            case R: {
                return AuditEvent.AuditEventAction.R;
            }
            case U: {
                return AuditEvent.AuditEventAction.U;
            }
            case D: {
                return AuditEvent.AuditEventAction.D;
            }
            case E: {
                return AuditEvent.AuditEventAction.E;
            }
        }
        return AuditEvent.AuditEventAction.NULL;
    }

    public AuditEvent.AuditEventAction convertAuditEventAction(AuditEvent.AuditEventAction src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case C: {
                return AuditEvent.AuditEventAction.C;
            }
            case R: {
                return AuditEvent.AuditEventAction.R;
            }
            case U: {
                return AuditEvent.AuditEventAction.U;
            }
            case D: {
                return AuditEvent.AuditEventAction.D;
            }
            case E: {
                return AuditEvent.AuditEventAction.E;
            }
        }
        return AuditEvent.AuditEventAction.NULL;
    }

    public AuditEvent.AuditEventOutcome convertAuditEventOutcome(AuditEvent.AuditEventOutcome src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case _0: {
                return AuditEvent.AuditEventOutcome._0;
            }
            case _4: {
                return AuditEvent.AuditEventOutcome._4;
            }
            case _8: {
                return AuditEvent.AuditEventOutcome._8;
            }
            case _12: {
                return AuditEvent.AuditEventOutcome._12;
            }
        }
        return AuditEvent.AuditEventOutcome.NULL;
    }

    public AuditEvent.AuditEventOutcome convertAuditEventOutcome(AuditEvent.AuditEventOutcome src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case _0: {
                return AuditEvent.AuditEventOutcome._0;
            }
            case _4: {
                return AuditEvent.AuditEventOutcome._4;
            }
            case _8: {
                return AuditEvent.AuditEventOutcome._8;
            }
            case _12: {
                return AuditEvent.AuditEventOutcome._12;
            }
        }
        return AuditEvent.AuditEventOutcome.NULL;
    }

    public AuditEvent.AuditEventAgentComponent convertAuditEventAgentComponent(AuditEvent.AuditEventParticipantComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventAgentComponent tgt = new AuditEvent.AuditEventAgentComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (CodeableConcept t : src.getRole()) {
            tgt.addRole(this.convertCodeableConcept(t));
        }
        tgt.setWho(this.convertReference(src.getReference()));
        if (src.hasUserId()) {
            tgt.getWho().setIdentifier(this.convertIdentifier(src.getUserId()));
        }
        tgt.setAltId(src.getAltId());
        tgt.setName(src.getName());
        tgt.setRequestor(src.getRequestor());
        tgt.setLocation(this.convertReference(src.getLocation()));
        for (CodeableConcept t : src.getPolicy()) {
            tgt.addPolicy((String)t.getValue());
        }
        tgt.setMedia(this.convertCoding(src.getMedia()));
        tgt.setNetwork(this.convertAuditEventAgentNetworkComponent(src.getNetwork()));
        for (CodeableConcept t : src.getPurposeOfUse()) {
            tgt.addPurposeOfUse().addCoding(this.convertCoding((Coding)t));
        }
        return tgt;
    }

    public AuditEvent.AuditEventParticipantComponent convertAuditEventAgentComponent(AuditEvent.AuditEventAgentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventParticipantComponent tgt = new AuditEvent.AuditEventParticipantComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getRole()) {
            tgt.addRole(this.convertCodeableConcept(t));
        }
        if (src.hasWho()) {
            if (src.getWho().hasIdentifier()) {
                tgt.setUserId(this.convertIdentifier(src.getWho().getIdentifier()));
            }
            if (src.getWho().hasReference() || src.getWho().hasDisplay() || src.getWho().hasExtension() || src.getWho().hasId()) {
                tgt.setReference(this.convertReference(src.getWho()));
            }
        }
        tgt.setAltId(src.getAltId());
        tgt.setName(src.getName());
        tgt.setRequestor(src.getRequestor());
        tgt.setLocation(this.convertReference(src.getLocation()));
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getPolicy()) {
            tgt.addPolicy((String)t.getValue());
        }
        tgt.setMedia(this.convertCoding(src.getMedia()));
        tgt.setNetwork(this.convertAuditEventAgentNetworkComponent(src.getNetwork()));
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getPurposeOfUse()) {
            for (org.hl7.fhir.r4.model.Coding cc : t.getCoding()) {
                tgt.addPurposeOfUse(this.convertCoding(cc));
            }
        }
        return tgt;
    }

    public AuditEvent.AuditEventAgentNetworkComponent convertAuditEventAgentNetworkComponent(AuditEvent.AuditEventParticipantNetworkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventAgentNetworkComponent tgt = new AuditEvent.AuditEventAgentNetworkComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setAddress(src.getAddress());
        tgt.setType(this.convertAuditEventParticipantNetworkType(src.getType()));
        return tgt;
    }

    public AuditEvent.AuditEventParticipantNetworkComponent convertAuditEventAgentNetworkComponent(AuditEvent.AuditEventAgentNetworkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventParticipantNetworkComponent tgt = new AuditEvent.AuditEventParticipantNetworkComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setAddress(src.getAddress());
        tgt.setType(this.convertAuditEventParticipantNetworkType(src.getType()));
        return tgt;
    }

    public AuditEvent.AuditEventAgentNetworkType convertAuditEventParticipantNetworkType(AuditEvent.AuditEventParticipantNetworkType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case _1: {
                return AuditEvent.AuditEventAgentNetworkType._1;
            }
            case _2: {
                return AuditEvent.AuditEventAgentNetworkType._2;
            }
            case _3: {
                return AuditEvent.AuditEventAgentNetworkType._3;
            }
            case _4: {
                return AuditEvent.AuditEventAgentNetworkType._4;
            }
            case _5: {
                return AuditEvent.AuditEventAgentNetworkType._5;
            }
        }
        return AuditEvent.AuditEventAgentNetworkType.NULL;
    }

    public AuditEvent.AuditEventParticipantNetworkType convertAuditEventParticipantNetworkType(AuditEvent.AuditEventAgentNetworkType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case _1: {
                return AuditEvent.AuditEventParticipantNetworkType._1;
            }
            case _2: {
                return AuditEvent.AuditEventParticipantNetworkType._2;
            }
            case _3: {
                return AuditEvent.AuditEventParticipantNetworkType._3;
            }
            case _4: {
                return AuditEvent.AuditEventParticipantNetworkType._4;
            }
            case _5: {
                return AuditEvent.AuditEventParticipantNetworkType._5;
            }
        }
        return AuditEvent.AuditEventParticipantNetworkType.NULL;
    }

    public AuditEvent.AuditEventSourceComponent convertAuditEventSourceComponent(AuditEvent.AuditEventSourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventSourceComponent tgt = new AuditEvent.AuditEventSourceComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setSite(src.getSite());
        if (src.hasIdentifier()) {
            tgt.getObserver().setIdentifier(this.convertIdentifier(src.getIdentifier()));
        }
        for (Coding t : src.getType()) {
            tgt.addType(this.convertCoding(t));
        }
        return tgt;
    }

    public AuditEvent.AuditEventSourceComponent convertAuditEventSourceComponent(AuditEvent.AuditEventSourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventSourceComponent tgt = new AuditEvent.AuditEventSourceComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setSite(src.getSite());
        if (src.hasObserver()) {
            tgt.setIdentifier(this.convertIdentifier(src.getObserver().getIdentifier()));
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getType()) {
            tgt.addType(this.convertCoding(t));
        }
        return tgt;
    }

    public AuditEvent.AuditEventEntityComponent convertAuditEventEntityComponent(AuditEvent.AuditEventObjectComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventEntityComponent tgt = new AuditEvent.AuditEventEntityComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        if (src.hasIdentifier()) {
            tgt.getWhat().setIdentifier(this.convertIdentifier(src.getIdentifier()));
        }
        if (src.hasReference()) {
            tgt.setWhat(this.convertReference(src.getReference()));
        }
        tgt.setType(this.convertCoding(src.getType()));
        tgt.setRole(this.convertCoding(src.getRole()));
        tgt.setLifecycle(this.convertCoding(src.getLifecycle()));
        for (Coding t : src.getSecurityLabel()) {
            tgt.addSecurityLabel(this.convertCoding(t));
        }
        tgt.setName(src.getName());
        tgt.setDescription(src.getDescription());
        tgt.setQuery(src.getQuery());
        for (Coding t : src.getDetail()) {
            tgt.addDetail(this.convertAuditEventEntityDetailComponent((AuditEvent.AuditEventObjectDetailComponent)t));
        }
        return tgt;
    }

    public AuditEvent.AuditEventObjectComponent convertAuditEventEntityComponent(AuditEvent.AuditEventEntityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventObjectComponent tgt = new AuditEvent.AuditEventObjectComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        if (src.hasWhat()) {
            if (src.getWhat().hasIdentifier()) {
                tgt.setIdentifier(this.convertIdentifier(src.getWhat().getIdentifier()));
            }
            if (src.getWhat().hasReference() || src.getWhat().hasDisplay() || src.getWhat().hasExtension() || src.getWhat().hasId()) {
                tgt.setReference(this.convertReference(src.getWhat()));
            }
        }
        tgt.setType(this.convertCoding(src.getType()));
        tgt.setRole(this.convertCoding(src.getRole()));
        tgt.setLifecycle(this.convertCoding(src.getLifecycle()));
        for (org.hl7.fhir.r4.model.Coding t : src.getSecurityLabel()) {
            tgt.addSecurityLabel(this.convertCoding(t));
        }
        tgt.setName(src.getName());
        tgt.setDescription(src.getDescription());
        tgt.setQuery(src.getQuery());
        for (org.hl7.fhir.r4.model.Coding t : src.getDetail()) {
            tgt.addDetail(this.convertAuditEventEntityDetailComponent((AuditEvent.AuditEventEntityDetailComponent)t));
        }
        return tgt;
    }

    public AuditEvent.AuditEventEntityDetailComponent convertAuditEventEntityDetailComponent(AuditEvent.AuditEventObjectDetailComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventEntityDetailComponent tgt = new AuditEvent.AuditEventEntityDetailComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setType(src.getType());
        if (src.hasValue()) {
            tgt.setValue((Type)new org.hl7.fhir.r4.model.Base64BinaryType(src.getValue()));
        }
        return tgt;
    }

    public AuditEvent.AuditEventObjectDetailComponent convertAuditEventEntityDetailComponent(AuditEvent.AuditEventEntityDetailComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        AuditEvent.AuditEventObjectDetailComponent tgt = new AuditEvent.AuditEventObjectDetailComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setType(src.getType());
        if (src.hasValueStringType()) {
            tgt.setValue(((String)src.getValueStringType().getValue()).getBytes());
        } else if (src.hasValueBase64BinaryType()) {
            tgt.setValue((byte[])src.getValueBase64BinaryType().getValue());
        }
        return tgt;
    }

    public org.hl7.fhir.r4.model.Basic convertBasic(Basic src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Basic tgt = new org.hl7.fhir.r4.model.Basic();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setCreated(src.getCreated());
        tgt.setAuthor(this.convertReference(src.getAuthor()));
        return tgt;
    }

    public Basic convertBasic(org.hl7.fhir.r4.model.Basic src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Basic tgt = new Basic();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setCreated(src.getCreated());
        tgt.setAuthor(this.convertReference(src.getAuthor()));
        return tgt;
    }

    public Binary convertBinary(org.hl7.fhir.instance.model.Binary src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Binary tgt = new Binary();
        this.copyResource((org.hl7.fhir.instance.model.Resource)src, (Resource)tgt);
        tgt.setContentType(src.getContentType());
        tgt.setContent(src.getContent());
        return tgt;
    }

    public org.hl7.fhir.instance.model.Binary convertBinary(Binary src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Binary tgt = new org.hl7.fhir.instance.model.Binary();
        this.copyResource((Resource)src, (org.hl7.fhir.instance.model.Resource)tgt);
        tgt.setContentType(src.getContentType());
        tgt.setContent(src.getContent());
        return tgt;
    }

    public Bundle convertBundle(org.hl7.fhir.instance.model.Bundle src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle tgt = new Bundle();
        this.copyResource((org.hl7.fhir.instance.model.Resource)src, (Resource)tgt);
        tgt.setType(this.convertBundleType(src.getType()));
        if (src.hasTotal()) {
            tgt.setTotal(src.getTotal());
        }
        for (Bundle.BundleLinkComponent t : src.getLink()) {
            tgt.addLink(this.convertBundleLinkComponent(t));
        }
        for (Bundle.BundleLinkComponent t : src.getEntry()) {
            tgt.addEntry(this.convertBundleEntryComponent((Bundle.BundleEntryComponent)t));
        }
        tgt.setSignature(this.convertSignature(src.getSignature()));
        return tgt;
    }

    public org.hl7.fhir.instance.model.Bundle convertBundle(Bundle src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Bundle tgt = new org.hl7.fhir.instance.model.Bundle();
        this.copyResource((Resource)src, (org.hl7.fhir.instance.model.Resource)tgt);
        tgt.setType(this.convertBundleType(src.getType()));
        if (src.hasTotal()) {
            tgt.setTotal(src.getTotal());
        }
        for (Bundle.BundleLinkComponent t : src.getLink()) {
            tgt.addLink(this.convertBundleLinkComponent(t));
        }
        for (Bundle.BundleLinkComponent t : src.getEntry()) {
            tgt.addEntry(this.convertBundleEntryComponent((Bundle.BundleEntryComponent)t));
        }
        if (src.hasSignature()) {
            tgt.setSignature(this.convertSignature(src.getSignature()));
        }
        return tgt;
    }

    public Bundle.BundleType convertBundleType(Bundle.BundleType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DOCUMENT: {
                return Bundle.BundleType.DOCUMENT;
            }
            case MESSAGE: {
                return Bundle.BundleType.MESSAGE;
            }
            case TRANSACTION: {
                return Bundle.BundleType.TRANSACTION;
            }
            case TRANSACTIONRESPONSE: {
                return Bundle.BundleType.TRANSACTIONRESPONSE;
            }
            case BATCH: {
                return Bundle.BundleType.BATCH;
            }
            case BATCHRESPONSE: {
                return Bundle.BundleType.BATCHRESPONSE;
            }
            case HISTORY: {
                return Bundle.BundleType.HISTORY;
            }
            case SEARCHSET: {
                return Bundle.BundleType.SEARCHSET;
            }
            case COLLECTION: {
                return Bundle.BundleType.COLLECTION;
            }
        }
        return Bundle.BundleType.NULL;
    }

    public Bundle.BundleType convertBundleType(Bundle.BundleType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DOCUMENT: {
                return Bundle.BundleType.DOCUMENT;
            }
            case MESSAGE: {
                return Bundle.BundleType.MESSAGE;
            }
            case TRANSACTION: {
                return Bundle.BundleType.TRANSACTION;
            }
            case TRANSACTIONRESPONSE: {
                return Bundle.BundleType.TRANSACTIONRESPONSE;
            }
            case BATCH: {
                return Bundle.BundleType.BATCH;
            }
            case BATCHRESPONSE: {
                return Bundle.BundleType.BATCHRESPONSE;
            }
            case HISTORY: {
                return Bundle.BundleType.HISTORY;
            }
            case SEARCHSET: {
                return Bundle.BundleType.SEARCHSET;
            }
            case COLLECTION: {
                return Bundle.BundleType.COLLECTION;
            }
        }
        return Bundle.BundleType.NULL;
    }

    public Bundle.BundleLinkComponent convertBundleLinkComponent(Bundle.BundleLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleLinkComponent tgt = new Bundle.BundleLinkComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setRelation(src.getRelation());
        tgt.setUrl(src.getUrl());
        return tgt;
    }

    public Bundle.BundleLinkComponent convertBundleLinkComponent(Bundle.BundleLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleLinkComponent tgt = new Bundle.BundleLinkComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setRelation(src.getRelation());
        tgt.setUrl(src.getUrl());
        return tgt;
    }

    public Bundle.BundleEntryComponent convertBundleEntryComponent(Bundle.BundleEntryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryComponent tgt = new Bundle.BundleEntryComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (Bundle.BundleLinkComponent t : src.getLink()) {
            tgt.addLink(this.convertBundleLinkComponent(t));
        }
        tgt.setFullUrl(src.getFullUrl());
        tgt.setResource(this.convertResource(src.getResource()));
        tgt.setSearch(this.convertBundleEntrySearchComponent(src.getSearch()));
        tgt.setRequest(this.convertBundleEntryRequestComponent(src.getRequest()));
        tgt.setResponse(this.convertBundleEntryResponseComponent(src.getResponse()));
        return tgt;
    }

    public Bundle.BundleEntryComponent convertBundleEntryComponent(Bundle.BundleEntryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (this.advisor.ignoreEntry(src)) {
            return null;
        }
        Bundle.BundleEntryComponent tgt = new Bundle.BundleEntryComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (Bundle.BundleLinkComponent t : src.getLink()) {
            tgt.addLink(this.convertBundleLinkComponent(t));
        }
        tgt.setFullUrl(src.getFullUrl());
        org.hl7.fhir.instance.model.Resource res = this.advisor.convertR2(src.getResource());
        if (res == null) {
            res = this.convertResource(src.getResource());
        }
        tgt.setResource(res);
        if (src.hasSearch()) {
            tgt.setSearch(this.convertBundleEntrySearchComponent(src.getSearch()));
        }
        if (src.hasRequest()) {
            tgt.setRequest(this.convertBundleEntryRequestComponent(src.getRequest()));
        }
        if (src.hasResponse()) {
            tgt.setResponse(this.convertBundleEntryResponseComponent(src.getResponse()));
        }
        return tgt;
    }

    public Bundle.BundleEntrySearchComponent convertBundleEntrySearchComponent(Bundle.BundleEntrySearchComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntrySearchComponent tgt = new Bundle.BundleEntrySearchComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setMode(this.convertSearchEntryMode(src.getMode()));
        tgt.setScore(src.getScore());
        return tgt;
    }

    public Bundle.BundleEntrySearchComponent convertBundleEntrySearchComponent(Bundle.BundleEntrySearchComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntrySearchComponent tgt = new Bundle.BundleEntrySearchComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setMode(this.convertSearchEntryMode(src.getMode()));
        tgt.setScore(src.getScore());
        return tgt;
    }

    public Bundle.SearchEntryMode convertSearchEntryMode(Bundle.SearchEntryMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MATCH: {
                return Bundle.SearchEntryMode.MATCH;
            }
            case INCLUDE: {
                return Bundle.SearchEntryMode.INCLUDE;
            }
            case OUTCOME: {
                return Bundle.SearchEntryMode.OUTCOME;
            }
        }
        return Bundle.SearchEntryMode.NULL;
    }

    public Bundle.SearchEntryMode convertSearchEntryMode(Bundle.SearchEntryMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MATCH: {
                return Bundle.SearchEntryMode.MATCH;
            }
            case INCLUDE: {
                return Bundle.SearchEntryMode.INCLUDE;
            }
            case OUTCOME: {
                return Bundle.SearchEntryMode.OUTCOME;
            }
        }
        return Bundle.SearchEntryMode.NULL;
    }

    public Bundle.BundleEntryRequestComponent convertBundleEntryRequestComponent(Bundle.BundleEntryRequestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryRequestComponent tgt = new Bundle.BundleEntryRequestComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setMethod(this.convertHTTPVerb(src.getMethod()));
        tgt.setUrl(src.getUrl());
        tgt.setIfNoneMatch(src.getIfNoneMatch());
        tgt.setIfModifiedSince(src.getIfModifiedSince());
        tgt.setIfMatch(src.getIfMatch());
        tgt.setIfNoneExist(src.getIfNoneExist());
        return tgt;
    }

    public Bundle.BundleEntryRequestComponent convertBundleEntryRequestComponent(Bundle.BundleEntryRequestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryRequestComponent tgt = new Bundle.BundleEntryRequestComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setMethod(this.convertHTTPVerb(src.getMethod()));
        tgt.setUrl(src.getUrl());
        tgt.setIfNoneMatch(src.getIfNoneMatch());
        tgt.setIfModifiedSince(src.getIfModifiedSince());
        tgt.setIfMatch(src.getIfMatch());
        tgt.setIfNoneExist(src.getIfNoneExist());
        return tgt;
    }

    public Bundle.HTTPVerb convertHTTPVerb(Bundle.HTTPVerb src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GET: {
                return Bundle.HTTPVerb.GET;
            }
            case POST: {
                return Bundle.HTTPVerb.POST;
            }
            case PUT: {
                return Bundle.HTTPVerb.PUT;
            }
            case DELETE: {
                return Bundle.HTTPVerb.DELETE;
            }
        }
        return Bundle.HTTPVerb.NULL;
    }

    public Bundle.HTTPVerb convertHTTPVerb(Bundle.HTTPVerb src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case GET: {
                return Bundle.HTTPVerb.GET;
            }
            case POST: {
                return Bundle.HTTPVerb.POST;
            }
            case PUT: {
                return Bundle.HTTPVerb.PUT;
            }
            case DELETE: {
                return Bundle.HTTPVerb.DELETE;
            }
        }
        return Bundle.HTTPVerb.NULL;
    }

    public Bundle.BundleEntryResponseComponent convertBundleEntryResponseComponent(Bundle.BundleEntryResponseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryResponseComponent tgt = new Bundle.BundleEntryResponseComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setStatus(src.getStatus());
        tgt.setLocation(src.getLocation());
        tgt.setEtag(src.getEtag());
        tgt.setLastModified(src.getLastModified());
        return tgt;
    }

    public Bundle.BundleEntryResponseComponent convertBundleEntryResponseComponent(Bundle.BundleEntryResponseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Bundle.BundleEntryResponseComponent tgt = new Bundle.BundleEntryResponseComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setStatus(src.getStatus());
        tgt.setLocation(src.getLocation());
        tgt.setEtag(src.getEtag());
        tgt.setLastModified(src.getLastModified());
        return tgt;
    }

    public org.hl7.fhir.r4.model.CarePlan convertCarePlan(CarePlan src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.CarePlan tgt = new org.hl7.fhir.r4.model.CarePlan();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setStatus(this.convertCarePlanStatus(src.getStatus()));
        tgt.setEncounter(this.convertReference(src.getContext()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getAuthor()) {
            if (!tgt.hasAuthor()) {
                tgt.setAuthor(this.convertReference((Reference)t));
                continue;
            }
            tgt.addContributor(this.convertReference((Reference)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getCategory()) {
            tgt.addCategory(this.convertCodeableConcept((CodeableConcept)t));
        }
        tgt.setDescription(src.getDescription());
        for (org.hl7.fhir.instance.model.Identifier t : src.getAddresses()) {
            tgt.addAddresses(this.convertReference((Reference)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getGoal()) {
            tgt.addGoal(this.convertReference((Reference)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getActivity()) {
            tgt.addActivity(this.convertCarePlanActivityComponent((CarePlan.CarePlanActivityComponent)t));
        }
        return tgt;
    }

    public CarePlan convertCarePlan(org.hl7.fhir.r4.model.CarePlan src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CarePlan tgt = new CarePlan();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setStatus(this.convertCarePlanStatus(src.getStatus()));
        tgt.setContext(this.convertReference(src.getEncounter()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        if (src.hasAuthor()) {
            tgt.addAuthor(this.convertReference(src.getAuthor()));
        }
        for (Identifier t : src.getContributor()) {
            tgt.addAuthor(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getCategory()) {
            tgt.addCategory(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setDescription(src.getDescription());
        for (Identifier t : src.getAddresses()) {
            tgt.addAddresses(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getGoal()) {
            tgt.addGoal(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getActivity()) {
            tgt.addActivity(this.convertCarePlanActivityComponent((CarePlan.CarePlanActivityComponent)t));
        }
        return tgt;
    }

    public CarePlan.CarePlanStatus convertCarePlanStatus(CarePlan.CarePlanStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PROPOSED: {
                return CarePlan.CarePlanStatus.DRAFT;
            }
            case DRAFT: {
                return CarePlan.CarePlanStatus.DRAFT;
            }
            case ACTIVE: {
                return CarePlan.CarePlanStatus.ACTIVE;
            }
            case COMPLETED: {
                return CarePlan.CarePlanStatus.COMPLETED;
            }
            case CANCELLED: {
                return CarePlan.CarePlanStatus.REVOKED;
            }
        }
        return CarePlan.CarePlanStatus.NULL;
    }

    public CarePlan.CarePlanStatus convertCarePlanStatus(CarePlan.CarePlanStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DRAFT: {
                return CarePlan.CarePlanStatus.DRAFT;
            }
            case ACTIVE: {
                return CarePlan.CarePlanStatus.ACTIVE;
            }
            case COMPLETED: {
                return CarePlan.CarePlanStatus.COMPLETED;
            }
            case REVOKED: {
                return CarePlan.CarePlanStatus.CANCELLED;
            }
        }
        return CarePlan.CarePlanStatus.NULL;
    }

    public CarePlan.CarePlanActivityComponent convertCarePlanActivityComponent(CarePlan.CarePlanActivityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CarePlan.CarePlanActivityComponent tgt = new CarePlan.CarePlanActivityComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (Annotation t : src.getProgress()) {
            tgt.addProgress(this.convertAnnotation(t));
        }
        tgt.setReference(this.convertReference(src.getReference()));
        tgt.setDetail(this.convertCarePlanActivityDetailComponent(src.getDetail()));
        return tgt;
    }

    public CarePlan.CarePlanActivityComponent convertCarePlanActivityComponent(CarePlan.CarePlanActivityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CarePlan.CarePlanActivityComponent tgt = new CarePlan.CarePlanActivityComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (org.hl7.fhir.r4.model.Annotation t : src.getProgress()) {
            tgt.addProgress(this.convertAnnotation(t));
        }
        tgt.setReference(this.convertReference(src.getReference()));
        tgt.setDetail(this.convertCarePlanActivityDetailComponent(src.getDetail()));
        return tgt;
    }

    public CarePlan.CarePlanActivityDetailComponent convertCarePlanActivityDetailComponent(CarePlan.CarePlanActivityDetailComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CarePlan.CarePlanActivityDetailComponent tgt = new CarePlan.CarePlanActivityDetailComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        for (CodeableConcept t : src.getReasonCode()) {
            tgt.addReasonCode(this.convertCodeableConcept(t));
        }
        for (CodeableConcept t : src.getReasonReference()) {
            tgt.addReasonReference(this.convertReference((Reference)t));
        }
        for (CodeableConcept t : src.getGoal()) {
            tgt.addGoal(this.convertReference((Reference)t));
        }
        tgt.setStatus(this.convertCarePlanActivityStatus(src.getStatus()));
        tgt.setDoNotPerform(src.getProhibited());
        tgt.setScheduled(this.convertType(src.getScheduled()));
        tgt.setLocation(this.convertReference(src.getLocation()));
        for (CodeableConcept t : src.getPerformer()) {
            tgt.addPerformer(this.convertReference((Reference)t));
        }
        tgt.setProduct(this.convertType(src.getProduct()));
        tgt.setDailyAmount(this.convertSimpleQuantity(src.getDailyAmount()));
        tgt.setQuantity(this.convertSimpleQuantity(src.getQuantity()));
        tgt.setDescription(src.getDescription());
        return tgt;
    }

    public CarePlan.CarePlanActivityDetailComponent convertCarePlanActivityDetailComponent(CarePlan.CarePlanActivityDetailComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CarePlan.CarePlanActivityDetailComponent tgt = new CarePlan.CarePlanActivityDetailComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getReasonCode()) {
            tgt.addReasonCode(this.convertCodeableConcept(t));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getReasonReference()) {
            tgt.addReasonReference(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getGoal()) {
            tgt.addGoal(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        tgt.setStatus(this.convertCarePlanActivityStatus(src.getStatus()));
        tgt.setProhibited(src.getDoNotPerform());
        tgt.setScheduled(this.convertType(src.getScheduled()));
        tgt.setLocation(this.convertReference(src.getLocation()));
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getPerformer()) {
            tgt.addPerformer(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        tgt.setProduct(this.convertType(src.getProduct()));
        tgt.setDailyAmount(this.convertSimpleQuantity(src.getDailyAmount()));
        tgt.setQuantity(this.convertSimpleQuantity(src.getQuantity()));
        tgt.setDescription(src.getDescription());
        return tgt;
    }

    public CarePlan.CarePlanActivityStatus convertCarePlanActivityStatus(CarePlan.CarePlanActivityStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOTSTARTED: {
                return CarePlan.CarePlanActivityStatus.NOTSTARTED;
            }
            case SCHEDULED: {
                return CarePlan.CarePlanActivityStatus.SCHEDULED;
            }
            case INPROGRESS: {
                return CarePlan.CarePlanActivityStatus.INPROGRESS;
            }
            case ONHOLD: {
                return CarePlan.CarePlanActivityStatus.ONHOLD;
            }
            case COMPLETED: {
                return CarePlan.CarePlanActivityStatus.COMPLETED;
            }
            case CANCELLED: {
                return CarePlan.CarePlanActivityStatus.CANCELLED;
            }
        }
        return CarePlan.CarePlanActivityStatus.NULL;
    }

    public CarePlan.CarePlanActivityStatus convertCarePlanActivityStatus(CarePlan.CarePlanActivityStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOTSTARTED: {
                return CarePlan.CarePlanActivityStatus.NOTSTARTED;
            }
            case SCHEDULED: {
                return CarePlan.CarePlanActivityStatus.SCHEDULED;
            }
            case INPROGRESS: {
                return CarePlan.CarePlanActivityStatus.INPROGRESS;
            }
            case ONHOLD: {
                return CarePlan.CarePlanActivityStatus.ONHOLD;
            }
            case COMPLETED: {
                return CarePlan.CarePlanActivityStatus.COMPLETED;
            }
            case CANCELLED: {
                return CarePlan.CarePlanActivityStatus.CANCELLED;
            }
        }
        return CarePlan.CarePlanActivityStatus.NULL;
    }

    public Communication convertCommunication(org.hl7.fhir.instance.model.Communication src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Communication tgt = new Communication();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.addCategory(this.convertCodeableConcept(src.getCategory()));
        tgt.setSender(this.convertReference(src.getSender()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getRecipient()) {
            tgt.addRecipient(this.convertReference((Reference)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getPayload()) {
            tgt.addPayload(this.convertCommunicationPayloadComponent((Communication.CommunicationPayloadComponent)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getMedium()) {
            tgt.addMedium(this.convertCodeableConcept((CodeableConcept)t));
        }
        tgt.setStatus(this.convertCommunicationStatus(src.getStatus()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        tgt.setSent(src.getSent());
        tgt.setReceived(src.getReceived());
        for (org.hl7.fhir.instance.model.Identifier t : src.getReason()) {
            tgt.addReasonCode(this.convertCodeableConcept((CodeableConcept)t));
        }
        tgt.setSubject(this.convertReference(src.getSubject()));
        return tgt;
    }

    public org.hl7.fhir.instance.model.Communication convertCommunication(Communication src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Communication tgt = new org.hl7.fhir.instance.model.Communication();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setCategory(this.convertCodeableConcept(src.getCategoryFirstRep()));
        tgt.setSender(this.convertReference(src.getSender()));
        for (Identifier t : src.getRecipient()) {
            tgt.addRecipient(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getPayload()) {
            tgt.addPayload(this.convertCommunicationPayloadComponent((Communication.CommunicationPayloadComponent)t));
        }
        for (Identifier t : src.getMedium()) {
            tgt.addMedium(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setStatus(this.convertCommunicationStatus(src.getStatus()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        tgt.setSent(src.getSent());
        tgt.setReceived(src.getReceived());
        for (Identifier t : src.getReasonCode()) {
            tgt.addReason(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setSubject(this.convertReference(src.getSubject()));
        return tgt;
    }

    public Communication.CommunicationStatus convertCommunicationStatus(Communication.CommunicationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INPROGRESS: {
                return Communication.CommunicationStatus.INPROGRESS;
            }
            case COMPLETED: {
                return Communication.CommunicationStatus.COMPLETED;
            }
            case SUSPENDED: {
                return Communication.CommunicationStatus.ONHOLD;
            }
            case REJECTED: {
                return Communication.CommunicationStatus.ENTEREDINERROR;
            }
            case FAILED: {
                return Communication.CommunicationStatus.NOTDONE;
            }
        }
        return Communication.CommunicationStatus.NULL;
    }

    public Communication.CommunicationStatus convertCommunicationStatus(Communication.CommunicationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INPROGRESS: {
                return Communication.CommunicationStatus.INPROGRESS;
            }
            case COMPLETED: {
                return Communication.CommunicationStatus.COMPLETED;
            }
            case ONHOLD: {
                return Communication.CommunicationStatus.SUSPENDED;
            }
            case ENTEREDINERROR: {
                return Communication.CommunicationStatus.REJECTED;
            }
            case NOTDONE: {
                return Communication.CommunicationStatus.FAILED;
            }
        }
        return Communication.CommunicationStatus.NULL;
    }

    public Communication.CommunicationPayloadComponent convertCommunicationPayloadComponent(Communication.CommunicationPayloadComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Communication.CommunicationPayloadComponent tgt = new Communication.CommunicationPayloadComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setContent(this.convertType(src.getContent()));
        return tgt;
    }

    public Communication.CommunicationPayloadComponent convertCommunicationPayloadComponent(Communication.CommunicationPayloadComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Communication.CommunicationPayloadComponent tgt = new Communication.CommunicationPayloadComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setContent(this.convertType(src.getContent()));
        return tgt;
    }

    public org.hl7.fhir.r4.model.CommunicationRequest convertCommunicationRequest(CommunicationRequest src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.CommunicationRequest tgt = new org.hl7.fhir.r4.model.CommunicationRequest();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.addCategory(this.convertCodeableConcept(src.getCategory()));
        tgt.setSender(this.convertReference(src.getSender()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getRecipient()) {
            tgt.addRecipient(this.convertReference((Reference)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getPayload()) {
            tgt.addPayload(this.convertCommunicationRequestPayloadComponent((CommunicationRequest.CommunicationRequestPayloadComponent)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getMedium()) {
            tgt.addMedium(this.convertCodeableConcept((CodeableConcept)t));
        }
        tgt.setRequester(this.convertReference(src.getRequester()));
        tgt.setStatus(this.convertCommunicationRequestStatus(src.getStatus()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        tgt.setOccurrence(this.convertType(src.getScheduled()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getReason()) {
            tgt.addReasonCode(this.convertCodeableConcept((CodeableConcept)t));
        }
        tgt.setAuthoredOn(src.getRequestedOn());
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setPriority(this.convertPriorityCode(src.getPriority()));
        return tgt;
    }

    private CommunicationRequest.CommunicationPriority convertPriorityCode(CodeableConcept priority) {
        for (Coding c : priority.getCoding()) {
            if ("http://hl7.org/fhir/diagnostic-order-priority".equals(c.getSystem()) && "routine".equals(c.getCode())) {
                return CommunicationRequest.CommunicationPriority.ROUTINE;
            }
            if ("http://hl7.org/fhir/diagnostic-order-priority".equals(c.getSystem()) && "urgent".equals(c.getCode())) {
                return CommunicationRequest.CommunicationPriority.URGENT;
            }
            if ("http://hl7.org/fhir/diagnostic-order-priority".equals(c.getSystem()) && "stat".equals(c.getCode())) {
                return CommunicationRequest.CommunicationPriority.STAT;
            }
            if (!"http://hl7.org/fhir/diagnostic-order-priority".equals(c.getSystem()) || !"asap".equals(c.getCode())) continue;
            return CommunicationRequest.CommunicationPriority.ASAP;
        }
        return null;
    }

    public CommunicationRequest convertCommunicationRequest(org.hl7.fhir.r4.model.CommunicationRequest src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CommunicationRequest tgt = new CommunicationRequest();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setCategory(this.convertCodeableConcept(src.getCategoryFirstRep()));
        tgt.setSender(this.convertReference(src.getSender()));
        for (Identifier t : src.getRecipient()) {
            tgt.addRecipient(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getPayload()) {
            tgt.addPayload(this.convertCommunicationRequestPayloadComponent((CommunicationRequest.CommunicationRequestPayloadComponent)t));
        }
        for (Identifier t : src.getMedium()) {
            tgt.addMedium(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setRequester(this.convertReference(src.getRequester()));
        tgt.setStatus(this.convertCommunicationRequestStatus(src.getStatus()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        tgt.setScheduled(this.convertType(src.getOccurrence()));
        for (Identifier t : src.getReasonCode()) {
            tgt.addReason(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setRequestedOn(src.getAuthoredOn());
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setPriority(this.convertPriorityCode(src.getPriority()));
        return tgt;
    }

    private CodeableConcept convertPriorityCode(CommunicationRequest.CommunicationPriority priority) {
        CodeableConcept cc = new CodeableConcept();
        switch (priority) {
            case ROUTINE: {
                cc.addCoding().setSystem("http://hl7.org/fhir/diagnostic-order-priority").setCode("routine");
                break;
            }
            case URGENT: {
                cc.addCoding().setSystem("http://hl7.org/fhir/diagnostic-order-priority").setCode("urgent");
                break;
            }
            case STAT: {
                cc.addCoding().setSystem("http://hl7.org/fhir/diagnostic-order-priority").setCode("stat");
                break;
            }
            case ASAP: {
                cc.addCoding().setSystem("http://hl7.org/fhir/diagnostic-order-priority").setCode("asap");
                break;
            }
            default: {
                return null;
            }
        }
        return cc;
    }

    public CommunicationRequest.CommunicationRequestStatus convertCommunicationRequestStatus(CommunicationRequest.CommunicationRequestStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PROPOSED: {
                return CommunicationRequest.CommunicationRequestStatus.DRAFT;
            }
            case PLANNED: {
                return CommunicationRequest.CommunicationRequestStatus.ACTIVE;
            }
            case REQUESTED: {
                return CommunicationRequest.CommunicationRequestStatus.ACTIVE;
            }
            case RECEIVED: {
                return CommunicationRequest.CommunicationRequestStatus.ACTIVE;
            }
            case ACCEPTED: {
                return CommunicationRequest.CommunicationRequestStatus.ACTIVE;
            }
            case INPROGRESS: {
                return CommunicationRequest.CommunicationRequestStatus.ACTIVE;
            }
            case COMPLETED: {
                return CommunicationRequest.CommunicationRequestStatus.COMPLETED;
            }
            case SUSPENDED: {
                return CommunicationRequest.CommunicationRequestStatus.ONHOLD;
            }
            case REJECTED: {
                return CommunicationRequest.CommunicationRequestStatus.ENTEREDINERROR;
            }
        }
        return CommunicationRequest.CommunicationRequestStatus.NULL;
    }

    public CommunicationRequest.CommunicationRequestStatus convertCommunicationRequestStatus(CommunicationRequest.CommunicationRequestStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DRAFT: {
                return CommunicationRequest.CommunicationRequestStatus.PROPOSED;
            }
            case ACTIVE: {
                return CommunicationRequest.CommunicationRequestStatus.INPROGRESS;
            }
            case COMPLETED: {
                return CommunicationRequest.CommunicationRequestStatus.COMPLETED;
            }
            case ONHOLD: {
                return CommunicationRequest.CommunicationRequestStatus.SUSPENDED;
            }
            case ENTEREDINERROR: {
                return CommunicationRequest.CommunicationRequestStatus.REJECTED;
            }
        }
        return CommunicationRequest.CommunicationRequestStatus.NULL;
    }

    public CommunicationRequest.CommunicationRequestPayloadComponent convertCommunicationRequestPayloadComponent(CommunicationRequest.CommunicationRequestPayloadComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CommunicationRequest.CommunicationRequestPayloadComponent tgt = new CommunicationRequest.CommunicationRequestPayloadComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setContent(this.convertType(src.getContent()));
        return tgt;
    }

    public CommunicationRequest.CommunicationRequestPayloadComponent convertCommunicationRequestPayloadComponent(CommunicationRequest.CommunicationRequestPayloadComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CommunicationRequest.CommunicationRequestPayloadComponent tgt = new CommunicationRequest.CommunicationRequestPayloadComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setContent(this.convertType(src.getContent()));
        return tgt;
    }

    public Composition convertComposition(org.hl7.fhir.instance.model.Composition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition tgt = new Composition();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifier()));
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setType(this.convertCodeableConcept(src.getType()));
        tgt.addCategory(this.convertCodeableConcept(src.getClass_()));
        tgt.setTitle(src.getTitle());
        tgt.setStatus(this.convertCompositionStatus(src.getStatus()));
        try {
            tgt.setConfidentiality(Composition.DocumentConfidentiality.fromCode((String)src.getConfidentiality()));
        }
        catch (FHIRException e) {
            throw new FHIRException((Throwable)e);
        }
        tgt.setSubject(this.convertReference(src.getSubject()));
        for (Reference t : src.getAuthor()) {
            tgt.addAuthor(this.convertReference(t));
        }
        for (Reference t : src.getAttester()) {
            tgt.addAttester(this.convertCompositionAttesterComponent((Composition.CompositionAttesterComponent)t));
        }
        tgt.setCustodian(this.convertReference(src.getCustodian()));
        for (Reference t : src.getEvent()) {
            tgt.addEvent(this.convertCompositionEventComponent((Composition.CompositionEventComponent)t));
        }
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        for (Reference t : src.getSection()) {
            tgt.addSection(this.convertSectionComponent((Composition.SectionComponent)t));
        }
        return tgt;
    }

    public org.hl7.fhir.instance.model.Composition convertComposition(Composition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Composition tgt = new org.hl7.fhir.instance.model.Composition();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifier()));
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setType(this.convertCodeableConcept(src.getType()));
        if (src.hasCategory()) {
            tgt.setClass_(this.convertCodeableConcept(src.getCategoryFirstRep()));
        }
        tgt.setTitle(src.getTitle());
        tgt.setStatus(this.convertCompositionStatus(src.getStatus()));
        tgt.setConfidentiality(src.getConfidentiality().toCode());
        tgt.setSubject(this.convertReference(src.getSubject()));
        for (org.hl7.fhir.r4.model.Reference t : src.getAuthor()) {
            tgt.addAuthor(this.convertReference(t));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getAttester()) {
            tgt.addAttester(this.convertCompositionAttesterComponent((Composition.CompositionAttesterComponent)t));
        }
        tgt.setCustodian(this.convertReference(src.getCustodian()));
        for (org.hl7.fhir.r4.model.Reference t : src.getEvent()) {
            tgt.addEvent(this.convertCompositionEventComponent((Composition.CompositionEventComponent)t));
        }
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        for (org.hl7.fhir.r4.model.Reference t : src.getSection()) {
            tgt.addSection(this.convertSectionComponent((Composition.SectionComponent)t));
        }
        return tgt;
    }

    public Composition.CompositionStatus convertCompositionStatus(Composition.CompositionStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PRELIMINARY: {
                return Composition.CompositionStatus.PRELIMINARY;
            }
            case FINAL: {
                return Composition.CompositionStatus.FINAL;
            }
            case AMENDED: {
                return Composition.CompositionStatus.AMENDED;
            }
            case ENTEREDINERROR: {
                return Composition.CompositionStatus.ENTEREDINERROR;
            }
        }
        return Composition.CompositionStatus.NULL;
    }

    public Composition.CompositionStatus convertCompositionStatus(Composition.CompositionStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PRELIMINARY: {
                return Composition.CompositionStatus.PRELIMINARY;
            }
            case FINAL: {
                return Composition.CompositionStatus.FINAL;
            }
            case AMENDED: {
                return Composition.CompositionStatus.AMENDED;
            }
            case ENTEREDINERROR: {
                return Composition.CompositionStatus.ENTEREDINERROR;
            }
        }
        return Composition.CompositionStatus.NULL;
    }

    public Composition.CompositionAttesterComponent convertCompositionAttesterComponent(Composition.CompositionAttesterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.CompositionAttesterComponent tgt = new Composition.CompositionAttesterComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        if (src.hasMode()) {
            tgt.setMode(this.convertCompositionAttestationMode((Composition.CompositionAttestationMode)((Enumeration)src.getMode().get(0)).getValue()));
        }
        tgt.setTime(src.getTime());
        tgt.setParty(this.convertReference(src.getParty()));
        return tgt;
    }

    public Composition.CompositionAttesterComponent convertCompositionAttesterComponent(Composition.CompositionAttesterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.CompositionAttesterComponent tgt = new Composition.CompositionAttesterComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        if (src.hasMode()) {
            tgt.addMode(this.convertCompositionAttestationMode(src.getMode()));
        }
        tgt.setTime(src.getTime());
        tgt.setParty(this.convertReference(src.getParty()));
        return tgt;
    }

    public Composition.CompositionAttestationMode convertCompositionAttestationMode(Composition.CompositionAttestationMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PERSONAL: {
                return Composition.CompositionAttestationMode.PERSONAL;
            }
            case PROFESSIONAL: {
                return Composition.CompositionAttestationMode.PROFESSIONAL;
            }
            case LEGAL: {
                return Composition.CompositionAttestationMode.LEGAL;
            }
            case OFFICIAL: {
                return Composition.CompositionAttestationMode.OFFICIAL;
            }
        }
        return Composition.CompositionAttestationMode.NULL;
    }

    public Composition.CompositionAttestationMode convertCompositionAttestationMode(Composition.CompositionAttestationMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PERSONAL: {
                return Composition.CompositionAttestationMode.PERSONAL;
            }
            case PROFESSIONAL: {
                return Composition.CompositionAttestationMode.PROFESSIONAL;
            }
            case LEGAL: {
                return Composition.CompositionAttestationMode.LEGAL;
            }
            case OFFICIAL: {
                return Composition.CompositionAttestationMode.OFFICIAL;
            }
        }
        return Composition.CompositionAttestationMode.NULL;
    }

    public Composition.CompositionEventComponent convertCompositionEventComponent(Composition.CompositionEventComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.CompositionEventComponent tgt = new Composition.CompositionEventComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (CodeableConcept t : src.getCode()) {
            tgt.addCode(this.convertCodeableConcept(t));
        }
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        for (CodeableConcept t : src.getDetail()) {
            tgt.addDetail(this.convertReference((Reference)t));
        }
        return tgt;
    }

    public Composition.CompositionEventComponent convertCompositionEventComponent(Composition.CompositionEventComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.CompositionEventComponent tgt = new Composition.CompositionEventComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getCode()) {
            tgt.addCode(this.convertCodeableConcept(t));
        }
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getDetail()) {
            tgt.addDetail(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    public Composition.SectionComponent convertSectionComponent(Composition.SectionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.SectionComponent tgt = new Composition.SectionComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setTitle(src.getTitle());
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setText(this.convertNarrative(src.getText()));
        try {
            tgt.setMode(Composition.SectionMode.fromCode((String)src.getMode()));
        }
        catch (FHIRException e) {
            throw new FHIRException((Throwable)e);
        }
        tgt.setOrderedBy(this.convertCodeableConcept(src.getOrderedBy()));
        for (Reference t : src.getEntry()) {
            tgt.addEntry(this.convertReference(t));
        }
        tgt.setEmptyReason(this.convertCodeableConcept(src.getEmptyReason()));
        for (Reference t : src.getSection()) {
            tgt.addSection(this.convertSectionComponent((Composition.SectionComponent)t));
        }
        return tgt;
    }

    public Composition.SectionComponent convertSectionComponent(Composition.SectionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Composition.SectionComponent tgt = new Composition.SectionComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setTitle(src.getTitle());
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setText(this.convertNarrative(src.getText()));
        tgt.setMode(src.getMode().toCode());
        tgt.setOrderedBy(this.convertCodeableConcept(src.getOrderedBy()));
        for (org.hl7.fhir.r4.model.Reference t : src.getEntry()) {
            tgt.addEntry(this.convertReference(t));
        }
        tgt.setEmptyReason(this.convertCodeableConcept(src.getEmptyReason()));
        for (org.hl7.fhir.r4.model.Reference t : src.getSection()) {
            tgt.addSection(this.convertSectionComponent((Composition.SectionComponent)t));
        }
        return tgt;
    }

    public org.hl7.fhir.r4.model.ConceptMap convertConceptMap(ConceptMap src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.ConceptMap tgt = new org.hl7.fhir.r4.model.ConceptMap();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifier()));
        tgt.setVersion(src.getVersion());
        tgt.setName(src.getName());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        tgt.setPublisher(src.getPublisher());
        for (ConceptMap.ConceptMapContactComponent t : src.getContact()) {
            tgt.addContact(this.convertConceptMapContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setDescription(src.getDescription());
        for (ConceptMap.ConceptMapContactComponent t : src.getUseContext()) {
            if (VersionConvertor_10_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(this.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(this.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        tgt.setPurpose(src.getRequirements());
        tgt.setCopyright(src.getCopyright());
        Type r = this.convertType(src.getSource());
        tgt.setSource((Type)(r instanceof org.hl7.fhir.r4.model.Reference ? new CanonicalType(((org.hl7.fhir.r4.model.Reference)r).getReference()) : r));
        r = this.convertType(src.getTarget());
        tgt.setTarget((Type)(r instanceof org.hl7.fhir.r4.model.Reference ? new CanonicalType(((org.hl7.fhir.r4.model.Reference)r).getReference()) : r));
        for (ConceptMap.SourceElementComponent t : src.getElement()) {
            List<SourceElementComponentWrapper> ws = this.convertSourceElementComponent(t);
            for (SourceElementComponentWrapper w : ws) {
                this.getGroup(tgt, w.source, w.target).addElement(w.comp);
            }
        }
        return tgt;
    }

    public UsageContext convertCodeableConceptToUsageContext(CodeableConcept t) throws FHIRException {
        UsageContext result = new UsageContext();
        result.setValue((Type)this.convertCodeableConcept(t));
        return result;
    }

    private ConceptMap.ConceptMapGroupComponent getGroup(org.hl7.fhir.r4.model.ConceptMap map, String srcs, String tgts) {
        for (ConceptMap.ConceptMapGroupComponent grp : map.getGroup()) {
            if (!grp.getSource().equals(srcs) || !grp.getTarget().equals(tgts)) continue;
            return grp;
        }
        ConceptMap.ConceptMapGroupComponent grp = map.addGroup();
        grp.setSource(srcs);
        grp.setTarget(tgts);
        return grp;
    }

    public ConceptMap convertConceptMap(org.hl7.fhir.r4.model.ConceptMap src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap tgt = new ConceptMap();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifier()));
        tgt.setVersion(src.getVersion());
        tgt.setName(src.getName());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        tgt.setPublisher(src.getPublisher());
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(this.convertConceptMapContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setDescription(src.getDescription());
        for (ContactDetail t : src.getUseContext()) {
            if (!t.hasValueCodeableConcept()) continue;
            tgt.addUseContext(this.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addUseContext(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setRequirements(src.getPurpose());
        tgt.setCopyright(src.getCopyright());
        tgt.setSource(this.convertType(src.getSource()));
        tgt.setTarget(this.convertType(src.getTarget()));
        for (ConceptMap.ConceptMapGroupComponent g : src.getGroup()) {
            for (ConceptMap.SourceElementComponent t : g.getElement()) {
                tgt.addElement(this.convertSourceElementComponent(t, g));
            }
        }
        return tgt;
    }

    public Enumerations.PublicationStatus convertConformanceResourceStatus(Enumerations.ConformanceResourceStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DRAFT: {
                return Enumerations.PublicationStatus.DRAFT;
            }
            case ACTIVE: {
                return Enumerations.PublicationStatus.ACTIVE;
            }
            case RETIRED: {
                return Enumerations.PublicationStatus.RETIRED;
            }
        }
        return Enumerations.PublicationStatus.NULL;
    }

    public Enumerations.ConformanceResourceStatus convertConformanceResourceStatus(Enumerations.PublicationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DRAFT: {
                return Enumerations.ConformanceResourceStatus.DRAFT;
            }
            case ACTIVE: {
                return Enumerations.ConformanceResourceStatus.ACTIVE;
            }
            case RETIRED: {
                return Enumerations.ConformanceResourceStatus.RETIRED;
            }
        }
        return Enumerations.ConformanceResourceStatus.NULL;
    }

    public ContactDetail convertConceptMapContactComponent(ConceptMap.ConceptMapContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public ConceptMap.ConceptMapContactComponent convertConceptMapContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.ConceptMapContactComponent tgt = new ConceptMap.ConceptMapContactComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public List<SourceElementComponentWrapper> convertSourceElementComponent(ConceptMap.SourceElementComponent src) throws FHIRException {
        ArrayList<SourceElementComponentWrapper> res = new ArrayList<SourceElementComponentWrapper>();
        if (src == null || src.isEmpty()) {
            return res;
        }
        for (ConceptMap.TargetElementComponent t : src.getTarget()) {
            ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
            this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
            tgt.setCode(src.getCode());
            tgt.addTarget(this.convertTargetElementComponent(t));
            res.add(new SourceElementComponentWrapper(tgt, src.getCodeSystem(), t.getCodeSystem()));
        }
        return res;
    }

    public ConceptMap.SourceElementComponent convertSourceElementComponent(ConceptMap.SourceElementComponent src, ConceptMap.ConceptMapGroupComponent g) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.SourceElementComponent tgt = new ConceptMap.SourceElementComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setCodeSystem(g.getSource());
        tgt.setCode(src.getCode());
        for (ConceptMap.TargetElementComponent t : src.getTarget()) {
            tgt.addTarget(this.convertTargetElementComponent(t, g));
        }
        return tgt;
    }

    public ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setCode(src.getCode());
        tgt.setEquivalence(this.convertConceptMapEquivalence(src.getEquivalence()));
        tgt.setComment(src.getComments());
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(this.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(this.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public ConceptMap.TargetElementComponent convertTargetElementComponent(ConceptMap.TargetElementComponent src, ConceptMap.ConceptMapGroupComponent g) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.TargetElementComponent tgt = new ConceptMap.TargetElementComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setCodeSystem(g.getTarget());
        tgt.setCode(src.getCode());
        tgt.setEquivalence(this.convertConceptMapEquivalence(src.getEquivalence()));
        tgt.setComments(src.getComment());
        for (ConceptMap.OtherElementComponent t : src.getDependsOn()) {
            tgt.addDependsOn(this.convertOtherElementComponent(t));
        }
        for (ConceptMap.OtherElementComponent t : src.getProduct()) {
            tgt.addProduct(this.convertOtherElementComponent(t));
        }
        return tgt;
    }

    public Enumerations.ConceptMapEquivalence convertConceptMapEquivalence(Enumerations.ConceptMapEquivalence src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EQUIVALENT: {
                return Enumerations.ConceptMapEquivalence.EQUIVALENT;
            }
            case EQUAL: {
                return Enumerations.ConceptMapEquivalence.EQUAL;
            }
            case WIDER: {
                return Enumerations.ConceptMapEquivalence.WIDER;
            }
            case SUBSUMES: {
                return Enumerations.ConceptMapEquivalence.SUBSUMES;
            }
            case NARROWER: {
                return Enumerations.ConceptMapEquivalence.NARROWER;
            }
            case SPECIALIZES: {
                return Enumerations.ConceptMapEquivalence.SPECIALIZES;
            }
            case INEXACT: {
                return Enumerations.ConceptMapEquivalence.INEXACT;
            }
            case UNMATCHED: {
                return Enumerations.ConceptMapEquivalence.UNMATCHED;
            }
            case DISJOINT: {
                return Enumerations.ConceptMapEquivalence.DISJOINT;
            }
        }
        return Enumerations.ConceptMapEquivalence.NULL;
    }

    public Enumerations.ConceptMapEquivalence convertConceptMapEquivalence(Enumerations.ConceptMapEquivalence src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EQUIVALENT: {
                return Enumerations.ConceptMapEquivalence.EQUIVALENT;
            }
            case EQUAL: {
                return Enumerations.ConceptMapEquivalence.EQUAL;
            }
            case WIDER: {
                return Enumerations.ConceptMapEquivalence.WIDER;
            }
            case SUBSUMES: {
                return Enumerations.ConceptMapEquivalence.SUBSUMES;
            }
            case NARROWER: {
                return Enumerations.ConceptMapEquivalence.NARROWER;
            }
            case SPECIALIZES: {
                return Enumerations.ConceptMapEquivalence.SPECIALIZES;
            }
            case INEXACT: {
                return Enumerations.ConceptMapEquivalence.INEXACT;
            }
            case UNMATCHED: {
                return Enumerations.ConceptMapEquivalence.UNMATCHED;
            }
            case DISJOINT: {
                return Enumerations.ConceptMapEquivalence.DISJOINT;
            }
        }
        return Enumerations.ConceptMapEquivalence.NULL;
    }

    public ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setProperty(src.getElement());
        tgt.setSystem(src.getCodeSystem());
        tgt.setValue(src.getCode());
        return tgt;
    }

    public ConceptMap.OtherElementComponent convertOtherElementComponent(ConceptMap.OtherElementComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ConceptMap.OtherElementComponent tgt = new ConceptMap.OtherElementComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setElement(src.getProperty());
        tgt.setCodeSystem(src.getSystem());
        tgt.setCode(src.getValue());
        return tgt;
    }

    public Condition convertCondition(org.hl7.fhir.instance.model.Condition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Condition tgt = new Condition();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setSubject(this.convertReference(src.getPatient()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        tgt.setAsserter(this.convertReference(src.getAsserter()));
        if (src.hasDateRecorded()) {
            tgt.setRecordedDate(src.getDateRecorded());
        }
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.addCategory(this.convertCodeableConcept(src.getCategory()));
        if (src.hasClinicalStatus()) {
            tgt.setClinicalStatus(VersionConvertor_10_40.convertConditionClinicalStatus(src.getClinicalStatus()));
        }
        tgt.setVerificationStatus(VersionConvertor_10_40.convertConditionVerificationStatus(src.getVerificationStatus()));
        tgt.setSeverity(this.convertCodeableConcept(src.getSeverity()));
        tgt.setOnset(this.convertType(src.getOnset()));
        tgt.setAbatement(this.convertType(src.getAbatement()));
        tgt.addStage(this.convertConditionStageComponent(src.getStage()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getEvidence()) {
            tgt.addEvidence(this.convertConditionEvidenceComponent((Condition.ConditionEvidenceComponent)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getBodySite()) {
            tgt.addBodySite(this.convertCodeableConcept((CodeableConcept)t));
        }
        return tgt;
    }

    public org.hl7.fhir.instance.model.Condition convertCondition(Condition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Condition tgt = new org.hl7.fhir.instance.model.Condition();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setPatient(this.convertReference(src.getSubject()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        tgt.setAsserter(this.convertReference(src.getAsserter()));
        if (src.hasRecordedDate()) {
            tgt.setDateRecorded(src.getRecordedDate());
        }
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        for (Identifier t : src.getCategory()) {
            tgt.setCategory(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        if (src.hasClinicalStatus()) {
            tgt.setClinicalStatus(VersionConvertor_10_40.convertConditionClinicalStatus(src.getClinicalStatus()));
        }
        tgt.setVerificationStatus(VersionConvertor_10_40.convertConditionVerificationStatus(src.getVerificationStatus()));
        tgt.setSeverity(this.convertCodeableConcept(src.getSeverity()));
        tgt.setOnset(this.convertType(src.getOnset()));
        tgt.setAbatement(this.convertType(src.getAbatement()));
        tgt.setStage(this.convertConditionStageComponent(src.getStageFirstRep()));
        for (Identifier t : src.getEvidence()) {
            tgt.addEvidence(this.convertConditionEvidenceComponent((Condition.ConditionEvidenceComponent)t));
        }
        for (Identifier t : src.getBodySite()) {
            tgt.addBodySite(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        return tgt;
    }

    private static org.hl7.fhir.r4.model.CodeableConcept convertConditionClinicalStatus(String src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CodeableConcept cc = new org.hl7.fhir.r4.model.CodeableConcept();
        cc.addCoding().setSystem("http://hl7.org/fhir/condition-clinical").setCode(src);
        return cc;
    }

    private static String convertConditionClinicalStatus(org.hl7.fhir.r4.model.CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        for (org.hl7.fhir.r4.model.Coding c : src.getCoding()) {
            if (!"http://hl7.org/fhir/condition-clinical".equals(c.getSystem())) continue;
            return c.getCode();
        }
        return null;
    }

    private static org.hl7.fhir.r4.model.CodeableConcept convertConditionVerificationStatus(Condition.ConditionVerificationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        org.hl7.fhir.r4.model.CodeableConcept cc = new org.hl7.fhir.r4.model.CodeableConcept();
        switch (src) {
            case PROVISIONAL: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-ver-status").setCode("provisional");
                return cc;
            }
            case DIFFERENTIAL: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-ver-status").setCode("differential");
                return cc;
            }
            case CONFIRMED: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-ver-status").setCode("confirmed");
                return cc;
            }
            case REFUTED: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-ver-status").setCode("refuted");
                return cc;
            }
            case ENTEREDINERROR: {
                cc.addCoding().setSystem("http://hl7.org/fhir/condition-ver-status").setCode("entered-in-error");
                return cc;
            }
        }
        return null;
    }

    private static Condition.ConditionVerificationStatus convertConditionVerificationStatus(org.hl7.fhir.r4.model.CodeableConcept src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "provisional")) {
            return Condition.ConditionVerificationStatus.PROVISIONAL;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "differential")) {
            return Condition.ConditionVerificationStatus.DIFFERENTIAL;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "confirmed")) {
            return Condition.ConditionVerificationStatus.CONFIRMED;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "refuted")) {
            return Condition.ConditionVerificationStatus.REFUTED;
        }
        if (src.hasCoding("http://hl7.org/fhir/condition-clinical", "entered-in-error")) {
            return Condition.ConditionVerificationStatus.ENTEREDINERROR;
        }
        return Condition.ConditionVerificationStatus.NULL;
    }

    public Condition.ConditionStageComponent convertConditionStageComponent(Condition.ConditionStageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Condition.ConditionStageComponent tgt = new Condition.ConditionStageComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setSummary(this.convertCodeableConcept(src.getSummary()));
        for (Reference t : src.getAssessment()) {
            tgt.addAssessment(this.convertReference(t));
        }
        return tgt;
    }

    public Condition.ConditionStageComponent convertConditionStageComponent(Condition.ConditionStageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Condition.ConditionStageComponent tgt = new Condition.ConditionStageComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setSummary(this.convertCodeableConcept(src.getSummary()));
        for (org.hl7.fhir.r4.model.Reference t : src.getAssessment()) {
            tgt.addAssessment(this.convertReference(t));
        }
        return tgt;
    }

    public Condition.ConditionEvidenceComponent convertConditionEvidenceComponent(Condition.ConditionEvidenceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Condition.ConditionEvidenceComponent tgt = new Condition.ConditionEvidenceComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.addCode(this.convertCodeableConcept(src.getCode()));
        for (Reference t : src.getDetail()) {
            tgt.addDetail(this.convertReference(t));
        }
        return tgt;
    }

    public Condition.ConditionEvidenceComponent convertConditionEvidenceComponent(Condition.ConditionEvidenceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Condition.ConditionEvidenceComponent tgt = new Condition.ConditionEvidenceComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (org.hl7.fhir.r4.model.CodeableConcept cc : src.getCode()) {
            tgt.setCode(this.convertCodeableConcept(cc));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getDetail()) {
            tgt.addDetail(this.convertReference(t));
        }
        return tgt;
    }

    private CanonicalType convertReferenceToCanonical(Reference src) throws FHIRException {
        CanonicalType dst = new CanonicalType(src.getReference());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)dst);
        return dst;
    }

    private Reference convertCanonicalToReference(CanonicalType src) throws FHIRException {
        Reference dst = new Reference((String)src.getValue());
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)dst);
        return dst;
    }

    public CapabilityStatement convertConformance(Conformance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement tgt = new CapabilityStatement();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setVersion(src.getVersion());
        tgt.setName(src.getName());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setPublisher(src.getPublisher());
        for (Conformance.ConformanceContactComponent t : src.getContact()) {
            tgt.addContact(this.convertConformanceContactComponent(t));
        }
        tgt.setDescription(src.getDescription());
        tgt.setPurpose(src.getRequirements());
        tgt.setCopyright(src.getCopyright());
        tgt.setKind(this.convertConformanceStatementKind(src.getKind()));
        tgt.setSoftware(this.convertConformanceSoftwareComponent(src.getSoftware()));
        tgt.setImplementation(this.convertConformanceImplementationComponent(src.getImplementation()));
        tgt.setFhirVersion(Enumerations.FHIRVersion.fromCode((String)src.getFhirVersion()));
        for (Conformance.ConformanceContactComponent t : src.getFormat()) {
            tgt.addFormat((String)t.getValue());
        }
        for (Conformance.ConformanceContactComponent t : src.getRest()) {
            tgt.addRest(this.convertConformanceRestComponent((Conformance.ConformanceRestComponent)t));
        }
        for (Conformance.ConformanceContactComponent t : src.getMessaging()) {
            tgt.addMessaging(this.convertConformanceMessagingComponent((Conformance.ConformanceMessagingComponent)t));
        }
        for (Conformance.ConformanceContactComponent t : src.getDocument()) {
            tgt.addDocument(this.convertConformanceDocumentComponent((Conformance.ConformanceDocumentComponent)t));
        }
        return tgt;
    }

    public Conformance convertConformance(CapabilityStatement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance tgt = new Conformance();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setVersion(src.getVersion());
        tgt.setName(src.getName());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setPublisher(src.getPublisher());
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(this.convertConformanceContactComponent(t));
        }
        tgt.setDescription(src.getDescription());
        tgt.setRequirements(src.getPurpose());
        tgt.setCopyright(src.getCopyright());
        tgt.setKind(this.convertConformanceStatementKind(src.getKind()));
        tgt.setSoftware(this.convertConformanceSoftwareComponent(src.getSoftware()));
        if (src.hasImplementation()) {
            tgt.setImplementation(this.convertConformanceImplementationComponent(src.getImplementation()));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(src.getFhirVersion().toCode());
        }
        for (ContactDetail t : src.getFormat()) {
            tgt.addFormat((String)t.getValue());
        }
        for (CapabilityStatement.CapabilityStatementRestComponent r : src.getRest()) {
            for (CapabilityStatement.CapabilityStatementRestResourceComponent rr : r.getResource()) {
                for (CanonicalType t : rr.getSupportedProfile()) {
                    tgt.addProfile(this.convertCanonicalToReference(t));
                }
            }
        }
        for (ContactDetail t : src.getRest()) {
            tgt.addRest(this.convertConformanceRestComponent((CapabilityStatement.CapabilityStatementRestComponent)t));
        }
        for (ContactDetail t : src.getMessaging()) {
            tgt.addMessaging(this.convertConformanceMessagingComponent((CapabilityStatement.CapabilityStatementMessagingComponent)t));
        }
        for (ContactDetail t : src.getDocument()) {
            tgt.addDocument(this.convertConformanceDocumentComponent((CapabilityStatement.CapabilityStatementDocumentComponent)t));
        }
        return tgt;
    }

    public CapabilityStatement.CapabilityStatementKind convertConformanceStatementKind(Conformance.ConformanceStatementKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INSTANCE: {
                return CapabilityStatement.CapabilityStatementKind.INSTANCE;
            }
            case CAPABILITY: {
                return CapabilityStatement.CapabilityStatementKind.CAPABILITY;
            }
            case REQUIREMENTS: {
                return CapabilityStatement.CapabilityStatementKind.REQUIREMENTS;
            }
        }
        return CapabilityStatement.CapabilityStatementKind.NULL;
    }

    public Conformance.ConformanceStatementKind convertConformanceStatementKind(CapabilityStatement.CapabilityStatementKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INSTANCE: {
                return Conformance.ConformanceStatementKind.INSTANCE;
            }
            case CAPABILITY: {
                return Conformance.ConformanceStatementKind.CAPABILITY;
            }
            case REQUIREMENTS: {
                return Conformance.ConformanceStatementKind.REQUIREMENTS;
            }
        }
        return Conformance.ConformanceStatementKind.NULL;
    }

    public ContactDetail convertConformanceContactComponent(Conformance.ConformanceContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public Conformance.ConformanceContactComponent convertConformanceContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceContactComponent tgt = new Conformance.ConformanceContactComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public CapabilityStatement.CapabilityStatementSoftwareComponent convertConformanceSoftwareComponent(Conformance.ConformanceSoftwareComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementSoftwareComponent tgt = new CapabilityStatement.CapabilityStatementSoftwareComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        tgt.setVersion(src.getVersion());
        tgt.setReleaseDate(src.getReleaseDate());
        return tgt;
    }

    public Conformance.ConformanceSoftwareComponent convertConformanceSoftwareComponent(CapabilityStatement.CapabilityStatementSoftwareComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceSoftwareComponent tgt = new Conformance.ConformanceSoftwareComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        tgt.setVersion(src.getVersion());
        tgt.setReleaseDate(src.getReleaseDate());
        return tgt;
    }

    public CapabilityStatement.CapabilityStatementImplementationComponent convertConformanceImplementationComponent(Conformance.ConformanceImplementationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementImplementationComponent tgt = new CapabilityStatement.CapabilityStatementImplementationComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setDescription(src.getDescription());
        tgt.setUrl(src.getUrl());
        return tgt;
    }

    public Conformance.ConformanceImplementationComponent convertConformanceImplementationComponent(CapabilityStatement.CapabilityStatementImplementationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceImplementationComponent tgt = new Conformance.ConformanceImplementationComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setDescription(src.getDescription());
        tgt.setUrl(src.getUrl());
        return tgt;
    }

    public CapabilityStatement.CapabilityStatementRestComponent convertConformanceRestComponent(Conformance.ConformanceRestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestComponent tgt = new CapabilityStatement.CapabilityStatementRestComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setMode(this.convertRestfulConformanceMode(src.getMode()));
        tgt.setDocumentation(src.getDocumentation());
        tgt.setSecurity(this.convertConformanceRestSecurityComponent(src.getSecurity()));
        for (Conformance.ConformanceRestResourceComponent t : src.getResource()) {
            tgt.addResource(this.convertConformanceRestResourceComponent(t));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getInteraction()) {
            tgt.addInteraction(this.convertSystemInteractionComponent((Conformance.SystemInteractionComponent)t));
        }
        if (src.getTransactionMode() == Conformance.TransactionMode.BATCH || src.getTransactionMode() == Conformance.TransactionMode.BOTH) {
            tgt.addInteraction().setCode(CapabilityStatement.SystemRestfulInteraction.BATCH);
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getSearchParam()) {
            tgt.addSearchParam(this.convertConformanceRestResourceSearchParamComponent((Conformance.ConformanceRestResourceSearchParamComponent)t));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getOperation()) {
            tgt.addOperation(this.convertConformanceRestOperationComponent((Conformance.ConformanceRestOperationComponent)t));
        }
        for (Conformance.ConformanceRestResourceComponent t : src.getCompartment()) {
            tgt.addCompartment((String)t.getValue());
        }
        return tgt;
    }

    public Conformance.ConformanceRestComponent convertConformanceRestComponent(CapabilityStatement.CapabilityStatementRestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestComponent tgt = new Conformance.ConformanceRestComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setMode(this.convertRestfulConformanceMode(src.getMode()));
        tgt.setDocumentation(src.getDocumentation());
        tgt.setSecurity(this.convertConformanceRestSecurityComponent(src.getSecurity()));
        for (CapabilityStatement.CapabilityStatementRestResourceComponent t : src.getResource()) {
            tgt.addResource(this.convertConformanceRestResourceComponent(t));
        }
        boolean batch = false;
        boolean transaction = false;
        for (CapabilityStatement.SystemInteractionComponent t : src.getInteraction()) {
            if (t.getCode().equals((Object)CapabilityStatement.SystemRestfulInteraction.BATCH)) {
                batch = true;
            } else {
                tgt.addInteraction(this.convertSystemInteractionComponent(t));
            }
            if (!t.getCode().equals((Object)CapabilityStatement.SystemRestfulInteraction.TRANSACTION)) continue;
            transaction = true;
        }
        if (batch) {
            tgt.setTransactionMode(transaction ? Conformance.TransactionMode.BOTH : Conformance.TransactionMode.BATCH);
        } else {
            tgt.setTransactionMode(transaction ? Conformance.TransactionMode.TRANSACTION : Conformance.TransactionMode.NOTSUPPORTED);
        }
        for (CapabilityStatement.SystemInteractionComponent t : src.getSearchParam()) {
            tgt.addSearchParam(this.convertConformanceRestResourceSearchParamComponent((CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent)t));
        }
        for (CapabilityStatement.SystemInteractionComponent t : src.getOperation()) {
            tgt.addOperation(this.convertConformanceRestOperationComponent((CapabilityStatement.CapabilityStatementRestResourceOperationComponent)t));
        }
        for (CapabilityStatement.SystemInteractionComponent t : src.getCompartment()) {
            tgt.addCompartment((String)t.getValue());
        }
        return tgt;
    }

    public CapabilityStatement.RestfulCapabilityMode convertRestfulConformanceMode(Conformance.RestfulConformanceMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CLIENT: {
                return CapabilityStatement.RestfulCapabilityMode.CLIENT;
            }
            case SERVER: {
                return CapabilityStatement.RestfulCapabilityMode.SERVER;
            }
        }
        return CapabilityStatement.RestfulCapabilityMode.NULL;
    }

    public Conformance.RestfulConformanceMode convertRestfulConformanceMode(CapabilityStatement.RestfulCapabilityMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CLIENT: {
                return Conformance.RestfulConformanceMode.CLIENT;
            }
            case SERVER: {
                return Conformance.RestfulConformanceMode.SERVER;
            }
        }
        return Conformance.RestfulConformanceMode.NULL;
    }

    public CapabilityStatement.CapabilityStatementRestSecurityComponent convertConformanceRestSecurityComponent(Conformance.ConformanceRestSecurityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestSecurityComponent tgt = new CapabilityStatement.CapabilityStatementRestSecurityComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setCors(src.getCors());
        for (CodeableConcept t : src.getService()) {
            tgt.addService(this.convertCodeableConcept(t));
        }
        tgt.setDescription(src.getDescription());
        return tgt;
    }

    public Conformance.ConformanceRestSecurityComponent convertConformanceRestSecurityComponent(CapabilityStatement.CapabilityStatementRestSecurityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestSecurityComponent tgt = new Conformance.ConformanceRestSecurityComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setCors(src.getCors());
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getService()) {
            tgt.addService(this.convertCodeableConcept(t));
        }
        tgt.setDescription(src.getDescription());
        return tgt;
    }

    public CapabilityStatement.CapabilityStatementRestResourceComponent convertConformanceRestResourceComponent(Conformance.ConformanceRestResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setType(src.getType());
        tgt.setProfileElement(this.convertReferenceToCanonical(src.getProfile()));
        for (Conformance.ResourceInteractionComponent t : src.getInteraction()) {
            tgt.addInteraction(this.convertResourceInteractionComponent(t));
        }
        tgt.setVersioning(this.convertResourceVersionPolicy(src.getVersioning()));
        tgt.setReadHistory(src.getReadHistory());
        tgt.setUpdateCreate(src.getUpdateCreate());
        tgt.setConditionalCreate(src.getConditionalCreate());
        tgt.setConditionalUpdate(src.getConditionalUpdate());
        tgt.setConditionalDelete(this.convertConditionalDeleteStatus(src.getConditionalDelete()));
        for (Conformance.ResourceInteractionComponent t : src.getSearchInclude()) {
            tgt.addSearchInclude((String)t.getValue());
        }
        for (Conformance.ResourceInteractionComponent t : src.getSearchRevInclude()) {
            tgt.addSearchRevInclude((String)t.getValue());
        }
        for (Conformance.ResourceInteractionComponent t : src.getSearchParam()) {
            tgt.addSearchParam(this.convertConformanceRestResourceSearchParamComponent((Conformance.ConformanceRestResourceSearchParamComponent)t));
        }
        return tgt;
    }

    public Conformance.ConformanceRestResourceComponent convertConformanceRestResourceComponent(CapabilityStatement.CapabilityStatementRestResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestResourceComponent tgt = new Conformance.ConformanceRestResourceComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setType(src.getType());
        if (src.hasProfile()) {
            tgt.setProfile(this.convertCanonicalToReference(src.getProfileElement()));
        }
        for (CapabilityStatement.ResourceInteractionComponent t : src.getInteraction()) {
            tgt.addInteraction(this.convertResourceInteractionComponent(t));
        }
        tgt.setVersioning(this.convertResourceVersionPolicy(src.getVersioning()));
        tgt.setReadHistory(src.getReadHistory());
        tgt.setUpdateCreate(src.getUpdateCreate());
        tgt.setConditionalCreate(src.getConditionalCreate());
        tgt.setConditionalUpdate(src.getConditionalUpdate());
        tgt.setConditionalDelete(this.convertConditionalDeleteStatus(src.getConditionalDelete()));
        for (CapabilityStatement.ResourceInteractionComponent t : src.getSearchInclude()) {
            tgt.addSearchInclude((String)t.getValue());
        }
        for (CapabilityStatement.ResourceInteractionComponent t : src.getSearchRevInclude()) {
            tgt.addSearchRevInclude((String)t.getValue());
        }
        for (CapabilityStatement.ResourceInteractionComponent t : src.getSearchParam()) {
            tgt.addSearchParam(this.convertConformanceRestResourceSearchParamComponent((CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent)t));
        }
        return tgt;
    }

    public CapabilityStatement.ResourceVersionPolicy convertResourceVersionPolicy(Conformance.ResourceVersionPolicy src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOVERSION: {
                return CapabilityStatement.ResourceVersionPolicy.NOVERSION;
            }
            case VERSIONED: {
                return CapabilityStatement.ResourceVersionPolicy.VERSIONED;
            }
            case VERSIONEDUPDATE: {
                return CapabilityStatement.ResourceVersionPolicy.VERSIONEDUPDATE;
            }
        }
        return CapabilityStatement.ResourceVersionPolicy.NULL;
    }

    public Conformance.ResourceVersionPolicy convertResourceVersionPolicy(CapabilityStatement.ResourceVersionPolicy src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOVERSION: {
                return Conformance.ResourceVersionPolicy.NOVERSION;
            }
            case VERSIONED: {
                return Conformance.ResourceVersionPolicy.VERSIONED;
            }
            case VERSIONEDUPDATE: {
                return Conformance.ResourceVersionPolicy.VERSIONEDUPDATE;
            }
        }
        return Conformance.ResourceVersionPolicy.NULL;
    }

    public CapabilityStatement.ConditionalDeleteStatus convertConditionalDeleteStatus(Conformance.ConditionalDeleteStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOTSUPPORTED: {
                return CapabilityStatement.ConditionalDeleteStatus.NOTSUPPORTED;
            }
            case SINGLE: {
                return CapabilityStatement.ConditionalDeleteStatus.SINGLE;
            }
            case MULTIPLE: {
                return CapabilityStatement.ConditionalDeleteStatus.MULTIPLE;
            }
        }
        return CapabilityStatement.ConditionalDeleteStatus.NULL;
    }

    public Conformance.ConditionalDeleteStatus convertConditionalDeleteStatus(CapabilityStatement.ConditionalDeleteStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOTSUPPORTED: {
                return Conformance.ConditionalDeleteStatus.NOTSUPPORTED;
            }
            case SINGLE: {
                return Conformance.ConditionalDeleteStatus.SINGLE;
            }
            case MULTIPLE: {
                return Conformance.ConditionalDeleteStatus.MULTIPLE;
            }
        }
        return Conformance.ConditionalDeleteStatus.NULL;
    }

    public CapabilityStatement.ResourceInteractionComponent convertResourceInteractionComponent(Conformance.ResourceInteractionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.ResourceInteractionComponent tgt = new CapabilityStatement.ResourceInteractionComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setCode(this.convertTypeRestfulInteraction(src.getCode()));
        tgt.setDocumentation(src.getDocumentation());
        return tgt;
    }

    public Conformance.ResourceInteractionComponent convertResourceInteractionComponent(CapabilityStatement.ResourceInteractionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ResourceInteractionComponent tgt = new Conformance.ResourceInteractionComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setCode(this.convertTypeRestfulInteraction(src.getCode()));
        tgt.setDocumentation(src.getDocumentation());
        return tgt;
    }

    public CapabilityStatement.TypeRestfulInteraction convertTypeRestfulInteraction(Conformance.TypeRestfulInteraction src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case READ: {
                return CapabilityStatement.TypeRestfulInteraction.READ;
            }
            case VREAD: {
                return CapabilityStatement.TypeRestfulInteraction.VREAD;
            }
            case UPDATE: {
                return CapabilityStatement.TypeRestfulInteraction.UPDATE;
            }
            case DELETE: {
                return CapabilityStatement.TypeRestfulInteraction.DELETE;
            }
            case HISTORYINSTANCE: {
                return CapabilityStatement.TypeRestfulInteraction.HISTORYINSTANCE;
            }
            case HISTORYTYPE: {
                return CapabilityStatement.TypeRestfulInteraction.HISTORYTYPE;
            }
            case CREATE: {
                return CapabilityStatement.TypeRestfulInteraction.CREATE;
            }
            case SEARCHTYPE: {
                return CapabilityStatement.TypeRestfulInteraction.SEARCHTYPE;
            }
        }
        return CapabilityStatement.TypeRestfulInteraction.NULL;
    }

    public Conformance.TypeRestfulInteraction convertTypeRestfulInteraction(CapabilityStatement.TypeRestfulInteraction src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case READ: {
                return Conformance.TypeRestfulInteraction.READ;
            }
            case VREAD: {
                return Conformance.TypeRestfulInteraction.VREAD;
            }
            case UPDATE: {
                return Conformance.TypeRestfulInteraction.UPDATE;
            }
            case DELETE: {
                return Conformance.TypeRestfulInteraction.DELETE;
            }
            case HISTORYINSTANCE: {
                return Conformance.TypeRestfulInteraction.HISTORYINSTANCE;
            }
            case HISTORYTYPE: {
                return Conformance.TypeRestfulInteraction.HISTORYTYPE;
            }
            case CREATE: {
                return Conformance.TypeRestfulInteraction.CREATE;
            }
            case SEARCHTYPE: {
                return Conformance.TypeRestfulInteraction.SEARCHTYPE;
            }
        }
        return Conformance.TypeRestfulInteraction.NULL;
    }

    public CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent convertConformanceRestResourceSearchParamComponent(Conformance.ConformanceRestResourceSearchParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        tgt.setDefinition(src.getDefinition());
        tgt.setType(this.convertSearchParamType(src.getType()));
        tgt.setDocumentation(src.getDocumentation());
        return tgt;
    }

    public Conformance.ConformanceRestResourceSearchParamComponent convertConformanceRestResourceSearchParamComponent(CapabilityStatement.CapabilityStatementRestResourceSearchParamComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestResourceSearchParamComponent tgt = new Conformance.ConformanceRestResourceSearchParamComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        tgt.setDefinition(src.getDefinition());
        tgt.setType(this.convertSearchParamType(src.getType()));
        tgt.setDocumentation(src.getDocumentation());
        return tgt;
    }

    public CapabilityStatement.SystemInteractionComponent convertSystemInteractionComponent(Conformance.SystemInteractionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.SystemInteractionComponent tgt = new CapabilityStatement.SystemInteractionComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setCode(this.convertSystemRestfulInteraction(src.getCode()));
        tgt.setDocumentation(src.getDocumentation());
        return tgt;
    }

    public Conformance.SystemInteractionComponent convertSystemInteractionComponent(CapabilityStatement.SystemInteractionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.SystemInteractionComponent tgt = new Conformance.SystemInteractionComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setCode(this.convertSystemRestfulInteraction(src.getCode()));
        tgt.setDocumentation(src.getDocumentation());
        return tgt;
    }

    public CapabilityStatement.SystemRestfulInteraction convertSystemRestfulInteraction(Conformance.SystemRestfulInteraction src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case TRANSACTION: {
                return CapabilityStatement.SystemRestfulInteraction.TRANSACTION;
            }
            case SEARCHSYSTEM: {
                return CapabilityStatement.SystemRestfulInteraction.SEARCHSYSTEM;
            }
            case HISTORYSYSTEM: {
                return CapabilityStatement.SystemRestfulInteraction.HISTORYSYSTEM;
            }
        }
        return CapabilityStatement.SystemRestfulInteraction.NULL;
    }

    public Conformance.SystemRestfulInteraction convertSystemRestfulInteraction(CapabilityStatement.SystemRestfulInteraction src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case TRANSACTION: {
                return Conformance.SystemRestfulInteraction.TRANSACTION;
            }
            case SEARCHSYSTEM: {
                return Conformance.SystemRestfulInteraction.SEARCHSYSTEM;
            }
            case HISTORYSYSTEM: {
                return Conformance.SystemRestfulInteraction.HISTORYSYSTEM;
            }
        }
        return Conformance.SystemRestfulInteraction.NULL;
    }

    public CapabilityStatement.CapabilityStatementRestResourceOperationComponent convertConformanceRestOperationComponent(Conformance.ConformanceRestOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementRestResourceOperationComponent tgt = new CapabilityStatement.CapabilityStatementRestResourceOperationComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        tgt.setDefinitionElement(this.convertReferenceToCanonical(src.getDefinition()));
        return tgt;
    }

    public Conformance.ConformanceRestOperationComponent convertConformanceRestOperationComponent(CapabilityStatement.CapabilityStatementRestResourceOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceRestOperationComponent tgt = new Conformance.ConformanceRestOperationComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        tgt.setDefinition(this.convertCanonicalToReference(src.getDefinitionElement()));
        return tgt;
    }

    public CapabilityStatement.CapabilityStatementMessagingComponent convertConformanceMessagingComponent(Conformance.ConformanceMessagingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingComponent tgt = new CapabilityStatement.CapabilityStatementMessagingComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (Conformance.ConformanceMessagingEndpointComponent t : src.getEndpoint()) {
            tgt.addEndpoint(this.convertConformanceMessagingEndpointComponent(t));
        }
        tgt.setReliableCache(src.getReliableCache());
        tgt.setDocumentation(src.getDocumentation());
        return tgt;
    }

    public Conformance.ConformanceMessagingComponent convertConformanceMessagingComponent(CapabilityStatement.CapabilityStatementMessagingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceMessagingComponent tgt = new Conformance.ConformanceMessagingComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (CapabilityStatement.CapabilityStatementMessagingEndpointComponent t : src.getEndpoint()) {
            tgt.addEndpoint(this.convertConformanceMessagingEndpointComponent(t));
        }
        tgt.setReliableCache(src.getReliableCache());
        tgt.setDocumentation(src.getDocumentation());
        return tgt;
    }

    public CapabilityStatement.CapabilityStatementMessagingEndpointComponent convertConformanceMessagingEndpointComponent(Conformance.ConformanceMessagingEndpointComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementMessagingEndpointComponent tgt = new CapabilityStatement.CapabilityStatementMessagingEndpointComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setProtocol(this.convertCoding(src.getProtocol()));
        tgt.setAddress(src.getAddress());
        return tgt;
    }

    public Conformance.ConformanceMessagingEndpointComponent convertConformanceMessagingEndpointComponent(CapabilityStatement.CapabilityStatementMessagingEndpointComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceMessagingEndpointComponent tgt = new Conformance.ConformanceMessagingEndpointComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setProtocol(this.convertCoding(src.getProtocol()));
        tgt.setAddress(src.getAddress());
        return tgt;
    }

    public CapabilityStatement.EventCapabilityMode convertConformanceEventMode(Conformance.ConformanceEventMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case SENDER: {
                return CapabilityStatement.EventCapabilityMode.SENDER;
            }
            case RECEIVER: {
                return CapabilityStatement.EventCapabilityMode.RECEIVER;
            }
        }
        return CapabilityStatement.EventCapabilityMode.NULL;
    }

    public Conformance.ConformanceEventMode convertConformanceEventMode(CapabilityStatement.EventCapabilityMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case SENDER: {
                return Conformance.ConformanceEventMode.SENDER;
            }
            case RECEIVER: {
                return Conformance.ConformanceEventMode.RECEIVER;
            }
        }
        return Conformance.ConformanceEventMode.NULL;
    }

    public CapabilityStatement.CapabilityStatementDocumentComponent convertConformanceDocumentComponent(Conformance.ConformanceDocumentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        CapabilityStatement.CapabilityStatementDocumentComponent tgt = new CapabilityStatement.CapabilityStatementDocumentComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setMode(this.convertDocumentMode(src.getMode()));
        tgt.setDocumentation(src.getDocumentation());
        tgt.setProfileElement(this.convertReferenceToCanonical(src.getProfile()));
        return tgt;
    }

    public Conformance.ConformanceDocumentComponent convertConformanceDocumentComponent(CapabilityStatement.CapabilityStatementDocumentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Conformance.ConformanceDocumentComponent tgt = new Conformance.ConformanceDocumentComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setMode(this.convertDocumentMode(src.getMode()));
        tgt.setDocumentation(src.getDocumentation());
        tgt.setProfile(this.convertCanonicalToReference(src.getProfileElement()));
        return tgt;
    }

    public CapabilityStatement.DocumentMode convertDocumentMode(Conformance.DocumentMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PRODUCER: {
                return CapabilityStatement.DocumentMode.PRODUCER;
            }
            case CONSUMER: {
                return CapabilityStatement.DocumentMode.CONSUMER;
            }
        }
        return CapabilityStatement.DocumentMode.NULL;
    }

    public Conformance.DocumentMode convertDocumentMode(CapabilityStatement.DocumentMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PRODUCER: {
                return Conformance.DocumentMode.PRODUCER;
            }
            case CONSUMER: {
                return Conformance.DocumentMode.CONSUMER;
            }
        }
        return Conformance.DocumentMode.NULL;
    }

    public org.hl7.fhir.r4.model.StructureDefinition convertDataElement(DataElement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.StructureDefinition tgt = new org.hl7.fhir.r4.model.StructureDefinition();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasUrl()) {
            tgt.setUrl(src.getUrl().replace("/DataElement/", "/StructureDefinition/de-"));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setVersion(src.getVersion());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        tgt.setPublisher(src.getPublisher());
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setName(src.getName());
        for (org.hl7.fhir.instance.model.Identifier t : src.getContact()) {
            tgt.addContact(this.convertDataElementContactComponent((DataElement.DataElementContactComponent)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getUseContext()) {
            if (VersionConvertor_10_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(this.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(this.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        tgt.setCopyright(src.getCopyright());
        for (org.hl7.fhir.instance.model.Identifier t : src.getMapping()) {
            tgt.addMapping(this.convertDataElementMappingComponent((DataElement.DataElementMappingComponent)t));
        }
        ArrayList<String> slicePaths = new ArrayList<String>();
        for (org.hl7.fhir.instance.model.ElementDefinition t : src.getElement()) {
            if (t.hasSlicing()) {
                slicePaths.add(t.getPath());
            }
            tgt.getSnapshot().addElement(this.convertElementDefinition(t, slicePaths, src.getElement(), src.getElement().indexOf(t)));
        }
        tgt.setKind(StructureDefinition.StructureDefinitionKind.COMPLEXTYPE);
        tgt.setAbstract(false);
        tgt.setType(tgt.getName());
        tgt.setBaseDefinition("http://hl7.org/fhir/StructureDefinition/Element");
        tgt.setDerivation(StructureDefinition.TypeDerivationRule.SPECIALIZATION);
        return tgt;
    }

    public ContactDetail convertDataElementContactComponent(DataElement.DataElementContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public DataElement.DataElementContactComponent convertDataElementContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DataElement.DataElementContactComponent tgt = new DataElement.DataElementContactComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public StructureDefinition.StructureDefinitionMappingComponent convertDataElementMappingComponent(DataElement.DataElementMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setIdentity(src.getIdentity());
        tgt.setUri(src.getUri());
        tgt.setName(src.getName());
        tgt.setComment(src.getComments());
        return tgt;
    }

    public DetectedIssue convertDetectedIssue(org.hl7.fhir.instance.model.DetectedIssue src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DetectedIssue tgt = new DetectedIssue();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setPatient(this.convertReference(src.getPatient()));
        tgt.setCode(this.convertCodeableConcept(src.getCategory()));
        tgt.setSeverity(this.convertDetectedIssueSeverity(src.getSeverity()));
        for (Reference t : src.getImplicated()) {
            tgt.addImplicated(this.convertReference(t));
        }
        tgt.setDetail(src.getDetail());
        if (src.hasDate()) {
            tgt.setIdentified((Type)this.convertDateTime(src.getDateElement()));
        }
        tgt.setAuthor(this.convertReference(src.getAuthor()));
        tgt.addIdentifier(this.convertIdentifier(src.getIdentifier()));
        tgt.setReference(src.getReference());
        for (Reference t : src.getMitigation()) {
            tgt.addMitigation(this.convertDetectedIssueMitigationComponent((DetectedIssue.DetectedIssueMitigationComponent)t));
        }
        return tgt;
    }

    public org.hl7.fhir.instance.model.DetectedIssue convertDetectedIssue(DetectedIssue src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.DetectedIssue tgt = new org.hl7.fhir.instance.model.DetectedIssue();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setPatient(this.convertReference(src.getPatient()));
        tgt.setCategory(this.convertCodeableConcept(src.getCode()));
        tgt.setSeverity(this.convertDetectedIssueSeverity(src.getSeverity()));
        for (org.hl7.fhir.r4.model.Reference t : src.getImplicated()) {
            tgt.addImplicated(this.convertReference(t));
        }
        tgt.setDetail(src.getDetail());
        if (src.hasIdentifiedDateTimeType()) {
            tgt.setDateElement(this.convertDateTime(src.getIdentifiedDateTimeType()));
        }
        tgt.setAuthor(this.convertReference(src.getAuthor()));
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifierFirstRep()));
        tgt.setReference(src.getReference());
        for (org.hl7.fhir.r4.model.Reference t : src.getMitigation()) {
            tgt.addMitigation(this.convertDetectedIssueMitigationComponent((DetectedIssue.DetectedIssueMitigationComponent)t));
        }
        return tgt;
    }

    public DetectedIssue.DetectedIssueSeverity convertDetectedIssueSeverity(DetectedIssue.DetectedIssueSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HIGH: {
                return DetectedIssue.DetectedIssueSeverity.HIGH;
            }
            case MODERATE: {
                return DetectedIssue.DetectedIssueSeverity.MODERATE;
            }
            case LOW: {
                return DetectedIssue.DetectedIssueSeverity.LOW;
            }
        }
        return DetectedIssue.DetectedIssueSeverity.NULL;
    }

    public DetectedIssue.DetectedIssueSeverity convertDetectedIssueSeverity(DetectedIssue.DetectedIssueSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case HIGH: {
                return DetectedIssue.DetectedIssueSeverity.HIGH;
            }
            case MODERATE: {
                return DetectedIssue.DetectedIssueSeverity.MODERATE;
            }
            case LOW: {
                return DetectedIssue.DetectedIssueSeverity.LOW;
            }
        }
        return DetectedIssue.DetectedIssueSeverity.NULL;
    }

    public DetectedIssue.DetectedIssueMitigationComponent convertDetectedIssueMitigationComponent(DetectedIssue.DetectedIssueMitigationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DetectedIssue.DetectedIssueMitigationComponent tgt = new DetectedIssue.DetectedIssueMitigationComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setAction(this.convertCodeableConcept(src.getAction()));
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setAuthor(this.convertReference(src.getAuthor()));
        return tgt;
    }

    public DetectedIssue.DetectedIssueMitigationComponent convertDetectedIssueMitigationComponent(DetectedIssue.DetectedIssueMitigationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DetectedIssue.DetectedIssueMitigationComponent tgt = new DetectedIssue.DetectedIssueMitigationComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setAction(this.convertCodeableConcept(src.getAction()));
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setAuthor(this.convertReference(src.getAuthor()));
        return tgt;
    }

    public org.hl7.fhir.r4.model.DeviceMetric convertDeviceMetric(DeviceMetric src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.DeviceMetric tgt = new org.hl7.fhir.r4.model.DeviceMetric();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setType(this.convertCodeableConcept(src.getType()));
        tgt.addIdentifier(this.convertIdentifier(src.getIdentifier()));
        tgt.setUnit(this.convertCodeableConcept(src.getUnit()));
        tgt.setSource(this.convertReference(src.getSource()));
        tgt.setParent(this.convertReference(src.getParent()));
        tgt.setOperationalStatus(this.convertDeviceMetricOperationalStatus(src.getOperationalStatus()));
        tgt.setColor(this.convertDeviceMetricColor(src.getColor()));
        tgt.setCategory(this.convertDeviceMetricCategory(src.getCategory()));
        tgt.setMeasurementPeriod(this.convertTiming(src.getMeasurementPeriod()));
        for (DeviceMetric.DeviceMetricCalibrationComponent t : src.getCalibration()) {
            tgt.addCalibration(this.convertDeviceMetricCalibrationComponent(t));
        }
        return tgt;
    }

    public DeviceMetric convertDeviceMetric(org.hl7.fhir.r4.model.DeviceMetric src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DeviceMetric tgt = new DeviceMetric();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setType(this.convertCodeableConcept(src.getType()));
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifierFirstRep()));
        tgt.setUnit(this.convertCodeableConcept(src.getUnit()));
        tgt.setSource(this.convertReference(src.getSource()));
        tgt.setParent(this.convertReference(src.getParent()));
        tgt.setOperationalStatus(this.convertDeviceMetricOperationalStatus(src.getOperationalStatus()));
        tgt.setColor(this.convertDeviceMetricColor(src.getColor()));
        tgt.setCategory(this.convertDeviceMetricCategory(src.getCategory()));
        tgt.setMeasurementPeriod(this.convertTiming(src.getMeasurementPeriod()));
        for (DeviceMetric.DeviceMetricCalibrationComponent t : src.getCalibration()) {
            tgt.addCalibration(this.convertDeviceMetricCalibrationComponent(t));
        }
        return tgt;
    }

    public DeviceMetric.DeviceMetricOperationalStatus convertDeviceMetricOperationalStatus(DeviceMetric.DeviceMetricOperationalStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ON: {
                return DeviceMetric.DeviceMetricOperationalStatus.ON;
            }
            case OFF: {
                return DeviceMetric.DeviceMetricOperationalStatus.OFF;
            }
            case STANDBY: {
                return DeviceMetric.DeviceMetricOperationalStatus.STANDBY;
            }
        }
        return DeviceMetric.DeviceMetricOperationalStatus.NULL;
    }

    public DeviceMetric.DeviceMetricOperationalStatus convertDeviceMetricOperationalStatus(DeviceMetric.DeviceMetricOperationalStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ON: {
                return DeviceMetric.DeviceMetricOperationalStatus.ON;
            }
            case OFF: {
                return DeviceMetric.DeviceMetricOperationalStatus.OFF;
            }
            case STANDBY: {
                return DeviceMetric.DeviceMetricOperationalStatus.STANDBY;
            }
        }
        return DeviceMetric.DeviceMetricOperationalStatus.NULL;
    }

    public DeviceMetric.DeviceMetricColor convertDeviceMetricColor(DeviceMetric.DeviceMetricColor src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case BLACK: {
                return DeviceMetric.DeviceMetricColor.BLACK;
            }
            case RED: {
                return DeviceMetric.DeviceMetricColor.RED;
            }
            case GREEN: {
                return DeviceMetric.DeviceMetricColor.GREEN;
            }
            case YELLOW: {
                return DeviceMetric.DeviceMetricColor.YELLOW;
            }
            case BLUE: {
                return DeviceMetric.DeviceMetricColor.BLUE;
            }
            case MAGENTA: {
                return DeviceMetric.DeviceMetricColor.MAGENTA;
            }
            case CYAN: {
                return DeviceMetric.DeviceMetricColor.CYAN;
            }
            case WHITE: {
                return DeviceMetric.DeviceMetricColor.WHITE;
            }
        }
        return DeviceMetric.DeviceMetricColor.NULL;
    }

    public DeviceMetric.DeviceMetricColor convertDeviceMetricColor(DeviceMetric.DeviceMetricColor src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case BLACK: {
                return DeviceMetric.DeviceMetricColor.BLACK;
            }
            case RED: {
                return DeviceMetric.DeviceMetricColor.RED;
            }
            case GREEN: {
                return DeviceMetric.DeviceMetricColor.GREEN;
            }
            case YELLOW: {
                return DeviceMetric.DeviceMetricColor.YELLOW;
            }
            case BLUE: {
                return DeviceMetric.DeviceMetricColor.BLUE;
            }
            case MAGENTA: {
                return DeviceMetric.DeviceMetricColor.MAGENTA;
            }
            case CYAN: {
                return DeviceMetric.DeviceMetricColor.CYAN;
            }
            case WHITE: {
                return DeviceMetric.DeviceMetricColor.WHITE;
            }
        }
        return DeviceMetric.DeviceMetricColor.NULL;
    }

    public DeviceMetric.DeviceMetricCategory convertDeviceMetricCategory(DeviceMetric.DeviceMetricCategory src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MEASUREMENT: {
                return DeviceMetric.DeviceMetricCategory.MEASUREMENT;
            }
            case SETTING: {
                return DeviceMetric.DeviceMetricCategory.SETTING;
            }
            case CALCULATION: {
                return DeviceMetric.DeviceMetricCategory.CALCULATION;
            }
            case UNSPECIFIED: {
                return DeviceMetric.DeviceMetricCategory.UNSPECIFIED;
            }
        }
        return DeviceMetric.DeviceMetricCategory.NULL;
    }

    public DeviceMetric.DeviceMetricCategory convertDeviceMetricCategory(DeviceMetric.DeviceMetricCategory src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MEASUREMENT: {
                return DeviceMetric.DeviceMetricCategory.MEASUREMENT;
            }
            case SETTING: {
                return DeviceMetric.DeviceMetricCategory.SETTING;
            }
            case CALCULATION: {
                return DeviceMetric.DeviceMetricCategory.CALCULATION;
            }
            case UNSPECIFIED: {
                return DeviceMetric.DeviceMetricCategory.UNSPECIFIED;
            }
        }
        return DeviceMetric.DeviceMetricCategory.NULL;
    }

    public DeviceMetric.DeviceMetricCalibrationComponent convertDeviceMetricCalibrationComponent(DeviceMetric.DeviceMetricCalibrationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DeviceMetric.DeviceMetricCalibrationComponent tgt = new DeviceMetric.DeviceMetricCalibrationComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setType(this.convertDeviceMetricCalibrationType(src.getType()));
        tgt.setState(this.convertDeviceMetricCalibrationState(src.getState()));
        tgt.setTime(src.getTime());
        return tgt;
    }

    public DeviceMetric.DeviceMetricCalibrationComponent convertDeviceMetricCalibrationComponent(DeviceMetric.DeviceMetricCalibrationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DeviceMetric.DeviceMetricCalibrationComponent tgt = new DeviceMetric.DeviceMetricCalibrationComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setType(this.convertDeviceMetricCalibrationType(src.getType()));
        tgt.setState(this.convertDeviceMetricCalibrationState(src.getState()));
        tgt.setTime(src.getTime());
        return tgt;
    }

    public DeviceMetric.DeviceMetricCalibrationType convertDeviceMetricCalibrationType(DeviceMetric.DeviceMetricCalibrationType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case UNSPECIFIED: {
                return DeviceMetric.DeviceMetricCalibrationType.UNSPECIFIED;
            }
            case OFFSET: {
                return DeviceMetric.DeviceMetricCalibrationType.OFFSET;
            }
            case GAIN: {
                return DeviceMetric.DeviceMetricCalibrationType.GAIN;
            }
            case TWOPOINT: {
                return DeviceMetric.DeviceMetricCalibrationType.TWOPOINT;
            }
        }
        return DeviceMetric.DeviceMetricCalibrationType.NULL;
    }

    public DeviceMetric.DeviceMetricCalibrationType convertDeviceMetricCalibrationType(DeviceMetric.DeviceMetricCalibrationType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case UNSPECIFIED: {
                return DeviceMetric.DeviceMetricCalibrationType.UNSPECIFIED;
            }
            case OFFSET: {
                return DeviceMetric.DeviceMetricCalibrationType.OFFSET;
            }
            case GAIN: {
                return DeviceMetric.DeviceMetricCalibrationType.GAIN;
            }
            case TWOPOINT: {
                return DeviceMetric.DeviceMetricCalibrationType.TWOPOINT;
            }
        }
        return DeviceMetric.DeviceMetricCalibrationType.NULL;
    }

    public DeviceMetric.DeviceMetricCalibrationState convertDeviceMetricCalibrationState(DeviceMetric.DeviceMetricCalibrationState src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOTCALIBRATED: {
                return DeviceMetric.DeviceMetricCalibrationState.NOTCALIBRATED;
            }
            case CALIBRATIONREQUIRED: {
                return DeviceMetric.DeviceMetricCalibrationState.CALIBRATIONREQUIRED;
            }
            case CALIBRATED: {
                return DeviceMetric.DeviceMetricCalibrationState.CALIBRATED;
            }
            case UNSPECIFIED: {
                return DeviceMetric.DeviceMetricCalibrationState.UNSPECIFIED;
            }
        }
        return DeviceMetric.DeviceMetricCalibrationState.NULL;
    }

    public DeviceMetric.DeviceMetricCalibrationState convertDeviceMetricCalibrationState(DeviceMetric.DeviceMetricCalibrationState src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NOTCALIBRATED: {
                return DeviceMetric.DeviceMetricCalibrationState.NOTCALIBRATED;
            }
            case CALIBRATIONREQUIRED: {
                return DeviceMetric.DeviceMetricCalibrationState.CALIBRATIONREQUIRED;
            }
            case CALIBRATED: {
                return DeviceMetric.DeviceMetricCalibrationState.CALIBRATED;
            }
            case UNSPECIFIED: {
                return DeviceMetric.DeviceMetricCalibrationState.UNSPECIFIED;
            }
        }
        return DeviceMetric.DeviceMetricCalibrationState.NULL;
    }

    public org.hl7.fhir.r4.model.DeviceUseStatement convertDeviceUseStatement(DeviceUseStatement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.DeviceUseStatement tgt = new org.hl7.fhir.r4.model.DeviceUseStatement();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        if (src.hasBodySiteCodeableConcept()) {
            tgt.setBodySite(this.convertCodeableConcept(src.getBodySiteCodeableConcept()));
        }
        tgt.setDevice(this.convertReference(src.getDevice()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getIndication()) {
            tgt.addReasonCode(this.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getNotes()) {
            tgt.addNote().setText((String)t.getValue());
        }
        tgt.setRecordedOn(src.getRecordedOn());
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setTiming(this.convertType(src.getTiming()));
        return tgt;
    }

    public DeviceUseStatement convertDeviceUseStatement(org.hl7.fhir.r4.model.DeviceUseStatement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DeviceUseStatement tgt = new DeviceUseStatement();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setBodySite(this.convertType((Type)src.getBodySite()));
        tgt.setDevice(this.convertReference(src.getDevice()));
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        for (Identifier t : src.getReasonCode()) {
            tgt.addIndication(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getNote()) {
            tgt.addNotes(t.getText());
        }
        tgt.setRecordedOn(src.getRecordedOn());
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setTiming(this.convertType(src.getTiming()));
        return tgt;
    }

    public org.hl7.fhir.r4.model.DiagnosticReport convertDiagnosticReport(DiagnosticReport src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.DiagnosticReport tgt = new org.hl7.fhir.r4.model.DiagnosticReport();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setStatus(this.convertDiagnosticReportStatus(src.getStatus()));
        tgt.addCategory(this.convertCodeableConcept(src.getCategory()));
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        tgt.setEffective(this.convertType(src.getEffective()));
        tgt.setIssued(src.getIssued());
        for (org.hl7.fhir.instance.model.Identifier t : src.getSpecimen()) {
            tgt.addSpecimen(this.convertReference((Reference)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getResult()) {
            tgt.addResult(this.convertReference((Reference)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getImagingStudy()) {
            tgt.addImagingStudy(this.convertReference((Reference)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getImage()) {
            tgt.addMedia(this.convertDiagnosticReportImageComponent((DiagnosticReport.DiagnosticReportImageComponent)t));
        }
        tgt.setConclusion(src.getConclusion());
        for (org.hl7.fhir.instance.model.Identifier t : src.getCodedDiagnosis()) {
            tgt.addConclusionCode(this.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getPresentedForm()) {
            tgt.addPresentedForm(this.convertAttachment((org.hl7.fhir.instance.model.Attachment)t));
        }
        return tgt;
    }

    public DiagnosticReport convertDiagnosticReport(org.hl7.fhir.r4.model.DiagnosticReport src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DiagnosticReport tgt = new DiagnosticReport();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setStatus(this.convertDiagnosticReportStatus(src.getStatus()));
        tgt.setCategory(this.convertCodeableConcept(src.getCategoryFirstRep()));
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        tgt.setEffective(this.convertType(src.getEffective()));
        tgt.setIssued(src.getIssued());
        for (Identifier t : src.getSpecimen()) {
            tgt.addSpecimen(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getResult()) {
            tgt.addResult(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getImagingStudy()) {
            tgt.addImagingStudy(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getMedia()) {
            tgt.addImage(this.convertDiagnosticReportImageComponent((DiagnosticReport.DiagnosticReportMediaComponent)t));
        }
        tgt.setConclusion(src.getConclusion());
        for (Identifier t : src.getConclusionCode()) {
            tgt.addCodedDiagnosis(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getPresentedForm()) {
            tgt.addPresentedForm(this.convertAttachment((Attachment)t));
        }
        return tgt;
    }

    public DiagnosticReport.DiagnosticReportStatus convertDiagnosticReportStatus(DiagnosticReport.DiagnosticReportStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REGISTERED: {
                return DiagnosticReport.DiagnosticReportStatus.REGISTERED;
            }
            case PARTIAL: {
                return DiagnosticReport.DiagnosticReportStatus.PARTIAL;
            }
            case FINAL: {
                return DiagnosticReport.DiagnosticReportStatus.FINAL;
            }
            case CORRECTED: {
                return DiagnosticReport.DiagnosticReportStatus.CORRECTED;
            }
            case APPENDED: {
                return DiagnosticReport.DiagnosticReportStatus.APPENDED;
            }
            case CANCELLED: {
                return DiagnosticReport.DiagnosticReportStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return DiagnosticReport.DiagnosticReportStatus.ENTEREDINERROR;
            }
        }
        return DiagnosticReport.DiagnosticReportStatus.NULL;
    }

    public DiagnosticReport.DiagnosticReportStatus convertDiagnosticReportStatus(DiagnosticReport.DiagnosticReportStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REGISTERED: {
                return DiagnosticReport.DiagnosticReportStatus.REGISTERED;
            }
            case PARTIAL: {
                return DiagnosticReport.DiagnosticReportStatus.PARTIAL;
            }
            case FINAL: {
                return DiagnosticReport.DiagnosticReportStatus.FINAL;
            }
            case CORRECTED: {
                return DiagnosticReport.DiagnosticReportStatus.CORRECTED;
            }
            case APPENDED: {
                return DiagnosticReport.DiagnosticReportStatus.APPENDED;
            }
            case CANCELLED: {
                return DiagnosticReport.DiagnosticReportStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return DiagnosticReport.DiagnosticReportStatus.ENTEREDINERROR;
            }
        }
        return DiagnosticReport.DiagnosticReportStatus.NULL;
    }

    public DiagnosticReport.DiagnosticReportMediaComponent convertDiagnosticReportImageComponent(DiagnosticReport.DiagnosticReportImageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DiagnosticReport.DiagnosticReportMediaComponent tgt = new DiagnosticReport.DiagnosticReportMediaComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setComment(src.getComment());
        tgt.setLink(this.convertReference(src.getLink()));
        return tgt;
    }

    public DiagnosticReport.DiagnosticReportImageComponent convertDiagnosticReportImageComponent(DiagnosticReport.DiagnosticReportMediaComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DiagnosticReport.DiagnosticReportImageComponent tgt = new DiagnosticReport.DiagnosticReportImageComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setComment(src.getComment());
        tgt.setLink(this.convertReference(src.getLink()));
        return tgt;
    }

    public Enumerations.DocumentReferenceStatus convertDocumentReferenceStatus(Enumerations.DocumentReferenceStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CURRENT: {
                return Enumerations.DocumentReferenceStatus.CURRENT;
            }
            case SUPERSEDED: {
                return Enumerations.DocumentReferenceStatus.SUPERSEDED;
            }
            case ENTEREDINERROR: {
                return Enumerations.DocumentReferenceStatus.ENTEREDINERROR;
            }
        }
        return Enumerations.DocumentReferenceStatus.NULL;
    }

    public Enumerations.DocumentReferenceStatus convertDocumentReferenceStatus(Enumerations.DocumentReferenceStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CURRENT: {
                return Enumerations.DocumentReferenceStatus.CURRENT;
            }
            case SUPERSEDED: {
                return Enumerations.DocumentReferenceStatus.SUPERSEDED;
            }
            case ENTEREDINERROR: {
                return Enumerations.DocumentReferenceStatus.ENTEREDINERROR;
            }
        }
        return Enumerations.DocumentReferenceStatus.NULL;
    }

    public DocumentManifest.DocumentManifestRelatedComponent convertDocumentManifestRelatedComponent(DocumentManifest.DocumentManifestRelatedComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentManifest.DocumentManifestRelatedComponent tgt = new DocumentManifest.DocumentManifestRelatedComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifier()));
        tgt.setRef(this.convertReference(src.getRef()));
        return tgt;
    }

    public DocumentManifest.DocumentManifestRelatedComponent convertDocumentManifestRelatedComponent(DocumentManifest.DocumentManifestRelatedComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentManifest.DocumentManifestRelatedComponent tgt = new DocumentManifest.DocumentManifestRelatedComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifier()));
        tgt.setRef(this.convertReference(src.getRef()));
        return tgt;
    }

    public org.hl7.fhir.r4.model.DocumentReference convertDocumentReference(DocumentReference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.DocumentReference tgt = new org.hl7.fhir.r4.model.DocumentReference();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setMasterIdentifier(this.convertIdentifier(src.getMasterIdentifier()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setType(this.convertCodeableConcept(src.getType()));
        tgt.addCategory(this.convertCodeableConcept(src.getClass_()));
        tgt.setCustodian(this.convertReference(src.getCustodian()));
        tgt.setAuthenticator(this.convertReference(src.getAuthenticator()));
        tgt.setDate(src.getCreated());
        tgt.setStatus(this.convertDocumentReferenceStatus(src.getStatus()));
        tgt.setDocStatus(this.convertDocStatus(src.getDocStatus()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getRelatesTo()) {
            tgt.addRelatesTo(this.convertDocumentReferenceRelatesToComponent((DocumentReference.DocumentReferenceRelatesToComponent)t));
        }
        tgt.setDescription(src.getDescription());
        for (org.hl7.fhir.instance.model.Identifier t : src.getSecurityLabel()) {
            tgt.addSecurityLabel(this.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getContent()) {
            tgt.addContent(this.convertDocumentReferenceContentComponent((DocumentReference.DocumentReferenceContentComponent)t));
        }
        tgt.setContext(this.convertDocumentReferenceContextComponent(src.getContext()));
        return tgt;
    }

    private DocumentReference.ReferredDocumentStatus convertDocStatus(CodeableConcept cc) {
        if (this.hasConcept(cc, "http://hl7.org/fhir/composition-status", "preliminary")) {
            return DocumentReference.ReferredDocumentStatus.PRELIMINARY;
        }
        if (this.hasConcept(cc, "http://hl7.org/fhir/composition-status", "final")) {
            return DocumentReference.ReferredDocumentStatus.FINAL;
        }
        if (this.hasConcept(cc, "http://hl7.org/fhir/composition-status", "amended")) {
            return DocumentReference.ReferredDocumentStatus.AMENDED;
        }
        if (this.hasConcept(cc, "http://hl7.org/fhir/composition-status", "entered-in-error")) {
            return DocumentReference.ReferredDocumentStatus.ENTEREDINERROR;
        }
        return null;
    }

    private CodeableConcept convertDocStatus(DocumentReference.ReferredDocumentStatus docStatus) {
        CodeableConcept cc = new CodeableConcept();
        switch (docStatus) {
            case AMENDED: {
                cc.addCoding().setSystem("http://hl7.org/fhir/composition-status").setCode("amended");
                break;
            }
            case ENTEREDINERROR: {
                cc.addCoding().setSystem("http://hl7.org/fhir/composition-status").setCode("entered-in-error");
                break;
            }
            case FINAL: {
                cc.addCoding().setSystem("http://hl7.org/fhir/composition-status").setCode("final");
                break;
            }
            case PRELIMINARY: {
                cc.addCoding().setSystem("http://hl7.org/fhir/composition-status").setCode("preliminary");
                break;
            }
            default: {
                return null;
            }
        }
        return cc;
    }

    public DocumentReference convertDocumentReference(org.hl7.fhir.r4.model.DocumentReference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference tgt = new DocumentReference();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setMasterIdentifier(this.convertIdentifier(src.getMasterIdentifier()));
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setType(this.convertCodeableConcept(src.getType()));
        tgt.setClass_(this.convertCodeableConcept(src.getCategoryFirstRep()));
        tgt.setCustodian(this.convertReference(src.getCustodian()));
        tgt.setAuthenticator(this.convertReference(src.getAuthenticator()));
        tgt.setCreated(src.getDate());
        tgt.setStatus(this.convertDocumentReferenceStatus(src.getStatus()));
        tgt.setDocStatus(this.convertDocStatus(src.getDocStatus()));
        for (Identifier t : src.getRelatesTo()) {
            tgt.addRelatesTo(this.convertDocumentReferenceRelatesToComponent((DocumentReference.DocumentReferenceRelatesToComponent)t));
        }
        tgt.setDescription(src.getDescription());
        for (Identifier t : src.getSecurityLabel()) {
            tgt.addSecurityLabel(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getContent()) {
            tgt.addContent(this.convertDocumentReferenceContentComponent((DocumentReference.DocumentReferenceContentComponent)t));
        }
        tgt.setContext(this.convertDocumentReferenceContextComponent(src.getContext()));
        return tgt;
    }

    public DocumentReference.DocumentReferenceRelatesToComponent convertDocumentReferenceRelatesToComponent(DocumentReference.DocumentReferenceRelatesToComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceRelatesToComponent tgt = new DocumentReference.DocumentReferenceRelatesToComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setCode(this.convertDocumentRelationshipType(src.getCode()));
        tgt.setTarget(this.convertReference(src.getTarget()));
        return tgt;
    }

    public DocumentReference.DocumentReferenceRelatesToComponent convertDocumentReferenceRelatesToComponent(DocumentReference.DocumentReferenceRelatesToComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceRelatesToComponent tgt = new DocumentReference.DocumentReferenceRelatesToComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setCode(this.convertDocumentRelationshipType(src.getCode()));
        tgt.setTarget(this.convertReference(src.getTarget()));
        return tgt;
    }

    public DocumentReference.DocumentRelationshipType convertDocumentRelationshipType(DocumentReference.DocumentRelationshipType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REPLACES: {
                return DocumentReference.DocumentRelationshipType.REPLACES;
            }
            case TRANSFORMS: {
                return DocumentReference.DocumentRelationshipType.TRANSFORMS;
            }
            case SIGNS: {
                return DocumentReference.DocumentRelationshipType.SIGNS;
            }
            case APPENDS: {
                return DocumentReference.DocumentRelationshipType.APPENDS;
            }
        }
        return DocumentReference.DocumentRelationshipType.NULL;
    }

    public DocumentReference.DocumentRelationshipType convertDocumentRelationshipType(DocumentReference.DocumentRelationshipType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REPLACES: {
                return DocumentReference.DocumentRelationshipType.REPLACES;
            }
            case TRANSFORMS: {
                return DocumentReference.DocumentRelationshipType.TRANSFORMS;
            }
            case SIGNS: {
                return DocumentReference.DocumentRelationshipType.SIGNS;
            }
            case APPENDS: {
                return DocumentReference.DocumentRelationshipType.APPENDS;
            }
        }
        return DocumentReference.DocumentRelationshipType.NULL;
    }

    public DocumentReference.DocumentReferenceContentComponent convertDocumentReferenceContentComponent(DocumentReference.DocumentReferenceContentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContentComponent tgt = new DocumentReference.DocumentReferenceContentComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setAttachment(this.convertAttachment(src.getAttachment()));
        for (Coding t : src.getFormat()) {
            tgt.setFormat(this.convertCoding(t));
        }
        return tgt;
    }

    public DocumentReference.DocumentReferenceContentComponent convertDocumentReferenceContentComponent(DocumentReference.DocumentReferenceContentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContentComponent tgt = new DocumentReference.DocumentReferenceContentComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setAttachment(this.convertAttachment(src.getAttachment()));
        tgt.addFormat(this.convertCoding(src.getFormat()));
        return tgt;
    }

    public DocumentReference.DocumentReferenceContextComponent convertDocumentReferenceContextComponent(DocumentReference.DocumentReferenceContextComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContextComponent tgt = new DocumentReference.DocumentReferenceContextComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.addEncounter(this.convertReference(src.getEncounter()));
        for (CodeableConcept t : src.getEvent()) {
            tgt.addEvent(this.convertCodeableConcept(t));
        }
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        tgt.setFacilityType(this.convertCodeableConcept(src.getFacilityType()));
        tgt.setPracticeSetting(this.convertCodeableConcept(src.getPracticeSetting()));
        tgt.setSourcePatientInfo(this.convertReference(src.getSourcePatientInfo()));
        for (CodeableConcept t : src.getRelated()) {
            tgt.addRelated(this.convertDocumentReferenceContextRelatedComponent((DocumentReference.DocumentReferenceContextRelatedComponent)t));
        }
        return tgt;
    }

    public DocumentReference.DocumentReferenceContextComponent convertDocumentReferenceContextComponent(DocumentReference.DocumentReferenceContextComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContextComponent tgt = new DocumentReference.DocumentReferenceContextComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        if (src.hasEncounter()) {
            tgt.setEncounter(this.convertReference(src.getEncounterFirstRep()));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getEvent()) {
            tgt.addEvent(this.convertCodeableConcept(t));
        }
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        tgt.setFacilityType(this.convertCodeableConcept(src.getFacilityType()));
        tgt.setPracticeSetting(this.convertCodeableConcept(src.getPracticeSetting()));
        tgt.setSourcePatientInfo(this.convertReference(src.getSourcePatientInfo()));
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getRelated()) {
            tgt.addRelated(this.convertDocumentReferenceContextRelatedComponent((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    public org.hl7.fhir.r4.model.Reference convertDocumentReferenceContextRelatedComponent(DocumentReference.DocumentReferenceContextRelatedComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Reference tgt = this.convertReference(src.getRef());
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifier()));
        return tgt;
    }

    public DocumentReference.DocumentReferenceContextRelatedComponent convertDocumentReferenceContextRelatedComponent(org.hl7.fhir.r4.model.Reference src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        DocumentReference.DocumentReferenceContextRelatedComponent tgt = new DocumentReference.DocumentReferenceContextRelatedComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifier()));
        tgt.setRef(this.convertReference(src));
        return tgt;
    }

    public org.hl7.fhir.r4.model.Encounter convertEncounter(Encounter src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Encounter tgt = new org.hl7.fhir.r4.model.Encounter();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setStatus(this.convertEncounterState(src.getStatus()));
        tgt.setClass_(this.convertEncounterClass(src.getClass_()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getType()) {
            tgt.addType(this.convertCodeableConcept((CodeableConcept)t));
        }
        tgt.setPriority(this.convertCodeableConcept(src.getPriority()));
        tgt.setSubject(this.convertReference(src.getPatient()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getEpisodeOfCare()) {
            tgt.addEpisodeOfCare(this.convertReference((Reference)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getIncomingReferral()) {
            tgt.addBasedOn(this.convertReference((Reference)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getParticipant()) {
            tgt.addParticipant(this.convertEncounterParticipantComponent((Encounter.EncounterParticipantComponent)t));
        }
        tgt.addAppointment(this.convertReference(src.getAppointment()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        tgt.setLength(this.convertDuration(src.getLength()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getReason()) {
            tgt.addReasonCode(this.convertCodeableConcept((CodeableConcept)t));
        }
        tgt.setHospitalization(this.convertEncounterHospitalizationComponent(src.getHospitalization()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getLocation()) {
            tgt.addLocation(this.convertEncounterLocationComponent((Encounter.EncounterLocationComponent)t));
        }
        tgt.setServiceProvider(this.convertReference(src.getServiceProvider()));
        tgt.setPartOf(this.convertReference(src.getPartOf()));
        return tgt;
    }

    public Encounter convertEncounter(org.hl7.fhir.r4.model.Encounter src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Encounter tgt = new Encounter();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setStatus(this.convertEncounterState(src.getStatus()));
        tgt.setClass_(this.convertEncounterClass(src.getClass_()));
        for (Identifier t : src.getType()) {
            tgt.addType(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setPriority(this.convertCodeableConcept(src.getPriority()));
        tgt.setPatient(this.convertReference(src.getSubject()));
        for (Identifier t : src.getEpisodeOfCare()) {
            tgt.addEpisodeOfCare(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getBasedOn()) {
            tgt.addIncomingReferral(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getParticipant()) {
            tgt.addParticipant(this.convertEncounterParticipantComponent((Encounter.EncounterParticipantComponent)t));
        }
        tgt.setAppointment(this.convertReference(src.getAppointmentFirstRep()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        tgt.setLength(this.convertDuration(src.getLength()));
        for (Identifier t : src.getReasonCode()) {
            tgt.addReason(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setHospitalization(this.convertEncounterHospitalizationComponent(src.getHospitalization()));
        for (Identifier t : src.getLocation()) {
            tgt.addLocation(this.convertEncounterLocationComponent((Encounter.EncounterLocationComponent)t));
        }
        tgt.setServiceProvider(this.convertReference(src.getServiceProvider()));
        tgt.setPartOf(this.convertReference(src.getPartOf()));
        return tgt;
    }

    public Encounter.EncounterStatus convertEncounterState(Encounter.EncounterState src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PLANNED: {
                return Encounter.EncounterStatus.PLANNED;
            }
            case ARRIVED: {
                return Encounter.EncounterStatus.ARRIVED;
            }
            case INPROGRESS: {
                return Encounter.EncounterStatus.INPROGRESS;
            }
            case ONLEAVE: {
                return Encounter.EncounterStatus.ONLEAVE;
            }
            case FINISHED: {
                return Encounter.EncounterStatus.FINISHED;
            }
            case CANCELLED: {
                return Encounter.EncounterStatus.CANCELLED;
            }
        }
        return Encounter.EncounterStatus.NULL;
    }

    public Encounter.EncounterState convertEncounterState(Encounter.EncounterStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PLANNED: {
                return Encounter.EncounterState.PLANNED;
            }
            case ARRIVED: {
                return Encounter.EncounterState.ARRIVED;
            }
            case INPROGRESS: {
                return Encounter.EncounterState.INPROGRESS;
            }
            case ONLEAVE: {
                return Encounter.EncounterState.ONLEAVE;
            }
            case FINISHED: {
                return Encounter.EncounterState.FINISHED;
            }
            case CANCELLED: {
                return Encounter.EncounterState.CANCELLED;
            }
        }
        return Encounter.EncounterState.NULL;
    }

    public org.hl7.fhir.r4.model.Coding convertEncounterClass(Encounter.EncounterClass src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INPATIENT: {
                return new org.hl7.fhir.r4.model.Coding().setSystem("http://terminology.hl7.org/v3/ActCode").setCode("IMP");
            }
            case OUTPATIENT: {
                return new org.hl7.fhir.r4.model.Coding().setSystem("http://terminology.hl7.org/v3/ActCode").setCode("AMB");
            }
            case AMBULATORY: {
                return new org.hl7.fhir.r4.model.Coding().setSystem("http://terminology.hl7.org/v3/ActCode").setCode("AMB");
            }
            case EMERGENCY: {
                return new org.hl7.fhir.r4.model.Coding().setSystem("http://terminology.hl7.org/v3/ActCode").setCode("EMER");
            }
            case HOME: {
                return new org.hl7.fhir.r4.model.Coding().setSystem("http://terminology.hl7.org/v3/ActCode").setCode("HH");
            }
            case FIELD: {
                return new org.hl7.fhir.r4.model.Coding().setSystem("http://terminology.hl7.org/v3/ActCode").setCode("FLD");
            }
            case DAYTIME: {
                return new org.hl7.fhir.r4.model.Coding().setSystem("http://terminology.hl7.org/v3/ActCode").setCode("SS");
            }
            case VIRTUAL: {
                return new org.hl7.fhir.r4.model.Coding().setSystem("http://terminology.hl7.org/v3/ActCode").setCode("VR");
            }
        }
        return null;
    }

    public Encounter.EncounterClass convertEncounterClass(org.hl7.fhir.r4.model.Coding src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src.getSystem().equals("http://terminology.hl7.org/v3/ActCode")) {
            if (src.getCode().equals("IMP")) {
                return Encounter.EncounterClass.INPATIENT;
            }
            if (src.getCode().equals("AMB")) {
                return Encounter.EncounterClass.AMBULATORY;
            }
            if (src.getCode().equals("EMER")) {
                return Encounter.EncounterClass.EMERGENCY;
            }
            if (src.getCode().equals("HH")) {
                return Encounter.EncounterClass.HOME;
            }
            if (src.getCode().equals("FLD")) {
                return Encounter.EncounterClass.FIELD;
            }
            if (src.getCode().equals("")) {
                return Encounter.EncounterClass.DAYTIME;
            }
            if (src.getCode().equals("VR")) {
                return Encounter.EncounterClass.VIRTUAL;
            }
        }
        return Encounter.EncounterClass.NULL;
    }

    public Encounter.EncounterParticipantComponent convertEncounterParticipantComponent(Encounter.EncounterParticipantComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Encounter.EncounterParticipantComponent tgt = new Encounter.EncounterParticipantComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (CodeableConcept t : src.getType()) {
            tgt.addType(this.convertCodeableConcept(t));
        }
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        tgt.setIndividual(this.convertReference(src.getIndividual()));
        return tgt;
    }

    public Encounter.EncounterParticipantComponent convertEncounterParticipantComponent(Encounter.EncounterParticipantComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Encounter.EncounterParticipantComponent tgt = new Encounter.EncounterParticipantComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getType()) {
            tgt.addType(this.convertCodeableConcept(t));
        }
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        tgt.setIndividual(this.convertReference(src.getIndividual()));
        return tgt;
    }

    public Encounter.EncounterHospitalizationComponent convertEncounterHospitalizationComponent(Encounter.EncounterHospitalizationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Encounter.EncounterHospitalizationComponent tgt = new Encounter.EncounterHospitalizationComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setPreAdmissionIdentifier(this.convertIdentifier(src.getPreAdmissionIdentifier()));
        tgt.setOrigin(this.convertReference(src.getOrigin()));
        tgt.setAdmitSource(this.convertCodeableConcept(src.getAdmitSource()));
        tgt.setReAdmission(this.convertCodeableConcept(src.getReAdmission()));
        for (CodeableConcept t : src.getDietPreference()) {
            tgt.addDietPreference(this.convertCodeableConcept(t));
        }
        for (CodeableConcept t : src.getSpecialCourtesy()) {
            tgt.addSpecialCourtesy(this.convertCodeableConcept(t));
        }
        for (CodeableConcept t : src.getSpecialArrangement()) {
            tgt.addSpecialArrangement(this.convertCodeableConcept(t));
        }
        tgt.setDestination(this.convertReference(src.getDestination()));
        tgt.setDischargeDisposition(this.convertCodeableConcept(src.getDischargeDisposition()));
        return tgt;
    }

    public Encounter.EncounterHospitalizationComponent convertEncounterHospitalizationComponent(Encounter.EncounterHospitalizationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Encounter.EncounterHospitalizationComponent tgt = new Encounter.EncounterHospitalizationComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setPreAdmissionIdentifier(this.convertIdentifier(src.getPreAdmissionIdentifier()));
        tgt.setOrigin(this.convertReference(src.getOrigin()));
        tgt.setAdmitSource(this.convertCodeableConcept(src.getAdmitSource()));
        tgt.setReAdmission(this.convertCodeableConcept(src.getReAdmission()));
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getDietPreference()) {
            tgt.addDietPreference(this.convertCodeableConcept(t));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getSpecialCourtesy()) {
            tgt.addSpecialCourtesy(this.convertCodeableConcept(t));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getSpecialArrangement()) {
            tgt.addSpecialArrangement(this.convertCodeableConcept(t));
        }
        tgt.setDestination(this.convertReference(src.getDestination()));
        tgt.setDischargeDisposition(this.convertCodeableConcept(src.getDischargeDisposition()));
        return tgt;
    }

    public Encounter.EncounterLocationComponent convertEncounterLocationComponent(Encounter.EncounterLocationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Encounter.EncounterLocationComponent tgt = new Encounter.EncounterLocationComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setLocation(this.convertReference(src.getLocation()));
        tgt.setStatus(this.convertEncounterLocationStatus(src.getStatus()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public Encounter.EncounterLocationComponent convertEncounterLocationComponent(Encounter.EncounterLocationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Encounter.EncounterLocationComponent tgt = new Encounter.EncounterLocationComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setLocation(this.convertReference(src.getLocation()));
        tgt.setStatus(this.convertEncounterLocationStatus(src.getStatus()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public Encounter.EncounterLocationStatus convertEncounterLocationStatus(Encounter.EncounterLocationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PLANNED: {
                return Encounter.EncounterLocationStatus.PLANNED;
            }
            case ACTIVE: {
                return Encounter.EncounterLocationStatus.ACTIVE;
            }
            case RESERVED: {
                return Encounter.EncounterLocationStatus.RESERVED;
            }
            case COMPLETED: {
                return Encounter.EncounterLocationStatus.COMPLETED;
            }
        }
        return Encounter.EncounterLocationStatus.NULL;
    }

    public Encounter.EncounterLocationStatus convertEncounterLocationStatus(Encounter.EncounterLocationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PLANNED: {
                return Encounter.EncounterLocationStatus.PLANNED;
            }
            case ACTIVE: {
                return Encounter.EncounterLocationStatus.ACTIVE;
            }
            case RESERVED: {
                return Encounter.EncounterLocationStatus.RESERVED;
            }
            case COMPLETED: {
                return Encounter.EncounterLocationStatus.COMPLETED;
            }
        }
        return Encounter.EncounterLocationStatus.NULL;
    }

    public org.hl7.fhir.r4.model.EnrollmentRequest convertEnrollmentRequest(EnrollmentRequest src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.EnrollmentRequest tgt = new org.hl7.fhir.r4.model.EnrollmentRequest();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setCreated(src.getCreated());
        tgt.setProvider(this.convertReference(src.getProvider()));
        tgt.setCandidate(this.convertReference(src.getSubject()));
        tgt.setCoverage(this.convertReference(src.getCoverage()));
        return tgt;
    }

    public EnrollmentRequest convertEnrollmentRequest(org.hl7.fhir.r4.model.EnrollmentRequest src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        EnrollmentRequest tgt = new EnrollmentRequest();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setCreated(src.getCreated());
        tgt.setCoverage(this.convertReference(src.getCoverage()));
        return tgt;
    }

    public EnrollmentResponse convertEnrollmentResponse(org.hl7.fhir.instance.model.EnrollmentResponse src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        EnrollmentResponse tgt = new EnrollmentResponse();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setRequest(this.convertReference(src.getRequest()));
        tgt.setDisposition(src.getDisposition());
        tgt.setCreated(src.getCreated());
        tgt.setOrganization(this.convertReference(src.getOrganization()));
        tgt.setRequestProvider(this.convertReference(src.getRequestProvider()));
        return tgt;
    }

    public org.hl7.fhir.instance.model.EnrollmentResponse convertEnrollmentResponse(EnrollmentResponse src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.EnrollmentResponse tgt = new org.hl7.fhir.instance.model.EnrollmentResponse();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setDisposition(src.getDisposition());
        tgt.setCreated(src.getCreated());
        return tgt;
    }

    public EpisodeOfCare convertEpisodeOfCare(org.hl7.fhir.instance.model.EpisodeOfCare src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        EpisodeOfCare tgt = new EpisodeOfCare();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setStatus(this.convertEpisodeOfCareStatus(src.getStatus()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getStatusHistory()) {
            tgt.addStatusHistory(this.convertEpisodeOfCareStatusHistoryComponent((EpisodeOfCare.EpisodeOfCareStatusHistoryComponent)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getType()) {
            tgt.addType(this.convertCodeableConcept((CodeableConcept)t));
        }
        tgt.setPatient(this.convertReference(src.getPatient()));
        tgt.setManagingOrganization(this.convertReference(src.getManagingOrganization()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getReferralRequest()) {
            tgt.addReferralRequest(this.convertReference((Reference)t));
        }
        tgt.setCareManager(this.convertReference(src.getCareManager()));
        return tgt;
    }

    public org.hl7.fhir.instance.model.EpisodeOfCare convertEpisodeOfCare(EpisodeOfCare src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.EpisodeOfCare tgt = new org.hl7.fhir.instance.model.EpisodeOfCare();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setStatus(this.convertEpisodeOfCareStatus(src.getStatus()));
        for (Identifier t : src.getStatusHistory()) {
            tgt.addStatusHistory(this.convertEpisodeOfCareStatusHistoryComponent((EpisodeOfCare.EpisodeOfCareStatusHistoryComponent)t));
        }
        for (Identifier t : src.getType()) {
            tgt.addType(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setPatient(this.convertReference(src.getPatient()));
        tgt.setManagingOrganization(this.convertReference(src.getManagingOrganization()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        for (Identifier t : src.getReferralRequest()) {
            tgt.addReferralRequest(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        tgt.setCareManager(this.convertReference(src.getCareManager()));
        return tgt;
    }

    public EpisodeOfCare.EpisodeOfCareStatus convertEpisodeOfCareStatus(EpisodeOfCare.EpisodeOfCareStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PLANNED: {
                return EpisodeOfCare.EpisodeOfCareStatus.PLANNED;
            }
            case WAITLIST: {
                return EpisodeOfCare.EpisodeOfCareStatus.WAITLIST;
            }
            case ACTIVE: {
                return EpisodeOfCare.EpisodeOfCareStatus.ACTIVE;
            }
            case ONHOLD: {
                return EpisodeOfCare.EpisodeOfCareStatus.ONHOLD;
            }
            case FINISHED: {
                return EpisodeOfCare.EpisodeOfCareStatus.FINISHED;
            }
            case CANCELLED: {
                return EpisodeOfCare.EpisodeOfCareStatus.CANCELLED;
            }
        }
        return EpisodeOfCare.EpisodeOfCareStatus.NULL;
    }

    public EpisodeOfCare.EpisodeOfCareStatus convertEpisodeOfCareStatus(EpisodeOfCare.EpisodeOfCareStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PLANNED: {
                return EpisodeOfCare.EpisodeOfCareStatus.PLANNED;
            }
            case WAITLIST: {
                return EpisodeOfCare.EpisodeOfCareStatus.WAITLIST;
            }
            case ACTIVE: {
                return EpisodeOfCare.EpisodeOfCareStatus.ACTIVE;
            }
            case ONHOLD: {
                return EpisodeOfCare.EpisodeOfCareStatus.ONHOLD;
            }
            case FINISHED: {
                return EpisodeOfCare.EpisodeOfCareStatus.FINISHED;
            }
            case CANCELLED: {
                return EpisodeOfCare.EpisodeOfCareStatus.CANCELLED;
            }
        }
        return EpisodeOfCare.EpisodeOfCareStatus.NULL;
    }

    public EpisodeOfCare.EpisodeOfCareStatusHistoryComponent convertEpisodeOfCareStatusHistoryComponent(EpisodeOfCare.EpisodeOfCareStatusHistoryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent tgt = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setStatus(this.convertEpisodeOfCareStatus(src.getStatus()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public EpisodeOfCare.EpisodeOfCareStatusHistoryComponent convertEpisodeOfCareStatusHistoryComponent(EpisodeOfCare.EpisodeOfCareStatusHistoryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        EpisodeOfCare.EpisodeOfCareStatusHistoryComponent tgt = new EpisodeOfCare.EpisodeOfCareStatusHistoryComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setStatus(this.convertEpisodeOfCareStatus(src.getStatus()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public org.hl7.fhir.r4.model.FamilyMemberHistory convertFamilyMemberHistory(FamilyMemberHistory src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.FamilyMemberHistory tgt = new org.hl7.fhir.r4.model.FamilyMemberHistory();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setPatient(this.convertReference(src.getPatient()));
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setStatus(this.convertFamilyHistoryStatus(src.getStatus()));
        tgt.setName(src.getName());
        tgt.setRelationship(this.convertCodeableConcept(src.getRelationship()));
        tgt.setBorn(this.convertType(src.getBorn()));
        tgt.setAge(this.convertType(src.getAge()));
        tgt.setDeceased(this.convertType(src.getDeceased()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getCondition()) {
            tgt.addCondition(this.convertFamilyMemberHistoryConditionComponent((FamilyMemberHistory.FamilyMemberHistoryConditionComponent)t));
        }
        return tgt;
    }

    public FamilyMemberHistory convertFamilyMemberHistory(org.hl7.fhir.r4.model.FamilyMemberHistory src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        FamilyMemberHistory tgt = new FamilyMemberHistory();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setPatient(this.convertReference(src.getPatient()));
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setStatus(this.convertFamilyHistoryStatus(src.getStatus()));
        tgt.setName(src.getName());
        tgt.setRelationship(this.convertCodeableConcept(src.getRelationship()));
        tgt.setBorn(this.convertType(src.getBorn()));
        tgt.setAge(this.convertType(src.getAge()));
        tgt.setDeceased(this.convertType(src.getDeceased()));
        for (Identifier t : src.getCondition()) {
            tgt.addCondition(this.convertFamilyMemberHistoryConditionComponent((FamilyMemberHistory.FamilyMemberHistoryConditionComponent)t));
        }
        return tgt;
    }

    public FamilyMemberHistory.FamilyHistoryStatus convertFamilyHistoryStatus(FamilyMemberHistory.FamilyHistoryStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PARTIAL: {
                return FamilyMemberHistory.FamilyHistoryStatus.PARTIAL;
            }
            case COMPLETED: {
                return FamilyMemberHistory.FamilyHistoryStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return FamilyMemberHistory.FamilyHistoryStatus.ENTEREDINERROR;
            }
            case HEALTHUNKNOWN: {
                return FamilyMemberHistory.FamilyHistoryStatus.HEALTHUNKNOWN;
            }
        }
        return FamilyMemberHistory.FamilyHistoryStatus.NULL;
    }

    public FamilyMemberHistory.FamilyHistoryStatus convertFamilyHistoryStatus(FamilyMemberHistory.FamilyHistoryStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PARTIAL: {
                return FamilyMemberHistory.FamilyHistoryStatus.PARTIAL;
            }
            case COMPLETED: {
                return FamilyMemberHistory.FamilyHistoryStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return FamilyMemberHistory.FamilyHistoryStatus.ENTEREDINERROR;
            }
            case HEALTHUNKNOWN: {
                return FamilyMemberHistory.FamilyHistoryStatus.HEALTHUNKNOWN;
            }
        }
        return FamilyMemberHistory.FamilyHistoryStatus.NULL;
    }

    public FamilyMemberHistory.FamilyMemberHistoryConditionComponent convertFamilyMemberHistoryConditionComponent(FamilyMemberHistory.FamilyMemberHistoryConditionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent tgt = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setOutcome(this.convertCodeableConcept(src.getOutcome()));
        tgt.setOnset(this.convertType(src.getOnset()));
        return tgt;
    }

    public FamilyMemberHistory.FamilyMemberHistoryConditionComponent convertFamilyMemberHistoryConditionComponent(FamilyMemberHistory.FamilyMemberHistoryConditionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        FamilyMemberHistory.FamilyMemberHistoryConditionComponent tgt = new FamilyMemberHistory.FamilyMemberHistoryConditionComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setOutcome(this.convertCodeableConcept(src.getOutcome()));
        tgt.setOnset(this.convertType(src.getOnset()));
        return tgt;
    }

    public Flag convertFlag(org.hl7.fhir.instance.model.Flag src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Flag tgt = new Flag();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.addCategory(this.convertCodeableConcept(src.getCategory()));
        tgt.setStatus(this.convertFlagStatus(src.getStatus()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        tgt.setAuthor(this.convertReference(src.getAuthor()));
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        return tgt;
    }

    public org.hl7.fhir.instance.model.Flag convertFlag(Flag src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Flag tgt = new org.hl7.fhir.instance.model.Flag();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setCategory(this.convertCodeableConcept(src.getCategoryFirstRep()));
        tgt.setStatus(this.convertFlagStatus(src.getStatus()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        tgt.setAuthor(this.convertReference(src.getAuthor()));
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        return tgt;
    }

    public Flag.FlagStatus convertFlagStatus(Flag.FlagStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return Flag.FlagStatus.ACTIVE;
            }
            case INACTIVE: {
                return Flag.FlagStatus.INACTIVE;
            }
            case ENTEREDINERROR: {
                return Flag.FlagStatus.ENTEREDINERROR;
            }
        }
        return Flag.FlagStatus.NULL;
    }

    public Flag.FlagStatus convertFlagStatus(Flag.FlagStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return Flag.FlagStatus.ACTIVE;
            }
            case INACTIVE: {
                return Flag.FlagStatus.INACTIVE;
            }
            case ENTEREDINERROR: {
                return Flag.FlagStatus.ENTEREDINERROR;
            }
        }
        return Flag.FlagStatus.NULL;
    }

    public Group convertGroup(org.hl7.fhir.instance.model.Group src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Group tgt = new Group();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setType(this.convertGroupType(src.getType()));
        tgt.setActual(src.getActual());
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setName(src.getName());
        tgt.setQuantity(src.getQuantity());
        for (org.hl7.fhir.instance.model.Identifier t : src.getCharacteristic()) {
            tgt.addCharacteristic(this.convertGroupCharacteristicComponent((Group.GroupCharacteristicComponent)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getMember()) {
            tgt.addMember(this.convertGroupMemberComponent((Group.GroupMemberComponent)t));
        }
        return tgt;
    }

    public org.hl7.fhir.instance.model.Group convertGroup(Group src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Group tgt = new org.hl7.fhir.instance.model.Group();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setType(this.convertGroupType(src.getType()));
        tgt.setActual(src.getActual());
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setName(src.getName());
        tgt.setQuantity(src.getQuantity());
        for (Identifier t : src.getCharacteristic()) {
            tgt.addCharacteristic(this.convertGroupCharacteristicComponent((Group.GroupCharacteristicComponent)t));
        }
        for (Identifier t : src.getMember()) {
            tgt.addMember(this.convertGroupMemberComponent((Group.GroupMemberComponent)t));
        }
        return tgt;
    }

    public Group.GroupType convertGroupType(Group.GroupType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PERSON: {
                return Group.GroupType.PERSON;
            }
            case ANIMAL: {
                return Group.GroupType.ANIMAL;
            }
            case PRACTITIONER: {
                return Group.GroupType.PRACTITIONER;
            }
            case DEVICE: {
                return Group.GroupType.DEVICE;
            }
            case MEDICATION: {
                return Group.GroupType.MEDICATION;
            }
            case SUBSTANCE: {
                return Group.GroupType.SUBSTANCE;
            }
        }
        return Group.GroupType.NULL;
    }

    public Group.GroupType convertGroupType(Group.GroupType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PERSON: {
                return Group.GroupType.PERSON;
            }
            case ANIMAL: {
                return Group.GroupType.ANIMAL;
            }
            case PRACTITIONER: {
                return Group.GroupType.PRACTITIONER;
            }
            case DEVICE: {
                return Group.GroupType.DEVICE;
            }
            case MEDICATION: {
                return Group.GroupType.MEDICATION;
            }
            case SUBSTANCE: {
                return Group.GroupType.SUBSTANCE;
            }
        }
        return Group.GroupType.NULL;
    }

    public Group.GroupCharacteristicComponent convertGroupCharacteristicComponent(Group.GroupCharacteristicComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Group.GroupCharacteristicComponent tgt = new Group.GroupCharacteristicComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setValue(this.convertType(src.getValue()));
        tgt.setExclude(src.getExclude());
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public Group.GroupCharacteristicComponent convertGroupCharacteristicComponent(Group.GroupCharacteristicComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Group.GroupCharacteristicComponent tgt = new Group.GroupCharacteristicComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setValue(this.convertType(src.getValue()));
        tgt.setExclude(src.getExclude());
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public Group.GroupMemberComponent convertGroupMemberComponent(Group.GroupMemberComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Group.GroupMemberComponent tgt = new Group.GroupMemberComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setEntity(this.convertReference(src.getEntity()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        tgt.setInactive(src.getInactive());
        return tgt;
    }

    public Group.GroupMemberComponent convertGroupMemberComponent(Group.GroupMemberComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Group.GroupMemberComponent tgt = new Group.GroupMemberComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setEntity(this.convertReference(src.getEntity()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        tgt.setInactive(src.getInactive());
        return tgt;
    }

    public HealthcareService convertHealthcareService(org.hl7.fhir.instance.model.HealthcareService src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService tgt = new HealthcareService();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setProvidedBy(this.convertReference(src.getProvidedBy()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getServiceType()) {
            for (CodeableConcept tj : t.getSpecialty()) {
                tgt.addSpecialty(this.convertCodeableConcept(tj));
            }
        }
        tgt.addLocation(this.convertReference(src.getLocation()));
        tgt.setComment(src.getComment());
        tgt.setExtraDetails(src.getExtraDetails());
        tgt.setPhoto(this.convertAttachment(src.getPhoto()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint((ContactPoint)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getCoverageArea()) {
            tgt.addCoverageArea(this.convertReference((Reference)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getServiceProvisionCode()) {
            tgt.addServiceProvisionCode(this.convertCodeableConcept((CodeableConcept)t));
        }
        if (src.hasEligibility()) {
            tgt.getEligibilityFirstRep().setCode(this.convertCodeableConcept(src.getEligibility()));
        }
        if (src.hasEligibilityNote()) {
            tgt.getEligibilityFirstRep().setComment(src.getEligibilityNote());
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getProgramName()) {
            tgt.addProgram().setText((String)t.getValue());
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getCharacteristic()) {
            tgt.addCharacteristic(this.convertCodeableConcept((CodeableConcept)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getReferralMethod()) {
            tgt.addReferralMethod(this.convertCodeableConcept((CodeableConcept)t));
        }
        tgt.setAppointmentRequired(src.getAppointmentRequired());
        for (org.hl7.fhir.instance.model.Identifier t : src.getAvailableTime()) {
            tgt.addAvailableTime(this.convertHealthcareServiceAvailableTimeComponent((HealthcareService.HealthcareServiceAvailableTimeComponent)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getNotAvailable()) {
            tgt.addNotAvailable(this.convertHealthcareServiceNotAvailableComponent((HealthcareService.HealthcareServiceNotAvailableComponent)t));
        }
        tgt.setAvailabilityExceptions(src.getAvailabilityExceptions());
        return tgt;
    }

    public org.hl7.fhir.instance.model.HealthcareService convertHealthcareService(HealthcareService src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.HealthcareService tgt = new org.hl7.fhir.instance.model.HealthcareService();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setProvidedBy(this.convertReference(src.getProvidedBy()));
        for (Identifier t : src.getSpecialty()) {
            if (!tgt.hasServiceType()) {
                tgt.addServiceType();
            }
            ((HealthcareService.ServiceTypeComponent)tgt.getServiceType().get(0)).addSpecialty(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getLocation()) {
            tgt.setLocation(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        tgt.setComment(src.getComment());
        tgt.setExtraDetails(src.getExtraDetails());
        tgt.setPhoto(this.convertAttachment(src.getPhoto()));
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint((org.hl7.fhir.r4.model.ContactPoint)t));
        }
        for (Identifier t : src.getCoverageArea()) {
            tgt.addCoverageArea(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (Identifier t : src.getServiceProvisionCode()) {
            tgt.addServiceProvisionCode(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setEligibility(this.convertCodeableConcept(src.getEligibilityFirstRep().getCode()));
        tgt.setEligibilityNote(src.getEligibilityFirstRep().getComment());
        for (Identifier t : src.getProgram()) {
            if (!t.hasText()) continue;
            tgt.addProgramName(t.getText());
        }
        for (Identifier t : src.getCharacteristic()) {
            tgt.addCharacteristic(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        for (Identifier t : src.getReferralMethod()) {
            tgt.addReferralMethod(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setAppointmentRequired(src.getAppointmentRequired());
        for (Identifier t : src.getAvailableTime()) {
            tgt.addAvailableTime(this.convertHealthcareServiceAvailableTimeComponent((HealthcareService.HealthcareServiceAvailableTimeComponent)t));
        }
        for (Identifier t : src.getNotAvailable()) {
            tgt.addNotAvailable(this.convertHealthcareServiceNotAvailableComponent((HealthcareService.HealthcareServiceNotAvailableComponent)t));
        }
        tgt.setAvailabilityExceptions(src.getAvailabilityExceptions());
        return tgt;
    }

    public HealthcareService.HealthcareServiceAvailableTimeComponent convertHealthcareServiceAvailableTimeComponent(HealthcareService.HealthcareServiceAvailableTimeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService.HealthcareServiceAvailableTimeComponent tgt = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (Enumeration t : src.getDaysOfWeek()) {
            tgt.addDaysOfWeek(this.convertDaysOfWeek((HealthcareService.DaysOfWeek)t.getValue()));
        }
        tgt.setAllDay(src.getAllDay());
        tgt.setAvailableStartTime(src.getAvailableStartTime());
        tgt.setAvailableEndTime(src.getAvailableEndTime());
        return tgt;
    }

    public HealthcareService.HealthcareServiceAvailableTimeComponent convertHealthcareServiceAvailableTimeComponent(HealthcareService.HealthcareServiceAvailableTimeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService.HealthcareServiceAvailableTimeComponent tgt = new HealthcareService.HealthcareServiceAvailableTimeComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (org.hl7.fhir.r4.model.Enumeration t : src.getDaysOfWeek()) {
            tgt.addDaysOfWeek(this.convertDaysOfWeek((HealthcareService.DaysOfWeek)t.getValue()));
        }
        tgt.setAllDay(src.getAllDay());
        tgt.setAvailableStartTime(src.getAvailableStartTime());
        tgt.setAvailableEndTime(src.getAvailableEndTime());
        return tgt;
    }

    public HealthcareService.DaysOfWeek convertDaysOfWeek(HealthcareService.DaysOfWeek src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MON: {
                return HealthcareService.DaysOfWeek.MON;
            }
            case TUE: {
                return HealthcareService.DaysOfWeek.TUE;
            }
            case WED: {
                return HealthcareService.DaysOfWeek.WED;
            }
            case THU: {
                return HealthcareService.DaysOfWeek.THU;
            }
            case FRI: {
                return HealthcareService.DaysOfWeek.FRI;
            }
            case SAT: {
                return HealthcareService.DaysOfWeek.SAT;
            }
            case SUN: {
                return HealthcareService.DaysOfWeek.SUN;
            }
        }
        return HealthcareService.DaysOfWeek.NULL;
    }

    public HealthcareService.DaysOfWeek convertDaysOfWeek(HealthcareService.DaysOfWeek src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case MON: {
                return HealthcareService.DaysOfWeek.MON;
            }
            case TUE: {
                return HealthcareService.DaysOfWeek.TUE;
            }
            case WED: {
                return HealthcareService.DaysOfWeek.WED;
            }
            case THU: {
                return HealthcareService.DaysOfWeek.THU;
            }
            case FRI: {
                return HealthcareService.DaysOfWeek.FRI;
            }
            case SAT: {
                return HealthcareService.DaysOfWeek.SAT;
            }
            case SUN: {
                return HealthcareService.DaysOfWeek.SUN;
            }
        }
        return HealthcareService.DaysOfWeek.NULL;
    }

    public HealthcareService.HealthcareServiceNotAvailableComponent convertHealthcareServiceNotAvailableComponent(HealthcareService.HealthcareServiceNotAvailableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService.HealthcareServiceNotAvailableComponent tgt = new HealthcareService.HealthcareServiceNotAvailableComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setDescription(src.getDescription());
        tgt.setDuring(this.convertPeriod(src.getDuring()));
        return tgt;
    }

    public HealthcareService.HealthcareServiceNotAvailableComponent convertHealthcareServiceNotAvailableComponent(HealthcareService.HealthcareServiceNotAvailableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        HealthcareService.HealthcareServiceNotAvailableComponent tgt = new HealthcareService.HealthcareServiceNotAvailableComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setDescription(src.getDescription());
        tgt.setDuring(this.convertPeriod(src.getDuring()));
        return tgt;
    }

    private org.hl7.fhir.r4.model.Reference getPerformer(List<Immunization.ImmunizationPerformerComponent> practitioner) {
        for (Immunization.ImmunizationPerformerComponent p : practitioner) {
            if (!this.hasConcept(p.getFunction(), "http://hl7.org/fhir/v2/0443", "AP")) continue;
            return p.getActor();
        }
        return null;
    }

    private org.hl7.fhir.r4.model.Reference getRequester(List<Immunization.ImmunizationPerformerComponent> practitioner) {
        for (Immunization.ImmunizationPerformerComponent p : practitioner) {
            if (!this.hasConcept(p.getFunction(), "http://hl7.org/fhir/v2/0443", "OP")) continue;
            return p.getActor();
        }
        return null;
    }

    private boolean hasConcept(org.hl7.fhir.r4.model.CodeableConcept cc, String system, String code) {
        for (org.hl7.fhir.r4.model.Coding c : cc.getCoding()) {
            if (!system.equals(c.getSystem()) || !code.equals(c.getCode())) continue;
            return true;
        }
        return false;
    }

    private boolean hasConcept(CodeableConcept cc, String system, String code) {
        for (Coding c : cc.getCoding()) {
            if (!system.equals(c.getSystem()) || !code.equals(c.getCode())) continue;
            return true;
        }
        return false;
    }

    public org.hl7.fhir.r4.model.ImplementationGuide convertImplementationGuide(ImplementationGuide src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.ImplementationGuide tgt = new org.hl7.fhir.r4.model.ImplementationGuide();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setVersion(src.getVersion());
        tgt.setName(src.getName());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        tgt.setPublisher(src.getPublisher());
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getContact()) {
            tgt.addContact(this.convertImplementationGuideContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setDescription(src.getDescription());
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getUseContext()) {
            if (VersionConvertor_10_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(this.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(this.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        tgt.setCopyright(src.getCopyright());
        tgt.addFhirVersion(Enumerations.FHIRVersion.fromCode((String)src.getFhirVersion()));
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getDependency()) {
            tgt.addDependsOn(this.convertImplementationGuideDependencyComponent((ImplementationGuide.ImplementationGuideDependencyComponent)t));
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getPackage()) {
            tgt.getDefinition().addGrouping(this.convertImplementationGuidePackageComponent(tgt.getDefinition(), (ImplementationGuide.ImplementationGuidePackageComponent)t));
        }
        for (ImplementationGuide.ImplementationGuideContactComponent t : src.getGlobal()) {
            tgt.addGlobal(this.convertImplementationGuideGlobalComponent((ImplementationGuide.ImplementationGuideGlobalComponent)t));
        }
        tgt.getDefinition().setPage(this.convertImplementationGuidePageComponent(src.getPage()));
        return tgt;
    }

    public ImplementationGuide convertImplementationGuide(org.hl7.fhir.r4.model.ImplementationGuide src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide tgt = new ImplementationGuide();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setVersion(src.getVersion());
        tgt.setName(src.getName());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        tgt.setPublisher(src.getPublisher());
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(this.convertImplementationGuideContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setDescription(src.getDescription());
        for (ContactDetail t : src.getUseContext()) {
            if (!t.hasValueCodeableConcept()) continue;
            tgt.addUseContext(this.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addUseContext(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setCopyright(src.getCopyright());
        for (org.hl7.fhir.r4.model.Enumeration v : src.getFhirVersion()) {
            tgt.setFhirVersion(v.asStringValue());
        }
        for (ContactDetail t : src.getDependsOn()) {
            tgt.addDependency(this.convertImplementationGuideDependencyComponent((ImplementationGuide.ImplementationGuideDependsOnComponent)t));
        }
        for (ContactDetail t : src.getDefinition().getGrouping()) {
            tgt.addPackage(this.convertImplementationGuidePackageComponent((ImplementationGuide.ImplementationGuideDefinitionGroupingComponent)t));
        }
        for (ContactDetail t : src.getDefinition().getResource()) {
            VersionConvertor_10_40.findPackage(tgt.getPackage(), t.getGroupingId()).addResource(this.convertImplementationGuidePackageResourceComponent((ImplementationGuide.ImplementationGuideDefinitionResourceComponent)t));
        }
        for (ContactDetail t : src.getGlobal()) {
            tgt.addGlobal(this.convertImplementationGuideGlobalComponent((ImplementationGuide.ImplementationGuideGlobalComponent)t));
        }
        tgt.setPage(this.convertImplementationGuidePageComponent(src.getDefinition().getPage()));
        return tgt;
    }

    private static ImplementationGuide.ImplementationGuidePackageComponent findPackage(List<ImplementationGuide.ImplementationGuidePackageComponent> definition, String id) {
        if (id != null) {
            for (ImplementationGuide.ImplementationGuidePackageComponent t : definition) {
                if (!id.equals(t.getId())) continue;
                return t;
            }
        }
        ImplementationGuide.ImplementationGuidePackageComponent t = new ImplementationGuide.ImplementationGuidePackageComponent();
        t.setName("Default Package");
        t.setId(id);
        return t;
    }

    public ContactDetail convertImplementationGuideContactComponent(ImplementationGuide.ImplementationGuideContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public ImplementationGuide.ImplementationGuideContactComponent convertImplementationGuideContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideContactComponent tgt = new ImplementationGuide.ImplementationGuideContactComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public ImplementationGuide.ImplementationGuideDependsOnComponent convertImplementationGuideDependencyComponent(ImplementationGuide.ImplementationGuideDependencyComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependsOnComponent tgt = new ImplementationGuide.ImplementationGuideDependsOnComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setUri(src.getUri());
        return tgt;
    }

    public ImplementationGuide.ImplementationGuideDependencyComponent convertImplementationGuideDependencyComponent(ImplementationGuide.ImplementationGuideDependsOnComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDependencyComponent tgt = new ImplementationGuide.ImplementationGuideDependencyComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setType(ImplementationGuide.GuideDependencyType.REFERENCE);
        tgt.setUri(src.getUri());
        return tgt;
    }

    public ImplementationGuide.ImplementationGuideDefinitionGroupingComponent convertImplementationGuidePackageComponent(ImplementationGuide.ImplementationGuideDefinitionComponent context, ImplementationGuide.ImplementationGuidePackageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionGroupingComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionGroupingComponent();
        tgt.setId("p" + (context.getGrouping().size() + 1));
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        for (ImplementationGuide.ImplementationGuidePackageResourceComponent t : src.getResource()) {
            ImplementationGuide.ImplementationGuideDefinitionResourceComponent tn = this.convertImplementationGuidePackageResourceComponent(t);
            tn.setGroupingId(tgt.getId());
            context.addResource(tn);
        }
        return tgt;
    }

    public ImplementationGuide.ImplementationGuidePackageComponent convertImplementationGuidePackageComponent(ImplementationGuide.ImplementationGuideDefinitionGroupingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageComponent tgt = new ImplementationGuide.ImplementationGuidePackageComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setId(src.getId());
        tgt.setName(src.getName());
        tgt.setDescription(src.getDescription());
        return tgt;
    }

    public ImplementationGuide.ImplementationGuideDefinitionResourceComponent convertImplementationGuidePackageResourceComponent(ImplementationGuide.ImplementationGuidePackageResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionResourceComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionResourceComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        if (src.hasExampleFor()) {
            tgt.setExample((Type)this.convertReferenceToCanonical(src.getExampleFor()));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasSourceReference()) {
            tgt.setReference(this.convertReference(src.getSourceReference()));
        } else if (src.hasSourceUriType()) {
            tgt.setReference(new org.hl7.fhir.r4.model.Reference((String)src.getSourceUriType().getValue()));
        }
        return tgt;
    }

    public ImplementationGuide.ImplementationGuidePackageResourceComponent convertImplementationGuidePackageResourceComponent(ImplementationGuide.ImplementationGuideDefinitionResourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePackageResourceComponent tgt = new ImplementationGuide.ImplementationGuidePackageResourceComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        if (src.hasExampleCanonicalType()) {
            tgt.setExampleFor(this.convertCanonicalToReference(src.getExampleCanonicalType()));
        }
        if (src.hasName()) {
            tgt.setName(src.getName());
        }
        if (src.hasDescription()) {
            tgt.setDescription(src.getDescription());
        }
        if (src.hasReference()) {
            tgt.setSource((org.hl7.fhir.instance.model.Type)this.convertReference(src.getReference()));
        }
        return tgt;
    }

    public ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setType(src.getType());
        tgt.setProfileElement(this.convertReferenceToCanonical(src.getProfile()));
        return tgt;
    }

    public ImplementationGuide.ImplementationGuideGlobalComponent convertImplementationGuideGlobalComponent(ImplementationGuide.ImplementationGuideGlobalComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideGlobalComponent tgt = new ImplementationGuide.ImplementationGuideGlobalComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setType(src.getType());
        tgt.setProfile(this.convertCanonicalToReference(src.getProfileElement()));
        return tgt;
    }

    public ImplementationGuide.ImplementationGuideDefinitionPageComponent convertImplementationGuidePageComponent(ImplementationGuide.ImplementationGuidePageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuideDefinitionPageComponent tgt = new ImplementationGuide.ImplementationGuideDefinitionPageComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        if (src.hasSource()) {
            tgt.setName((Type)this.convertUriToUrl(src.getSourceElement()));
        }
        tgt.setTitle(src.getName());
        if (src.hasKind()) {
            tgt.setGeneration(VersionConvertor_10_40.convertPageGeneration(src.getKind()));
        }
        for (ImplementationGuide.ImplementationGuidePageComponent t : src.getPage()) {
            tgt.addPage(this.convertImplementationGuidePageComponent(t));
        }
        return tgt;
    }

    private static ImplementationGuide.GuidePageGeneration convertPageGeneration(ImplementationGuide.GuidePageKind kind) {
        switch (kind) {
            case PAGE: {
                return ImplementationGuide.GuidePageGeneration.HTML;
            }
        }
        return ImplementationGuide.GuidePageGeneration.GENERATED;
    }

    private static ImplementationGuide.GuidePageKind convertPageGeneration(ImplementationGuide.GuidePageGeneration generation) {
        switch (generation) {
            case HTML: {
                return ImplementationGuide.GuidePageKind.PAGE;
            }
        }
        return ImplementationGuide.GuidePageKind.RESOURCE;
    }

    public ImplementationGuide.ImplementationGuidePageComponent convertImplementationGuidePageComponent(ImplementationGuide.ImplementationGuideDefinitionPageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ImplementationGuide.ImplementationGuidePageComponent tgt = new ImplementationGuide.ImplementationGuidePageComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        if (src.hasNameUrlType()) {
            tgt.setSource((String)src.getNameUrlType().getValue());
        }
        tgt.setName(src.getTitle());
        if (src.hasGeneration()) {
            tgt.setKind(VersionConvertor_10_40.convertPageGeneration(src.getGeneration()));
        }
        for (ImplementationGuide.ImplementationGuideDefinitionPageComponent t : src.getPage()) {
            tgt.addPage(this.convertImplementationGuidePageComponent(t));
        }
        return tgt;
    }

    public Location convertLocation(org.hl7.fhir.instance.model.Location src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Location tgt = new Location();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setStatus(this.convertLocationStatus(src.getStatus()));
        tgt.setName(src.getName());
        tgt.setDescription(src.getDescription());
        tgt.setMode(this.convertLocationMode(src.getMode()));
        tgt.addType(this.convertCodeableConcept(src.getType()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint((ContactPoint)t));
        }
        tgt.setAddress(this.convertAddress(src.getAddress()));
        tgt.setPhysicalType(this.convertCodeableConcept(src.getPhysicalType()));
        tgt.setPosition(this.convertLocationPositionComponent(src.getPosition()));
        tgt.setManagingOrganization(this.convertReference(src.getManagingOrganization()));
        tgt.setPartOf(this.convertReference(src.getPartOf()));
        return tgt;
    }

    public org.hl7.fhir.instance.model.Location convertLocation(Location src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Location tgt = new org.hl7.fhir.instance.model.Location();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setStatus(this.convertLocationStatus(src.getStatus()));
        tgt.setName(src.getName());
        tgt.setDescription(src.getDescription());
        tgt.setMode(this.convertLocationMode(src.getMode()));
        tgt.setType(this.convertCodeableConcept(src.getTypeFirstRep()));
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint((org.hl7.fhir.r4.model.ContactPoint)t));
        }
        tgt.setAddress(this.convertAddress(src.getAddress()));
        tgt.setPhysicalType(this.convertCodeableConcept(src.getPhysicalType()));
        tgt.setPosition(this.convertLocationPositionComponent(src.getPosition()));
        tgt.setManagingOrganization(this.convertReference(src.getManagingOrganization()));
        tgt.setPartOf(this.convertReference(src.getPartOf()));
        return tgt;
    }

    public Location.LocationStatus convertLocationStatus(Location.LocationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return Location.LocationStatus.ACTIVE;
            }
            case SUSPENDED: {
                return Location.LocationStatus.SUSPENDED;
            }
            case INACTIVE: {
                return Location.LocationStatus.INACTIVE;
            }
        }
        return Location.LocationStatus.NULL;
    }

    public Location.LocationStatus convertLocationStatus(Location.LocationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return Location.LocationStatus.ACTIVE;
            }
            case SUSPENDED: {
                return Location.LocationStatus.SUSPENDED;
            }
            case INACTIVE: {
                return Location.LocationStatus.INACTIVE;
            }
        }
        return Location.LocationStatus.NULL;
    }

    public Location.LocationMode convertLocationMode(Location.LocationMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INSTANCE: {
                return Location.LocationMode.INSTANCE;
            }
            case KIND: {
                return Location.LocationMode.KIND;
            }
        }
        return Location.LocationMode.NULL;
    }

    public Location.LocationMode convertLocationMode(Location.LocationMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INSTANCE: {
                return Location.LocationMode.INSTANCE;
            }
            case KIND: {
                return Location.LocationMode.KIND;
            }
        }
        return Location.LocationMode.NULL;
    }

    public Location.LocationPositionComponent convertLocationPositionComponent(Location.LocationPositionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Location.LocationPositionComponent tgt = new Location.LocationPositionComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setLongitude(src.getLongitude());
        tgt.setLatitude(src.getLatitude());
        tgt.setAltitude(src.getAltitude());
        return tgt;
    }

    public Location.LocationPositionComponent convertLocationPositionComponent(Location.LocationPositionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Location.LocationPositionComponent tgt = new Location.LocationPositionComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setLongitude(src.getLongitude());
        tgt.setLatitude(src.getLatitude());
        tgt.setAltitude(src.getAltitude());
        return tgt;
    }

    public MedicationDispense convertMedicationDispense(org.hl7.fhir.instance.model.MedicationDispense src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationDispense tgt = new MedicationDispense();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.addIdentifier(this.convertIdentifier(src.getIdentifier()));
        tgt.setStatus(this.convertMedicationDispenseStatus(src.getStatus()));
        tgt.setMedication(this.convertType(src.getMedication()));
        tgt.setSubject(this.convertReference(src.getPatient()));
        for (Reference t : src.getAuthorizingPrescription()) {
            tgt.addAuthorizingPrescription(this.convertReference(t));
        }
        tgt.setType(this.convertCodeableConcept(src.getType()));
        tgt.setQuantity(this.convertSimpleQuantity(src.getQuantity()));
        tgt.setDaysSupply(this.convertSimpleQuantity(src.getDaysSupply()));
        tgt.setWhenPrepared(src.getWhenPrepared());
        tgt.setWhenHandedOver(src.getWhenHandedOver());
        tgt.setDestination(this.convertReference(src.getDestination()));
        for (Reference t : src.getReceiver()) {
            tgt.addReceiver(this.convertReference(t));
        }
        if (src.hasNote()) {
            tgt.addNote().setText(src.getNote());
        }
        for (Reference t : src.getDosageInstruction()) {
            tgt.addDosageInstruction(this.convertMedicationDispenseDosageInstructionComponent((MedicationDispense.MedicationDispenseDosageInstructionComponent)t));
        }
        tgt.setSubstitution(this.convertMedicationDispenseSubstitutionComponent(src.getSubstitution()));
        return tgt;
    }

    public org.hl7.fhir.instance.model.MedicationDispense convertMedicationDispense(MedicationDispense src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.MedicationDispense tgt = new org.hl7.fhir.instance.model.MedicationDispense();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifierFirstRep()));
        tgt.setStatus(this.convertMedicationDispenseStatus(src.getStatus()));
        tgt.setMedication(this.convertType(src.getMedication()));
        tgt.setPatient(this.convertReference(src.getSubject()));
        for (org.hl7.fhir.r4.model.Reference t : src.getAuthorizingPrescription()) {
            tgt.addAuthorizingPrescription(this.convertReference(t));
        }
        tgt.setType(this.convertCodeableConcept(src.getType()));
        tgt.setQuantity(this.convertSimpleQuantity(src.getQuantity()));
        tgt.setDaysSupply(this.convertSimpleQuantity(src.getDaysSupply()));
        tgt.setWhenPrepared(src.getWhenPrepared());
        tgt.setWhenHandedOver(src.getWhenHandedOver());
        tgt.setDestination(this.convertReference(src.getDestination()));
        for (org.hl7.fhir.r4.model.Reference t : src.getReceiver()) {
            tgt.addReceiver(this.convertReference(t));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getNote()) {
            tgt.setNote(t.getText());
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getDosageInstruction()) {
            tgt.addDosageInstruction(this.convertMedicationDispenseDosageInstructionComponent((Dosage)t));
        }
        tgt.setSubstitution(this.convertMedicationDispenseSubstitutionComponent(src.getSubstitution()));
        return tgt;
    }

    public String convertMedicationDispenseStatus(MedicationDispense.MedicationDispenseStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        return src.toCode();
    }

    public MedicationDispense.MedicationDispenseStatus convertMedicationDispenseStatus(String src) throws FHIRException {
        if (src == null) {
            return null;
        }
        return MedicationDispense.MedicationDispenseStatus.fromCode((String)src);
    }

    public Dosage convertMedicationDispenseDosageInstructionComponent(MedicationDispense.MedicationDispenseDosageInstructionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Dosage tgt = new Dosage();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setText(src.getText());
        tgt.setTiming(this.convertTiming(src.getTiming()));
        tgt.setAsNeeded(this.convertType(src.getAsNeeded()));
        if (src.hasSiteCodeableConcept()) {
            tgt.setSite(this.convertCodeableConcept(src.getSiteCodeableConcept()));
        }
        tgt.setRoute(this.convertCodeableConcept(src.getRoute()));
        tgt.setMethod(this.convertCodeableConcept(src.getMethod()));
        if (src.hasDose() || src.hasRate()) {
            Dosage.DosageDoseAndRateComponent dr = tgt.addDoseAndRate();
            if (src.hasDose()) {
                dr.setDose(this.convertType(src.getDose()));
            }
            if (src.hasRate()) {
                dr.setRate(this.convertType(src.getRate()));
            }
        }
        tgt.setMaxDosePerPeriod(this.convertRatio(src.getMaxDosePerPeriod()));
        return tgt;
    }

    public MedicationDispense.MedicationDispenseDosageInstructionComponent convertMedicationDispenseDosageInstructionComponent(Dosage src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationDispense.MedicationDispenseDosageInstructionComponent tgt = new MedicationDispense.MedicationDispenseDosageInstructionComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setText(src.getText());
        tgt.setTiming(this.convertTiming(src.getTiming()));
        tgt.setAsNeeded(this.convertType(src.getAsNeeded()));
        tgt.setSite(this.convertType((Type)src.getSite()));
        tgt.setRoute(this.convertCodeableConcept(src.getRoute()));
        tgt.setMethod(this.convertCodeableConcept(src.getMethod()));
        if (src.hasDoseAndRate() && ((Dosage.DosageDoseAndRateComponent)src.getDoseAndRate().get(0)).hasDose()) {
            tgt.setDose(this.convertType(((Dosage.DosageDoseAndRateComponent)src.getDoseAndRate().get(0)).getDose()));
        }
        tgt.setMaxDosePerPeriod(this.convertRatio(src.getMaxDosePerPeriod()));
        if (src.hasDoseAndRate() && ((Dosage.DosageDoseAndRateComponent)src.getDoseAndRate().get(0)).hasRate()) {
            tgt.setRate(this.convertType(((Dosage.DosageDoseAndRateComponent)src.getDoseAndRate().get(0)).getRate()));
        }
        return tgt;
    }

    public MedicationDispense.MedicationDispenseSubstitutionComponent convertMedicationDispenseSubstitutionComponent(MedicationDispense.MedicationDispenseSubstitutionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationDispense.MedicationDispenseSubstitutionComponent tgt = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setType(this.convertCodeableConcept(src.getType()));
        for (CodeableConcept t : src.getReason()) {
            tgt.addReason(this.convertCodeableConcept(t));
        }
        for (CodeableConcept t : src.getResponsibleParty()) {
            tgt.addResponsibleParty(this.convertReference((Reference)t));
        }
        return tgt;
    }

    public MedicationDispense.MedicationDispenseSubstitutionComponent convertMedicationDispenseSubstitutionComponent(MedicationDispense.MedicationDispenseSubstitutionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationDispense.MedicationDispenseSubstitutionComponent tgt = new MedicationDispense.MedicationDispenseSubstitutionComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setType(this.convertCodeableConcept(src.getType()));
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getReason()) {
            tgt.addReason(this.convertCodeableConcept(t));
        }
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getResponsibleParty()) {
            tgt.addResponsibleParty(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    public Dosage convertMedicationOrderDosageInstructionComponent(MedicationOrder.MedicationOrderDosageInstructionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Dosage tgt = new Dosage();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setText(src.getText());
        tgt.setTiming(this.convertTiming(src.getTiming()));
        tgt.setAsNeeded(this.convertType(src.getAsNeeded()));
        if (src.hasSiteCodeableConcept()) {
            tgt.setSite(this.convertCodeableConcept(src.getSiteCodeableConcept()));
        }
        tgt.setRoute(this.convertCodeableConcept(src.getRoute()));
        tgt.setMethod(this.convertCodeableConcept(src.getMethod()));
        if (src.hasDose() || src.hasRate()) {
            Dosage.DosageDoseAndRateComponent dr = tgt.addDoseAndRate();
            if (src.hasDose()) {
                dr.setDose(this.convertType(src.getDose()));
            }
            if (src.hasRate()) {
                dr.setRate(this.convertType(src.getRate()));
            }
        }
        tgt.setMaxDosePerPeriod(this.convertRatio(src.getMaxDosePerPeriod()));
        return tgt;
    }

    public MedicationOrder.MedicationOrderDosageInstructionComponent convertMedicationOrderDosageInstructionComponent(Dosage src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationOrder.MedicationOrderDosageInstructionComponent tgt = new MedicationOrder.MedicationOrderDosageInstructionComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setText(src.getText());
        tgt.setTiming(this.convertTiming(src.getTiming()));
        tgt.setAsNeeded(this.convertType(src.getAsNeeded()));
        tgt.setSite(this.convertType((Type)src.getSite()));
        tgt.setRoute(this.convertCodeableConcept(src.getRoute()));
        tgt.setMethod(this.convertCodeableConcept(src.getMethod()));
        if (src.hasDoseAndRate() && ((Dosage.DosageDoseAndRateComponent)src.getDoseAndRate().get(0)).hasDose()) {
            tgt.setDose(this.convertType(((Dosage.DosageDoseAndRateComponent)src.getDoseAndRate().get(0)).getDose()));
        }
        if (src.hasDoseAndRate() && ((Dosage.DosageDoseAndRateComponent)src.getDoseAndRate().get(0)).hasRate()) {
            tgt.setRate(this.convertType(((Dosage.DosageDoseAndRateComponent)src.getDoseAndRate().get(0)).getRate()));
        }
        tgt.setMaxDosePerPeriod(this.convertRatio(src.getMaxDosePerPeriod()));
        return tgt;
    }

    public org.hl7.fhir.r4.model.MedicationStatement convertMedicationStatement(MedicationStatement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.MedicationStatement tgt = new org.hl7.fhir.r4.model.MedicationStatement();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setStatus(this.convertMedicationStatementStatus(src.getStatus()));
        tgt.setMedication(this.convertType(src.getMedication()));
        tgt.setSubject(this.convertReference(src.getPatient()));
        tgt.setEffective(this.convertType(src.getEffective()));
        tgt.setInformationSource(this.convertReference(src.getInformationSource()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getSupportingInformation()) {
            tgt.addDerivedFrom(this.convertReference((Reference)t));
        }
        if (src.hasDateAsserted()) {
            tgt.setDateAsserted(src.getDateAsserted());
        }
        if (src.hasNote()) {
            tgt.addNote().setText(src.getNote());
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getDosage()) {
            tgt.addDosage(this.convertMedicationStatementDosageComponent((MedicationStatement.MedicationStatementDosageComponent)t));
        }
        return tgt;
    }

    public MedicationStatement convertMedicationStatement(org.hl7.fhir.r4.model.MedicationStatement src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationStatement tgt = new MedicationStatement();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setStatus(this.convertMedicationStatementStatus(src.getStatus()));
        tgt.setMedication(this.convertType(src.getMedication()));
        tgt.setPatient(this.convertReference(src.getSubject()));
        tgt.setEffective(this.convertType(src.getEffective()));
        tgt.setInformationSource(this.convertReference(src.getInformationSource()));
        for (Identifier t : src.getDerivedFrom()) {
            tgt.addSupportingInformation(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        if (src.hasDateAsserted()) {
            tgt.setDateAsserted(src.getDateAsserted());
        }
        for (Identifier t : src.getNote()) {
            tgt.setNote(t.getText());
        }
        for (Identifier t : src.getDosage()) {
            tgt.addDosage(this.convertMedicationStatementDosageComponent((Dosage)t));
        }
        return tgt;
    }

    public MedicationStatement.MedicationStatementStatus convertMedicationStatementStatus(MedicationStatement.MedicationStatementStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return MedicationStatement.MedicationStatementStatus.ACTIVE;
            }
            case COMPLETED: {
                return MedicationStatement.MedicationStatementStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return MedicationStatement.MedicationStatementStatus.ENTEREDINERROR;
            }
            case INTENDED: {
                return MedicationStatement.MedicationStatementStatus.INTENDED;
            }
        }
        return MedicationStatement.MedicationStatementStatus.NULL;
    }

    public MedicationStatement.MedicationStatementStatus convertMedicationStatementStatus(MedicationStatement.MedicationStatementStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return MedicationStatement.MedicationStatementStatus.ACTIVE;
            }
            case COMPLETED: {
                return MedicationStatement.MedicationStatementStatus.COMPLETED;
            }
            case ENTEREDINERROR: {
                return MedicationStatement.MedicationStatementStatus.ENTEREDINERROR;
            }
            case INTENDED: {
                return MedicationStatement.MedicationStatementStatus.INTENDED;
            }
        }
        return MedicationStatement.MedicationStatementStatus.NULL;
    }

    public Dosage convertMedicationStatementDosageComponent(MedicationStatement.MedicationStatementDosageComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Dosage tgt = new Dosage();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setText(src.getText());
        tgt.setTiming(this.convertTiming(src.getTiming()));
        tgt.setAsNeeded(this.convertType(src.getAsNeeded()));
        if (src.hasSiteCodeableConcept()) {
            tgt.setSite(this.convertCodeableConcept(src.getSiteCodeableConcept()));
        }
        tgt.setRoute(this.convertCodeableConcept(src.getRoute()));
        tgt.setMethod(this.convertCodeableConcept(src.getMethod()));
        if (src.hasRate()) {
            Dosage.DosageDoseAndRateComponent dr = tgt.addDoseAndRate();
            if (src.hasRate()) {
                dr.setRate(this.convertType(src.getRate()));
            }
        }
        tgt.setMaxDosePerPeriod(this.convertRatio(src.getMaxDosePerPeriod()));
        return tgt;
    }

    public MedicationStatement.MedicationStatementDosageComponent convertMedicationStatementDosageComponent(Dosage src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MedicationStatement.MedicationStatementDosageComponent tgt = new MedicationStatement.MedicationStatementDosageComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setText(src.getText());
        tgt.setTiming(this.convertTiming(src.getTiming()));
        tgt.setAsNeeded(this.convertType(src.getAsNeeded()));
        tgt.setSite(this.convertType((Type)src.getSite()));
        tgt.setRoute(this.convertCodeableConcept(src.getRoute()));
        tgt.setMethod(this.convertCodeableConcept(src.getMethod()));
        if (src.hasDoseAndRate() && ((Dosage.DosageDoseAndRateComponent)src.getDoseAndRate().get(0)).hasRate()) {
            tgt.setRate(this.convertType(((Dosage.DosageDoseAndRateComponent)src.getDoseAndRate().get(0)).getRate()));
        }
        tgt.setMaxDosePerPeriod(this.convertRatio(src.getMaxDosePerPeriod()));
        return tgt;
    }

    public org.hl7.fhir.r4.model.MessageHeader convertMessageHeader(MessageHeader src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.MessageHeader tgt = new org.hl7.fhir.r4.model.MessageHeader();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setEvent((Type)this.convertCoding(src.getEvent()));
        tgt.setResponse(this.convertMessageHeaderResponseComponent(src.getResponse()));
        tgt.setSource(this.convertMessageSourceComponent(src.getSource()));
        for (MessageHeader.MessageDestinationComponent t : src.getDestination()) {
            tgt.addDestination(this.convertMessageDestinationComponent(t));
        }
        tgt.setEnterer(this.convertReference(src.getEnterer()));
        tgt.setAuthor(this.convertReference(src.getAuthor()));
        tgt.setResponsible(this.convertReference(src.getResponsible()));
        tgt.setReason(this.convertCodeableConcept(src.getReason()));
        for (MessageHeader.MessageDestinationComponent t : src.getData()) {
            tgt.addFocus(this.convertReference((Reference)t));
        }
        return tgt;
    }

    public MessageHeader convertMessageHeader(org.hl7.fhir.r4.model.MessageHeader src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MessageHeader tgt = new MessageHeader();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        if (src.hasEventCoding()) {
            tgt.setEvent(this.convertCoding(src.getEventCoding()));
        }
        tgt.setResponse(this.convertMessageHeaderResponseComponent(src.getResponse()));
        tgt.setSource(this.convertMessageSourceComponent(src.getSource()));
        for (MessageHeader.MessageDestinationComponent t : src.getDestination()) {
            tgt.addDestination(this.convertMessageDestinationComponent(t));
        }
        tgt.setEnterer(this.convertReference(src.getEnterer()));
        tgt.setAuthor(this.convertReference(src.getAuthor()));
        tgt.setResponsible(this.convertReference(src.getResponsible()));
        tgt.setReason(this.convertCodeableConcept(src.getReason()));
        for (MessageHeader.MessageDestinationComponent t : src.getFocus()) {
            tgt.addData(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        return tgt;
    }

    public MessageHeader.MessageHeaderResponseComponent convertMessageHeaderResponseComponent(MessageHeader.MessageHeaderResponseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MessageHeader.MessageHeaderResponseComponent tgt = new MessageHeader.MessageHeaderResponseComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setIdentifier(src.getIdentifier());
        tgt.setCode(this.convertResponseType(src.getCode()));
        tgt.setDetails(this.convertReference(src.getDetails()));
        return tgt;
    }

    public MessageHeader.MessageHeaderResponseComponent convertMessageHeaderResponseComponent(MessageHeader.MessageHeaderResponseComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MessageHeader.MessageHeaderResponseComponent tgt = new MessageHeader.MessageHeaderResponseComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setIdentifier(src.getIdentifier());
        tgt.setCode(this.convertResponseType(src.getCode()));
        tgt.setDetails(this.convertReference(src.getDetails()));
        return tgt;
    }

    public MessageHeader.ResponseType convertResponseType(MessageHeader.ResponseType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OK: {
                return MessageHeader.ResponseType.OK;
            }
            case TRANSIENTERROR: {
                return MessageHeader.ResponseType.TRANSIENTERROR;
            }
            case FATALERROR: {
                return MessageHeader.ResponseType.FATALERROR;
            }
        }
        return MessageHeader.ResponseType.NULL;
    }

    public MessageHeader.ResponseType convertResponseType(MessageHeader.ResponseType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OK: {
                return MessageHeader.ResponseType.OK;
            }
            case TRANSIENTERROR: {
                return MessageHeader.ResponseType.TRANSIENTERROR;
            }
            case FATALERROR: {
                return MessageHeader.ResponseType.FATALERROR;
            }
        }
        return MessageHeader.ResponseType.NULL;
    }

    public MessageHeader.MessageSourceComponent convertMessageSourceComponent(MessageHeader.MessageSourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MessageHeader.MessageSourceComponent tgt = new MessageHeader.MessageSourceComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        tgt.setSoftware(src.getSoftware());
        tgt.setVersion(src.getVersion());
        tgt.setContact(this.convertContactPoint(src.getContact()));
        tgt.setEndpoint(src.getEndpoint());
        return tgt;
    }

    public MessageHeader.MessageSourceComponent convertMessageSourceComponent(MessageHeader.MessageSourceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MessageHeader.MessageSourceComponent tgt = new MessageHeader.MessageSourceComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        tgt.setSoftware(src.getSoftware());
        tgt.setVersion(src.getVersion());
        tgt.setContact(this.convertContactPoint(src.getContact()));
        tgt.setEndpoint(src.getEndpoint());
        return tgt;
    }

    public MessageHeader.MessageDestinationComponent convertMessageDestinationComponent(MessageHeader.MessageDestinationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MessageHeader.MessageDestinationComponent tgt = new MessageHeader.MessageDestinationComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        tgt.setTarget(this.convertReference(src.getTarget()));
        tgt.setEndpoint(src.getEndpoint());
        return tgt;
    }

    public MessageHeader.MessageDestinationComponent convertMessageDestinationComponent(MessageHeader.MessageDestinationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        MessageHeader.MessageDestinationComponent tgt = new MessageHeader.MessageDestinationComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        tgt.setTarget(this.convertReference(src.getTarget()));
        tgt.setEndpoint(src.getEndpoint());
        return tgt;
    }

    public NamingSystem convertNamingSystem(org.hl7.fhir.instance.model.NamingSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem tgt = new NamingSystem();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setName(src.getName());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        tgt.setKind(this.convertNamingSystemType(src.getKind()));
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setPublisher(src.getPublisher());
        for (NamingSystem.NamingSystemContactComponent t : src.getContact()) {
            tgt.addContact(this.convertNamingSystemContactComponent(t));
        }
        tgt.setResponsible(src.getResponsible());
        tgt.setType(this.convertCodeableConcept(src.getType()));
        tgt.setDescription(src.getDescription());
        for (NamingSystem.NamingSystemContactComponent t : src.getUseContext()) {
            if (VersionConvertor_10_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(this.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(this.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        tgt.setUsage(src.getUsage());
        for (NamingSystem.NamingSystemContactComponent t : src.getUniqueId()) {
            tgt.addUniqueId(this.convertNamingSystemUniqueIdComponent((NamingSystem.NamingSystemUniqueIdComponent)t));
        }
        return tgt;
    }

    public org.hl7.fhir.instance.model.NamingSystem convertNamingSystem(NamingSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.NamingSystem tgt = new org.hl7.fhir.instance.model.NamingSystem();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setName(src.getName());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        tgt.setKind(this.convertNamingSystemType(src.getKind()));
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setPublisher(src.getPublisher());
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(this.convertNamingSystemContactComponent(t));
        }
        tgt.setResponsible(src.getResponsible());
        tgt.setType(this.convertCodeableConcept(src.getType()));
        tgt.setDescription(src.getDescription());
        for (ContactDetail t : src.getUseContext()) {
            if (!t.hasValueCodeableConcept()) continue;
            tgt.addUseContext(this.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addUseContext(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setUsage(src.getUsage());
        for (ContactDetail t : src.getUniqueId()) {
            tgt.addUniqueId(this.convertNamingSystemUniqueIdComponent((NamingSystem.NamingSystemUniqueIdComponent)t));
        }
        return tgt;
    }

    public NamingSystem.NamingSystemType convertNamingSystemType(NamingSystem.NamingSystemType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CODESYSTEM: {
                return NamingSystem.NamingSystemType.CODESYSTEM;
            }
            case IDENTIFIER: {
                return NamingSystem.NamingSystemType.IDENTIFIER;
            }
            case ROOT: {
                return NamingSystem.NamingSystemType.ROOT;
            }
        }
        return NamingSystem.NamingSystemType.NULL;
    }

    public NamingSystem.NamingSystemType convertNamingSystemType(NamingSystem.NamingSystemType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CODESYSTEM: {
                return NamingSystem.NamingSystemType.CODESYSTEM;
            }
            case IDENTIFIER: {
                return NamingSystem.NamingSystemType.IDENTIFIER;
            }
            case ROOT: {
                return NamingSystem.NamingSystemType.ROOT;
            }
        }
        return NamingSystem.NamingSystemType.NULL;
    }

    public ContactDetail convertNamingSystemContactComponent(NamingSystem.NamingSystemContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public NamingSystem.NamingSystemContactComponent convertNamingSystemContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem.NamingSystemContactComponent tgt = new NamingSystem.NamingSystemContactComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public NamingSystem.NamingSystemUniqueIdComponent convertNamingSystemUniqueIdComponent(NamingSystem.NamingSystemUniqueIdComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem.NamingSystemUniqueIdComponent tgt = new NamingSystem.NamingSystemUniqueIdComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setType(this.convertNamingSystemIdentifierType(src.getType()));
        tgt.setValue(src.getValue());
        tgt.setPreferred(src.getPreferred());
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public NamingSystem.NamingSystemUniqueIdComponent convertNamingSystemUniqueIdComponent(NamingSystem.NamingSystemUniqueIdComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        NamingSystem.NamingSystemUniqueIdComponent tgt = new NamingSystem.NamingSystemUniqueIdComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setType(this.convertNamingSystemIdentifierType(src.getType()));
        tgt.setValue(src.getValue());
        tgt.setPreferred(src.getPreferred());
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public NamingSystem.NamingSystemIdentifierType convertNamingSystemIdentifierType(NamingSystem.NamingSystemIdentifierType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OID: {
                return NamingSystem.NamingSystemIdentifierType.OID;
            }
            case UUID: {
                return NamingSystem.NamingSystemIdentifierType.UUID;
            }
            case URI: {
                return NamingSystem.NamingSystemIdentifierType.URI;
            }
            case OTHER: {
                return NamingSystem.NamingSystemIdentifierType.OTHER;
            }
        }
        return NamingSystem.NamingSystemIdentifierType.NULL;
    }

    public NamingSystem.NamingSystemIdentifierType convertNamingSystemIdentifierType(NamingSystem.NamingSystemIdentifierType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OID: {
                return NamingSystem.NamingSystemIdentifierType.OID;
            }
            case UUID: {
                return NamingSystem.NamingSystemIdentifierType.UUID;
            }
            case URI: {
                return NamingSystem.NamingSystemIdentifierType.URI;
            }
            case OTHER: {
                return NamingSystem.NamingSystemIdentifierType.OTHER;
            }
        }
        return NamingSystem.NamingSystemIdentifierType.NULL;
    }

    public Observation convertObservation(org.hl7.fhir.instance.model.Observation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation tgt = new Observation();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setStatus(this.convertObservationStatus(src.getStatus()));
        tgt.addCategory(this.convertCodeableConcept(src.getCategory()));
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        tgt.setEffective(this.convertType(src.getEffective()));
        tgt.setIssued(src.getIssued());
        for (org.hl7.fhir.instance.model.Identifier t : src.getPerformer()) {
            tgt.addPerformer(this.convertReference((Reference)t));
        }
        tgt.setValue(this.convertType(src.getValue()));
        tgt.setDataAbsentReason(this.convertCodeableConcept(src.getDataAbsentReason()));
        tgt.addInterpretation(this.convertCodeableConcept(src.getInterpretation()));
        tgt.addNote().setText(src.getComments());
        tgt.setBodySite(this.convertCodeableConcept(src.getBodySite()));
        tgt.setMethod(this.convertCodeableConcept(src.getMethod()));
        tgt.setSpecimen(this.convertReference(src.getSpecimen()));
        tgt.setDevice(this.convertReference(src.getDevice()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getReferenceRange()) {
            tgt.addReferenceRange(this.convertObservationReferenceRangeComponent((Observation.ObservationReferenceRangeComponent)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getRelated()) {
            if (t.getType() == Observation.ObservationRelationshipType.HASMEMBER) {
                tgt.addHasMember(this.convertReference(t.getTarget()));
                continue;
            }
            if (t.getType() != Observation.ObservationRelationshipType.DERIVEDFROM) continue;
            tgt.addDerivedFrom(this.convertReference(t.getTarget()));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getComponent()) {
            tgt.addComponent(this.convertObservationComponentComponent((Observation.ObservationComponentComponent)t));
        }
        return tgt;
    }

    public org.hl7.fhir.instance.model.Observation convertObservation(Observation src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Observation tgt = new org.hl7.fhir.instance.model.Observation();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setStatus(this.convertObservationStatus(src.getStatus()));
        for (org.hl7.fhir.r4.model.CodeableConcept c : src.getCategory()) {
            tgt.setCategory(this.convertCodeableConcept(c));
        }
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        tgt.setEffective(this.convertType(src.getEffective()));
        tgt.setIssued(src.getIssued());
        for (Identifier t : src.getPerformer()) {
            tgt.addPerformer(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        tgt.setValue(this.convertType(src.getValue()));
        tgt.setDataAbsentReason(this.convertCodeableConcept(src.getDataAbsentReason()));
        tgt.setInterpretation(this.convertCodeableConcept(src.getInterpretationFirstRep()));
        if (src.hasNote()) {
            tgt.setComments(src.getNoteFirstRep().getText());
        }
        tgt.setBodySite(this.convertCodeableConcept(src.getBodySite()));
        tgt.setMethod(this.convertCodeableConcept(src.getMethod()));
        tgt.setSpecimen(this.convertReference(src.getSpecimen()));
        tgt.setDevice(this.convertReference(src.getDevice()));
        for (Identifier t : src.getReferenceRange()) {
            tgt.addReferenceRange(this.convertObservationReferenceRangeComponent((Observation.ObservationReferenceRangeComponent)t));
        }
        for (Identifier t : src.getHasMember()) {
            tgt.addRelated(this.convertObservationRelatedComponent((org.hl7.fhir.r4.model.Reference)t, Observation.ObservationRelationshipType.HASMEMBER));
        }
        for (Identifier t : src.getDerivedFrom()) {
            tgt.addRelated(this.convertObservationRelatedComponent((org.hl7.fhir.r4.model.Reference)t, Observation.ObservationRelationshipType.DERIVEDFROM));
        }
        for (Identifier t : src.getComponent()) {
            tgt.addComponent(this.convertObservationComponentComponent((Observation.ObservationComponentComponent)t));
        }
        return tgt;
    }

    public Observation.ObservationStatus convertObservationStatus(Observation.ObservationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REGISTERED: {
                return Observation.ObservationStatus.REGISTERED;
            }
            case PRELIMINARY: {
                return Observation.ObservationStatus.PRELIMINARY;
            }
            case FINAL: {
                return Observation.ObservationStatus.FINAL;
            }
            case AMENDED: {
                return Observation.ObservationStatus.AMENDED;
            }
            case CANCELLED: {
                return Observation.ObservationStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return Observation.ObservationStatus.ENTEREDINERROR;
            }
            case UNKNOWN: {
                return Observation.ObservationStatus.UNKNOWN;
            }
        }
        return Observation.ObservationStatus.NULL;
    }

    public Observation.ObservationStatus convertObservationStatus(Observation.ObservationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REGISTERED: {
                return Observation.ObservationStatus.REGISTERED;
            }
            case PRELIMINARY: {
                return Observation.ObservationStatus.PRELIMINARY;
            }
            case FINAL: {
                return Observation.ObservationStatus.FINAL;
            }
            case AMENDED: {
                return Observation.ObservationStatus.AMENDED;
            }
            case CANCELLED: {
                return Observation.ObservationStatus.CANCELLED;
            }
            case ENTEREDINERROR: {
                return Observation.ObservationStatus.ENTEREDINERROR;
            }
            case UNKNOWN: {
                return Observation.ObservationStatus.UNKNOWN;
            }
        }
        return Observation.ObservationStatus.NULL;
    }

    public Observation.ObservationReferenceRangeComponent convertObservationReferenceRangeComponent(Observation.ObservationReferenceRangeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation.ObservationReferenceRangeComponent tgt = new Observation.ObservationReferenceRangeComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setLow(this.convertSimpleQuantity(src.getLow()));
        tgt.setHigh(this.convertSimpleQuantity(src.getHigh()));
        tgt.setType(this.convertCodeableConcept(src.getMeaning()));
        tgt.setAge(this.convertRange(src.getAge()));
        tgt.setText(src.getText());
        return tgt;
    }

    public Observation.ObservationReferenceRangeComponent convertObservationReferenceRangeComponent(Observation.ObservationReferenceRangeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation.ObservationReferenceRangeComponent tgt = new Observation.ObservationReferenceRangeComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setLow(this.convertSimpleQuantity(src.getLow()));
        tgt.setHigh(this.convertSimpleQuantity(src.getHigh()));
        tgt.setMeaning(this.convertCodeableConcept(src.getType()));
        tgt.setAge(this.convertRange(src.getAge()));
        tgt.setText(src.getText());
        return tgt;
    }

    public Observation.ObservationRelatedComponent convertObservationRelatedComponent(org.hl7.fhir.r4.model.Reference src, Observation.ObservationRelationshipType type) throws FHIRException {
        if (src == null) {
            return null;
        }
        Observation.ObservationRelatedComponent tgt = new Observation.ObservationRelatedComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setType(type);
        tgt.setTarget(this.convertReference(src));
        return tgt;
    }

    public Observation.ObservationComponentComponent convertObservationComponentComponent(Observation.ObservationComponentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation.ObservationComponentComponent tgt = new Observation.ObservationComponentComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setValue(this.convertType(src.getValue()));
        tgt.setDataAbsentReason(this.convertCodeableConcept(src.getDataAbsentReason()));
        for (Observation.ObservationReferenceRangeComponent t : src.getReferenceRange()) {
            tgt.addReferenceRange(this.convertObservationReferenceRangeComponent(t));
        }
        return tgt;
    }

    public Observation.ObservationComponentComponent convertObservationComponentComponent(Observation.ObservationComponentComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Observation.ObservationComponentComponent tgt = new Observation.ObservationComponentComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setValue(this.convertType(src.getValue()));
        tgt.setDataAbsentReason(this.convertCodeableConcept(src.getDataAbsentReason()));
        for (Observation.ObservationReferenceRangeComponent t : src.getReferenceRange()) {
            tgt.addReferenceRange(this.convertObservationReferenceRangeComponent(t));
        }
        return tgt;
    }

    public org.hl7.fhir.r4.model.OperationDefinition convertOperationDefinition(OperationDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.OperationDefinition tgt = new org.hl7.fhir.r4.model.OperationDefinition();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setVersion(src.getVersion());
        tgt.setName(src.getName());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        tgt.setKind(this.convertOperationKind(src.getKind()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setPublisher(src.getPublisher());
        for (OperationDefinition.OperationDefinitionContactComponent t : src.getContact()) {
            tgt.addContact(this.convertOperationDefinitionContactComponent(t));
        }
        tgt.setDescription(src.getDescription());
        tgt.setPurpose(src.getRequirements());
        if (src.hasIdempotent()) {
            tgt.setAffectsState(!src.getIdempotent());
        }
        tgt.setCode(src.getCode());
        tgt.setComment(src.getNotes());
        tgt.setBaseElement(this.convertReferenceToCanonical(src.getBase()));
        tgt.setSystem(src.getSystem());
        for (OperationDefinition.OperationDefinitionContactComponent t : src.getType()) {
            tgt.addResource((String)t.getValue());
        }
        tgt.setType(tgt.hasResource());
        tgt.setInstance(src.getInstance());
        for (OperationDefinition.OperationDefinitionContactComponent t : src.getParameter()) {
            tgt.addParameter(this.convertOperationDefinitionParameterComponent((OperationDefinition.OperationDefinitionParameterComponent)t));
        }
        return tgt;
    }

    public OperationDefinition convertOperationDefinition(org.hl7.fhir.r4.model.OperationDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition tgt = new OperationDefinition();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setVersion(src.getVersion());
        tgt.setName(src.getName());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        tgt.setKind(this.convertOperationKind(src.getKind()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setPublisher(src.getPublisher());
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(this.convertOperationDefinitionContactComponent(t));
        }
        tgt.setDescription(src.getDescription());
        tgt.setRequirements(src.getPurpose());
        tgt.setIdempotent(!src.getAffectsState());
        tgt.setCode(src.getCode());
        tgt.setNotes(src.getComment());
        if (src.hasBase()) {
            tgt.setBase(this.convertCanonicalToReference(src.getBaseElement()));
        }
        tgt.setSystem(src.getSystem());
        if (src.getType()) {
            for (ContactDetail t : src.getResource()) {
                tgt.addType((String)t.getValue());
            }
        }
        tgt.setInstance(src.getInstance());
        for (ContactDetail t : src.getParameter()) {
            tgt.addParameter(this.convertOperationDefinitionParameterComponent((OperationDefinition.OperationDefinitionParameterComponent)t));
        }
        return tgt;
    }

    public OperationDefinition.OperationKind convertOperationKind(OperationDefinition.OperationKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OPERATION: {
                return OperationDefinition.OperationKind.OPERATION;
            }
            case QUERY: {
                return OperationDefinition.OperationKind.QUERY;
            }
        }
        return OperationDefinition.OperationKind.NULL;
    }

    public OperationDefinition.OperationKind convertOperationKind(OperationDefinition.OperationKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OPERATION: {
                return OperationDefinition.OperationKind.OPERATION;
            }
            case QUERY: {
                return OperationDefinition.OperationKind.QUERY;
            }
        }
        return OperationDefinition.OperationKind.NULL;
    }

    public ContactDetail convertOperationDefinitionContactComponent(OperationDefinition.OperationDefinitionContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public OperationDefinition.OperationDefinitionContactComponent convertOperationDefinitionContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionContactComponent tgt = new OperationDefinition.OperationDefinitionContactComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public OperationDefinition.OperationDefinitionParameterComponent convertOperationDefinitionParameterComponent(OperationDefinition.OperationDefinitionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterComponent tgt = new OperationDefinition.OperationDefinitionParameterComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        tgt.setUse(this.convertOperationParameterUse(src.getUse()));
        tgt.setMin(src.getMin());
        tgt.setMax(src.getMax());
        tgt.setDocumentation(src.getDocumentation());
        tgt.setType(src.getType());
        tgt.addTargetProfile(src.getProfile().getReference());
        tgt.setBinding(this.convertOperationDefinitionParameterBindingComponent(src.getBinding()));
        for (OperationDefinition.OperationDefinitionParameterComponent t : src.getPart()) {
            tgt.addPart(this.convertOperationDefinitionParameterComponent(t));
        }
        return tgt;
    }

    public OperationDefinition.OperationDefinitionParameterComponent convertOperationDefinitionParameterComponent(OperationDefinition.OperationDefinitionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterComponent tgt = new OperationDefinition.OperationDefinitionParameterComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        tgt.setUse(this.convertOperationParameterUse(src.getUse()));
        tgt.setMin(src.getMin());
        tgt.setMax(src.getMax());
        tgt.setDocumentation(src.getDocumentation());
        if (src.hasSearchType()) {
            tgt.setType(src.getSearchType().toCode());
            tgt.setType("string");
        } else {
            tgt.setType(src.getType());
        }
        for (org.hl7.fhir.r4.model.UriType t : src.getTargetProfile()) {
            tgt.setProfile(new Reference((String)t.getValue()));
        }
        if (src.hasBinding()) {
            tgt.setBinding(this.convertOperationDefinitionParameterBindingComponent(src.getBinding()));
        }
        for (org.hl7.fhir.r4.model.UriType t : src.getPart()) {
            tgt.addPart(this.convertOperationDefinitionParameterComponent((OperationDefinition.OperationDefinitionParameterComponent)t));
        }
        return tgt;
    }

    public OperationDefinition.OperationParameterUse convertOperationParameterUse(OperationDefinition.OperationParameterUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case IN: {
                return OperationDefinition.OperationParameterUse.IN;
            }
            case OUT: {
                return OperationDefinition.OperationParameterUse.OUT;
            }
        }
        return OperationDefinition.OperationParameterUse.NULL;
    }

    public OperationDefinition.OperationParameterUse convertOperationParameterUse(OperationDefinition.OperationParameterUse src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case IN: {
                return OperationDefinition.OperationParameterUse.IN;
            }
            case OUT: {
                return OperationDefinition.OperationParameterUse.OUT;
            }
        }
        return OperationDefinition.OperationParameterUse.NULL;
    }

    public OperationDefinition.OperationDefinitionParameterBindingComponent convertOperationDefinitionParameterBindingComponent(OperationDefinition.OperationDefinitionParameterBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterBindingComponent tgt = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setStrength(this.convertBindingStrength(src.getStrength()));
        Type t = this.convertType(src.getValueSet());
        if (t != null) {
            if (t instanceof org.hl7.fhir.r4.model.Reference) {
                tgt.setValueSet(((org.hl7.fhir.r4.model.Reference)t).getReference());
            } else {
                tgt.setValueSet(t.primitiveValue());
            }
            tgt.setValueSet(VersionConvertorConstants.refToVS(tgt.getValueSet()));
        }
        return tgt;
    }

    public OperationDefinition.OperationDefinitionParameterBindingComponent convertOperationDefinitionParameterBindingComponent(OperationDefinition.OperationDefinitionParameterBindingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationDefinition.OperationDefinitionParameterBindingComponent tgt = new OperationDefinition.OperationDefinitionParameterBindingComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setStrength(this.convertBindingStrength(src.getStrength()));
        if (src.hasValueSet()) {
            String vsr = VersionConvertorConstants.vsToRef(src.getValueSet());
            if (vsr != null) {
                tgt.setValueSet((org.hl7.fhir.instance.model.Type)new UriType(vsr));
            } else {
                tgt.setValueSet((org.hl7.fhir.instance.model.Type)new Reference(src.getValueSet()));
            }
        }
        return tgt;
    }

    public OperationOutcome convertOperationOutcome(org.hl7.fhir.instance.model.OperationOutcome src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationOutcome tgt = new OperationOutcome();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (OperationOutcome.OperationOutcomeIssueComponent t : src.getIssue()) {
            tgt.addIssue(this.convertOperationOutcomeIssueComponent(t));
        }
        return tgt;
    }

    public org.hl7.fhir.instance.model.OperationOutcome convertOperationOutcome(OperationOutcome src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.OperationOutcome tgt = new org.hl7.fhir.instance.model.OperationOutcome();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (OperationOutcome.OperationOutcomeIssueComponent t : src.getIssue()) {
            tgt.addIssue(this.convertOperationOutcomeIssueComponent(t));
        }
        return tgt;
    }

    public OperationOutcome.OperationOutcomeIssueComponent convertOperationOutcomeIssueComponent(OperationOutcome.OperationOutcomeIssueComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationOutcome.OperationOutcomeIssueComponent tgt = new OperationOutcome.OperationOutcomeIssueComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setSeverity(this.convertIssueSeverity(src.getSeverity()));
        tgt.setCode(this.convertIssueType(src.getCode()));
        tgt.setDetails(this.convertCodeableConcept(src.getDetails()));
        tgt.setDiagnostics(src.getDiagnostics());
        for (org.hl7.fhir.instance.model.StringType t : src.getLocation()) {
            tgt.addLocation((String)t.getValue());
        }
        return tgt;
    }

    public OperationOutcome.OperationOutcomeIssueComponent convertOperationOutcomeIssueComponent(OperationOutcome.OperationOutcomeIssueComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        OperationOutcome.OperationOutcomeIssueComponent tgt = new OperationOutcome.OperationOutcomeIssueComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setSeverity(this.convertIssueSeverity(src.getSeverity()));
        tgt.setCode(this.convertIssueType(src.getCode()));
        tgt.setDetails(this.convertCodeableConcept(src.getDetails()));
        tgt.setDiagnostics(src.getDiagnostics());
        for (StringType t : src.getLocation()) {
            tgt.addLocation((String)t.getValue());
        }
        return tgt;
    }

    public OperationOutcome.IssueSeverity convertIssueSeverity(OperationOutcome.IssueSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case FATAL: {
                return OperationOutcome.IssueSeverity.FATAL;
            }
            case ERROR: {
                return OperationOutcome.IssueSeverity.ERROR;
            }
            case WARNING: {
                return OperationOutcome.IssueSeverity.WARNING;
            }
            case INFORMATION: {
                return OperationOutcome.IssueSeverity.INFORMATION;
            }
        }
        return OperationOutcome.IssueSeverity.NULL;
    }

    public OperationOutcome.IssueSeverity convertIssueSeverity(OperationOutcome.IssueSeverity src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case FATAL: {
                return OperationOutcome.IssueSeverity.FATAL;
            }
            case ERROR: {
                return OperationOutcome.IssueSeverity.ERROR;
            }
            case WARNING: {
                return OperationOutcome.IssueSeverity.WARNING;
            }
            case INFORMATION: {
                return OperationOutcome.IssueSeverity.INFORMATION;
            }
        }
        return OperationOutcome.IssueSeverity.NULL;
    }

    public OperationOutcome.IssueType convertIssueType(OperationOutcome.IssueType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INVALID: {
                return OperationOutcome.IssueType.INVALID;
            }
            case STRUCTURE: {
                return OperationOutcome.IssueType.STRUCTURE;
            }
            case REQUIRED: {
                return OperationOutcome.IssueType.REQUIRED;
            }
            case VALUE: {
                return OperationOutcome.IssueType.VALUE;
            }
            case INVARIANT: {
                return OperationOutcome.IssueType.INVARIANT;
            }
            case SECURITY: {
                return OperationOutcome.IssueType.SECURITY;
            }
            case LOGIN: {
                return OperationOutcome.IssueType.LOGIN;
            }
            case UNKNOWN: {
                return OperationOutcome.IssueType.UNKNOWN;
            }
            case EXPIRED: {
                return OperationOutcome.IssueType.EXPIRED;
            }
            case FORBIDDEN: {
                return OperationOutcome.IssueType.FORBIDDEN;
            }
            case SUPPRESSED: {
                return OperationOutcome.IssueType.SUPPRESSED;
            }
            case PROCESSING: {
                return OperationOutcome.IssueType.PROCESSING;
            }
            case NOTSUPPORTED: {
                return OperationOutcome.IssueType.NOTSUPPORTED;
            }
            case DUPLICATE: {
                return OperationOutcome.IssueType.DUPLICATE;
            }
            case NOTFOUND: {
                return OperationOutcome.IssueType.NOTFOUND;
            }
            case TOOLONG: {
                return OperationOutcome.IssueType.TOOLONG;
            }
            case CODEINVALID: {
                return OperationOutcome.IssueType.CODEINVALID;
            }
            case EXTENSION: {
                return OperationOutcome.IssueType.EXTENSION;
            }
            case TOOCOSTLY: {
                return OperationOutcome.IssueType.TOOCOSTLY;
            }
            case BUSINESSRULE: {
                return OperationOutcome.IssueType.BUSINESSRULE;
            }
            case CONFLICT: {
                return OperationOutcome.IssueType.CONFLICT;
            }
            case INCOMPLETE: {
                return OperationOutcome.IssueType.INCOMPLETE;
            }
            case TRANSIENT: {
                return OperationOutcome.IssueType.TRANSIENT;
            }
            case LOCKERROR: {
                return OperationOutcome.IssueType.LOCKERROR;
            }
            case NOSTORE: {
                return OperationOutcome.IssueType.NOSTORE;
            }
            case EXCEPTION: {
                return OperationOutcome.IssueType.EXCEPTION;
            }
            case TIMEOUT: {
                return OperationOutcome.IssueType.TIMEOUT;
            }
            case THROTTLED: {
                return OperationOutcome.IssueType.THROTTLED;
            }
            case INFORMATIONAL: {
                return OperationOutcome.IssueType.INFORMATIONAL;
            }
        }
        return OperationOutcome.IssueType.NULL;
    }

    public OperationOutcome.IssueType convertIssueType(OperationOutcome.IssueType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INVALID: {
                return OperationOutcome.IssueType.INVALID;
            }
            case STRUCTURE: {
                return OperationOutcome.IssueType.STRUCTURE;
            }
            case REQUIRED: {
                return OperationOutcome.IssueType.REQUIRED;
            }
            case VALUE: {
                return OperationOutcome.IssueType.VALUE;
            }
            case INVARIANT: {
                return OperationOutcome.IssueType.INVARIANT;
            }
            case SECURITY: {
                return OperationOutcome.IssueType.SECURITY;
            }
            case LOGIN: {
                return OperationOutcome.IssueType.LOGIN;
            }
            case UNKNOWN: {
                return OperationOutcome.IssueType.UNKNOWN;
            }
            case EXPIRED: {
                return OperationOutcome.IssueType.EXPIRED;
            }
            case FORBIDDEN: {
                return OperationOutcome.IssueType.FORBIDDEN;
            }
            case SUPPRESSED: {
                return OperationOutcome.IssueType.SUPPRESSED;
            }
            case PROCESSING: {
                return OperationOutcome.IssueType.PROCESSING;
            }
            case NOTSUPPORTED: {
                return OperationOutcome.IssueType.NOTSUPPORTED;
            }
            case DUPLICATE: {
                return OperationOutcome.IssueType.DUPLICATE;
            }
            case NOTFOUND: {
                return OperationOutcome.IssueType.NOTFOUND;
            }
            case TOOLONG: {
                return OperationOutcome.IssueType.TOOLONG;
            }
            case CODEINVALID: {
                return OperationOutcome.IssueType.CODEINVALID;
            }
            case EXTENSION: {
                return OperationOutcome.IssueType.EXTENSION;
            }
            case TOOCOSTLY: {
                return OperationOutcome.IssueType.TOOCOSTLY;
            }
            case BUSINESSRULE: {
                return OperationOutcome.IssueType.BUSINESSRULE;
            }
            case CONFLICT: {
                return OperationOutcome.IssueType.CONFLICT;
            }
            case INCOMPLETE: {
                return OperationOutcome.IssueType.INCOMPLETE;
            }
            case TRANSIENT: {
                return OperationOutcome.IssueType.TRANSIENT;
            }
            case LOCKERROR: {
                return OperationOutcome.IssueType.LOCKERROR;
            }
            case NOSTORE: {
                return OperationOutcome.IssueType.NOSTORE;
            }
            case EXCEPTION: {
                return OperationOutcome.IssueType.EXCEPTION;
            }
            case TIMEOUT: {
                return OperationOutcome.IssueType.TIMEOUT;
            }
            case THROTTLED: {
                return OperationOutcome.IssueType.THROTTLED;
            }
            case INFORMATIONAL: {
                return OperationOutcome.IssueType.INFORMATIONAL;
            }
        }
        return OperationOutcome.IssueType.NULL;
    }

    public org.hl7.fhir.r4.model.Organization convertOrganization(Organization src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Organization tgt = new org.hl7.fhir.r4.model.Organization();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setActive(src.getActive());
        tgt.addType(this.convertCodeableConcept(src.getType()));
        tgt.setName(src.getName());
        for (org.hl7.fhir.instance.model.Identifier t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint((ContactPoint)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getAddress()) {
            tgt.addAddress(this.convertAddress((org.hl7.fhir.instance.model.Address)t));
        }
        tgt.setPartOf(this.convertReference(src.getPartOf()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getContact()) {
            tgt.addContact(this.convertOrganizationContactComponent((Organization.OrganizationContactComponent)t));
        }
        return tgt;
    }

    public Organization convertOrganization(org.hl7.fhir.r4.model.Organization src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Organization tgt = new Organization();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setActive(src.getActive());
        tgt.setType(this.convertCodeableConcept(src.getTypeFirstRep()));
        tgt.setName(src.getName());
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint((org.hl7.fhir.r4.model.ContactPoint)t));
        }
        for (Identifier t : src.getAddress()) {
            tgt.addAddress(this.convertAddress((Address)t));
        }
        tgt.setPartOf(this.convertReference(src.getPartOf()));
        for (Identifier t : src.getContact()) {
            tgt.addContact(this.convertOrganizationContactComponent((Organization.OrganizationContactComponent)t));
        }
        return tgt;
    }

    public Organization.OrganizationContactComponent convertOrganizationContactComponent(Organization.OrganizationContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Organization.OrganizationContactComponent tgt = new Organization.OrganizationContactComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setPurpose(this.convertCodeableConcept(src.getPurpose()));
        tgt.setName(this.convertHumanName(src.getName()));
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        tgt.setAddress(this.convertAddress(src.getAddress()));
        return tgt;
    }

    public Organization.OrganizationContactComponent convertOrganizationContactComponent(Organization.OrganizationContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Organization.OrganizationContactComponent tgt = new Organization.OrganizationContactComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setPurpose(this.convertCodeableConcept(src.getPurpose()));
        tgt.setName(this.convertHumanName(src.getName()));
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        tgt.setAddress(this.convertAddress(src.getAddress()));
        return tgt;
    }

    public Patient convertPatient(org.hl7.fhir.instance.model.Patient src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient tgt = new Patient();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setActive(src.getActive());
        for (org.hl7.fhir.instance.model.Identifier t : src.getName()) {
            tgt.addName(this.convertHumanName((HumanName)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint((ContactPoint)t));
        }
        tgt.setGender(this.convertAdministrativeGender(src.getGender()));
        tgt.setBirthDate(src.getBirthDate());
        tgt.setDeceased(this.convertType(src.getDeceased()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getAddress()) {
            tgt.addAddress(this.convertAddress((org.hl7.fhir.instance.model.Address)t));
        }
        tgt.setMaritalStatus(this.convertCodeableConcept(src.getMaritalStatus()));
        tgt.setMultipleBirth(this.convertType(src.getMultipleBirth()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getPhoto()) {
            tgt.addPhoto(this.convertAttachment((org.hl7.fhir.instance.model.Attachment)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getContact()) {
            tgt.addContact(this.convertContactComponent((Patient.ContactComponent)t));
        }
        if (src.hasAnimal()) {
            tgt.addExtension(this.convertAnimalComponent(src.getAnimal()));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getCommunication()) {
            tgt.addCommunication(this.convertPatientCommunicationComponent((Patient.PatientCommunicationComponent)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getCareProvider()) {
            tgt.addGeneralPractitioner(this.convertReference((Reference)t));
        }
        tgt.setManagingOrganization(this.convertReference(src.getManagingOrganization()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getLink()) {
            tgt.addLink(this.convertPatientLinkComponent((Patient.PatientLinkComponent)t));
        }
        return tgt;
    }

    public org.hl7.fhir.instance.model.Patient convertPatient(Patient src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Patient tgt = new org.hl7.fhir.instance.model.Patient();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setActive(src.getActive());
        for (Identifier t : src.getName()) {
            tgt.addName(this.convertHumanName((org.hl7.fhir.r4.model.HumanName)t));
        }
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint((org.hl7.fhir.r4.model.ContactPoint)t));
        }
        tgt.setGender(this.convertAdministrativeGender(src.getGender()));
        tgt.setBirthDate(src.getBirthDate());
        tgt.setDeceased(this.convertType(src.getDeceased()));
        for (Identifier t : src.getAddress()) {
            tgt.addAddress(this.convertAddress((Address)t));
        }
        tgt.setMaritalStatus(this.convertCodeableConcept(src.getMaritalStatus()));
        tgt.setMultipleBirth(this.convertType(src.getMultipleBirth()));
        for (Identifier t : src.getPhoto()) {
            tgt.addPhoto(this.convertAttachment((Attachment)t));
        }
        for (Identifier t : src.getContact()) {
            tgt.addContact(this.convertContactComponent((Patient.ContactComponent)t));
        }
        if (src.hasExtension("http://hl7.org/fhir/StructureDefinition/patient-animal")) {
            tgt.setAnimal(this.convertAnimalComponent(src.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/patient-animal")));
        }
        for (Identifier t : src.getCommunication()) {
            tgt.addCommunication(this.convertPatientCommunicationComponent((Patient.PatientCommunicationComponent)t));
        }
        for (Identifier t : src.getGeneralPractitioner()) {
            tgt.addCareProvider(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        tgt.setManagingOrganization(this.convertReference(src.getManagingOrganization()));
        for (Identifier t : src.getLink()) {
            tgt.addLink(this.convertPatientLinkComponent((Patient.PatientLinkComponent)t));
        }
        return tgt;
    }

    public Patient.ContactComponent convertContactComponent(Patient.ContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.ContactComponent tgt = new Patient.ContactComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (CodeableConcept t : src.getRelationship()) {
            tgt.addRelationship(this.convertCodeableConcept(t));
        }
        tgt.setName(this.convertHumanName(src.getName()));
        for (CodeableConcept t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint((ContactPoint)t));
        }
        tgt.setAddress(this.convertAddress(src.getAddress()));
        tgt.setGender(this.convertAdministrativeGender(src.getGender()));
        tgt.setOrganization(this.convertReference(src.getOrganization()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public Patient.ContactComponent convertContactComponent(Patient.ContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.ContactComponent tgt = new Patient.ContactComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getRelationship()) {
            tgt.addRelationship(this.convertCodeableConcept(t));
        }
        tgt.setName(this.convertHumanName(src.getName()));
        for (org.hl7.fhir.r4.model.CodeableConcept t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint((org.hl7.fhir.r4.model.ContactPoint)t));
        }
        tgt.setAddress(this.convertAddress(src.getAddress()));
        tgt.setGender(this.convertAdministrativeGender(src.getGender()));
        tgt.setOrganization(this.convertReference(src.getOrganization()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        return tgt;
    }

    public Extension convertAnimalComponent(Patient.AnimalComponent src) throws FHIRException {
        if (src == null) {
            return null;
        }
        Extension tgt = new Extension();
        tgt.setUrl("http://hl7.org/fhir/StructureDefinition/patient-animal");
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        if (src.hasSpecies()) {
            tgt.addExtension("species", (Type)this.convertCodeableConcept(src.getSpecies()));
        }
        if (src.hasBreed()) {
            tgt.addExtension("breed", (Type)this.convertCodeableConcept(src.getBreed()));
        }
        if (src.hasGenderStatus()) {
            tgt.addExtension("genderStatus", (Type)this.convertCodeableConcept(src.getGenderStatus()));
        }
        return tgt;
    }

    public Patient.AnimalComponent convertAnimalComponent(Extension src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.AnimalComponent tgt = new Patient.AnimalComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        if (src.hasExtension("species")) {
            tgt.setSpecies(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)src.getExtensionByUrl("species").getValue()));
        }
        if (src.hasExtension("breed")) {
            tgt.setBreed(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)src.getExtensionByUrl("breed").getValue()));
        }
        if (src.hasExtension("genderStatus")) {
            tgt.setGenderStatus(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)src.getExtensionByUrl("genderStatus").getValue()));
        }
        return tgt;
    }

    public Patient.PatientCommunicationComponent convertPatientCommunicationComponent(Patient.PatientCommunicationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.PatientCommunicationComponent tgt = new Patient.PatientCommunicationComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setLanguage(this.convertCodeableConcept(src.getLanguage()));
        tgt.setPreferred(src.getPreferred());
        return tgt;
    }

    public Patient.PatientCommunicationComponent convertPatientCommunicationComponent(Patient.PatientCommunicationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.PatientCommunicationComponent tgt = new Patient.PatientCommunicationComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setLanguage(this.convertCodeableConcept(src.getLanguage()));
        tgt.setPreferred(src.getPreferred());
        return tgt;
    }

    public Patient.PatientLinkComponent convertPatientLinkComponent(Patient.PatientLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.PatientLinkComponent tgt = new Patient.PatientLinkComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setOther(this.convertReference(src.getOther()));
        tgt.setType(this.convertLinkType(src.getType()));
        return tgt;
    }

    public Patient.PatientLinkComponent convertPatientLinkComponent(Patient.PatientLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Patient.PatientLinkComponent tgt = new Patient.PatientLinkComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setOther(this.convertReference(src.getOther()));
        tgt.setType(this.convertLinkType(src.getType()));
        return tgt;
    }

    public Patient.LinkType convertLinkType(Patient.LinkType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REPLACE: {
                return Patient.LinkType.REPLACEDBY;
            }
            case REFER: {
                return Patient.LinkType.REFER;
            }
            case SEEALSO: {
                return Patient.LinkType.SEEALSO;
            }
        }
        return Patient.LinkType.NULL;
    }

    public Patient.LinkType convertLinkType(Patient.LinkType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REPLACEDBY: {
                return Patient.LinkType.REPLACE;
            }
            case REPLACES: {
                return Patient.LinkType.REPLACE;
            }
            case REFER: {
                return Patient.LinkType.REFER;
            }
            case SEEALSO: {
                return Patient.LinkType.SEEALSO;
            }
        }
        return Patient.LinkType.NULL;
    }

    public Person convertPerson(org.hl7.fhir.instance.model.Person src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Person tgt = new Person();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getName()) {
            tgt.addName(this.convertHumanName((HumanName)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint((ContactPoint)t));
        }
        tgt.setGender(this.convertAdministrativeGender(src.getGender()));
        tgt.setBirthDate(src.getBirthDate());
        for (org.hl7.fhir.instance.model.Identifier t : src.getAddress()) {
            tgt.addAddress(this.convertAddress((org.hl7.fhir.instance.model.Address)t));
        }
        tgt.setPhoto(this.convertAttachment(src.getPhoto()));
        tgt.setManagingOrganization(this.convertReference(src.getManagingOrganization()));
        tgt.setActive(src.getActive());
        for (org.hl7.fhir.instance.model.Identifier t : src.getLink()) {
            tgt.addLink(this.convertPersonLinkComponent((Person.PersonLinkComponent)t));
        }
        return tgt;
    }

    public org.hl7.fhir.instance.model.Person convertPerson(Person src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Person tgt = new org.hl7.fhir.instance.model.Person();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        for (Identifier t : src.getName()) {
            tgt.addName(this.convertHumanName((org.hl7.fhir.r4.model.HumanName)t));
        }
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint((org.hl7.fhir.r4.model.ContactPoint)t));
        }
        tgt.setGender(this.convertAdministrativeGender(src.getGender()));
        tgt.setBirthDate(src.getBirthDate());
        for (Identifier t : src.getAddress()) {
            tgt.addAddress(this.convertAddress((Address)t));
        }
        tgt.setPhoto(this.convertAttachment(src.getPhoto()));
        tgt.setManagingOrganization(this.convertReference(src.getManagingOrganization()));
        tgt.setActive(src.getActive());
        for (Identifier t : src.getLink()) {
            tgt.addLink(this.convertPersonLinkComponent((Person.PersonLinkComponent)t));
        }
        return tgt;
    }

    public Person.PersonLinkComponent convertPersonLinkComponent(Person.PersonLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Person.PersonLinkComponent tgt = new Person.PersonLinkComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setTarget(this.convertReference(src.getTarget()));
        tgt.setAssurance(this.convertIdentityAssuranceLevel(src.getAssurance()));
        return tgt;
    }

    public Person.PersonLinkComponent convertPersonLinkComponent(Person.PersonLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Person.PersonLinkComponent tgt = new Person.PersonLinkComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setTarget(this.convertReference(src.getTarget()));
        tgt.setAssurance(this.convertIdentityAssuranceLevel(src.getAssurance()));
        return tgt;
    }

    public Person.IdentityAssuranceLevel convertIdentityAssuranceLevel(Person.IdentityAssuranceLevel src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case LEVEL1: {
                return Person.IdentityAssuranceLevel.LEVEL1;
            }
            case LEVEL2: {
                return Person.IdentityAssuranceLevel.LEVEL2;
            }
            case LEVEL3: {
                return Person.IdentityAssuranceLevel.LEVEL3;
            }
            case LEVEL4: {
                return Person.IdentityAssuranceLevel.LEVEL4;
            }
        }
        return Person.IdentityAssuranceLevel.NULL;
    }

    public Person.IdentityAssuranceLevel convertIdentityAssuranceLevel(Person.IdentityAssuranceLevel src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case LEVEL1: {
                return Person.IdentityAssuranceLevel.LEVEL1;
            }
            case LEVEL2: {
                return Person.IdentityAssuranceLevel.LEVEL2;
            }
            case LEVEL3: {
                return Person.IdentityAssuranceLevel.LEVEL3;
            }
            case LEVEL4: {
                return Person.IdentityAssuranceLevel.LEVEL4;
            }
        }
        return Person.IdentityAssuranceLevel.NULL;
    }

    public org.hl7.fhir.r4.model.Practitioner convertPractitioner(Practitioner src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Practitioner tgt = new org.hl7.fhir.r4.model.Practitioner();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setActive(src.getActive());
        if (src.hasName()) {
            tgt.addName(this.convertHumanName(src.getName()));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint((ContactPoint)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getAddress()) {
            tgt.addAddress(this.convertAddress((org.hl7.fhir.instance.model.Address)t));
        }
        tgt.setGender(this.convertAdministrativeGender(src.getGender()));
        tgt.setBirthDate(src.getBirthDate());
        for (org.hl7.fhir.instance.model.Identifier t : src.getPhoto()) {
            tgt.addPhoto(this.convertAttachment((org.hl7.fhir.instance.model.Attachment)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getQualification()) {
            tgt.addQualification(this.convertPractitionerQualificationComponent((Practitioner.PractitionerQualificationComponent)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getCommunication()) {
            tgt.addCommunication(this.convertCodeableConcept((CodeableConcept)t));
        }
        return tgt;
    }

    public Practitioner convertPractitioner(org.hl7.fhir.r4.model.Practitioner src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Practitioner tgt = new Practitioner();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setActive(src.getActive());
        for (Identifier t : src.getName()) {
            tgt.setName(this.convertHumanName((org.hl7.fhir.r4.model.HumanName)t));
        }
        for (Identifier t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint((org.hl7.fhir.r4.model.ContactPoint)t));
        }
        for (Identifier t : src.getAddress()) {
            tgt.addAddress(this.convertAddress((Address)t));
        }
        tgt.setGender(this.convertAdministrativeGender(src.getGender()));
        tgt.setBirthDate(src.getBirthDate());
        for (Identifier t : src.getPhoto()) {
            tgt.addPhoto(this.convertAttachment((Attachment)t));
        }
        for (Identifier t : src.getQualification()) {
            tgt.addQualification(this.convertPractitionerQualificationComponent((Practitioner.PractitionerQualificationComponent)t));
        }
        for (Identifier t : src.getCommunication()) {
            tgt.addCommunication(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        return tgt;
    }

    public Practitioner.PractitionerQualificationComponent convertPractitionerQualificationComponent(Practitioner.PractitionerQualificationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Practitioner.PractitionerQualificationComponent tgt = new Practitioner.PractitionerQualificationComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        tgt.setIssuer(this.convertReference(src.getIssuer()));
        return tgt;
    }

    public Practitioner.PractitionerQualificationComponent convertPractitionerQualificationComponent(Practitioner.PractitionerQualificationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Practitioner.PractitionerQualificationComponent tgt = new Practitioner.PractitionerQualificationComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setPeriod(this.convertPeriod(src.getPeriod()));
        tgt.setIssuer(this.convertReference(src.getIssuer()));
        return tgt;
    }

    public org.hl7.fhir.r4.model.Questionnaire convertQuestionnaire(Questionnaire src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Questionnaire tgt = new org.hl7.fhir.r4.model.Questionnaire();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setVersion(src.getVersion());
        tgt.setStatus(VersionConvertor_10_40.convertQuestionnaireStatus(src.getStatus()));
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setPublisher(src.getPublisher());
        for (org.hl7.fhir.instance.model.Identifier t : src.getTelecom()) {
            tgt.addContact(this.convertQuestionnaireContactComponent((ContactPoint)t));
        }
        Questionnaire.GroupComponent root = src.getGroup();
        tgt.setTitle(root.getTitle());
        for (Coding t : root.getConcept()) {
            tgt.addCode(this.convertCoding(t));
        }
        for (Coding t : src.getSubjectType()) {
            tgt.addSubjectType((String)t.getValue());
        }
        tgt.addItem(this.convertQuestionnaireGroupComponent(root));
        return tgt;
    }

    public Questionnaire convertQuestionnaire(org.hl7.fhir.r4.model.Questionnaire src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire tgt = new Questionnaire();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setVersion(src.getVersion());
        tgt.setStatus(VersionConvertor_10_40.convertQuestionnaireStatus(src.getStatus()));
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setPublisher(src.getPublisher());
        for (Identifier t : src.getContact()) {
            for (org.hl7.fhir.r4.model.ContactPoint t1 : t.getTelecom()) {
                tgt.addTelecom(this.convertContactPoint(t1));
            }
        }
        Questionnaire.GroupComponent root = tgt.getGroup();
        root.setTitle(src.getTitle());
        for (org.hl7.fhir.r4.model.Coding t : src.getCode()) {
            root.addConcept(this.convertCoding(t));
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getSubjectType()) {
            tgt.addSubjectType((String)t.getValue());
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getItem()) {
            if (t.getType() == Questionnaire.QuestionnaireItemType.GROUP) {
                root.addGroup(this.convertQuestionnaireGroupComponent((Questionnaire.QuestionnaireItemComponent)t));
                continue;
            }
            root.addQuestion(this.convertQuestionnaireQuestionComponent((Questionnaire.QuestionnaireItemComponent)t));
        }
        return tgt;
    }

    public ContactDetail convertQuestionnaireContactComponent(ContactPoint src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.addTelecom(this.convertContactPoint(src));
        return tgt;
    }

    private static Enumerations.PublicationStatus convertQuestionnaireStatus(Questionnaire.QuestionnaireStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DRAFT: {
                return Enumerations.PublicationStatus.DRAFT;
            }
            case PUBLISHED: {
                return Enumerations.PublicationStatus.ACTIVE;
            }
            case RETIRED: {
                return Enumerations.PublicationStatus.RETIRED;
            }
        }
        return Enumerations.PublicationStatus.NULL;
    }

    private static Questionnaire.QuestionnaireStatus convertQuestionnaireStatus(Enumerations.PublicationStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DRAFT: {
                return Questionnaire.QuestionnaireStatus.DRAFT;
            }
            case ACTIVE: {
                return Questionnaire.QuestionnaireStatus.PUBLISHED;
            }
            case RETIRED: {
                return Questionnaire.QuestionnaireStatus.RETIRED;
            }
        }
        return Questionnaire.QuestionnaireStatus.NULL;
    }

    public Questionnaire.QuestionnaireItemComponent convertQuestionnaireQuestionComponent(Questionnaire.QuestionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemComponent tgt = new Questionnaire.QuestionnaireItemComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setLinkId(src.getLinkId());
        for (Coding t : src.getConcept()) {
            tgt.addCode(this.convertCoding(t));
        }
        tgt.setText(src.getText());
        tgt.setType(this.convertQuestionnaireQuestionType(src.getType()));
        tgt.setRequired(src.getRequired());
        tgt.setRepeats(src.getRepeats());
        tgt.setAnswerValueSetElement(this.convertReferenceToCanonical(src.getOptions()));
        for (Coding t : src.getOption()) {
            tgt.addAnswerOption().setValue((Type)this.convertCoding(t));
        }
        for (Coding t : src.getGroup()) {
            tgt.addItem(this.convertQuestionnaireGroupComponent((Questionnaire.GroupComponent)t));
        }
        return tgt;
    }

    public Questionnaire.QuestionnaireItemComponent convertQuestionnaireGroupComponent(Questionnaire.GroupComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionnaireItemComponent tgt = new Questionnaire.QuestionnaireItemComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setLinkId(src.getLinkId());
        for (Coding t : src.getConcept()) {
            tgt.addCode(this.convertCoding(t));
        }
        tgt.setText(src.getText());
        tgt.setType(Questionnaire.QuestionnaireItemType.GROUP);
        tgt.setRequired(src.getRequired());
        tgt.setRepeats(src.getRepeats());
        for (Coding t : src.getGroup()) {
            tgt.addItem(this.convertQuestionnaireGroupComponent((Questionnaire.GroupComponent)t));
        }
        for (Coding t : src.getQuestion()) {
            tgt.addItem(this.convertQuestionnaireQuestionComponent((Questionnaire.QuestionComponent)t));
        }
        return tgt;
    }

    public Questionnaire.GroupComponent convertQuestionnaireGroupComponent(Questionnaire.QuestionnaireItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.GroupComponent tgt = new Questionnaire.GroupComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setLinkId(src.getLinkId());
        for (org.hl7.fhir.r4.model.Coding t : src.getCode()) {
            tgt.addConcept(this.convertCoding(t));
        }
        tgt.setText(src.getText());
        tgt.setRequired(src.getRequired());
        tgt.setRepeats(src.getRepeats());
        for (org.hl7.fhir.r4.model.Coding t : src.getItem()) {
            if (t.getType() == Questionnaire.QuestionnaireItemType.GROUP) {
                tgt.addGroup(this.convertQuestionnaireGroupComponent((Questionnaire.QuestionnaireItemComponent)t));
                continue;
            }
            tgt.addQuestion(this.convertQuestionnaireQuestionComponent((Questionnaire.QuestionnaireItemComponent)t));
        }
        return tgt;
    }

    public Questionnaire.QuestionComponent convertQuestionnaireQuestionComponent(Questionnaire.QuestionnaireItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Questionnaire.QuestionComponent tgt = new Questionnaire.QuestionComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setLinkId(src.getLinkId());
        for (org.hl7.fhir.r4.model.Coding t : src.getCode()) {
            tgt.addConcept(this.convertCoding(t));
        }
        tgt.setText(src.getText());
        tgt.setType(this.convertQuestionnaireItemType(src.getType()));
        tgt.setRequired(src.getRequired());
        tgt.setRepeats(src.getRepeats());
        tgt.setOptions(this.convertCanonicalToReference(src.getAnswerValueSetElement()));
        for (org.hl7.fhir.r4.model.Coding t : src.getAnswerOption()) {
            if (!t.hasValueCoding()) continue;
            try {
                tgt.addOption(this.convertCoding(t.getValueCoding()));
            }
            catch (FHIRException e) {
                throw new FHIRException((Throwable)e);
            }
        }
        for (org.hl7.fhir.r4.model.Coding t : src.getItem()) {
            tgt.addGroup(this.convertQuestionnaireGroupComponent((Questionnaire.QuestionnaireItemComponent)t));
        }
        return tgt;
    }

    public Questionnaire.QuestionnaireItemType convertQuestionnaireQuestionType(Questionnaire.AnswerFormat src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case BOOLEAN: {
                return Questionnaire.QuestionnaireItemType.BOOLEAN;
            }
            case DECIMAL: {
                return Questionnaire.QuestionnaireItemType.DECIMAL;
            }
            case INTEGER: {
                return Questionnaire.QuestionnaireItemType.INTEGER;
            }
            case DATE: {
                return Questionnaire.QuestionnaireItemType.DATE;
            }
            case DATETIME: {
                return Questionnaire.QuestionnaireItemType.DATETIME;
            }
            case INSTANT: {
                return Questionnaire.QuestionnaireItemType.DATETIME;
            }
            case TIME: {
                return Questionnaire.QuestionnaireItemType.TIME;
            }
            case STRING: {
                return Questionnaire.QuestionnaireItemType.STRING;
            }
            case TEXT: {
                return Questionnaire.QuestionnaireItemType.TEXT;
            }
            case URL: {
                return Questionnaire.QuestionnaireItemType.URL;
            }
            case CHOICE: {
                return Questionnaire.QuestionnaireItemType.CHOICE;
            }
            case OPENCHOICE: {
                return Questionnaire.QuestionnaireItemType.OPENCHOICE;
            }
            case ATTACHMENT: {
                return Questionnaire.QuestionnaireItemType.ATTACHMENT;
            }
            case REFERENCE: {
                return Questionnaire.QuestionnaireItemType.REFERENCE;
            }
            case QUANTITY: {
                return Questionnaire.QuestionnaireItemType.QUANTITY;
            }
        }
        return Questionnaire.QuestionnaireItemType.NULL;
    }

    public Questionnaire.AnswerFormat convertQuestionnaireItemType(Questionnaire.QuestionnaireItemType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case BOOLEAN: {
                return Questionnaire.AnswerFormat.BOOLEAN;
            }
            case DECIMAL: {
                return Questionnaire.AnswerFormat.DECIMAL;
            }
            case INTEGER: {
                return Questionnaire.AnswerFormat.INTEGER;
            }
            case DATE: {
                return Questionnaire.AnswerFormat.DATE;
            }
            case DATETIME: {
                return Questionnaire.AnswerFormat.DATETIME;
            }
            case TIME: {
                return Questionnaire.AnswerFormat.TIME;
            }
            case STRING: {
                return Questionnaire.AnswerFormat.STRING;
            }
            case TEXT: {
                return Questionnaire.AnswerFormat.TEXT;
            }
            case URL: {
                return Questionnaire.AnswerFormat.URL;
            }
            case CHOICE: {
                return Questionnaire.AnswerFormat.CHOICE;
            }
            case OPENCHOICE: {
                return Questionnaire.AnswerFormat.OPENCHOICE;
            }
            case ATTACHMENT: {
                return Questionnaire.AnswerFormat.ATTACHMENT;
            }
            case REFERENCE: {
                return Questionnaire.AnswerFormat.REFERENCE;
            }
            case QUANTITY: {
                return Questionnaire.AnswerFormat.QUANTITY;
            }
        }
        return Questionnaire.AnswerFormat.NULL;
    }

    public org.hl7.fhir.r4.model.QuestionnaireResponse convertQuestionnaireResponse(QuestionnaireResponse src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.QuestionnaireResponse tgt = new org.hl7.fhir.r4.model.QuestionnaireResponse();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifier()));
        tgt.setQuestionnaireElement(this.convertReferenceToCanonical(src.getQuestionnaire()));
        tgt.setStatus(this.convertQuestionnaireResponseStatus(src.getStatus()));
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setAuthor(this.convertReference(src.getAuthor()));
        tgt.setAuthored(src.getAuthored());
        tgt.setSource(this.convertReference(src.getSource()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        if (src.hasGroup()) {
            tgt.addItem(this.convertQuestionnaireResponseGroupComponent(src.getGroup()));
        }
        return tgt;
    }

    public QuestionnaireResponse convertQuestionnaireResponse(org.hl7.fhir.r4.model.QuestionnaireResponse src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse tgt = new QuestionnaireResponse();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifier()));
        tgt.setQuestionnaire(this.convertCanonicalToReference(src.getQuestionnaireElement()));
        tgt.setStatus(this.convertQuestionnaireResponseStatus(src.getStatus()));
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setAuthor(this.convertReference(src.getAuthor()));
        tgt.setAuthored(src.getAuthored());
        tgt.setSource(this.convertReference(src.getSource()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        if (src.getItem().size() != 1) {
            throw new FHIRException("multiple root items not supported");
        }
        tgt.setGroup(this.convertQuestionnaireItemToGroup((QuestionnaireResponse.QuestionnaireResponseItemComponent)src.getItem().get(0)));
        return tgt;
    }

    public QuestionnaireResponse.QuestionnaireResponseStatus convertQuestionnaireResponseStatus(QuestionnaireResponse.QuestionnaireResponseStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INPROGRESS: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS;
            }
            case COMPLETED: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED;
            }
            case AMENDED: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.AMENDED;
            }
        }
        return QuestionnaireResponse.QuestionnaireResponseStatus.NULL;
    }

    public QuestionnaireResponse.QuestionnaireResponseStatus convertQuestionnaireResponseStatus(QuestionnaireResponse.QuestionnaireResponseStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INPROGRESS: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.INPROGRESS;
            }
            case COMPLETED: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.COMPLETED;
            }
            case AMENDED: {
                return QuestionnaireResponse.QuestionnaireResponseStatus.AMENDED;
            }
        }
        return QuestionnaireResponse.QuestionnaireResponseStatus.NULL;
    }

    public QuestionnaireResponse.QuestionnaireResponseItemComponent convertQuestionnaireResponseGroupComponent(QuestionnaireResponse.GroupComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setLinkId(src.getLinkId());
        tgt.setText(src.getText());
        for (QuestionnaireResponse.GroupComponent t : src.getGroup()) {
            tgt.addItem(this.convertQuestionnaireResponseGroupComponent(t));
        }
        for (QuestionnaireResponse.GroupComponent t : src.getQuestion()) {
            tgt.addItem(this.convertQuestionnaireResponseQuestionComponent((QuestionnaireResponse.QuestionComponent)t));
        }
        return tgt;
    }

    public QuestionnaireResponse.QuestionnaireResponseItemComponent convertQuestionnaireResponseQuestionComponent(QuestionnaireResponse.QuestionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setLinkId(src.getLinkId());
        tgt.setText(src.getText());
        for (QuestionnaireResponse.QuestionAnswerComponent t : src.getAnswer()) {
            tgt.addAnswer(this.convertQuestionnaireResponseItemAnswerComponent(t));
        }
        return tgt;
    }

    public QuestionnaireResponse.GroupComponent convertQuestionnaireItemToGroup(QuestionnaireResponse.QuestionnaireResponseItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.GroupComponent tgt = new QuestionnaireResponse.GroupComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setLinkId(src.getLinkId());
        tgt.setText(src.getText());
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent t : src.getItem()) {
            if (t.hasAnswer()) {
                tgt.addQuestion(this.convertQuestionnaireItemToQuestion(t));
                continue;
            }
            tgt.addGroup(this.convertQuestionnaireItemToGroup(t));
        }
        return tgt;
    }

    public QuestionnaireResponse.QuestionComponent convertQuestionnaireItemToQuestion(QuestionnaireResponse.QuestionnaireResponseItemComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionComponent tgt = new QuestionnaireResponse.QuestionComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setLinkId(src.getLinkId());
        tgt.setText(src.getText());
        for (QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent t : src.getAnswer()) {
            tgt.addAnswer(this.convertQuestionnaireResponseItemAnswerComponent(t));
        }
        return tgt;
    }

    public QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent convertQuestionnaireResponseItemAnswerComponent(QuestionnaireResponse.QuestionAnswerComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent tgt = new QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setValue(this.convertType(src.getValue()));
        for (QuestionnaireResponse.GroupComponent t : src.getGroup()) {
            tgt.addItem(this.convertQuestionnaireResponseGroupComponent(t));
        }
        return tgt;
    }

    public QuestionnaireResponse.QuestionAnswerComponent convertQuestionnaireResponseItemAnswerComponent(QuestionnaireResponse.QuestionnaireResponseItemAnswerComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        QuestionnaireResponse.QuestionAnswerComponent tgt = new QuestionnaireResponse.QuestionAnswerComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setValue(this.convertType(src.getValue()));
        for (QuestionnaireResponse.QuestionnaireResponseItemComponent t : src.getItem()) {
            tgt.addGroup(this.convertQuestionnaireItemToGroup(t));
        }
        return tgt;
    }

    public RiskAssessment convertRiskAssessment(org.hl7.fhir.instance.model.RiskAssessment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        RiskAssessment tgt = new RiskAssessment();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setCondition(this.convertReference(src.getCondition()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        tgt.setPerformer(this.convertReference(src.getPerformer()));
        tgt.addIdentifier(this.convertIdentifier(src.getIdentifier()));
        tgt.setMethod(this.convertCodeableConcept(src.getMethod()));
        for (Reference t : src.getBasis()) {
            tgt.addBasis(this.convertReference(t));
        }
        for (Reference t : src.getPrediction()) {
            tgt.addPrediction(this.convertRiskAssessmentPredictionComponent((RiskAssessment.RiskAssessmentPredictionComponent)t));
        }
        tgt.setMitigation(src.getMitigation());
        return tgt;
    }

    public org.hl7.fhir.instance.model.RiskAssessment convertRiskAssessment(RiskAssessment src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.RiskAssessment tgt = new org.hl7.fhir.instance.model.RiskAssessment();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setCondition(this.convertReference(src.getCondition()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        tgt.setPerformer(this.convertReference(src.getPerformer()));
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifierFirstRep()));
        tgt.setMethod(this.convertCodeableConcept(src.getMethod()));
        for (org.hl7.fhir.r4.model.Reference t : src.getBasis()) {
            tgt.addBasis(this.convertReference(t));
        }
        for (org.hl7.fhir.r4.model.Reference t : src.getPrediction()) {
            tgt.addPrediction(this.convertRiskAssessmentPredictionComponent((RiskAssessment.RiskAssessmentPredictionComponent)t));
        }
        tgt.setMitigation(src.getMitigation());
        return tgt;
    }

    public RiskAssessment.RiskAssessmentPredictionComponent convertRiskAssessmentPredictionComponent(RiskAssessment.RiskAssessmentPredictionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        RiskAssessment.RiskAssessmentPredictionComponent tgt = new RiskAssessment.RiskAssessmentPredictionComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setOutcome(this.convertCodeableConcept(src.getOutcome()));
        tgt.setProbability(this.convertType(src.getProbability()));
        tgt.setRelativeRisk(src.getRelativeRisk());
        tgt.setWhen(this.convertType(src.getWhen()));
        tgt.setRationale(src.getRationale());
        return tgt;
    }

    public RiskAssessment.RiskAssessmentPredictionComponent convertRiskAssessmentPredictionComponent(RiskAssessment.RiskAssessmentPredictionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        RiskAssessment.RiskAssessmentPredictionComponent tgt = new RiskAssessment.RiskAssessmentPredictionComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setOutcome(this.convertCodeableConcept(src.getOutcome()));
        tgt.setProbability(this.convertType(src.getProbability()));
        tgt.setRelativeRisk(src.getRelativeRisk());
        tgt.setWhen(this.convertType(src.getWhen()));
        tgt.setRationale(src.getRationale());
        return tgt;
    }

    public org.hl7.fhir.r4.model.Schedule convertSchedule(Schedule src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Schedule tgt = new org.hl7.fhir.r4.model.Schedule();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getType()) {
            tgt.addServiceType(this.convertCodeableConcept((CodeableConcept)t));
        }
        tgt.addActor(this.convertReference(src.getActor()));
        tgt.setPlanningHorizon(this.convertPeriod(src.getPlanningHorizon()));
        tgt.setComment(src.getComment());
        return tgt;
    }

    public Schedule convertSchedule(org.hl7.fhir.r4.model.Schedule src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Schedule tgt = new Schedule();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        for (Identifier t : src.getServiceType()) {
            tgt.addType(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setActor(this.convertReference(src.getActorFirstRep()));
        tgt.setPlanningHorizon(this.convertPeriod(src.getPlanningHorizon()));
        tgt.setComment(src.getComment());
        return tgt;
    }

    public SearchParameter convertSearchParameter(org.hl7.fhir.instance.model.SearchParameter src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SearchParameter tgt = new SearchParameter();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setName(src.getName());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setPublisher(src.getPublisher());
        for (SearchParameter.SearchParameterContactComponent t : src.getContact()) {
            tgt.addContact(this.convertSearchParameterContactComponent(t));
        }
        tgt.setPurpose(src.getRequirements());
        tgt.setCode(src.getCode());
        tgt.addBase(src.getBase());
        tgt.setType(this.convertSearchParamType(src.getType()));
        tgt.setDescription(src.getDescription());
        tgt.setExpression(ToolingExtensions.readStringExtension((DomainResource)src, (String)"http://hl7.org/fhir/StructureDefinition/structuredefinition-expression"));
        tgt.setXpath(src.getXpath());
        tgt.setXpathUsage(this.convertXPathUsageType(src.getXpathUsage()));
        for (SearchParameter.SearchParameterContactComponent t : src.getTarget()) {
            tgt.addTarget((String)t.getValue());
        }
        return tgt;
    }

    public org.hl7.fhir.instance.model.SearchParameter convertSearchParameter(SearchParameter src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.SearchParameter tgt = new org.hl7.fhir.instance.model.SearchParameter();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setName(src.getName());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setPublisher(src.getPublisher());
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(this.convertSearchParameterContactComponent(t));
        }
        tgt.setRequirements(src.getPurpose());
        tgt.setCode(src.getCode());
        for (ContactDetail t : src.getBase()) {
            tgt.setBase(t.asStringValue());
        }
        tgt.setType(this.convertSearchParamType(src.getType()));
        tgt.setDescription(src.getDescription());
        ToolingExtensions.setStringExtension((DomainResource)tgt, (String)"http://hl7.org/fhir/StructureDefinition/structuredefinition-expression", (String)src.getExpression());
        tgt.setXpath(src.getXpath());
        tgt.setXpathUsage(this.convertXPathUsageType(src.getXpathUsage()));
        for (ContactDetail t : src.getTarget()) {
            tgt.addTarget((String)t.getValue());
        }
        return tgt;
    }

    public SearchParameter.XPathUsageType convertXPathUsageType(SearchParameter.XPathUsageType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NORMAL: {
                return SearchParameter.XPathUsageType.NORMAL;
            }
            case PHONETIC: {
                return SearchParameter.XPathUsageType.PHONETIC;
            }
            case NEARBY: {
                return SearchParameter.XPathUsageType.NEARBY;
            }
            case DISTANCE: {
                return SearchParameter.XPathUsageType.DISTANCE;
            }
            case OTHER: {
                return SearchParameter.XPathUsageType.OTHER;
            }
        }
        return SearchParameter.XPathUsageType.NULL;
    }

    public SearchParameter.XPathUsageType convertXPathUsageType(SearchParameter.XPathUsageType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case NORMAL: {
                return SearchParameter.XPathUsageType.NORMAL;
            }
            case PHONETIC: {
                return SearchParameter.XPathUsageType.PHONETIC;
            }
            case NEARBY: {
                return SearchParameter.XPathUsageType.NEARBY;
            }
            case DISTANCE: {
                return SearchParameter.XPathUsageType.DISTANCE;
            }
            case OTHER: {
                return SearchParameter.XPathUsageType.OTHER;
            }
        }
        return SearchParameter.XPathUsageType.NULL;
    }

    public ContactDetail convertSearchParameterContactComponent(SearchParameter.SearchParameterContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public SearchParameter.SearchParameterContactComponent convertSearchParameterContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SearchParameter.SearchParameterContactComponent tgt = new SearchParameter.SearchParameterContactComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public Slot convertSlot(org.hl7.fhir.instance.model.Slot src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Slot tgt = new Slot();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        if (src.hasType()) {
            tgt.addServiceType(this.convertCodeableConcept(src.getType()));
        }
        tgt.setSchedule(this.convertReference(src.getSchedule()));
        tgt.setStart(src.getStart());
        tgt.setEnd(src.getEnd());
        tgt.setOverbooked(src.getOverbooked());
        tgt.setComment(src.getComment());
        return tgt;
    }

    public org.hl7.fhir.instance.model.Slot convertSlot(Slot src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Slot tgt = new org.hl7.fhir.instance.model.Slot();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        for (Identifier t : src.getServiceType()) {
            tgt.setType(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setSchedule(this.convertReference(src.getSchedule()));
        tgt.setStart(src.getStart());
        tgt.setEnd(src.getEnd());
        tgt.setOverbooked(src.getOverbooked());
        tgt.setComment(src.getComment());
        return tgt;
    }

    public Slot.SlotStatus convertSlotStatus(Slot.SlotStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case BUSY: {
                return Slot.SlotStatus.BUSY;
            }
            case FREE: {
                return Slot.SlotStatus.FREE;
            }
            case BUSYUNAVAILABLE: {
                return Slot.SlotStatus.BUSYUNAVAILABLE;
            }
            case BUSYTENTATIVE: {
                return Slot.SlotStatus.BUSYTENTATIVE;
            }
        }
        return Slot.SlotStatus.NULL;
    }

    public Slot.SlotStatus convertSlotStatus(Slot.SlotStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case BUSY: {
                return Slot.SlotStatus.BUSY;
            }
            case FREE: {
                return Slot.SlotStatus.FREE;
            }
            case BUSYUNAVAILABLE: {
                return Slot.SlotStatus.BUSYUNAVAILABLE;
            }
            case BUSYTENTATIVE: {
                return Slot.SlotStatus.BUSYTENTATIVE;
            }
        }
        return Slot.SlotStatus.NULL;
    }

    public org.hl7.fhir.r4.model.StructureDefinition convertStructureDefinition(StructureDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.StructureDefinition tgt = new org.hl7.fhir.r4.model.StructureDefinition();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setVersion(src.getVersion());
        tgt.setName(src.getName());
        tgt.setTitle(src.getDisplay());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        tgt.setPublisher(src.getPublisher());
        for (org.hl7.fhir.instance.model.Identifier t : src.getContact()) {
            tgt.addContact(this.convertStructureDefinitionContactComponent((StructureDefinition.StructureDefinitionContactComponent)t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setDescription(src.getDescription());
        for (org.hl7.fhir.instance.model.Identifier t : src.getUseContext()) {
            if (VersionConvertor_10_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(this.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(this.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        tgt.setPurpose(src.getRequirements());
        tgt.setCopyright(src.getCopyright());
        for (org.hl7.fhir.instance.model.Identifier t : src.getCode()) {
            tgt.addKeyword(this.convertCoding((Coding)t));
        }
        tgt.setFhirVersion(Enumerations.FHIRVersion.fromCode((String)src.getFhirVersion()));
        for (org.hl7.fhir.instance.model.Identifier t : src.getMapping()) {
            tgt.addMapping(this.convertStructureDefinitionMappingComponent((StructureDefinition.StructureDefinitionMappingComponent)t));
        }
        tgt.setKind(this.convertStructureDefinitionKind(src.getKind(), tgt.getId()));
        tgt.setAbstract(src.getAbstract());
        for (org.hl7.fhir.instance.model.Identifier t : src.getContext()) {
            StructureDefinition.StructureDefinitionContextComponent ec = tgt.addContext();
            ec.setType(VersionConvertor_10_40.convertExtensionContext(src.getContextType()));
            ec.setExpression((String)t.getValue());
        }
        if (src.hasConstrainedType()) {
            tgt.setType(src.getConstrainedType());
        } else if (src.getSnapshot().hasElement()) {
            tgt.setType(((org.hl7.fhir.instance.model.ElementDefinition)src.getSnapshot().getElement().get(0)).getPath());
        } else if (src.getDifferential().hasElement() && !((org.hl7.fhir.instance.model.ElementDefinition)src.getDifferential().getElement().get(0)).getPath().contains(".")) {
            tgt.setType(((org.hl7.fhir.instance.model.ElementDefinition)src.getDifferential().getElement().get(0)).getPath());
        } else {
            tgt.setType(((org.hl7.fhir.instance.model.ElementDefinition)src.getDifferential().getElement().get(0)).getPath().substring(0, ((org.hl7.fhir.instance.model.ElementDefinition)src.getDifferential().getElement().get(0)).getPath().indexOf(".")));
        }
        tgt.setBaseDefinition(src.getBase());
        tgt.setDerivation(src.hasConstrainedType() ? StructureDefinition.TypeDerivationRule.CONSTRAINT : StructureDefinition.TypeDerivationRule.SPECIALIZATION);
        tgt.setSnapshot(this.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
        tgt.setDifferential(this.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
        if (tgt.hasSnapshot()) {
            tgt.getSnapshot().getElementFirstRep().getType().clear();
        }
        if (tgt.hasDifferential()) {
            tgt.getDifferential().getElementFirstRep().getType().clear();
        }
        if (tgt.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE && !tgt.getType().equals(tgt.getId())) {
            tgt.setDerivation(StructureDefinition.TypeDerivationRule.SPECIALIZATION);
            tgt.setBaseDefinition("http://hl7.org/fhir/StructureDefinition/" + tgt.getType());
            tgt.setType(tgt.getId());
        }
        if (tgt.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION) {
            for (ElementDefinition ed : tgt.getSnapshot().getElement()) {
                if (ed.hasBase()) continue;
                ed.getBase().setPath(ed.getPath()).setMin(ed.getMin()).setMax(ed.getMax());
            }
        }
        return tgt;
    }

    public StructureDefinition convertStructureDefinition(org.hl7.fhir.r4.model.StructureDefinition src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition tgt = new StructureDefinition();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setVersion(src.getVersion());
        tgt.setName(src.getName());
        tgt.setDisplay(src.getTitle());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        tgt.setPublisher(src.getPublisher());
        for (Identifier t : src.getContact()) {
            tgt.addContact(this.convertStructureDefinitionContactComponent((ContactDetail)t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setDescription(src.getDescription());
        for (Identifier t : src.getUseContext()) {
            if (!t.hasValueCodeableConcept()) continue;
            tgt.addUseContext(this.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (Identifier t : src.getJurisdiction()) {
            tgt.addUseContext(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setRequirements(src.getPurpose());
        tgt.setCopyright(src.getCopyright());
        for (Identifier t : src.getKeyword()) {
            tgt.addCode(this.convertCoding((org.hl7.fhir.r4.model.Coding)t));
        }
        if (src.hasFhirVersion()) {
            tgt.setFhirVersion(src.getFhirVersion().toCode());
        }
        for (Identifier t : src.getMapping()) {
            tgt.addMapping(this.convertStructureDefinitionMappingComponent((StructureDefinition.StructureDefinitionMappingComponent)t));
        }
        tgt.setKind(this.convertStructureDefinitionKind(src.getKind()));
        tgt.setAbstract(src.getAbstract());
        for (Identifier t : src.getContext()) {
            if (!tgt.hasContextType()) {
                tgt.setContextType(VersionConvertor_10_40.convertExtensionContext(t.getType()));
            }
            tgt.addContext(t.getExpression());
        }
        tgt.setConstrainedType(src.getType());
        tgt.setBase(src.getBaseDefinition());
        tgt.setSnapshot(this.convertStructureDefinitionSnapshotComponent(src.getSnapshot()));
        tgt.setDifferential(this.convertStructureDefinitionDifferentialComponent(src.getDifferential()));
        if (tgt.hasBase()) {
            if (tgt.hasDifferential()) {
                ((org.hl7.fhir.instance.model.ElementDefinition)tgt.getDifferential().getElement().get(0)).addType().setCode(this.tail(tgt.getBase()));
            }
            if (tgt.hasSnapshot()) {
                ((org.hl7.fhir.instance.model.ElementDefinition)tgt.getSnapshot().getElement().get(0)).addType().setCode(this.tail(tgt.getBase()));
            }
        }
        return tgt;
    }

    private String tail(String base) {
        return base.substring(base.lastIndexOf("/") + 1);
    }

    public StructureDefinition.StructureDefinitionKind convertStructureDefinitionKind(StructureDefinition.StructureDefinitionKind src, String dtName) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case DATATYPE: {
                if (Utilities.existsInList((String)dtName, (String[])new String[]{"boolean", "integer", "decimal", "base64Binary", "instant", "string", "uri", "date", "dateTime", "time", "code", "oid", "uuid", "id", "unsignedInt", "positiveInt", "markdown", "xhtml", "url", "canonical"})) {
                    return StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
                }
                return StructureDefinition.StructureDefinitionKind.COMPLEXTYPE;
            }
            case RESOURCE: {
                return StructureDefinition.StructureDefinitionKind.RESOURCE;
            }
            case LOGICAL: {
                return StructureDefinition.StructureDefinitionKind.LOGICAL;
            }
        }
        return StructureDefinition.StructureDefinitionKind.NULL;
    }

    public StructureDefinition.StructureDefinitionKind convertStructureDefinitionKind(StructureDefinition.StructureDefinitionKind src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case PRIMITIVETYPE: {
                return StructureDefinition.StructureDefinitionKind.DATATYPE;
            }
            case COMPLEXTYPE: {
                return StructureDefinition.StructureDefinitionKind.DATATYPE;
            }
            case RESOURCE: {
                return StructureDefinition.StructureDefinitionKind.RESOURCE;
            }
            case LOGICAL: {
                return StructureDefinition.StructureDefinitionKind.LOGICAL;
            }
        }
        return StructureDefinition.StructureDefinitionKind.NULL;
    }

    private static StructureDefinition.ExtensionContextType convertExtensionContext(StructureDefinition.ExtensionContext src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case RESOURCE: {
                return StructureDefinition.ExtensionContextType.FHIRPATH;
            }
            case DATATYPE: {
                return StructureDefinition.ExtensionContextType.ELEMENT;
            }
            case EXTENSION: {
                return StructureDefinition.ExtensionContextType.EXTENSION;
            }
        }
        return StructureDefinition.ExtensionContextType.NULL;
    }

    private static StructureDefinition.ExtensionContext convertExtensionContext(StructureDefinition.ExtensionContextType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case FHIRPATH: {
                return StructureDefinition.ExtensionContext.RESOURCE;
            }
            case ELEMENT: {
                return StructureDefinition.ExtensionContext.DATATYPE;
            }
            case EXTENSION: {
                return StructureDefinition.ExtensionContext.EXTENSION;
            }
        }
        return StructureDefinition.ExtensionContext.NULL;
    }

    public ContactDetail convertStructureDefinitionContactComponent(StructureDefinition.StructureDefinitionContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public StructureDefinition.StructureDefinitionContactComponent convertStructureDefinitionContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionContactComponent tgt = new StructureDefinition.StructureDefinitionContactComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setIdentity(src.getIdentity());
        tgt.setUri(src.getUri());
        tgt.setName(src.getName());
        tgt.setComment(src.getComments());
        return tgt;
    }

    public StructureDefinition.StructureDefinitionMappingComponent convertStructureDefinitionMappingComponent(StructureDefinition.StructureDefinitionMappingComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionMappingComponent tgt = new StructureDefinition.StructureDefinitionMappingComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setIdentity(src.getIdentity());
        tgt.setUri(src.getUri());
        tgt.setName(src.getName());
        tgt.setComments(src.getComment());
        return tgt;
    }

    public StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        ArrayList<String> slicePaths = new ArrayList<String>();
        for (org.hl7.fhir.instance.model.ElementDefinition t : src.getElement()) {
            if (t.hasSlicing()) {
                slicePaths.add(t.getPath());
            }
            tgt.addElement(this.convertElementDefinition(t, slicePaths, src.getElement(), src.getElement().indexOf(t)));
        }
        return tgt;
    }

    public StructureDefinition.StructureDefinitionSnapshotComponent convertStructureDefinitionSnapshotComponent(StructureDefinition.StructureDefinitionSnapshotComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionSnapshotComponent tgt = new StructureDefinition.StructureDefinitionSnapshotComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(this.convertElementDefinition(t));
        }
        return tgt;
    }

    public StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        ArrayList<String> slicePaths = new ArrayList<String>();
        for (org.hl7.fhir.instance.model.ElementDefinition t : src.getElement()) {
            if (t.hasSlicing()) {
                slicePaths.add(t.getPath());
            }
            tgt.addElement(this.convertElementDefinition(t, slicePaths, src.getElement(), src.getElement().indexOf(t)));
        }
        return tgt;
    }

    public StructureDefinition.StructureDefinitionDifferentialComponent convertStructureDefinitionDifferentialComponent(StructureDefinition.StructureDefinitionDifferentialComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        StructureDefinition.StructureDefinitionDifferentialComponent tgt = new StructureDefinition.StructureDefinitionDifferentialComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (ElementDefinition t : src.getElement()) {
            tgt.addElement(this.convertElementDefinition(t));
        }
        return tgt;
    }

    public Subscription convertSubscription(org.hl7.fhir.instance.model.Subscription src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Subscription tgt = new Subscription();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setCriteria(src.getCriteria());
        for (ContactPoint t : src.getContact()) {
            tgt.addContact(this.convertContactPoint(t));
        }
        tgt.setReason(src.getReason());
        tgt.setStatus(this.convertSubscriptionStatus(src.getStatus()));
        tgt.setError(src.getError());
        tgt.setChannel(this.convertSubscriptionChannelComponent(src.getChannel()));
        tgt.setEnd(src.getEnd());
        return tgt;
    }

    public org.hl7.fhir.instance.model.Subscription convertSubscription(Subscription src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.Subscription tgt = new org.hl7.fhir.instance.model.Subscription();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setCriteria(src.getCriteria());
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getContact()) {
            tgt.addContact(this.convertContactPoint(t));
        }
        tgt.setReason(src.getReason());
        tgt.setStatus(this.convertSubscriptionStatus(src.getStatus()));
        tgt.setError(src.getError());
        tgt.setChannel(this.convertSubscriptionChannelComponent(src.getChannel()));
        tgt.setEnd(src.getEnd());
        return tgt;
    }

    public Subscription.SubscriptionStatus convertSubscriptionStatus(Subscription.SubscriptionStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REQUESTED: {
                return Subscription.SubscriptionStatus.REQUESTED;
            }
            case ACTIVE: {
                return Subscription.SubscriptionStatus.ACTIVE;
            }
            case ERROR: {
                return Subscription.SubscriptionStatus.ERROR;
            }
            case OFF: {
                return Subscription.SubscriptionStatus.OFF;
            }
        }
        return Subscription.SubscriptionStatus.NULL;
    }

    public Subscription.SubscriptionStatus convertSubscriptionStatus(Subscription.SubscriptionStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REQUESTED: {
                return Subscription.SubscriptionStatus.REQUESTED;
            }
            case ACTIVE: {
                return Subscription.SubscriptionStatus.ACTIVE;
            }
            case ERROR: {
                return Subscription.SubscriptionStatus.ERROR;
            }
            case OFF: {
                return Subscription.SubscriptionStatus.OFF;
            }
        }
        return Subscription.SubscriptionStatus.NULL;
    }

    public Subscription.SubscriptionChannelComponent convertSubscriptionChannelComponent(Subscription.SubscriptionChannelComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Subscription.SubscriptionChannelComponent tgt = new Subscription.SubscriptionChannelComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setType(this.convertSubscriptionChannelType(src.getType()));
        tgt.setEndpoint(src.getEndpoint());
        tgt.setPayload(src.getPayload());
        tgt.addHeader(src.getHeader());
        return tgt;
    }

    public Subscription.SubscriptionChannelComponent convertSubscriptionChannelComponent(Subscription.SubscriptionChannelComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Subscription.SubscriptionChannelComponent tgt = new Subscription.SubscriptionChannelComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setType(this.convertSubscriptionChannelType(src.getType()));
        tgt.setEndpoint(src.getEndpoint());
        tgt.setPayload(src.getPayload());
        if (src.hasHeader()) {
            tgt.setHeaderElement(this.convertString((StringType)src.getHeader().get(0)));
        }
        return tgt;
    }

    public Subscription.SubscriptionChannelType convertSubscriptionChannelType(Subscription.SubscriptionChannelType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case RESTHOOK: {
                return Subscription.SubscriptionChannelType.RESTHOOK;
            }
            case WEBSOCKET: {
                return Subscription.SubscriptionChannelType.WEBSOCKET;
            }
            case EMAIL: {
                return Subscription.SubscriptionChannelType.EMAIL;
            }
            case SMS: {
                return Subscription.SubscriptionChannelType.SMS;
            }
            case MESSAGE: {
                return Subscription.SubscriptionChannelType.MESSAGE;
            }
        }
        return Subscription.SubscriptionChannelType.NULL;
    }

    public Subscription.SubscriptionChannelType convertSubscriptionChannelType(Subscription.SubscriptionChannelType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case RESTHOOK: {
                return Subscription.SubscriptionChannelType.RESTHOOK;
            }
            case WEBSOCKET: {
                return Subscription.SubscriptionChannelType.WEBSOCKET;
            }
            case EMAIL: {
                return Subscription.SubscriptionChannelType.EMAIL;
            }
            case SMS: {
                return Subscription.SubscriptionChannelType.SMS;
            }
            case MESSAGE: {
                return Subscription.SubscriptionChannelType.MESSAGE;
            }
        }
        return Subscription.SubscriptionChannelType.NULL;
    }

    public org.hl7.fhir.r4.model.Substance convertSubstance(Substance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.Substance tgt = new org.hl7.fhir.r4.model.Substance();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getCategory()) {
            tgt.addCategory(this.convertCodeableConcept((CodeableConcept)t));
        }
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setDescription(src.getDescription());
        for (org.hl7.fhir.instance.model.Identifier t : src.getInstance()) {
            tgt.addInstance(this.convertSubstanceInstanceComponent((Substance.SubstanceInstanceComponent)t));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getIngredient()) {
            tgt.addIngredient(this.convertSubstanceIngredientComponent((Substance.SubstanceIngredientComponent)t));
        }
        return tgt;
    }

    public Substance convertSubstance(org.hl7.fhir.r4.model.Substance src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Substance tgt = new Substance();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        for (Identifier t : src.getCategory()) {
            tgt.addCategory(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setDescription(src.getDescription());
        for (Identifier t : src.getInstance()) {
            tgt.addInstance(this.convertSubstanceInstanceComponent((Substance.SubstanceInstanceComponent)t));
        }
        for (Identifier t : src.getIngredient()) {
            tgt.addIngredient(this.convertSubstanceIngredientComponent((Substance.SubstanceIngredientComponent)t));
        }
        return tgt;
    }

    public Substance.SubstanceInstanceComponent convertSubstanceInstanceComponent(Substance.SubstanceInstanceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Substance.SubstanceInstanceComponent tgt = new Substance.SubstanceInstanceComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifier()));
        tgt.setExpiry(src.getExpiry());
        tgt.setQuantity(this.convertSimpleQuantity(src.getQuantity()));
        return tgt;
    }

    public Substance.SubstanceInstanceComponent convertSubstanceInstanceComponent(Substance.SubstanceInstanceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Substance.SubstanceInstanceComponent tgt = new Substance.SubstanceInstanceComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifier()));
        tgt.setExpiry(src.getExpiry());
        tgt.setQuantity(this.convertSimpleQuantity(src.getQuantity()));
        return tgt;
    }

    public Substance.SubstanceIngredientComponent convertSubstanceIngredientComponent(Substance.SubstanceIngredientComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Substance.SubstanceIngredientComponent tgt = new Substance.SubstanceIngredientComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setQuantity(this.convertRatio(src.getQuantity()));
        tgt.setSubstance((Type)this.convertReference(src.getSubstance()));
        return tgt;
    }

    public Substance.SubstanceIngredientComponent convertSubstanceIngredientComponent(Substance.SubstanceIngredientComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        Substance.SubstanceIngredientComponent tgt = new Substance.SubstanceIngredientComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setQuantity(this.convertRatio(src.getQuantity()));
        return tgt;
    }

    public SupplyDelivery convertSupplyDelivery(org.hl7.fhir.instance.model.SupplyDelivery src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SupplyDelivery tgt = new SupplyDelivery();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.addIdentifier(this.convertIdentifier(src.getIdentifier()));
        tgt.setStatus(this.convertSupplyDeliveryStatus(src.getStatus()));
        tgt.setPatient(this.convertReference(src.getPatient()));
        tgt.setType(this.convertCodeableConcept(src.getType()));
        tgt.setSupplier(this.convertReference(src.getSupplier()));
        tgt.setDestination(this.convertReference(src.getDestination()));
        for (Reference t : src.getReceiver()) {
            tgt.addReceiver(this.convertReference(t));
        }
        return tgt;
    }

    public org.hl7.fhir.instance.model.SupplyDelivery convertSupplyDelivery(SupplyDelivery src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.instance.model.SupplyDelivery tgt = new org.hl7.fhir.instance.model.SupplyDelivery();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifierFirstRep()));
        tgt.setStatus(this.convertSupplyDeliveryStatus(src.getStatus()));
        tgt.setPatient(this.convertReference(src.getPatient()));
        tgt.setType(this.convertCodeableConcept(src.getType()));
        tgt.setSupplier(this.convertReference(src.getSupplier()));
        tgt.setDestination(this.convertReference(src.getDestination()));
        for (org.hl7.fhir.r4.model.Reference t : src.getReceiver()) {
            tgt.addReceiver(this.convertReference(t));
        }
        return tgt;
    }

    public SupplyDelivery.SupplyDeliveryStatus convertSupplyDeliveryStatus(SupplyDelivery.SupplyDeliveryStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INPROGRESS: {
                return SupplyDelivery.SupplyDeliveryStatus.INPROGRESS;
            }
            case COMPLETED: {
                return SupplyDelivery.SupplyDeliveryStatus.COMPLETED;
            }
            case ABANDONED: {
                return SupplyDelivery.SupplyDeliveryStatus.ABANDONED;
            }
        }
        return SupplyDelivery.SupplyDeliveryStatus.NULL;
    }

    public SupplyDelivery.SupplyDeliveryStatus convertSupplyDeliveryStatus(SupplyDelivery.SupplyDeliveryStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case INPROGRESS: {
                return SupplyDelivery.SupplyDeliveryStatus.INPROGRESS;
            }
            case COMPLETED: {
                return SupplyDelivery.SupplyDeliveryStatus.COMPLETED;
            }
            case ABANDONED: {
                return SupplyDelivery.SupplyDeliveryStatus.ABANDONED;
            }
        }
        return SupplyDelivery.SupplyDeliveryStatus.NULL;
    }

    public org.hl7.fhir.r4.model.SupplyRequest convertSupplyRequest(SupplyRequest src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.SupplyRequest tgt = new org.hl7.fhir.r4.model.SupplyRequest();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        return tgt;
    }

    public SupplyRequest convertSupplyRequest(org.hl7.fhir.r4.model.SupplyRequest src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        SupplyRequest tgt = new SupplyRequest();
        return tgt;
    }

    public SupplyRequest.SupplyRequestStatus convertSupplyRequestStatus(SupplyRequest.SupplyRequestStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case REQUESTED: {
                return SupplyRequest.SupplyRequestStatus.ACTIVE;
            }
            case COMPLETED: {
                return SupplyRequest.SupplyRequestStatus.COMPLETED;
            }
            case FAILED: {
                return SupplyRequest.SupplyRequestStatus.CANCELLED;
            }
            case CANCELLED: {
                return SupplyRequest.SupplyRequestStatus.CANCELLED;
            }
        }
        return SupplyRequest.SupplyRequestStatus.NULL;
    }

    public SupplyRequest.SupplyRequestStatus convertSupplyRequestStatus(SupplyRequest.SupplyRequestStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case ACTIVE: {
                return SupplyRequest.SupplyRequestStatus.REQUESTED;
            }
            case COMPLETED: {
                return SupplyRequest.SupplyRequestStatus.COMPLETED;
            }
            case CANCELLED: {
                return SupplyRequest.SupplyRequestStatus.CANCELLED;
            }
        }
        return SupplyRequest.SupplyRequestStatus.NULL;
    }

    public org.hl7.fhir.r4.model.TestScript convertTestScript(TestScript src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.TestScript tgt = new org.hl7.fhir.r4.model.TestScript();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setVersion(src.getVersion());
        tgt.setName(src.getName());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifier()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        tgt.setPublisher(src.getPublisher());
        for (TestScript.TestScriptContactComponent t : src.getContact()) {
            tgt.addContact(this.convertTestScriptContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setDescription(src.getDescription());
        for (TestScript.TestScriptContactComponent t : src.getUseContext()) {
            if (VersionConvertor_10_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(this.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(this.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        tgt.setPurpose(src.getRequirements());
        tgt.setCopyright(src.getCopyright());
        tgt.setMetadata(this.convertTestScriptMetadataComponent(src.getMetadata()));
        for (TestScript.TestScriptContactComponent t : src.getFixture()) {
            tgt.addFixture(this.convertTestScriptFixtureComponent((TestScript.TestScriptFixtureComponent)t));
        }
        for (TestScript.TestScriptContactComponent t : src.getProfile()) {
            tgt.addProfile(this.convertReference((Reference)t));
        }
        for (TestScript.TestScriptContactComponent t : src.getVariable()) {
            tgt.addVariable(this.convertTestScriptVariableComponent((TestScript.TestScriptVariableComponent)t));
        }
        tgt.setSetup(this.convertTestScriptSetupComponent(src.getSetup()));
        for (TestScript.TestScriptContactComponent t : src.getTest()) {
            tgt.addTest(this.convertTestScriptTestComponent((TestScript.TestScriptTestComponent)t));
        }
        tgt.setTeardown(this.convertTestScriptTeardownComponent(src.getTeardown()));
        return tgt;
    }

    public TestScript convertTestScript(org.hl7.fhir.r4.model.TestScript src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript tgt = new TestScript();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setVersion(src.getVersion());
        tgt.setName(src.getName());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        tgt.setIdentifier(this.convertIdentifier(src.getIdentifier()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        tgt.setPublisher(src.getPublisher());
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(this.convertTestScriptContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setDescription(src.getDescription());
        for (ContactDetail t : src.getUseContext()) {
            if (!t.hasValueCodeableConcept()) continue;
            tgt.addUseContext(this.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addUseContext(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setRequirements(src.getPurpose());
        tgt.setCopyright(src.getCopyright());
        tgt.setMetadata(this.convertTestScriptMetadataComponent(src.getMetadata()));
        for (ContactDetail t : src.getFixture()) {
            tgt.addFixture(this.convertTestScriptFixtureComponent((TestScript.TestScriptFixtureComponent)t));
        }
        for (ContactDetail t : src.getProfile()) {
            tgt.addProfile(this.convertReference((org.hl7.fhir.r4.model.Reference)t));
        }
        for (ContactDetail t : src.getVariable()) {
            tgt.addVariable(this.convertTestScriptVariableComponent((TestScript.TestScriptVariableComponent)t));
        }
        tgt.setSetup(this.convertTestScriptSetupComponent(src.getSetup()));
        for (ContactDetail t : src.getTest()) {
            tgt.addTest(this.convertTestScriptTestComponent((TestScript.TestScriptTestComponent)t));
        }
        tgt.setTeardown(this.convertTestScriptTeardownComponent(src.getTeardown()));
        return tgt;
    }

    public ContactDetail convertTestScriptContactComponent(TestScript.TestScriptContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public TestScript.TestScriptContactComponent convertTestScriptContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptContactComponent tgt = new TestScript.TestScriptContactComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public TestScript.TestScriptMetadataComponent convertTestScriptMetadataComponent(TestScript.TestScriptMetadataComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataComponent tgt = new TestScript.TestScriptMetadataComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (TestScript.TestScriptMetadataLinkComponent t : src.getLink()) {
            tgt.addLink(this.convertTestScriptMetadataLinkComponent(t));
        }
        for (TestScript.TestScriptMetadataLinkComponent t : src.getCapability()) {
            tgt.addCapability(this.convertTestScriptMetadataCapabilityComponent((TestScript.TestScriptMetadataCapabilityComponent)t));
        }
        return tgt;
    }

    public TestScript.TestScriptMetadataComponent convertTestScriptMetadataComponent(TestScript.TestScriptMetadataComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataComponent tgt = new TestScript.TestScriptMetadataComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (TestScript.TestScriptMetadataLinkComponent t : src.getLink()) {
            tgt.addLink(this.convertTestScriptMetadataLinkComponent(t));
        }
        for (TestScript.TestScriptMetadataLinkComponent t : src.getCapability()) {
            tgt.addCapability(this.convertTestScriptMetadataCapabilityComponent((TestScript.TestScriptMetadataCapabilityComponent)t));
        }
        return tgt;
    }

    public TestScript.TestScriptMetadataLinkComponent convertTestScriptMetadataLinkComponent(TestScript.TestScriptMetadataLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataLinkComponent tgt = new TestScript.TestScriptMetadataLinkComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setDescription(src.getDescription());
        return tgt;
    }

    public TestScript.TestScriptMetadataLinkComponent convertTestScriptMetadataLinkComponent(TestScript.TestScriptMetadataLinkComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataLinkComponent tgt = new TestScript.TestScriptMetadataLinkComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setUrl(src.getUrl());
        tgt.setDescription(src.getDescription());
        return tgt;
    }

    public TestScript.TestScriptMetadataCapabilityComponent convertTestScriptMetadataCapabilityComponent(TestScript.TestScriptMetadataCapabilityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataCapabilityComponent tgt = new TestScript.TestScriptMetadataCapabilityComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setRequired(src.getRequired());
        tgt.setValidated(src.getValidated());
        tgt.setDescription(src.getDescription());
        tgt.setDestination(src.getDestination());
        for (UriType t : src.getLink()) {
            tgt.addLink((String)t.getValue());
        }
        tgt.setCapabilitiesElement(this.convertReferenceToCanonical(src.getConformance()));
        return tgt;
    }

    public TestScript.TestScriptMetadataCapabilityComponent convertTestScriptMetadataCapabilityComponent(TestScript.TestScriptMetadataCapabilityComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptMetadataCapabilityComponent tgt = new TestScript.TestScriptMetadataCapabilityComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setRequired(src.getRequired());
        tgt.setValidated(src.getValidated());
        tgt.setDescription(src.getDescription());
        tgt.setDestination(src.getDestination());
        for (org.hl7.fhir.r4.model.UriType t : src.getLink()) {
            tgt.addLink((String)t.getValue());
        }
        tgt.setConformance(this.convertCanonicalToReference(src.getCapabilitiesElement()));
        return tgt;
    }

    public TestScript.TestScriptFixtureComponent convertTestScriptFixtureComponent(TestScript.TestScriptFixtureComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptFixtureComponent tgt = new TestScript.TestScriptFixtureComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setAutocreate(src.getAutocreate());
        tgt.setAutodelete(src.getAutodelete());
        tgt.setResource(this.convertReference(src.getResource()));
        return tgt;
    }

    public TestScript.TestScriptFixtureComponent convertTestScriptFixtureComponent(TestScript.TestScriptFixtureComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptFixtureComponent tgt = new TestScript.TestScriptFixtureComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setAutocreate(src.getAutocreate());
        tgt.setAutodelete(src.getAutodelete());
        tgt.setResource(this.convertReference(src.getResource()));
        return tgt;
    }

    public TestScript.TestScriptVariableComponent convertTestScriptVariableComponent(TestScript.TestScriptVariableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptVariableComponent tgt = new TestScript.TestScriptVariableComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        tgt.setHeaderField(src.getHeaderField());
        tgt.setPath(src.getPath());
        tgt.setSourceId(src.getSourceId());
        return tgt;
    }

    public TestScript.TestScriptVariableComponent convertTestScriptVariableComponent(TestScript.TestScriptVariableComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptVariableComponent tgt = new TestScript.TestScriptVariableComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        tgt.setHeaderField(src.getHeaderField());
        tgt.setPath(src.getPath());
        tgt.setSourceId(src.getSourceId());
        return tgt;
    }

    public TestScript.TestScriptSetupComponent convertTestScriptSetupComponent(TestScript.TestScriptSetupComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupComponent tgt = new TestScript.TestScriptSetupComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (TestScript.TestScriptSetupActionComponent t : src.getAction()) {
            tgt.addAction(this.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public TestScript.TestScriptSetupComponent convertTestScriptSetupComponent(TestScript.TestScriptSetupComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupComponent tgt = new TestScript.TestScriptSetupComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (TestScript.SetupActionComponent t : src.getAction()) {
            tgt.addAction(this.convertSetupActionComponent(t));
        }
        return tgt;
    }

    public TestScript.SetupActionComponent convertSetupActionComponent(TestScript.TestScriptSetupActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionComponent tgt = new TestScript.SetupActionComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setOperation(this.convertSetupActionOperationComponent(src.getOperation()));
        tgt.setAssert(this.convertSetupActionAssertComponent(src.getAssert()));
        return tgt;
    }

    public TestScript.TestScriptSetupActionComponent convertSetupActionComponent(TestScript.SetupActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupActionComponent tgt = new TestScript.TestScriptSetupActionComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setOperation(this.convertSetupActionOperationComponent(src.getOperation()));
        tgt.setAssert(this.convertSetupActionAssertComponent(src.getAssert()));
        return tgt;
    }

    public TestScript.SetupActionOperationComponent convertSetupActionOperationComponent(TestScript.TestScriptSetupActionOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionOperationComponent tgt = new TestScript.SetupActionOperationComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setType(this.convertCoding(src.getType()));
        tgt.setResource(src.getResource());
        tgt.setLabel(src.getLabel());
        tgt.setDescription(src.getDescription());
        tgt.setAccept(VersionConvertor_10_40.convertContentType(src.getAccept()));
        tgt.setContentType(VersionConvertor_10_40.convertContentType(src.getContentType()));
        tgt.setDestination(src.getDestination());
        tgt.setEncodeRequestUrl(src.getEncodeRequestUrl());
        tgt.setParams(src.getParams());
        for (TestScript.TestScriptSetupActionOperationRequestHeaderComponent t : src.getRequestHeader()) {
            tgt.addRequestHeader(this.convertSetupActionOperationRequestHeaderComponent(t));
        }
        tgt.setResponseId(src.getResponseId());
        tgt.setSourceId(src.getSourceId());
        tgt.setTargetId(src.getTargetId());
        tgt.setUrl(src.getUrl());
        return tgt;
    }

    public TestScript.TestScriptSetupActionOperationComponent convertSetupActionOperationComponent(TestScript.SetupActionOperationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupActionOperationComponent tgt = new TestScript.TestScriptSetupActionOperationComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setType(this.convertCoding(src.getType()));
        tgt.setResource(src.getResource());
        tgt.setLabel(src.getLabel());
        tgt.setDescription(src.getDescription());
        tgt.setAccept(VersionConvertor_10_40.convertContentType(src.getAccept()));
        tgt.setContentType(VersionConvertor_10_40.convertContentType(src.getContentType()));
        tgt.setDestination(src.getDestination());
        tgt.setEncodeRequestUrl(src.getEncodeRequestUrl());
        tgt.setParams(src.getParams());
        for (TestScript.SetupActionOperationRequestHeaderComponent t : src.getRequestHeader()) {
            tgt.addRequestHeader(this.convertSetupActionOperationRequestHeaderComponent(t));
        }
        tgt.setResponseId(src.getResponseId());
        tgt.setSourceId(src.getSourceId());
        tgt.setTargetId(src.getTargetId());
        tgt.setUrl(src.getUrl());
        return tgt;
    }

    private static String convertContentType(TestScript.ContentType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case XML: {
                return "application/fhir+xml";
            }
            case JSON: {
                return "application/fhir+json";
            }
        }
        return null;
    }

    private static TestScript.ContentType convertContentType(String src) throws FHIRException {
        if (src == null) {
            return null;
        }
        if (src.contains("xml")) {
            return TestScript.ContentType.XML;
        }
        if (src.contains("json")) {
            return TestScript.ContentType.JSON;
        }
        return TestScript.ContentType.NULL;
    }

    public TestScript.SetupActionOperationRequestHeaderComponent convertSetupActionOperationRequestHeaderComponent(TestScript.TestScriptSetupActionOperationRequestHeaderComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionOperationRequestHeaderComponent tgt = new TestScript.SetupActionOperationRequestHeaderComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setField(src.getField());
        tgt.setValue(src.getValue());
        return tgt;
    }

    public TestScript.TestScriptSetupActionOperationRequestHeaderComponent convertSetupActionOperationRequestHeaderComponent(TestScript.SetupActionOperationRequestHeaderComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupActionOperationRequestHeaderComponent tgt = new TestScript.TestScriptSetupActionOperationRequestHeaderComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setField(src.getField());
        tgt.setValue(src.getValue());
        return tgt;
    }

    public TestScript.SetupActionAssertComponent convertSetupActionAssertComponent(TestScript.TestScriptSetupActionAssertComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.SetupActionAssertComponent tgt = new TestScript.SetupActionAssertComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setLabel(src.getLabel());
        tgt.setDescription(src.getDescription());
        tgt.setDirection(this.convertAssertionDirectionType(src.getDirection()));
        tgt.setCompareToSourceId(src.getCompareToSourceId());
        tgt.setCompareToSourcePath(src.getCompareToSourcePath());
        tgt.setContentType(VersionConvertor_10_40.convertContentType(src.getContentType()));
        tgt.setHeaderField(src.getHeaderField());
        tgt.setMinimumId(src.getMinimumId());
        tgt.setNavigationLinks(src.getNavigationLinks());
        tgt.setOperator(this.convertAssertionOperatorType(src.getOperator()));
        tgt.setPath(src.getPath());
        tgt.setResource(src.getResource());
        tgt.setResponse(this.convertAssertionResponseTypes(src.getResponse()));
        tgt.setResponseCode(src.getResponseCode());
        tgt.setSourceId(src.getSourceId());
        tgt.setValidateProfileId(src.getValidateProfileId());
        tgt.setValue(src.getValue());
        tgt.setWarningOnly(src.getWarningOnly());
        return tgt;
    }

    public TestScript.TestScriptSetupActionAssertComponent convertSetupActionAssertComponent(TestScript.SetupActionAssertComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptSetupActionAssertComponent tgt = new TestScript.TestScriptSetupActionAssertComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setLabel(src.getLabel());
        tgt.setDescription(src.getDescription());
        tgt.setDirection(this.convertAssertionDirectionType(src.getDirection()));
        tgt.setCompareToSourceId(src.getCompareToSourceId());
        tgt.setCompareToSourcePath(src.getCompareToSourcePath());
        tgt.setContentType(VersionConvertor_10_40.convertContentType(src.getContentType()));
        tgt.setHeaderField(src.getHeaderField());
        tgt.setMinimumId(src.getMinimumId());
        tgt.setNavigationLinks(src.getNavigationLinks());
        tgt.setOperator(this.convertAssertionOperatorType(src.getOperator()));
        tgt.setPath(src.getPath());
        tgt.setResource(src.getResource());
        tgt.setResponse(this.convertAssertionResponseTypes(src.getResponse()));
        tgt.setResponseCode(src.getResponseCode());
        tgt.setSourceId(src.getSourceId());
        tgt.setValidateProfileId(src.getValidateProfileId());
        tgt.setValue(src.getValue());
        tgt.setWarningOnly(src.getWarningOnly());
        return tgt;
    }

    public TestScript.AssertionDirectionType convertAssertionDirectionType(TestScript.AssertionDirectionType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case RESPONSE: {
                return TestScript.AssertionDirectionType.RESPONSE;
            }
            case REQUEST: {
                return TestScript.AssertionDirectionType.REQUEST;
            }
        }
        return TestScript.AssertionDirectionType.NULL;
    }

    public TestScript.AssertionDirectionType convertAssertionDirectionType(TestScript.AssertionDirectionType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case RESPONSE: {
                return TestScript.AssertionDirectionType.RESPONSE;
            }
            case REQUEST: {
                return TestScript.AssertionDirectionType.REQUEST;
            }
        }
        return TestScript.AssertionDirectionType.NULL;
    }

    public TestScript.AssertionOperatorType convertAssertionOperatorType(TestScript.AssertionOperatorType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EQUALS: {
                return TestScript.AssertionOperatorType.EQUALS;
            }
            case NOTEQUALS: {
                return TestScript.AssertionOperatorType.NOTEQUALS;
            }
            case IN: {
                return TestScript.AssertionOperatorType.IN;
            }
            case NOTIN: {
                return TestScript.AssertionOperatorType.NOTIN;
            }
            case GREATERTHAN: {
                return TestScript.AssertionOperatorType.GREATERTHAN;
            }
            case LESSTHAN: {
                return TestScript.AssertionOperatorType.LESSTHAN;
            }
            case EMPTY: {
                return TestScript.AssertionOperatorType.EMPTY;
            }
            case NOTEMPTY: {
                return TestScript.AssertionOperatorType.NOTEMPTY;
            }
            case CONTAINS: {
                return TestScript.AssertionOperatorType.CONTAINS;
            }
            case NOTCONTAINS: {
                return TestScript.AssertionOperatorType.NOTCONTAINS;
            }
        }
        return TestScript.AssertionOperatorType.NULL;
    }

    public TestScript.AssertionOperatorType convertAssertionOperatorType(TestScript.AssertionOperatorType src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EQUALS: {
                return TestScript.AssertionOperatorType.EQUALS;
            }
            case NOTEQUALS: {
                return TestScript.AssertionOperatorType.NOTEQUALS;
            }
            case IN: {
                return TestScript.AssertionOperatorType.IN;
            }
            case NOTIN: {
                return TestScript.AssertionOperatorType.NOTIN;
            }
            case GREATERTHAN: {
                return TestScript.AssertionOperatorType.GREATERTHAN;
            }
            case LESSTHAN: {
                return TestScript.AssertionOperatorType.LESSTHAN;
            }
            case EMPTY: {
                return TestScript.AssertionOperatorType.EMPTY;
            }
            case NOTEMPTY: {
                return TestScript.AssertionOperatorType.NOTEMPTY;
            }
            case CONTAINS: {
                return TestScript.AssertionOperatorType.CONTAINS;
            }
            case NOTCONTAINS: {
                return TestScript.AssertionOperatorType.NOTCONTAINS;
            }
        }
        return TestScript.AssertionOperatorType.NULL;
    }

    public TestScript.AssertionResponseTypes convertAssertionResponseTypes(TestScript.AssertionResponseTypes src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OKAY: {
                return TestScript.AssertionResponseTypes.OKAY;
            }
            case CREATED: {
                return TestScript.AssertionResponseTypes.CREATED;
            }
            case NOCONTENT: {
                return TestScript.AssertionResponseTypes.NOCONTENT;
            }
            case NOTMODIFIED: {
                return TestScript.AssertionResponseTypes.NOTMODIFIED;
            }
            case BAD: {
                return TestScript.AssertionResponseTypes.BAD;
            }
            case FORBIDDEN: {
                return TestScript.AssertionResponseTypes.FORBIDDEN;
            }
            case NOTFOUND: {
                return TestScript.AssertionResponseTypes.NOTFOUND;
            }
            case METHODNOTALLOWED: {
                return TestScript.AssertionResponseTypes.METHODNOTALLOWED;
            }
            case CONFLICT: {
                return TestScript.AssertionResponseTypes.CONFLICT;
            }
            case GONE: {
                return TestScript.AssertionResponseTypes.GONE;
            }
            case PRECONDITIONFAILED: {
                return TestScript.AssertionResponseTypes.PRECONDITIONFAILED;
            }
            case UNPROCESSABLE: {
                return TestScript.AssertionResponseTypes.UNPROCESSABLE;
            }
        }
        return TestScript.AssertionResponseTypes.NULL;
    }

    public TestScript.AssertionResponseTypes convertAssertionResponseTypes(TestScript.AssertionResponseTypes src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case OKAY: {
                return TestScript.AssertionResponseTypes.OKAY;
            }
            case CREATED: {
                return TestScript.AssertionResponseTypes.CREATED;
            }
            case NOCONTENT: {
                return TestScript.AssertionResponseTypes.NOCONTENT;
            }
            case NOTMODIFIED: {
                return TestScript.AssertionResponseTypes.NOTMODIFIED;
            }
            case BAD: {
                return TestScript.AssertionResponseTypes.BAD;
            }
            case FORBIDDEN: {
                return TestScript.AssertionResponseTypes.FORBIDDEN;
            }
            case NOTFOUND: {
                return TestScript.AssertionResponseTypes.NOTFOUND;
            }
            case METHODNOTALLOWED: {
                return TestScript.AssertionResponseTypes.METHODNOTALLOWED;
            }
            case CONFLICT: {
                return TestScript.AssertionResponseTypes.CONFLICT;
            }
            case GONE: {
                return TestScript.AssertionResponseTypes.GONE;
            }
            case PRECONDITIONFAILED: {
                return TestScript.AssertionResponseTypes.PRECONDITIONFAILED;
            }
            case UNPROCESSABLE: {
                return TestScript.AssertionResponseTypes.UNPROCESSABLE;
            }
        }
        return TestScript.AssertionResponseTypes.NULL;
    }

    public TestScript.TestScriptTestComponent convertTestScriptTestComponent(TestScript.TestScriptTestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTestComponent tgt = new TestScript.TestScriptTestComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        tgt.setDescription(src.getDescription());
        for (TestScript.TestScriptTestActionComponent t : src.getAction()) {
            tgt.addAction(this.convertTestActionComponent(t));
        }
        return tgt;
    }

    public TestScript.TestScriptTestComponent convertTestScriptTestComponent(TestScript.TestScriptTestComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTestComponent tgt = new TestScript.TestScriptTestComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        tgt.setDescription(src.getDescription());
        for (TestScript.TestActionComponent t : src.getAction()) {
            tgt.addAction(this.convertTestActionComponent(t));
        }
        return tgt;
    }

    public TestScript.TestActionComponent convertTestActionComponent(TestScript.TestScriptTestActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestActionComponent tgt = new TestScript.TestActionComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setOperation(this.convertSetupActionOperationComponent(src.getOperation()));
        tgt.setAssert(this.convertSetupActionAssertComponent(src.getAssert()));
        return tgt;
    }

    public TestScript.TestScriptTestActionComponent convertTestActionComponent(TestScript.TestActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTestActionComponent tgt = new TestScript.TestScriptTestActionComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setOperation(this.convertSetupActionOperationComponent(src.getOperation()));
        tgt.setAssert(this.convertSetupActionAssertComponent(src.getAssert()));
        return tgt;
    }

    public TestScript.TestScriptTeardownComponent convertTestScriptTeardownComponent(TestScript.TestScriptTeardownComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTeardownComponent tgt = new TestScript.TestScriptTeardownComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (TestScript.TestScriptTeardownActionComponent t : src.getAction()) {
            tgt.addAction(this.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public TestScript.TestScriptTeardownComponent convertTestScriptTeardownComponent(TestScript.TestScriptTeardownComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTeardownComponent tgt = new TestScript.TestScriptTeardownComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (TestScript.TeardownActionComponent t : src.getAction()) {
            tgt.addAction(this.convertTeardownActionComponent(t));
        }
        return tgt;
    }

    public TestScript.TeardownActionComponent convertTeardownActionComponent(TestScript.TestScriptTeardownActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TeardownActionComponent tgt = new TestScript.TeardownActionComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setOperation(this.convertSetupActionOperationComponent(src.getOperation()));
        return tgt;
    }

    public TestScript.TestScriptTeardownActionComponent convertTeardownActionComponent(TestScript.TeardownActionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        TestScript.TestScriptTeardownActionComponent tgt = new TestScript.TestScriptTeardownActionComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setOperation(this.convertSetupActionOperationComponent(src.getOperation()));
        return tgt;
    }

    public ValueSet.ValueSetCodeSystemComponent convertCodeSystem(CodeSystem src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetCodeSystemComponent tgt = new ValueSet.ValueSetCodeSystemComponent();
        this.copyElement((org.hl7.fhir.r4.model.DomainResource)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setSystem(src.getUrl());
        tgt.setVersion(src.getVersion());
        tgt.setCaseSensitive(src.getCaseSensitive());
        for (CodeSystem.ConceptDefinitionComponent cc : src.getConcept()) {
            tgt.addConcept(this.convertCodeSystemConcept(src, cc));
        }
        return tgt;
    }

    public ValueSet.ConceptDefinitionComponent convertCodeSystemConcept(CodeSystem cs, CodeSystem.ConceptDefinitionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptDefinitionComponent tgt = new ValueSet.ConceptDefinitionComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setAbstract(CodeSystemUtilities.isNotSelectable((CodeSystem)cs, (CodeSystem.ConceptDefinitionComponent)src));
        tgt.setCode(src.getCode());
        tgt.setDefinition(src.getDefinition());
        tgt.setDisplay(src.getDisplay());
        for (CodeSystem.ConceptDefinitionComponent cc : src.getConcept()) {
            tgt.addConcept(this.convertCodeSystemConcept(cs, cc));
        }
        for (CodeSystem.ConceptDefinitionComponent cc : src.getDesignation()) {
            tgt.addDesignation(this.convertCodeSystemDesignation((CodeSystem.ConceptDefinitionDesignationComponent)cc));
        }
        return tgt;
    }

    public ValueSet.ConceptDefinitionDesignationComponent convertCodeSystemDesignation(CodeSystem.ConceptDefinitionDesignationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptDefinitionDesignationComponent tgt = new ValueSet.ConceptDefinitionDesignationComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setUse(this.convertCoding(src.getUse()));
        tgt.setLanguage(src.getLanguage());
        tgt.setValue(src.getValue());
        return tgt;
    }

    public org.hl7.fhir.r4.model.ValueSet convertValueSet(ValueSet src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        org.hl7.fhir.r4.model.ValueSet tgt = new org.hl7.fhir.r4.model.ValueSet();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        tgt.addIdentifier(this.convertIdentifier(src.getIdentifier()));
        tgt.setVersion(src.getVersion());
        tgt.setName(src.getName());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        tgt.setPublisher(src.getPublisher());
        for (ValueSet.ValueSetContactComponent t : src.getContact()) {
            tgt.addContact(this.convertValueSetContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setDescription(src.getDescription());
        for (ValueSet.ValueSetContactComponent t : src.getUseContext()) {
            if (VersionConvertor_10_40.isJurisdiction((CodeableConcept)t)) {
                tgt.addJurisdiction(this.convertCodeableConcept((CodeableConcept)t));
                continue;
            }
            tgt.addUseContext(this.convertCodeableConceptToUsageContext((CodeableConcept)t));
        }
        tgt.setImmutable(src.getImmutable());
        tgt.setPurpose(src.getRequirements());
        tgt.setCopyright(src.getCopyright());
        if (src.hasExtensible()) {
            tgt.addExtension("http://hl7.org/fhir/StructureDefinition/valueset-extensible", (Type)new BooleanType(src.getExtensible()));
        }
        if (src.hasCompose()) {
            tgt.setCompose(this.convertValueSetComposeComponent(src.getCompose()));
            tgt.getCompose().setLockedDate(src.getLockedDate());
        }
        if (src.hasCodeSystem() && this.advisor != null) {
            CodeSystem tgtcs = new CodeSystem();
            this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgtcs);
            tgtcs.setUrl(src.getCodeSystem().getSystem());
            tgtcs.addIdentifier(this.convertIdentifier(src.getIdentifier()));
            tgtcs.setVersion(src.getCodeSystem().getVersion());
            tgtcs.setName(src.getName() + " Code System");
            tgtcs.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
            if (src.hasExperimental()) {
                tgtcs.setExperimental(src.getExperimental());
            }
            tgtcs.setPublisher(src.getPublisher());
            for (ValueSet.ValueSetContactComponent t : src.getContact()) {
                tgtcs.addContact(this.convertValueSetContactComponent(t));
            }
            if (src.hasDate()) {
                tgtcs.setDate(src.getDate());
            }
            tgtcs.setDescription(src.getDescription());
            for (ValueSet.ValueSetContactComponent t : src.getUseContext()) {
                if (VersionConvertor_10_40.isJurisdiction((CodeableConcept)t)) {
                    tgtcs.addJurisdiction(this.convertCodeableConcept((CodeableConcept)t));
                    continue;
                }
                tgtcs.addUseContext(this.convertCodeableConceptToUsageContext((CodeableConcept)t));
            }
            tgtcs.setPurpose(src.getRequirements());
            tgtcs.setCopyright(src.getCopyright());
            tgtcs.setContent(CodeSystem.CodeSystemContentMode.COMPLETE);
            tgtcs.setCaseSensitive(src.getCodeSystem().getCaseSensitive());
            for (ValueSet.ConceptDefinitionComponent cs : src.getCodeSystem().getConcept()) {
                this.processConcept(tgtcs.getConcept(), cs, tgtcs);
            }
            this.advisor.handleCodeSystem(tgtcs, tgt);
            tgt.setUserData("r2-cs", (Object)tgtcs);
            tgt.getCompose().addInclude().setSystem(tgtcs.getUrl());
        }
        tgt.setExpansion(this.convertValueSetExpansionComponent(src.getExpansion()));
        return tgt;
    }

    private void processConcept(List<CodeSystem.ConceptDefinitionComponent> concepts, ValueSet.ConceptDefinitionComponent cs, CodeSystem tgtcs) throws FHIRException {
        CodeSystem.ConceptDefinitionComponent ct = new CodeSystem.ConceptDefinitionComponent();
        concepts.add(ct);
        ct.setCode(cs.getCode());
        ct.setDisplay(cs.getDisplay());
        ct.setDefinition(cs.getDefinition());
        if (cs.getAbstract()) {
            CodeSystemUtilities.setNotSelectable((CodeSystem)tgtcs, (CodeSystem.ConceptDefinitionComponent)ct);
        }
        for (ValueSet.ConceptDefinitionDesignationComponent csd : cs.getDesignation()) {
            CodeSystem.ConceptDefinitionDesignationComponent cst = new CodeSystem.ConceptDefinitionDesignationComponent();
            cst.setLanguage(csd.getLanguage());
            cst.setUse(this.convertCoding(csd.getUse()));
            cst.setValue(csd.getValue());
        }
        for (ValueSet.ConceptDefinitionComponent csc : cs.getConcept()) {
            this.processConcept(ct.getConcept(), csc, tgtcs);
        }
    }

    private void processConcept(List<ValueSet.ConceptDefinitionComponent> concepts, CodeSystem.ConceptDefinitionComponent cs, CodeSystem srcCS) throws FHIRException {
        ValueSet.ConceptDefinitionComponent ct = new ValueSet.ConceptDefinitionComponent();
        concepts.add(ct);
        ct.setCode(cs.getCode());
        ct.setDisplay(cs.getDisplay());
        ct.setDefinition(cs.getDefinition());
        if (CodeSystemUtilities.isNotSelectable((CodeSystem)srcCS, (CodeSystem.ConceptDefinitionComponent)cs)) {
            ct.setAbstract(true);
        }
        for (CodeSystem.ConceptDefinitionDesignationComponent csd : cs.getDesignation()) {
            ValueSet.ConceptDefinitionDesignationComponent cst = new ValueSet.ConceptDefinitionDesignationComponent();
            cst.setLanguage(csd.getLanguage());
            cst.setUse(this.convertCoding(csd.getUse()));
            cst.setValue(csd.getValue());
        }
        for (CodeSystem.ConceptDefinitionComponent csc : cs.getConcept()) {
            this.processConcept(ct.getConcept(), csc, srcCS);
        }
    }

    public ValueSet convertValueSet(org.hl7.fhir.r4.model.ValueSet src) throws FHIRException {
        CodeSystem srcCS;
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet tgt = new ValueSet();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        tgt.setUrl(src.getUrl());
        for (Identifier i : src.getIdentifier()) {
            tgt.setIdentifier(this.convertIdentifier(i));
        }
        tgt.setVersion(src.getVersion());
        tgt.setName(src.getName());
        tgt.setStatus(this.convertConformanceResourceStatus(src.getStatus()));
        if (src.hasExperimental()) {
            tgt.setExperimental(src.getExperimental());
        }
        tgt.setPublisher(src.getPublisher());
        for (ContactDetail t : src.getContact()) {
            tgt.addContact(this.convertValueSetContactComponent(t));
        }
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setLockedDate(src.getCompose().getLockedDate());
        tgt.setDescription(src.getDescription());
        for (ContactDetail t : src.getUseContext()) {
            if (!t.hasValueCodeableConcept()) continue;
            tgt.addUseContext(this.convertCodeableConcept(t.getValueCodeableConcept()));
        }
        for (ContactDetail t : src.getJurisdiction()) {
            tgt.addUseContext(this.convertCodeableConcept((org.hl7.fhir.r4.model.CodeableConcept)t));
        }
        tgt.setImmutable(src.getImmutable());
        tgt.setRequirements(src.getPurpose());
        tgt.setCopyright(src.getCopyright());
        if (src.hasExtension("http://hl7.org/fhir/StructureDefinition/valueset-extensible")) {
            tgt.setExtensible(((BooleanType)src.getExtensionByUrl("http://hl7.org/fhir/StructureDefinition/valueset-extensible").getValue()).booleanValue());
        }
        if ((srcCS = (CodeSystem)src.getUserData("r2-cs")) == null) {
            srcCS = this.advisor.getCodeSystem(src);
        }
        if (srcCS != null) {
            tgt.getCodeSystem().setSystem(srcCS.getUrl());
            tgt.getCodeSystem().setVersion(srcCS.getVersion());
            tgt.getCodeSystem().setCaseSensitive(srcCS.getCaseSensitive());
            for (CodeSystem.ConceptDefinitionComponent cs : srcCS.getConcept()) {
                this.processConcept(tgt.getCodeSystem().getConcept(), cs, srcCS);
            }
        }
        tgt.setCompose(this.convertValueSetComposeComponent(src.getCompose(), srcCS == null ? null : srcCS.getUrl()));
        tgt.setExpansion(this.convertValueSetExpansionComponent(src.getExpansion()));
        return tgt;
    }

    private static boolean isJurisdiction(CodeableConcept t) {
        return t.hasCoding() && ("http://unstats.un.org/unsd/methods/m49/m49.htm".equals(((Coding)t.getCoding().get(0)).getSystem()) || "urn:iso:std:iso:3166".equals(((Coding)t.getCoding().get(0)).getSystem()) || "https://www.usps.com/".equals(((Coding)t.getCoding().get(0)).getSystem()));
    }

    public ContactDetail convertValueSetContactComponent(ValueSet.ValueSetContactComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ContactDetail tgt = new ContactDetail();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        for (ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public ValueSet.ValueSetContactComponent convertValueSetContactComponent(ContactDetail src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetContactComponent tgt = new ValueSet.ValueSetContactComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        for (org.hl7.fhir.r4.model.ContactPoint t : src.getTelecom()) {
            tgt.addTelecom(this.convertContactPoint(t));
        }
        return tgt;
    }

    public ValueSet.ValueSetComposeComponent convertValueSetComposeComponent(ValueSet.ValueSetComposeComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetComposeComponent tgt = new ValueSet.ValueSetComposeComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        for (UriType t : src.getImport()) {
            tgt.addInclude().addValueSet((String)t.getValue());
        }
        for (UriType t : src.getInclude()) {
            tgt.addInclude(this.convertConceptSetComponent((ValueSet.ConceptSetComponent)t));
        }
        for (UriType t : src.getExclude()) {
            tgt.addExclude(this.convertConceptSetComponent((ValueSet.ConceptSetComponent)t));
        }
        return tgt;
    }

    public ValueSet.ValueSetComposeComponent convertValueSetComposeComponent(ValueSet.ValueSetComposeComponent src, String noSystem) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetComposeComponent tgt = new ValueSet.ValueSetComposeComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        for (ValueSet.ConceptSetComponent t : src.getInclude()) {
            for (org.hl7.fhir.r4.model.UriType ti : t.getValueSet()) {
                tgt.addImport((String)ti.getValue());
            }
            if (noSystem != null && t.getSystem().equals(noSystem)) continue;
            tgt.addInclude(this.convertConceptSetComponent(t));
        }
        for (ValueSet.ConceptSetComponent t : src.getExclude()) {
            tgt.addExclude(this.convertConceptSetComponent(t));
        }
        return tgt;
    }

    public ValueSet.ConceptSetComponent convertConceptSetComponent(ValueSet.ConceptSetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptSetComponent tgt = new ValueSet.ConceptSetComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setSystem(src.getSystem());
        tgt.setVersion(src.getVersion());
        for (ValueSet.ConceptReferenceComponent t : src.getConcept()) {
            tgt.addConcept(this.convertConceptReferenceComponent(t));
        }
        for (ValueSet.ConceptReferenceComponent t : src.getFilter()) {
            tgt.addFilter(this.convertConceptSetFilterComponent((ValueSet.ConceptSetFilterComponent)t));
        }
        return tgt;
    }

    public ValueSet.ConceptSetComponent convertConceptSetComponent(ValueSet.ConceptSetComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptSetComponent tgt = new ValueSet.ConceptSetComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setSystem(src.getSystem());
        tgt.setVersion(src.getVersion());
        for (ValueSet.ConceptReferenceComponent t : src.getConcept()) {
            tgt.addConcept(this.convertConceptReferenceComponent(t));
        }
        for (ValueSet.ConceptReferenceComponent t : src.getFilter()) {
            tgt.addFilter(this.convertConceptSetFilterComponent((ValueSet.ConceptSetFilterComponent)t));
        }
        return tgt;
    }

    public ValueSet.ConceptReferenceComponent convertConceptReferenceComponent(ValueSet.ConceptReferenceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptReferenceComponent tgt = new ValueSet.ConceptReferenceComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setCode(src.getCode());
        tgt.setDisplay(src.getDisplay());
        for (ValueSet.ConceptDefinitionDesignationComponent t : src.getDesignation()) {
            tgt.addDesignation(this.convertConceptReferenceDesignationComponent(t));
        }
        return tgt;
    }

    public ValueSet.ConceptReferenceComponent convertConceptReferenceComponent(ValueSet.ConceptReferenceComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptReferenceComponent tgt = new ValueSet.ConceptReferenceComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setCode(src.getCode());
        tgt.setDisplay(src.getDisplay());
        for (ValueSet.ConceptReferenceDesignationComponent t : src.getDesignation()) {
            tgt.addDesignation(this.convertConceptReferenceDesignationComponent(t));
        }
        return tgt;
    }

    public ValueSet.ConceptReferenceDesignationComponent convertConceptReferenceDesignationComponent(ValueSet.ConceptDefinitionDesignationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptReferenceDesignationComponent tgt = new ValueSet.ConceptReferenceDesignationComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setLanguage(src.getLanguage());
        tgt.setUse(this.convertCoding(src.getUse()));
        tgt.setValue(src.getValue());
        return tgt;
    }

    public ValueSet.ConceptDefinitionDesignationComponent convertConceptReferenceDesignationComponent(ValueSet.ConceptReferenceDesignationComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptDefinitionDesignationComponent tgt = new ValueSet.ConceptDefinitionDesignationComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setLanguage(src.getLanguage());
        tgt.setUse(this.convertCoding(src.getUse()));
        tgt.setValue(src.getValue());
        return tgt;
    }

    public ValueSet.ConceptSetFilterComponent convertConceptSetFilterComponent(ValueSet.ConceptSetFilterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptSetFilterComponent tgt = new ValueSet.ConceptSetFilterComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setProperty(src.getProperty());
        tgt.setOp(this.convertFilterOperator(src.getOp()));
        tgt.setValue(src.getValue());
        return tgt;
    }

    public ValueSet.ConceptSetFilterComponent convertConceptSetFilterComponent(ValueSet.ConceptSetFilterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ConceptSetFilterComponent tgt = new ValueSet.ConceptSetFilterComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setProperty(src.getProperty());
        tgt.setOp(this.convertFilterOperator(src.getOp()));
        tgt.setValue(src.getValue());
        return tgt;
    }

    public ValueSet.FilterOperator convertFilterOperator(ValueSet.FilterOperator src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EQUAL: {
                return ValueSet.FilterOperator.EQUAL;
            }
            case ISA: {
                return ValueSet.FilterOperator.ISA;
            }
            case ISNOTA: {
                return ValueSet.FilterOperator.ISNOTA;
            }
            case REGEX: {
                return ValueSet.FilterOperator.REGEX;
            }
            case IN: {
                return ValueSet.FilterOperator.IN;
            }
            case NOTIN: {
                return ValueSet.FilterOperator.NOTIN;
            }
        }
        return ValueSet.FilterOperator.NULL;
    }

    public ValueSet.FilterOperator convertFilterOperator(ValueSet.FilterOperator src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case EQUAL: {
                return ValueSet.FilterOperator.EQUAL;
            }
            case ISA: {
                return ValueSet.FilterOperator.ISA;
            }
            case ISNOTA: {
                return ValueSet.FilterOperator.ISNOTA;
            }
            case REGEX: {
                return ValueSet.FilterOperator.REGEX;
            }
            case IN: {
                return ValueSet.FilterOperator.IN;
            }
            case NOTIN: {
                return ValueSet.FilterOperator.NOTIN;
            }
        }
        return ValueSet.FilterOperator.NULL;
    }

    public ValueSet.ValueSetExpansionComponent convertValueSetExpansionComponent(ValueSet.ValueSetExpansionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionComponent tgt = new ValueSet.ValueSetExpansionComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setIdentifier(src.getIdentifier());
        tgt.setTimestamp(src.getTimestamp());
        tgt.setTotal(src.getTotal());
        tgt.setOffset(src.getOffset());
        for (ValueSet.ValueSetExpansionParameterComponent t : src.getParameter()) {
            tgt.addParameter(this.convertValueSetExpansionParameterComponent(t));
        }
        for (ValueSet.ValueSetExpansionParameterComponent t : src.getContains()) {
            tgt.addContains(this.convertValueSetExpansionContainsComponent((ValueSet.ValueSetExpansionContainsComponent)t));
        }
        return tgt;
    }

    public ValueSet.ValueSetExpansionComponent convertValueSetExpansionComponent(ValueSet.ValueSetExpansionComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionComponent tgt = new ValueSet.ValueSetExpansionComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setIdentifier(src.getIdentifier());
        tgt.setTimestamp(src.getTimestamp());
        tgt.setTotal(src.getTotal());
        tgt.setOffset(src.getOffset());
        for (ValueSet.ValueSetExpansionParameterComponent t : src.getParameter()) {
            tgt.addParameter(this.convertValueSetExpansionParameterComponent(t));
        }
        for (ValueSet.ValueSetExpansionParameterComponent t : src.getContains()) {
            tgt.addContains(this.convertValueSetExpansionContainsComponent((ValueSet.ValueSetExpansionContainsComponent)t));
        }
        return tgt;
    }

    public ValueSet.ValueSetExpansionParameterComponent convertValueSetExpansionParameterComponent(ValueSet.ValueSetExpansionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionParameterComponent tgt = new ValueSet.ValueSetExpansionParameterComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setName(src.getName());
        tgt.setValue(this.convertType(src.getValue()));
        return tgt;
    }

    public ValueSet.ValueSetExpansionParameterComponent convertValueSetExpansionParameterComponent(ValueSet.ValueSetExpansionParameterComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionParameterComponent tgt = new ValueSet.ValueSetExpansionParameterComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setName(src.getName());
        tgt.setValue(this.convertType(src.getValue()));
        return tgt;
    }

    public ValueSet.ValueSetExpansionContainsComponent convertValueSetExpansionContainsComponent(ValueSet.ValueSetExpansionContainsComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent tgt = new ValueSet.ValueSetExpansionContainsComponent();
        this.copyElement((org.hl7.fhir.instance.model.Element)src, (Element)tgt);
        tgt.setSystem(src.getSystem());
        tgt.setAbstract(src.getAbstract());
        tgt.setVersion(src.getVersion());
        tgt.setCode(src.getCode());
        tgt.setDisplay(src.getDisplay());
        for (ValueSet.ValueSetExpansionContainsComponent t : src.getContains()) {
            tgt.addContains(this.convertValueSetExpansionContainsComponent(t));
        }
        return tgt;
    }

    public ValueSet.ValueSetExpansionContainsComponent convertValueSetExpansionContainsComponent(ValueSet.ValueSetExpansionContainsComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ValueSet.ValueSetExpansionContainsComponent tgt = new ValueSet.ValueSetExpansionContainsComponent();
        this.copyElement((Element)src, (org.hl7.fhir.instance.model.Element)tgt);
        tgt.setSystem(src.getSystem());
        tgt.setAbstract(src.getAbstract());
        tgt.setVersion(src.getVersion());
        tgt.setCode(src.getCode());
        tgt.setDisplay(src.getDisplay());
        for (ValueSet.ValueSetExpansionContainsComponent t : src.getContains()) {
            tgt.addContains(this.convertValueSetExpansionContainsComponent(t));
        }
        return tgt;
    }

    public ListResource convertList(List_ src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ListResource tgt = new ListResource();
        this.copyDomainResource((DomainResource)src, (org.hl7.fhir.r4.model.DomainResource)tgt);
        for (org.hl7.fhir.instance.model.Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setTitle(src.getTitle());
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setSource(this.convertReference(src.getSource()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        tgt.setStatus(this.convertListStatus(src.getStatus()));
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setOrderedBy(this.convertCodeableConcept(src.getOrderedBy()));
        tgt.setMode(this.convertListMode(src.getMode()));
        if (src.hasNote()) {
            tgt.addNote(new org.hl7.fhir.r4.model.Annotation().setText(src.getNote()));
        }
        for (org.hl7.fhir.instance.model.Identifier t : src.getEntry()) {
            tgt.addEntry(this.convertListEntry((List_.ListEntryComponent)t));
        }
        return tgt;
    }

    public ListResource.ListStatus convertListStatus(List_.ListStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CURRENT: {
                return ListResource.ListStatus.CURRENT;
            }
            case RETIRED: {
                return ListResource.ListStatus.RETIRED;
            }
            case ENTEREDINERROR: {
                return ListResource.ListStatus.ENTEREDINERROR;
            }
        }
        return ListResource.ListStatus.NULL;
    }

    public ListResource.ListMode convertListMode(List_.ListMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case WORKING: {
                return ListResource.ListMode.WORKING;
            }
            case SNAPSHOT: {
                return ListResource.ListMode.SNAPSHOT;
            }
            case CHANGES: {
                return ListResource.ListMode.CHANGES;
            }
        }
        return ListResource.ListMode.NULL;
    }

    public ListResource.ListEntryComponent convertListEntry(List_.ListEntryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        ListResource.ListEntryComponent tgt = new ListResource.ListEntryComponent();
        this.copyBackboneElement((BackboneElement)src, (org.hl7.fhir.r4.model.BackboneElement)tgt);
        tgt.setFlag(this.convertCodeableConcept(src.getFlag()));
        tgt.setDeleted(src.getDeleted());
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setItem(this.convertReference(src.getItem()));
        return tgt;
    }

    public List_ convertList(ListResource src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        List_ tgt = new List_();
        this.copyDomainResource((org.hl7.fhir.r4.model.DomainResource)src, (DomainResource)tgt);
        for (Identifier t : src.getIdentifier()) {
            tgt.addIdentifier(this.convertIdentifier(t));
        }
        tgt.setTitle(src.getTitle());
        tgt.setCode(this.convertCodeableConcept(src.getCode()));
        tgt.setSubject(this.convertReference(src.getSubject()));
        tgt.setSource(this.convertReference(src.getSource()));
        tgt.setEncounter(this.convertReference(src.getEncounter()));
        tgt.setStatus(this.convertListStatus(src.getStatus()));
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setOrderedBy(this.convertCodeableConcept(src.getOrderedBy()));
        tgt.setMode(this.convertListMode(src.getMode()));
        for (Identifier t : src.getNote()) {
            tgt.setNote(t.getText());
        }
        for (Identifier t : src.getEntry()) {
            tgt.addEntry(this.convertListEntry((ListResource.ListEntryComponent)t));
        }
        return tgt;
    }

    public List_.ListStatus convertListStatus(ListResource.ListStatus src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case CURRENT: {
                return List_.ListStatus.CURRENT;
            }
            case RETIRED: {
                return List_.ListStatus.RETIRED;
            }
            case ENTEREDINERROR: {
                return List_.ListStatus.ENTEREDINERROR;
            }
        }
        return List_.ListStatus.NULL;
    }

    public List_.ListMode convertListMode(ListResource.ListMode src) throws FHIRException {
        if (src == null) {
            return null;
        }
        switch (src) {
            case WORKING: {
                return List_.ListMode.WORKING;
            }
            case SNAPSHOT: {
                return List_.ListMode.SNAPSHOT;
            }
            case CHANGES: {
                return List_.ListMode.CHANGES;
            }
        }
        return List_.ListMode.NULL;
    }

    public List_.ListEntryComponent convertListEntry(ListResource.ListEntryComponent src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        List_.ListEntryComponent tgt = new List_.ListEntryComponent();
        this.copyBackboneElement((org.hl7.fhir.r4.model.BackboneElement)src, (BackboneElement)tgt);
        tgt.setFlag(this.convertCodeableConcept(src.getFlag()));
        tgt.setDeleted(src.getDeleted());
        if (src.hasDate()) {
            tgt.setDate(src.getDate());
        }
        tgt.setItem(this.convertReference(src.getItem()));
        return tgt;
    }

    public Resource convertResource(org.hl7.fhir.instance.model.Resource src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof Parameters) {
            return this.convertParameters((Parameters)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Appointment) {
            return this.convertAppointment((org.hl7.fhir.instance.model.Appointment)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.AppointmentResponse) {
            return this.convertAppointmentResponse((org.hl7.fhir.instance.model.AppointmentResponse)src);
        }
        if (src instanceof AuditEvent) {
            return this.convertAuditEvent((AuditEvent)src);
        }
        if (src instanceof Basic) {
            return this.convertBasic((Basic)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Binary) {
            return this.convertBinary((org.hl7.fhir.instance.model.Binary)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Bundle) {
            return this.convertBundle((org.hl7.fhir.instance.model.Bundle)src);
        }
        if (src instanceof CarePlan) {
            return this.convertCarePlan((CarePlan)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Communication) {
            return this.convertCommunication((org.hl7.fhir.instance.model.Communication)src);
        }
        if (src instanceof CommunicationRequest) {
            return this.convertCommunicationRequest((CommunicationRequest)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Composition) {
            return this.convertComposition((org.hl7.fhir.instance.model.Composition)src);
        }
        if (src instanceof ConceptMap) {
            return this.convertConceptMap((ConceptMap)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Condition) {
            return this.convertCondition((org.hl7.fhir.instance.model.Condition)src);
        }
        if (src instanceof Conformance) {
            return this.convertConformance((Conformance)src);
        }
        if (src instanceof DataElement) {
            return this.convertDataElement((DataElement)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.DetectedIssue) {
            return this.convertDetectedIssue((org.hl7.fhir.instance.model.DetectedIssue)src);
        }
        if (src instanceof DeviceMetric) {
            return this.convertDeviceMetric((DeviceMetric)src);
        }
        if (src instanceof DeviceUseStatement) {
            return this.convertDeviceUseStatement((DeviceUseStatement)src);
        }
        if (src instanceof DiagnosticReport) {
            return this.convertDiagnosticReport((DiagnosticReport)src);
        }
        if (src instanceof DocumentReference) {
            return this.convertDocumentReference((DocumentReference)src);
        }
        if (src instanceof Encounter) {
            return this.convertEncounter((Encounter)src);
        }
        if (src instanceof EnrollmentRequest) {
            return this.convertEnrollmentRequest((EnrollmentRequest)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.EnrollmentResponse) {
            return this.convertEnrollmentResponse((org.hl7.fhir.instance.model.EnrollmentResponse)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.EpisodeOfCare) {
            return this.convertEpisodeOfCare((org.hl7.fhir.instance.model.EpisodeOfCare)src);
        }
        if (src instanceof FamilyMemberHistory) {
            return this.convertFamilyMemberHistory((FamilyMemberHistory)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Flag) {
            return this.convertFlag((org.hl7.fhir.instance.model.Flag)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Group) {
            return this.convertGroup((org.hl7.fhir.instance.model.Group)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.HealthcareService) {
            return this.convertHealthcareService((org.hl7.fhir.instance.model.HealthcareService)src);
        }
        if (src instanceof ImplementationGuide) {
            return this.convertImplementationGuide((ImplementationGuide)src);
        }
        if (src instanceof List_) {
            return this.convertList((List_)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Location) {
            return this.convertLocation((org.hl7.fhir.instance.model.Location)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.MedicationDispense) {
            return this.convertMedicationDispense((org.hl7.fhir.instance.model.MedicationDispense)src);
        }
        if (src instanceof MedicationStatement) {
            return this.convertMedicationStatement((MedicationStatement)src);
        }
        if (src instanceof MessageHeader) {
            return this.convertMessageHeader((MessageHeader)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.NamingSystem) {
            return this.convertNamingSystem((org.hl7.fhir.instance.model.NamingSystem)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Observation) {
            return this.convertObservation((org.hl7.fhir.instance.model.Observation)src);
        }
        if (src instanceof OperationDefinition) {
            return this.convertOperationDefinition((OperationDefinition)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.OperationOutcome) {
            return this.convertOperationOutcome((org.hl7.fhir.instance.model.OperationOutcome)src);
        }
        if (src instanceof Organization) {
            return this.convertOrganization((Organization)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Patient) {
            return this.convertPatient((org.hl7.fhir.instance.model.Patient)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Person) {
            return this.convertPerson((org.hl7.fhir.instance.model.Person)src);
        }
        if (src instanceof Practitioner) {
            return this.convertPractitioner((Practitioner)src);
        }
        if (src instanceof Questionnaire) {
            return this.convertQuestionnaire((Questionnaire)src);
        }
        if (src instanceof QuestionnaireResponse) {
            return this.convertQuestionnaireResponse((QuestionnaireResponse)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.RiskAssessment) {
            return this.convertRiskAssessment((org.hl7.fhir.instance.model.RiskAssessment)src);
        }
        if (src instanceof Schedule) {
            return this.convertSchedule((Schedule)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.SearchParameter) {
            return this.convertSearchParameter((org.hl7.fhir.instance.model.SearchParameter)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Slot) {
            return this.convertSlot((org.hl7.fhir.instance.model.Slot)src);
        }
        if (src instanceof StructureDefinition) {
            return this.convertStructureDefinition((StructureDefinition)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.Subscription) {
            return this.convertSubscription((org.hl7.fhir.instance.model.Subscription)src);
        }
        if (src instanceof Substance) {
            return this.convertSubstance((Substance)src);
        }
        if (src instanceof org.hl7.fhir.instance.model.SupplyDelivery) {
            return this.convertSupplyDelivery((org.hl7.fhir.instance.model.SupplyDelivery)src);
        }
        if (src instanceof SupplyRequest) {
            return this.convertSupplyRequest((SupplyRequest)src);
        }
        if (src instanceof TestScript) {
            return this.convertTestScript((TestScript)src);
        }
        if (src instanceof ValueSet) {
            return this.convertValueSet((ValueSet)src);
        }
        throw new FHIRException("Unknown resource " + src.fhirType());
    }

    public org.hl7.fhir.instance.model.Resource convertResource(Resource src) throws FHIRException {
        if (src == null || src.isEmpty()) {
            return null;
        }
        if (src instanceof org.hl7.fhir.r4.model.Parameters) {
            return this.convertParameters((org.hl7.fhir.r4.model.Parameters)src);
        }
        if (src instanceof Appointment) {
            return this.convertAppointment((Appointment)src);
        }
        if (src instanceof AppointmentResponse) {
            return this.convertAppointmentResponse((AppointmentResponse)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.AuditEvent) {
            return this.convertAuditEvent((org.hl7.fhir.r4.model.AuditEvent)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Basic) {
            return this.convertBasic((org.hl7.fhir.r4.model.Basic)src);
        }
        if (src instanceof Binary) {
            return this.convertBinary((Binary)src);
        }
        if (src instanceof Bundle) {
            return this.convertBundle((Bundle)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CarePlan) {
            return this.convertCarePlan((org.hl7.fhir.r4.model.CarePlan)src);
        }
        if (src instanceof Communication) {
            return this.convertCommunication((Communication)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.CommunicationRequest) {
            return this.convertCommunicationRequest((org.hl7.fhir.r4.model.CommunicationRequest)src);
        }
        if (src instanceof Composition) {
            return this.convertComposition((Composition)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ConceptMap) {
            return this.convertConceptMap((org.hl7.fhir.r4.model.ConceptMap)src);
        }
        if (src instanceof Condition) {
            return this.convertCondition((Condition)src);
        }
        if (src instanceof CapabilityStatement) {
            return this.convertConformance((CapabilityStatement)src);
        }
        if (src instanceof DetectedIssue) {
            return this.convertDetectedIssue((DetectedIssue)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.DeviceMetric) {
            return this.convertDeviceMetric((org.hl7.fhir.r4.model.DeviceMetric)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.DeviceUseStatement) {
            return this.convertDeviceUseStatement((org.hl7.fhir.r4.model.DeviceUseStatement)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.DiagnosticReport) {
            return this.convertDiagnosticReport((org.hl7.fhir.r4.model.DiagnosticReport)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.DocumentReference) {
            return this.convertDocumentReference((org.hl7.fhir.r4.model.DocumentReference)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Encounter) {
            return this.convertEncounter((org.hl7.fhir.r4.model.Encounter)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.EnrollmentRequest) {
            return this.convertEnrollmentRequest((org.hl7.fhir.r4.model.EnrollmentRequest)src);
        }
        if (src instanceof EnrollmentResponse) {
            return this.convertEnrollmentResponse((EnrollmentResponse)src);
        }
        if (src instanceof EpisodeOfCare) {
            return this.convertEpisodeOfCare((EpisodeOfCare)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.FamilyMemberHistory) {
            return this.convertFamilyMemberHistory((org.hl7.fhir.r4.model.FamilyMemberHistory)src);
        }
        if (src instanceof Flag) {
            return this.convertFlag((Flag)src);
        }
        if (src instanceof Group) {
            return this.convertGroup((Group)src);
        }
        if (src instanceof HealthcareService) {
            return this.convertHealthcareService((HealthcareService)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ImplementationGuide) {
            return this.convertImplementationGuide((org.hl7.fhir.r4.model.ImplementationGuide)src);
        }
        if (src instanceof ListResource) {
            return this.convertList((ListResource)src);
        }
        if (src instanceof Location) {
            return this.convertLocation((Location)src);
        }
        if (src instanceof MedicationDispense) {
            return this.convertMedicationDispense((MedicationDispense)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.MedicationStatement) {
            return this.convertMedicationStatement((org.hl7.fhir.r4.model.MedicationStatement)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.MessageHeader) {
            return this.convertMessageHeader((org.hl7.fhir.r4.model.MessageHeader)src);
        }
        if (src instanceof NamingSystem) {
            return this.convertNamingSystem((NamingSystem)src);
        }
        if (src instanceof Observation) {
            return this.convertObservation((Observation)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.OperationDefinition) {
            return this.convertOperationDefinition((org.hl7.fhir.r4.model.OperationDefinition)src);
        }
        if (src instanceof OperationOutcome) {
            return this.convertOperationOutcome((OperationOutcome)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Organization) {
            return this.convertOrganization((org.hl7.fhir.r4.model.Organization)src);
        }
        if (src instanceof Patient) {
            return this.convertPatient((Patient)src);
        }
        if (src instanceof Person) {
            return this.convertPerson((Person)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Practitioner) {
            return this.convertPractitioner((org.hl7.fhir.r4.model.Practitioner)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Questionnaire) {
            return this.convertQuestionnaire((org.hl7.fhir.r4.model.Questionnaire)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.QuestionnaireResponse) {
            return this.convertQuestionnaireResponse((org.hl7.fhir.r4.model.QuestionnaireResponse)src);
        }
        if (src instanceof RiskAssessment) {
            return this.convertRiskAssessment((RiskAssessment)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Schedule) {
            return this.convertSchedule((org.hl7.fhir.r4.model.Schedule)src);
        }
        if (src instanceof SearchParameter) {
            return this.convertSearchParameter((SearchParameter)src);
        }
        if (src instanceof Slot) {
            return this.convertSlot((Slot)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.StructureDefinition) {
            return this.convertStructureDefinition((org.hl7.fhir.r4.model.StructureDefinition)src);
        }
        if (src instanceof Subscription) {
            return this.convertSubscription((Subscription)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.Substance) {
            return this.convertSubstance((org.hl7.fhir.r4.model.Substance)src);
        }
        if (src instanceof SupplyDelivery) {
            return this.convertSupplyDelivery((SupplyDelivery)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.SupplyRequest) {
            return this.convertSupplyRequest((org.hl7.fhir.r4.model.SupplyRequest)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.TestScript) {
            return this.convertTestScript((org.hl7.fhir.r4.model.TestScript)src);
        }
        if (src instanceof org.hl7.fhir.r4.model.ValueSet) {
            return this.convertValueSet((org.hl7.fhir.r4.model.ValueSet)src);
        }
        throw new FHIRException("Unknown resource " + src.fhirType());
    }

    public TerminologyCapabilities convertTerminologyCapabilities(Parameters src) {
        TerminologyCapabilities res = new TerminologyCapabilities();
        for (Parameters.ParametersParameterComponent p : src.getParameter()) {
            if (!p.getName().equals("system")) continue;
            res.addCodeSystem().setUri(p.getValue().primitiveValue());
        }
        return res;
    }

    public static boolean convertsResource(String rt) {
        return Utilities.existsInList((String)rt, (String[])new String[]{"Parameters", "Appointment", "AppointmentResponse", "AuditEvent", "Basic", "Binary", "Bundle", "CarePlan", "Communication", "CommunicationRequest", "Composition", "ConceptMap", "Condition", "CapabilityStatement", "DetectedIssue", "DeviceMetric", "DeviceUseStatement", "DiagnosticReport", "DocumentReference", "Encounter", "EnrollmentRequest", "EnrollmentResponse", "EpisodeOfCare", "FamilyMemberHistory", "Flag", "Group", "HealthcareService", "ImplementationGuide", "ListResource", "Location", "MedicationDispense", "MedicationStatement", "MessageHeader", "NamingSystem", "Observation", "OperationDefinition", "OperationOutcome", "Organization", "Patient", "Person", "Practitioner", "Questionnaire", "QuestionnaireResponse", "RiskAssessment", "Schedule", "SearchParameter", "Slot", "StructureDefinition", "Subscription", "Substance", "SupplyDelivery", "SupplyRequest", "TestScript", "ValueSet"});
    }

    static {
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/11179-permitted-value-conceptmap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/11179-permitted-value-valueset");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/codesystem-map");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/cqif-library");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-allowedUnits");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-inheritedExtensibleValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-maxValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/elementdefinition-minValueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/event-instantiatesCanonical");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-allowedProfile");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-deMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-sourceStructureMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-targetStructureMap");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/questionnaire-unit-valueSet");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-map");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-supplement");
        CANONICAL_URLS.add("http://hl7.org/fhir/StructureDefinition/valueset-system");
    }

    private class SourceElementComponentWrapper {
        private String source;
        private String target;
        private ConceptMap.SourceElementComponent comp;

        public SourceElementComponentWrapper(ConceptMap.SourceElementComponent comp, String source, String target) {
            this.source = source;
            this.target = target;
            this.comp = comp;
        }
    }
}

