/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jaxrs.client;

import ca.uhn.fhir.jaxrs.client.JaxRsHttpResponse;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.client.api.BaseHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpRequest;
import ca.uhn.fhir.rest.client.api.IHttpResponse;
import ca.uhn.fhir.util.StopWatch;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;

public class JaxRsHttpRequest
extends BaseHttpRequest
implements IHttpRequest {
    private final Map<String, List<String>> myHeaders = new HashMap<String, List<String>>();
    private Invocation.Builder myRequest;
    private RequestTypeEnum myRequestType;
    private Entity<?> myEntity;

    public JaxRsHttpRequest(Invocation.Builder theRequest, RequestTypeEnum theRequestType, Entity<?> theEntity) {
        this.myRequest = theRequest;
        this.myRequestType = theRequestType;
        this.myEntity = theEntity;
    }

    public void addHeader(String theName, String theValue) {
        if (!this.myHeaders.containsKey(theName)) {
            this.myHeaders.put(theName, new LinkedList());
        }
        this.myHeaders.get(theName).add(theValue);
        this.getRequest().header(theName, (Object)theValue);
    }

    public IHttpResponse execute() {
        StopWatch responseStopWatch = new StopWatch();
        Invocation invocation = this.getRequest().build(this.getRequestType().name(), this.getEntity());
        Response response = invocation.invoke();
        return new JaxRsHttpResponse(response, responseStopWatch);
    }

    public Map<String, List<String>> getAllHeaders() {
        return Collections.unmodifiableMap(this.myHeaders);
    }

    public Entity<?> getEntity() {
        return this.myEntity;
    }

    public String getHttpVerbName() {
        return this.myRequestType.name();
    }

    public void removeHeaders(String theHeaderName) {
        this.myHeaders.remove(theHeaderName);
    }

    public Invocation.Builder getRequest() {
        return this.myRequest;
    }

    public String getRequestBodyFromStream() {
        return null;
    }

    public RequestTypeEnum getRequestType() {
        return this.myRequestType == null ? RequestTypeEnum.GET : this.myRequestType;
    }

    public String getUri() {
        return "";
    }

    public void setUri(String theUrl) {
        throw new UnsupportedOperationException();
    }
}

