/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jaxrs.server;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.api.BundleInclusionRule;
import ca.uhn.fhir.jaxrs.server.AbstractJaxRsProvider;
import ca.uhn.fhir.jaxrs.server.interceptor.JaxRsExceptionInterceptor;
import ca.uhn.fhir.jaxrs.server.util.JaxRsMethodBindings;
import ca.uhn.fhir.jaxrs.server.util.JaxRsRequest;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IBundleProvider;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.interceptor.IServerInterceptor;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.interceptor.Interceptors;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Produces(value={"application/json", "application/xml", "text/plain"})
@Consumes(value={"application/x-www-form-urlencoded", "application/json", "application/json+fhir", "application/xml+fhir"})
@Interceptors(value={JaxRsExceptionInterceptor.class})
public abstract class AbstractJaxRsBundleProvider
extends AbstractJaxRsProvider
implements IRestfulServer<JaxRsRequest>,
IBundleProvider {
    private final JaxRsMethodBindings theBindings;

    protected AbstractJaxRsBundleProvider() {
        this.theBindings = JaxRsMethodBindings.getMethodBindings(this, this.getClass());
    }

    protected AbstractJaxRsBundleProvider(FhirContext ctx) {
        super(ctx);
        this.theBindings = JaxRsMethodBindings.getMethodBindings(this, this.getClass());
    }

    protected AbstractJaxRsBundleProvider(Class<? extends AbstractJaxRsProvider> theProviderClass) {
        this.theBindings = JaxRsMethodBindings.getMethodBindings(this, theProviderClass);
    }

    @POST
    public Response create(String resource) throws IOException {
        return this.execute(this.getRequest(RequestTypeEnum.POST, RestOperationTypeEnum.TRANSACTION).resource(resource));
    }

    @GET
    public Response search() throws IOException {
        return this.execute(this.getRequest(RequestTypeEnum.GET, RestOperationTypeEnum.SEARCH_TYPE));
    }

    private Response execute(JaxRsRequest.Builder theRequestBuilder, String methodKey) throws IOException {
        JaxRsRequest theRequest = theRequestBuilder.build();
        BaseMethodBinding<?> method = this.getBinding(theRequest.getRestOperationType(), methodKey);
        try {
            return (Response)method.invokeServer((IRestfulServer)this, (RequestDetails)theRequest);
        }
        catch (Throwable theException) {
            return this.handleException(theRequest, theException);
        }
    }

    private Response execute(JaxRsRequest.Builder theRequestBuilder) throws IOException {
        return this.execute(theRequestBuilder, "");
    }

    protected BaseMethodBinding<?> getBinding(RestOperationTypeEnum restOperation, String theBindingKey) {
        return this.getBindings().getBinding(restOperation, theBindingKey);
    }

    @Override
    public List<IServerInterceptor> getInterceptors_() {
        return Collections.emptyList();
    }

    @Override
    public IPagingProvider getPagingProvider() {
        return null;
    }

    public BundleInclusionRule getBundleInclusionRule() {
        return BundleInclusionRule.BASED_ON_INCLUDES;
    }

    public JaxRsMethodBindings getBindings() {
        return this.theBindings;
    }
}

