/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jaxrs.server;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.api.BundleInclusionRule;
import ca.uhn.fhir.jaxrs.server.AbstractJaxRsProvider;
import ca.uhn.fhir.jaxrs.server.interceptor.JaxRsExceptionInterceptor;
import ca.uhn.fhir.jaxrs.server.interceptor.JaxRsResponseException;
import ca.uhn.fhir.jaxrs.server.util.JaxRsRequest;
import ca.uhn.fhir.rest.api.PreferReturnEnum;
import ca.uhn.fhir.rest.api.RequestTypeEnum;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.api.server.IRestfulServer;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.IPagingProvider;
import ca.uhn.fhir.rest.server.PageProvider;
import ca.uhn.fhir.rest.server.method.PageMethodBinding;
import java.io.IOException;
import javax.interceptor.Interceptors;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;

@Produces(value={"application/json", "application/xml", "text/plain"})
@Interceptors(value={JaxRsExceptionInterceptor.class})
public abstract class AbstractJaxRsPageProvider
extends AbstractJaxRsProvider
implements IRestfulServer<JaxRsRequest> {
    private PageMethodBinding myBinding;

    protected AbstractJaxRsPageProvider() {
        try {
            this.myBinding = new PageMethodBinding(this.getFhirContext(), PageProvider.class.getMethod("getPage", new Class[0]));
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    protected AbstractJaxRsPageProvider(FhirContext ctx) {
        super(ctx);
        try {
            this.myBinding = new PageMethodBinding(this.getFhirContext(), PageProvider.class.getMethod("getPage", new Class[0]));
        }
        catch (Exception e) {
            throw new ConfigurationException((Throwable)e);
        }
    }

    @Override
    public String getBaseForRequest() {
        try {
            return this.getUriInfo().getBaseUri().toURL().toExternalForm();
        }
        catch (Exception e) {
            return null;
        }
    }

    @GET
    public Response getPages(@QueryParam(value="_getpages") String thePageId) throws IOException {
        JaxRsRequest theRequest = this.getRequest(RequestTypeEnum.GET, RestOperationTypeEnum.GET_PAGE).build();
        try {
            return (Response)this.myBinding.invokeServer((IRestfulServer)this, (RequestDetails)theRequest);
        }
        catch (JaxRsResponseException theException) {
            return new JaxRsExceptionInterceptor().convertExceptionIntoResponse(theRequest, theException);
        }
    }

    @Override
    public IPagingProvider getPagingProvider() {
        return null;
    }

    public BundleInclusionRule getBundleInclusionRule() {
        return BundleInclusionRule.BASED_ON_INCLUDES;
    }

    public PreferReturnEnum getDefaultPreferReturn() {
        return PreferReturnEnum.REPRESENTATION;
    }
}

