/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jaxrs.server.interceptor;

import ca.uhn.fhir.jaxrs.server.AbstractJaxRsProvider;
import ca.uhn.fhir.jaxrs.server.interceptor.JaxRsResponseException;
import ca.uhn.fhir.jaxrs.server.util.JaxRsRequest;
import ca.uhn.fhir.rest.api.server.RequestDetails;
import ca.uhn.fhir.rest.server.exceptions.BaseServerResponseException;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.rest.server.interceptor.ExceptionHandlingInterceptor;
import java.io.IOException;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.servlet.ServletException;
import javax.ws.rs.core.Response;

public class JaxRsExceptionInterceptor {
    private final ExceptionHandlingInterceptor exceptionHandler;

    public JaxRsExceptionInterceptor() {
        this.exceptionHandler = new ExceptionHandlingInterceptor();
    }

    JaxRsExceptionInterceptor(ExceptionHandlingInterceptor exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws JaxRsResponseException {
        try {
            return ctx.proceed();
        }
        catch (Exception theException) {
            AbstractJaxRsProvider theServer = (AbstractJaxRsProvider)ctx.getTarget();
            throw this.convertException(theServer, theException);
        }
    }

    public JaxRsResponseException convertException(AbstractJaxRsProvider theServer, Throwable theException) {
        if (theServer.withStackTrace()) {
            this.exceptionHandler.setReturnStackTracesForExceptionTypes(new Class[]{Throwable.class});
        }
        JaxRsRequest requestDetails = theServer.getRequest(null, null).build();
        BaseServerResponseException convertedException = this.preprocessException(theException, requestDetails);
        return new JaxRsResponseException(convertedException);
    }

    public Response convertExceptionIntoResponse(JaxRsRequest theRequest, JaxRsResponseException theException) throws IOException {
        return this.handleExceptionWithoutServletError(theRequest, theException);
    }

    private BaseServerResponseException preprocessException(Throwable theException, JaxRsRequest requestDetails) {
        try {
            Throwable theExceptionToConvert = theException;
            if (!(theException instanceof BaseServerResponseException) && theException.getCause() instanceof BaseServerResponseException) {
                theExceptionToConvert = theException.getCause();
            }
            return this.exceptionHandler.preProcessOutgoingException((RequestDetails)requestDetails, theExceptionToConvert, null);
        }
        catch (ServletException e) {
            return new InternalErrorException((Throwable)e);
        }
    }

    private Response handleExceptionWithoutServletError(JaxRsRequest theRequest, BaseServerResponseException theException) throws IOException {
        try {
            return (Response)this.exceptionHandler.handleException((RequestDetails)theRequest, theException);
        }
        catch (ServletException e) {
            BaseServerResponseException newException = this.preprocessException((Throwable)new InternalErrorException((Throwable)e), theRequest);
            return this.handleExceptionWithoutServletError(theRequest, newException);
        }
    }
}

