/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jaxrs.server.util;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.jaxrs.server.AbstractJaxRsProvider;
import ca.uhn.fhir.rest.annotation.Search;
import ca.uhn.fhir.rest.api.RestOperationTypeEnum;
import ca.uhn.fhir.rest.server.exceptions.NotImplementedOperationException;
import ca.uhn.fhir.rest.server.method.BaseMethodBinding;
import ca.uhn.fhir.rest.server.method.OperationMethodBinding;
import ca.uhn.fhir.rest.server.method.SearchMethodBinding;
import ca.uhn.fhir.util.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;

public class JaxRsMethodBindings {
    public static final String DEFAULT_METHOD_KEY = "";
    private static final ConcurrentHashMap<Class<?>, JaxRsMethodBindings> classBindings = new ConcurrentHashMap();
    private ConcurrentHashMap<RestOperationTypeEnum, ConcurrentHashMap<String, BaseMethodBinding<?>>> operationBindings = new ConcurrentHashMap();

    public JaxRsMethodBindings(AbstractJaxRsProvider theProvider, Class<? extends AbstractJaxRsProvider> theProviderClass) {
        List declaredMethodsForCurrentProvider = ReflectionUtil.getDeclaredMethods(theProviderClass);
        declaredMethodsForCurrentProvider.addAll(ReflectionUtil.getDeclaredMethods(theProviderClass.getSuperclass()));
        for (Method m : declaredMethodsForCurrentProvider) {
            BaseMethodBinding foundMethodBinding = BaseMethodBinding.bindMethod((Method)m, (FhirContext)theProvider.getFhirContext(), (Object)theProvider);
            if (foundMethodBinding == null) continue;
            String bindingKey = this.getBindingKey(foundMethodBinding);
            this.addMethodBinding(bindingKey, foundMethodBinding);
        }
    }

    private String getBindingKey(BaseMethodBinding<?> theBinding) {
        if (theBinding instanceof OperationMethodBinding) {
            return ((OperationMethodBinding)theBinding).getName();
        }
        if (theBinding instanceof SearchMethodBinding) {
            Search search = theBinding.getMethod().getAnnotation(Search.class);
            return search.compartmentName();
        }
        return DEFAULT_METHOD_KEY;
    }

    private void addMethodBinding(String key, BaseMethodBinding<?> binding) {
        ConcurrentHashMap<String, BaseMethodBinding<?>> mapByOperation = this.getMapForOperation(binding.getRestOperationType());
        if (mapByOperation.containsKey(key)) {
            throw new IllegalArgumentException("Multiple Search Method Bindings Found : " + mapByOperation.get(key) + " -- " + binding.getMethod());
        }
        mapByOperation.put(key, binding);
    }

    private ConcurrentHashMap<String, BaseMethodBinding<?>> getMapForOperation(RestOperationTypeEnum operationType) {
        ConcurrentHashMap<String, BaseMethodBinding<?>> result = this.operationBindings.get(operationType);
        if (result == null) {
            this.operationBindings.putIfAbsent(operationType, new ConcurrentHashMap());
            return this.getMapForOperation(operationType);
        }
        return result;
    }

    public BaseMethodBinding<?> getBinding(RestOperationTypeEnum operationType, String theBindingKey) {
        String bindingKey = (String)StringUtils.defaultIfBlank((CharSequence)theBindingKey, (CharSequence)DEFAULT_METHOD_KEY);
        ConcurrentHashMap<String, BaseMethodBinding<?>> map = this.getMapForOperation(operationType);
        if (map == null || !map.containsKey(bindingKey)) {
            throw new NotImplementedOperationException("Operation not implemented");
        }
        return map.get(bindingKey);
    }

    public static JaxRsMethodBindings getMethodBindings(AbstractJaxRsProvider theProvider, Class<? extends AbstractJaxRsProvider> theProviderClass) {
        if (!JaxRsMethodBindings.getClassBindings().containsKey(theProviderClass)) {
            JaxRsMethodBindings foundBindings = new JaxRsMethodBindings(theProvider, theProviderClass);
            JaxRsMethodBindings.getClassBindings().putIfAbsent(theProviderClass, foundBindings);
        }
        return JaxRsMethodBindings.getClassBindings().get(theProviderClass);
    }

    static ConcurrentHashMap<Class<?>, JaxRsMethodBindings> getClassBindings() {
        return classBindings;
    }
}

