/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.jpa.util;

import ca.uhn.fhir.i18n.Msg;
import ca.uhn.fhir.rest.api.Constants;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.reflect.ClassPath;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.ForeignKey;
import javax.persistence.GeneratedValue;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.Size;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hibernate.annotations.Subselect;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.FullTextField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.GenericField;
import org.hibernate.search.mapper.pojo.mapping.definition.annotation.ScaledNumberField;
import org.hibernate.validator.constraints.Length;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.r4.model.InstantType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestUtil {
    public static final int MAX_COL_LENGTH = 4000;
    private static final int MAX_LENGTH = 30;
    private static final Logger ourLog = LoggerFactory.getLogger(TestUtil.class);
    private static Set<String> ourReservedWords;
    private static final Set<String> duplicateNameValidationExceptionList;

    private TestUtil() {
    }

    public static void scanEntities(String packageName) throws IOException, ClassNotFoundException {
        try (InputStream is = TestUtil.class.getResourceAsStream("/mysql-reserved-words.txt");){
            String contents = IOUtils.toString((InputStream)is, (Charset)Constants.CHARSET_UTF8);
            String[] words = contents.split("\\n");
            ourReservedWords = Arrays.stream(words).filter(t -> StringUtils.isNotBlank((CharSequence)t)).map(t -> Ascii.toUpperCase((String)t)).collect(Collectors.toSet());
        }
        ImmutableSet classes = ClassPath.from((ClassLoader)TestUtil.class.getClassLoader()).getTopLevelClassesRecursive(packageName);
        HashSet<String> names = new HashSet<String>();
        if (classes.size() <= 1) {
            throw new InternalErrorException(Msg.code((int)1623) + "Found no classes");
        }
        for (ClassPath.ClassInfo classInfo : classes) {
            Class<?> clazz = Class.forName(classInfo.getName());
            Entity entity = clazz.getAnnotation(Entity.class);
            Embeddable embeddable = clazz.getAnnotation(Embeddable.class);
            if (entity == null && embeddable == null) continue;
            TestUtil.scanClass(names, clazz, false);
        }
    }

    private static void scanClass(Set<String> theNames, Class<?> theClazz, boolean theIsSuperClass) {
        HashMap<String, Integer> columnNameToLength = new HashMap<String, Integer>();
        TestUtil.scanClassOrSuperclass(theNames, theClazz, theIsSuperClass, columnNameToLength);
        Table table = theClazz.getAnnotation(Table.class);
        if (table != null) {
            int maxIndexLength = 3072;
            for (UniqueConstraint nextIndex : table.uniqueConstraints()) {
                int indexLength = TestUtil.calculateIndexLength(nextIndex.columnNames(), columnNameToLength, theClazz, nextIndex.name());
                if (indexLength <= maxIndexLength) continue;
                throw new IllegalStateException(Msg.code((int)1624) + "Index '" + nextIndex.name() + "' is too long. Length is " + indexLength + " and must not exceed " + maxIndexLength + " which is the maximum MySQL length");
            }
        }
    }

    private static int calculateIndexLength(String[] theColumnNames, Map<String, Integer> theColumnNameToLength, Class<?> theClazz, String theIndexName) {
        int retVal = 0;
        for (String nextName : theColumnNames) {
            Integer nextLength = theColumnNameToLength.get(nextName);
            if (nextLength == null) {
                throw new IllegalStateException(Msg.code((int)1625) + "Index '" + theIndexName + "' references unknown column: " + nextName);
            }
            retVal += nextLength.intValue();
        }
        return retVal;
    }

    private static void scanClassOrSuperclass(Set<String> theNames, Class<?> theClazz, boolean theIsSuperClass, Map<String, Integer> columnNameToLength) {
        ourLog.info("Scanning: {}", (Object)theClazz.getSimpleName());
        Subselect subselect = theClazz.getAnnotation(Subselect.class);
        boolean isView = subselect != null;
        TestUtil.scan(theClazz, theNames, theIsSuperClass, isView);
        for (Field field : theClazz.getDeclaredFields()) {
            boolean isTransient;
            if (Modifier.isStatic(field.getModifiers())) continue;
            ourLog.info(" * Scanning field: {}", (Object)field.getName());
            TestUtil.scan(field, theNames, theIsSuperClass, isView);
            Lob lobClass = field.getAnnotation(Lob.class);
            if (lobClass == null || !field.getType().equals(byte[].class)) {
                // empty if block
            }
            boolean bl = isTransient = field.getAnnotation(Transient.class) != null;
            if (isTransient) continue;
            boolean hasColumn = field.getAnnotation(Column.class) != null;
            boolean hasJoinColumn = field.getAnnotation(JoinColumn.class) != null;
            boolean hasEmbeddedId = field.getAnnotation(EmbeddedId.class) != null;
            boolean hasEmbedded = field.getAnnotation(Embedded.class) != null;
            OneToMany oneToMany = field.getAnnotation(OneToMany.class);
            OneToOne oneToOne = field.getAnnotation(OneToOne.class);
            boolean isOtherSideOfOneToManyMapping = oneToMany != null && StringUtils.isNotBlank((CharSequence)oneToMany.mappedBy());
            boolean isOtherSideOfOneToOneMapping = oneToOne != null && StringUtils.isNotBlank((CharSequence)oneToOne.mappedBy());
            boolean isField = field.getAnnotation(FullTextField.class) != null;
            isField |= field.getAnnotation(GenericField.class) != null;
            Validate.isTrue((hasEmbedded || hasColumn || hasJoinColumn || isOtherSideOfOneToManyMapping || isOtherSideOfOneToOneMapping || hasEmbeddedId || (isField |= field.getAnnotation(ScaledNumberField.class) != null) ? 1 : 0) != 0, (String)("Non-transient has no @Column or @JoinColumn or @EmbeddedId: " + field), (Object[])new Object[0]);
            int columnLength = 16;
            String columnName = null;
            if (hasColumn) {
                columnName = field.getAnnotation(Column.class).name();
                columnLength = field.getAnnotation(Column.class).length();
            }
            if (hasJoinColumn) {
                columnName = field.getAnnotation(JoinColumn.class).name();
            }
            if (columnName == null) continue;
            if (field.getType().isAssignableFrom(String.class)) {
                columnLength *= 4;
            }
            columnNameToLength.put(columnName, columnLength);
        }
        for (AnnotatedElement annotatedElement : theClazz.getDeclaredClasses()) {
            Embeddable embeddable = ((Class)annotatedElement).getAnnotation(Embeddable.class);
            if (embeddable == null) continue;
            TestUtil.scanClassOrSuperclass(theNames, annotatedElement, false, columnNameToLength);
        }
        if (theClazz.getSuperclass().equals(Object.class)) {
            return;
        }
        TestUtil.scanClassOrSuperclass(theNames, theClazz.getSuperclass(), true, columnNameToLength);
    }

    private static void scan(AnnotatedElement theAnnotatedElement, Set<String> theNames, boolean theIsSuperClass, boolean theIsView) {
        Column column;
        JoinColumn joinColumn;
        Table table = theAnnotatedElement.getAnnotation(Table.class);
        if (table != null) {
            ArrayList bannedNames = Lists.newArrayList((Object[])new String[]{"CDR_USER_2FA", "TRM_VALUESET_CODE"});
            Validate.isTrue((!bannedNames.contains(table.name().toUpperCase()) ? 1 : 0) != 0);
            Validate.isTrue((boolean)table.name().toUpperCase().equals(table.name()));
            TestUtil.assertNotADuplicateName(table.name(), theNames);
            for (UniqueConstraint uniqueConstraint : table.uniqueConstraints()) {
                TestUtil.assertNotADuplicateName(uniqueConstraint.name(), theNames);
                Validate.isTrue((boolean)uniqueConstraint.name().startsWith("IDX_"), (String)(uniqueConstraint.name() + " must start with IDX_"), (Object[])new Object[0]);
            }
            for (UniqueConstraint uniqueConstraint : table.indexes()) {
                TestUtil.assertNotADuplicateName(uniqueConstraint.name(), theNames);
                Validate.isTrue((uniqueConstraint.name().startsWith("IDX_") || uniqueConstraint.name().startsWith("FK_") ? 1 : 0) != 0, (String)(uniqueConstraint.name() + " must start with IDX_ or FK_ (last one when indexing a FK column)"), (Object[])new Object[0]);
            }
        }
        if ((joinColumn = theAnnotatedElement.getAnnotation(JoinColumn.class)) != null) {
            String columnName = joinColumn.name();
            TestUtil.validateColumnName(columnName, theAnnotatedElement);
            TestUtil.assertNotADuplicateName(columnName, null);
            ForeignKey fk = joinColumn.foreignKey();
            if (theIsSuperClass) {
                Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)fk.name()), (String)("Foreign key on " + theAnnotatedElement + " has a name() and should not as it is a superclass"), (Object[])new Object[0]);
            } else {
                Validate.notNull((Object)fk);
                Validate.isTrue((boolean)StringUtils.isNotBlank((CharSequence)fk.name()), (String)("Foreign key on " + theAnnotatedElement + " has no name()"), (Object[])new Object[0]);
                List<String> legacySPHibernateFKNames = Arrays.asList("FKC97MPK37OKWU8QVTCEG2NH9VN", "FKGXSREUTYMMFJUWDSWV3Y887DO");
                if (!legacySPHibernateFKNames.contains(fk.name())) {
                    Validate.isTrue((boolean)fk.name().startsWith("FK_"), (String)("Foreign key " + fk.name() + " on " + theAnnotatedElement + " must start with FK"), (Object[])new Object[0]);
                }
                if (!duplicateNameValidationExceptionList.contains(fk.name())) {
                    TestUtil.assertNotADuplicateName(fk.name(), theNames);
                }
            }
        }
        if ((column = theAnnotatedElement.getAnnotation(Column.class)) != null) {
            String columnName = column.name();
            TestUtil.validateColumnName(columnName, theAnnotatedElement);
            TestUtil.assertNotADuplicateName(columnName, null);
            Validate.isTrue((!column.unique() ? 1 : 0) != 0, (String)("Should not use unique attribute on column (use named @UniqueConstraint instead) on " + theAnnotatedElement), (Object[])new Object[0]);
            boolean hasLob = theAnnotatedElement.getAnnotation(Lob.class) != null;
            Field field = (Field)theAnnotatedElement;
            if (field.getType().equals(String.class)) {
                Size size;
                if (!hasLob) {
                    if (!theIsView && column.length() == 255) {
                        throw new IllegalStateException(Msg.code((int)1626) + "Field does not have an explicit maximum length specified: " + field);
                    }
                    if (column.length() > 4000) {
                        throw new IllegalStateException(Msg.code((int)1627) + "Field is too long: " + field);
                    }
                }
                if ((size = theAnnotatedElement.getAnnotation(Size.class)) != null && size.max() > 4000) {
                    throw new IllegalStateException(Msg.code((int)1628) + "Field is too long: " + field);
                }
                Length length = theAnnotatedElement.getAnnotation(Length.class);
                if (length != null && length.max() > 4000) {
                    throw new IllegalStateException(Msg.code((int)1629) + "Field is too long: " + field);
                }
            }
        }
        GeneratedValue gen = theAnnotatedElement.getAnnotation(GeneratedValue.class);
        SequenceGenerator sg = theAnnotatedElement.getAnnotation(SequenceGenerator.class);
        Validate.isTrue((gen != null == (sg != null) ? 1 : 0) != 0);
        if (gen != null) {
            TestUtil.assertNotADuplicateName(gen.generator(), theNames);
            TestUtil.assertNotADuplicateName(sg.name(), null);
            TestUtil.assertNotADuplicateName(sg.sequenceName(), null);
            TestUtil.assertEquals(gen.generator(), sg.name());
            TestUtil.assertEquals(gen.generator(), sg.sequenceName());
        }
    }

    private static void validateColumnName(String theColumnName, AnnotatedElement theElement) {
        if (!theColumnName.equals(theColumnName.toUpperCase())) {
            throw new IllegalArgumentException(Msg.code((int)1630) + "Column name must be all upper case: " + theColumnName + " found on " + theElement);
        }
        if (ourReservedWords.contains(theColumnName)) {
            throw new IllegalArgumentException(Msg.code((int)1631) + "Column name is a reserved word: " + theColumnName + " found on " + theElement);
        }
    }

    private static void assertEquals(String theGenerator, String theName) {
        Validate.isTrue((boolean)theGenerator.equals(theName));
    }

    private static void assertNotADuplicateName(String theName, Set<String> theNames) {
        if (StringUtils.isBlank((CharSequence)theName)) {
            return;
        }
        Validate.isTrue((theName.length() <= 30 ? 1 : 0) != 0, (String)("Identifier \"" + theName + "\" is " + theName.length() + " chars long"), (Object[])new Object[0]);
        if (theNames != null) {
            Validate.isTrue((boolean)theNames.add(theName), (String)("Duplicate name: " + theName), (Object[])new Object[0]);
        }
    }

    public static InstantType getTimestamp(IBaseResource resource) {
        return new InstantType(new Date(resource.getMeta().getLastUpdated().getTime()));
    }

    public static void sleepOneClick() {
        ca.uhn.fhir.util.TestUtil.sleepAtLeast((long)1L);
    }

    static {
        duplicateNameValidationExceptionList = Sets.newHashSet((Object[])new String[]{"FK_CONCEPTPROP_CONCEPT", "FK_CONCEPTDESIG_CONCEPT", "FK_TERM_CONCEPTPC_CHILD", "FK_TERM_CONCEPTPC_PARENT", "FK_TRM_VALUESET_CONCEPT_PID"});
    }
}

